<?php

/**
 * Plugin Name: Ultimate Post Kit Pro
 * Plugin URI: https://bdthemes.com/ultimate-post-kit/
 * Description: <a href="https://bdthemes.com/ultimate-post-kit/">Ultimate Post Kit Pro</a> is a packed of post related elementor widgets. This plugin gives you post related widget features for elementor page builder plugin.
 * Version: 3.13.3
 * Author: BdThemes
 * Author URI: https://bdthemes.com/
 * Text Domain: ultimate-post-kit-pro
 * Domain Path: /languages
 * Elementor requires at least: 3.22
 * Elementor tested up to: 3.26.5
 */

if (!defined('ABSPATH')) {
	exit;
}

define('BDTUPK_PRO_VER', '3.13.3');

/**
 * Required version is very important
 * Required on Core/Base file changes
 * If Base function changes then must release a Pro
 * That means Must have free sufficient version to works
 */
define('BDTUPK_CORE_REQUIRED_VERSION', '3.12.3');

define('BDTUPK_PRO__FILE__', __FILE__);
define('BDTUPK_PRO_PNAME', basename(dirname(BDTUPK_PRO__FILE__)));
define('BDTUPK_PRO_PBNAME', plugin_basename(BDTUPK_PRO__FILE__));
define('BDTUPK_PRO_PATH', plugin_dir_path(BDTUPK_PRO__FILE__));
define('BDTUPK_PRO_MODULES_PATH', BDTUPK_PRO_PATH . 'modules/');
define('BDTUPK_PRO_INC_PATH', BDTUPK_PRO_PATH . 'includes/');
define('BDTUPK_PRO_URL', plugins_url('/', BDTUPK_PRO__FILE__));
define('BDTUPK_PRO_ASSETS_URL', BDTUPK_PRO_URL . 'assets/');
define('BDTUPK_PRO_ASSETS_PATH', BDTUPK_PRO_PATH . 'assets/');
define('BDTUPK_PRO_MODULES_URL', BDTUPK_PRO_URL . 'modules/');
define('BDTUPK_PRO_ADMIN_PATH', BDTUPK_PRO_PATH . 'admin/');
define('BDTUPK_PRO_ADM_ASSETS_URL', BDTUPK_PRO_URL . 'admin/assets/');

// Helper function here
require_once(dirname(__FILE__) . '/includes/helper.php');
require_once(dirname(__FILE__) . '/includes/utils.php');

require_once(dirname(__FILE__) . '/includes/modules-features.php');

/**
 * Loads translations
 *
 * @return void
 */

if ( ! function_exists( 'ultimate_post_kit_pro_load_textdomain' ) ) {
	function ultimate_post_kit_pro_load_textdomain() {
		load_plugin_textdomain( 'ultimate-post-kit-pro', false, basename( dirname( __FILE__ ) ) . '/languages' );
	}
	add_action( 'init', 'ultimate_post_kit_pro_load_textdomain' );
}

/**
 * Plugin load here correctly
 * Also loaded the language file from here
 */
function ultimate_post_kit_pro_load_plugin() {

	if (!did_action('elementor/loaded')) {
		add_action('admin_notices', 'upk_elementor_load_failed');
		return;
	}

	if (!did_action('bdthemes_ultimate_post_kit/init')) {
		add_action('admin_notices', 'upk_core_load_failed');
		return;
	}

	if (!_is_ultimate_post_kit_version_sufficient()) {
		add_action('admin_notices', 'not_upk_version_sufficient');
		// return;
	}

	/**
	 * Finally, Load the Pro plugin
	 */
	require_once(BDTUPK_PRO_PATH . 'loader.php');
}

add_action('plugins_loaded', 'ultimate_post_kit_pro_load_plugin', 20);


/**
 * Check Elementor installed and activated correctly
 */
function upk_core_load_failed() {
	$screen = get_current_screen();
	if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
		return;
	}

	$plugin = 'ultimate-post-kit/ultimate-post-kit.php';

	if (_is_ultimate_post_kit_installed()) {
		if (!current_user_can('activate_plugins')) {
			return;
		}
		$activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin);
		$admin_message  = '<p>' . esc_html__('Ops! Ultimate Post Kit Pro not working because you need to activate the Ultimate Post Kit plugin first.', 'ultimate-post-kit-pro') . '</p>';
		$admin_message  .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $activation_url, esc_html__('Activate Ultimate Post Kit Now', 'ultimate-post-kit-pro')) . '</p>';
	} else {
		if (!current_user_can('install_plugins')) {
			return;
		}

		$install_url = wp_nonce_url(self_admin_url('plugin-install.php?s=Ultimate+Post+Kit+Addons+For+Elementor+BdThemes&tab=search&type=term'), 'install-plugin_elementor');

		$admin_message = '<p>' . esc_html__('Ops! Ultimate Post Kit Pro not working because you need to install the Ultimate Post Kit plugin', 'ultimate-post-kit-pro') . '</p>';
		$admin_message .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $install_url, esc_html__('Install Ultimate Post Kit Now', 'ultimate-post-kit-pro')) . '</p>';
	}

	echo '<div class="error">' . $admin_message . '</div>';
}

function upk_elementor_load_failed() {
	$screen = get_current_screen();
	if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
		return;
	}

	$plugin = 'elementor/elementor.php';

	if (_is_elementor_installed()) {
		if (!current_user_can('activate_plugins')) {
			return;
		}
		$activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin);
		$admin_message  = '<p>' . esc_html__('Ops! Ultimate Post Kit Pro not working because you need to activate the Elementor plugin first.', 'ultimate-post-kit-pro') . '</p>';
		$admin_message  .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $activation_url, esc_html__('Activate Elementor Now', 'ultimate-post-kit-pro')) . '</p>';
	} else {
		if (!current_user_can('install_plugins')) {
			return;
		}
		$install_url   = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=elementor'), 'install-plugin_elementor');
		$admin_message = '<p>' . esc_html__('Ops! Ultimate Post Kit Pro not working because you need to install the Elementor plugin', 'ultimate-post-kit-pro') . '</p>';
		$admin_message .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $install_url, esc_html__('Install Elementor Now', 'ultimate-post-kit-pro')) . '</p>';
	}

	echo '<div class="error">' . $admin_message . '</div>';
}

function not_upk_version_sufficient() {
	$admin_message = '<p>' . esc_html__('Ops! Ultimate Post Kit Pro not working because your Free/Core version is not sufficient/updated. You must install at least ' . BDTUPK_CORE_REQUIRED_VERSION . ' version of the Free/Core version.', 'ultimate-post-kit-pro') . '</p>';
	echo '<div class="error">' . $admin_message . '</div>';
}

/**
 * Check the elementor installed or not
 */
if (!function_exists('_is_elementor_installed')) {

	function _is_elementor_installed() {
		$file_path         = 'elementor/elementor.php';
		$installed_plugins = get_plugins();

		return isset($installed_plugins[$file_path]);
	}
}

if (!function_exists('_is_ultimate_post_kit_installed')) {

	function _is_ultimate_post_kit_installed() {
		$file_path         = 'ultimate-post-kit/ultimate-post-kit.php';
		$installed_plugins = get_plugins();

		return isset($installed_plugins[$file_path]);
	}
}
if (!function_exists('_is_ultimate_post_kit_version_sufficient')) {
	function _is_ultimate_post_kit_version_sufficient() {
		if (!defined('BDTUPK_VER')) {
			return false;
		}
		if (version_compare(BDTUPK_VER, BDTUPK_CORE_REQUIRED_VERSION, '>=')) {
			return true;
		}
		return false;
	}
}
