<?php
namespace UltimatePostKitPro\Modules\SocialLink\Widgets;

use UltimatePostKitPro\Base\Module_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Icons_Manager;

use UltimatePostKitPro\Modules\SocialLink\Module;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Social_Link extends Module_Base {

	protected $_has_template_content = false;

	private static $medias_class = [
		'email'      => 'upk-icon-envelope',
		'vkontakte'  => 'upk-icon-vk',
	];

	private static function get_social_media_class( $media_name ) {
		if ( isset( self::$medias_class[ $media_name ] ) ) {
			return self::$medias_class[ $media_name ];
		}
		return 'upk-icon-' . $media_name;
	}


	public function get_name() {
		return 'upk-social-link';
	}

	public function get_title() {
		return BDTUPK . esc_html__( 'Social Link', 'ultimate-post-kit-pro' );
	}

	public function get_icon() {
		return 'upk-widget-icon upk-icon-social-link';
	}

	public function get_categories() {
		return [ 'ultimate-post-kit-pro' ];
	}

	public function get_keywords() {
		return [ 'social', 'link', 'share' ];
	}

	public function get_style_depends() {
        if ($this->upk_is_edit_mode()) {
            return ['upk-all-styles-pro'];
        } else {
            return [ 'upk-font', 'upk-social-share' ];
        }
    }

	public function get_custom_help_url() {
		return 'https://youtu.be/MCH3v8iwrTw';
	}

	public function has_widget_inner_wrapper(): bool {
        return ! \Elementor\Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
    }
	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_buttons_content',
			[
				'label' => esc_html__( 'Link Buttons', 'ultimate-post-kit-pro' ),
			]
		);

		$repeater = new Repeater();

		$medias = Module::get_social_media();

		$medias_names = array_keys( $medias );

		$repeater->add_control(
			'button',
			[
				'label' => esc_html__( 'Social Media', 'ultimate-post-kit-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => array_reduce( $medias_names, function( $options, $media_name ) use ( $medias ) {
					$options[ $media_name ] = $medias[ $media_name ]['title'];

					return $options;
				}, [] ),
				'default' => 'facebook',
			]
		);

		$repeater->add_control(
			'social_icon',
			[
				'label'   => __('Choose Icon', 'ultimate-post-kit-pro'),
				'type'    => Controls_Manager::ICONS,
				'default' => [
					'value'   => 'fas fa-plus',
					'library' => 'fa-solid',
				],
				'condition' => [
					'button' => 'custom'
				],
				'skin' => 'inline',
				'label_block' => false
			]
		);

		$repeater->add_control(
            'custom_style_popover',
            [
                'label'        => esc_html__('Custom Style', 'ultimate-post-kit-pro'),
                'type'         => Controls_Manager::POPOVER_TOGGLE,
                'render_type'  => 'ui',
                'return_value' => 'yes',
				'condition' => [
					'button' => 'custom'
				],
            ]
        );

		$repeater->start_popover();

		$repeater->add_control(
			'custom_primary_color',
			[
				'label'     => esc_html__( 'Primary Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default' => '#2B2D42',
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-flat {{CURRENT_ITEM}} .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-gradient {{CURRENT_ITEM}} .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-boxed {{CURRENT_ITEM}} .upk-ss-btn .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-minimal {{CURRENT_ITEM}} .upk-ss-btn .upk-ss-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}}.upk-ss-btns-style-framed {{CURRENT_ITEM}} .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-minimal {{CURRENT_ITEM}} .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-boxed {{CURRENT_ITEM}} .upk-ss-btn' => 'color: {{VALUE}}; border-color: {{VALUE}}',
				],
				'condition' => [
					'button' => 'custom',
					'custom_style_popover' => 'yes'
				],
			]
		);

		$repeater->add_control(
			'custom_secondary_color',
			[
				'label'     => esc_html__( 'Secondary Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-flat {{CURRENT_ITEM}} .upk-ss-icon, 
					 {{WRAPPER}}.upk-ss-btns-style-flat {{CURRENT_ITEM}} .upk-social-share-text, 
					 {{WRAPPER}}.upk-ss-btns-style-gradient {{CURRENT_ITEM}} .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-gradient {{CURRENT_ITEM}} .upk-social-share-text,
					 {{WRAPPER}}.upk-ss-btns-style-boxed {{CURRENT_ITEM}} .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-minimal {{CURRENT_ITEM}} .upk-ss-icon' => 'color: {{VALUE}}',
					 '{{WRAPPER}}.upk-ss-btns-style-framed {{CURRENT_ITEM}} .upk-ss-btn' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'button' => 'custom',
					'custom_style_popover' => 'yes'
				],
			]
		);

		$repeater->add_control(
			'custom_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-boxed {{CURRENT_ITEM}} .upk-ss-btn, {{WRAPPER}}.upk-ss-btns-style-framed {{CURRENT_ITEM}} .upk-ss-btn' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'button' => 'custom',
					'custom_style_popover' => 'yes'
				],
			]
		);

		$repeater->end_popover();

		$repeater->add_control(
			'text',
			[
				'label' => esc_html__( 'Custom Label', 'ultimate-post-kit-pro' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'social_link',
			[
				'label'   => __('Link', 'ultimate-post-kit-pro'),
				'type'    => Controls_Manager::TEXT,
				'default' => __('http://www.facebook.com/bdthemes/', 'ultimate-post-kit-pro'),
			]
		);

		$this->add_control(
			'share_buttons',
			[
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[ 
						'button'      => 'facebook',
						'social_link' => __('http://www.facebook.com/bdthemes/', 'ultimate-post-kit-pro'), 
					],
					[ 
						'button'      => 'linkedin',
						'social_link' => __('http://www.linkedin.com/bdthemes/', 'ultimate-post-kit-pro'),
					],
					[ 
						'button'      => 'twitter', 
						'social_link' => __('http://www.twitter.com/bdthemes/', 'ultimate-post-kit-pro'),
					],
					[ 
						'button'      => 'pinterest',
						'social_link' => __('http://www.pinterest.com/bdthemes/', 'ultimate-post-kit-pro'),
					],
				],
				'title_field' => '{{{ button  }}}',
			]
		);

		$this->add_control(
			'view',
			[
				'label'       => esc_html__( 'View', 'ultimate-post-kit-pro' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => false,
				'options'     => [
					'icon-text' => 'Icon & Text',
					'icon'      => 'Icon',
					'text'      => 'Text',
				],
				'default'      => 'icon-text',
				'separator'    => 'before',
				'prefix_class' => 'upk-ss-btns-view-',
				'render_type'  => 'template',
			]
		);

		$this->add_control(
			'hr',
			[
				'type'    => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'layout_style',
			[
				'label'   => esc_html__( 'Display', 'ultimate-post-kit-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'inline',
				'options' => [
					'inline' => esc_html__( 'Inline', 'ultimate-post-kit-pro' ),
					'grid'   => esc_html__( 'Grid', 'ultimate-post-kit-pro' ),
				],
				'prefix_class' => 'upk-layout-style--',
			]
		);
		
		$this->add_responsive_control(
			'columns',
			[
				'label'          => __( 'Columns', 'ultimate-post-kit-pro' ),
				'type'           => Controls_Manager::SELECT,
				'default'        => '4',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'selectors'      => [
					'{{WRAPPER}} .upk-social-share' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
				],
				'condition' => [
					'layout_style' => 'grid'
				]
			]
		);
		
		$this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Gap', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .upk-social-share' => 'grid-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => 'grid'
				]
			]
		);

		$this->add_responsive_control(
			'inline_column_gap',
			[
				'label'   => esc_html__( 'Columns Gap', 'ultimate-post-kit-pro' ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .upk-ss-btn' => 'margin-right: calc({{SIZE}}{{UNIT}} / 2); margin-left: calc({{SIZE}}{{UNIT}} / 2);',
					'{{WRAPPER}} .upk-ep-grid'             => 'margin-right: calc(-{{SIZE}}{{UNIT}} / 2); margin-left: calc(-{{SIZE}}{{UNIT}} / 2);',
				],
				'condition' => [
					'layout_style' => 'inline'
				]
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'   => esc_html__( 'Rows Gap', 'ultimate-post-kit-pro' ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .upk-ss-btn' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => 'inline'
				]
			]
		);

		$this->add_responsive_control(
			'alignment',
			[
				'label'   => esc_html__( 'Alignment', 'ultimate-post-kit-pro' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Left', 'ultimate-post-kit-pro' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ultimate-post-kit-pro' ),
						'icon'  => 'eicon-text-align-center',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', 'ultimate-post-kit-pro' ),
						'icon'  => 'eicon-text-align-right',
					],
					'space-between' => [
						'title' => esc_html__( 'Justify', 'ultimate-post-kit-pro' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .upk-social-share' => 'justify-content: {{VALUE}};',
				],
				'condition' => [
					'layout_style' => 'inline'
				]
			]
		);

		$this->add_control(
			'hr_1',
			[
				'type'    => Controls_Manager::DIVIDER,
				'condition' => [
					'layout_style' => 'inline'
				]
			]
		);

		$this->add_control(
			'layout_position',
			[
				'label'   => esc_html__( 'Position', 'ultimate-post-kit-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'      => esc_html__( 'Default', 'ultimate-post-kit-pro' ),
					'top-left'     => esc_html__( 'Top Left', 'ultimate-post-kit-pro' ),
					'top-right'    => esc_html__( 'Top Right', 'ultimate-post-kit-pro' ),
					'center-left'  => esc_html__( 'Center Left', 'ultimate-post-kit-pro' ),
					'center-right' => esc_html__( 'Center Right', 'ultimate-post-kit-pro' ),
					'bottom-left'  => esc_html__( 'Bottom Left', 'ultimate-post-kit-pro' ),
					'bottom-right' => esc_html__( 'Bottom Right', 'ultimate-post-kit-pro' ),
				],
				'prefix_class' => 'upk-ss-position--',
				'condition' => [
					'layout_style' => 'inline'
				]
			]
		);

		$this->add_control(
			'social_share_offset',
			[
				'label' => __( 'Offset', 'ultimate-post-kit-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'condition' => [
					'layout_position!' => 'default',
					'layout_style' => 'inline'
				],
				'render_type' => 'ui',
			]
		);
		
		$this->start_popover();
		
		$this->add_responsive_control(
			'ss_horizontal_offset',
			[
				'label'       => esc_html__( 'Horizontal', 'ultimate-post-kit-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'range'       => [
					'px' => [
						'min'   => -200,
						'max'   => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'condition'    => [
					'social_share_offset' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}}.upk-layout-style--inline .upk-social-share' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'ss_vertical_offset',
			[
				'label'       => esc_html__( 'Vertical', 'ultimate-post-kit-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'range'       => [
					'px' => [
						'min'   => -200,
						'max'   => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'condition'    => [
					'social_share_offset' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}}.upk-layout-style--inline .upk-social-share' => 'margin-top: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->end_popover();

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'section_buttons_style',
			[
				'label' => esc_html__( 'Share Buttons', 'ultimate-post-kit-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Style', 'ultimate-post-kit-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'flat'     => esc_html__( 'Flat', 'ultimate-post-kit-pro' ),
					'framed'   => esc_html__( 'Framed', 'ultimate-post-kit-pro' ),
					'gradient' => esc_html__( 'Gradient', 'ultimate-post-kit-pro' ),
					'minimal'  => esc_html__( 'Minimal', 'ultimate-post-kit-pro' ),
					'boxed'    => esc_html__( 'Boxed Icon', 'ultimate-post-kit-pro' ),
				],
				'default'      => 'flat',
				'prefix_class' => 'upk-ss-btns-style-',
			]
		);

		$this->add_control(
			'icon_top',
			[
				'label'        => __( 'Icon Position Top', 'ultimate-post-kit-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'prefix_class' => 'upk-ss-icon-top--',
				'condition' => [
					'layout_position!' => ['center-left', 'center-right'],
					'view' => 'icon-text'
				]
			]
		);

		$this->add_responsive_control(
            'ss_icon_padding',
            [
                'label'      => __('Icon Padding', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}}.upk-ss-icon-top--yes .upk-ss-btn .upk-ss-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition' => [
					'icon_top' => 'yes'
				]
            ]
        );

		$this->add_responsive_control(
            'ss_text_padding',
            [
                'label'      => __('Text Padding', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}}.upk-ss-icon-top--yes .upk-ss-btn .upk-social-share-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition' => [
					'icon_top' => 'yes'
				]
            ]
        );

		$this->add_control(
			'divider_one',
			[
				'type'    => Controls_Manager::DIVIDER,
			]
		);

		$this->add_responsive_control(
			'button_size',
			[
				'label' => esc_html__( 'Button Size', 'ultimate-post-kit-pro' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 0.5,
						'max'  => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .upk-ss-btn' => 'font-size: calc({{SIZE}}{{UNIT}} * 10);',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'ultimate-post-kit-pro' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'em' => [
						'min'  => 0.5,
						'max'  => 4,
						'step' => 0.1,
					],
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'em',
				],
				'tablet_default' => [
					'unit' => 'em',
				],
				'mobile_default' => [
					'unit' => 'em',
				],
				'size_units' => [ 'em', 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .upk-ss-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'view!' => 'text',
				],
			]
		);

		$this->add_responsive_control(
			'button_height',
			[
				'label' => esc_html__( 'Button Height', 'ultimate-post-kit-pro' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'em' => [
						'min'  => 1,
						'max'  => 7,
						'step' => 0.1,
					],
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'em',
				],
				'tablet_default' => [
					'unit' => 'em',
				],
				'mobile_default' => [
					'unit' => 'em',
				],
				'size_units' => [ 'em', 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .upk-ss-btn' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'icon_top' => ''
				]
			]
		);

		$this->add_responsive_control(
			'border_size',
			[
				'label'      => esc_html__( 'Border Size', 'ultimate-post-kit-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'default'    => [
					'size' => 2,
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
					'em' => [
						'max'  => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .upk-ss-btn' => 'border-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'style' => [ 'framed', 'boxed' ],
				],
			]
		);

		$this->add_responsive_control(
			'border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .upk-ss-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'text_padding',
			[
				'label'      => esc_html__( 'Text Padding', 'ultimate-post-kit-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}}.upk-ss-btns-view-text .upk-social-share-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'view' => 'text',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography',
				'label'    => esc_html__( 'Typography', 'ultimate-post-kit-pro' ),
				'selector' => '{{WRAPPER}} .upk-social-share-title, {{WRAPPER}} .upk-ss-counter',
				'exclude'  => [ 'line_height' ],
			]
		);

		$this->add_control(
			'color_source',
			[
				'label'       => esc_html__( 'Color', 'ultimate-post-kit-pro' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => false,
				'options'     => [
					'original' => 'Original Color',
					'custom'   => 'Custom Color',
				],
				'default'      => 'original',
				'prefix_class' => 'upk-ss-btns-color-',
				'separator'    => 'before',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label'     => esc_html__( 'Normal', 'ultimate-post-kit-pro' ),
				'condition' => [
					'color_source' => 'custom',
				],
			]
		);

		$this->add_control(
			'primary_color',
			[
				'label'     => esc_html__( 'Primary Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-flat .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-gradient .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-minimal .upk-ss-btn .upk-ss-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}}.upk-ss-btns-style-framed .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-minimal .upk-ss-btn,
					 {{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn' => 'color: {{VALUE}}; border-color: {{VALUE}}',
				],
				'condition' => [
					'color_source' => 'custom',
				],
			]
		);

		$this->add_control(
			'secondary_color',
			[
				'label'     => esc_html__( 'Secondary Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-flat .upk-ss-icon, 
					 {{WRAPPER}}.upk-ss-btns-style-flat .upk-social-share-text, 
					 {{WRAPPER}}.upk-ss-btns-style-gradient .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-gradient .upk-social-share-text,
					 {{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-minimal .upk-ss-icon' => 'color: {{VALUE}}',
					 '{{WRAPPER}}.upk-ss-btns-style-framed .upk-ss-btn' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'color_source' => 'custom',
				],
			]
		);

		$this->add_control(
			'border_color',
			[
				'label'     => esc_html__( 'Border Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn, {{WRAPPER}}.upk-ss-btns-style-framed .upk-ss-btn' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'color_source' => 'custom',
					'style' => ['framed', 'boxed']
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label'     => esc_html__( 'Hover', 'ultimate-post-kit-pro' ),
				'condition' => [
					'color_source' => 'custom',
				],
			]
		);

		$this->add_control(
			'primary_color_hover',
			[
				'label'     => esc_html__( 'Primary Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-flat .upk-ss-btn:hover,
					 {{WRAPPER}}.upk-ss-btns-style-gradient .upk-ss-btn:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}}.upk-ss-btns-style-framed .upk-ss-btn:hover,
					 {{WRAPPER}}.upk-ss-btns-style-minimal .upk-ss-btn:hover,
					 {{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn:hover' => 'color: {{VALUE}}; border-color: {{VALUE}}',
					'{{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn:hover .upk-ss-icon, 
					 {{WRAPPER}}.upk-ss-btns-style-minimal .upk-ss-btn:hover .upk-ss-icon' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'color_source' => 'custom',
				],
			]
		);

		$this->add_control(
			'secondary_color_hover',
			[
				'label'     => esc_html__( 'Secondary Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-flat .upk-ss-btn:hover .upk-ss-icon, 
					 {{WRAPPER}}.upk-ss-btns-style-flat .upk-ss-btn:hover .upk-social-share-text, 
					 {{WRAPPER}}.upk-ss-btns-style-gradient .upk-ss-btn:hover .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-gradient .upk-ss-btn:hover .upk-social-share-text,
					 {{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn:hover .upk-ss-icon,
					 {{WRAPPER}}.upk-ss-btns-style-minimal .upk-ss-btn:hover .upk-ss-icon' => 'color: {{VALUE}}',
					 '{{WRAPPER}}.upk-ss-btns-style-framed .upk-ss-btn:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'color_source' => 'custom',
				],
			]
		);

		$this->add_control(
			'border_hover_color',
			[
				'label'     => esc_html__( 'Border Color', 'ultimate-post-kit-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.upk-ss-btns-style-boxed .upk-ss-btn:hover, {{WRAPPER}}.upk-ss-btns-style-framed .upk-ss-btn:hover' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'color_source' => 'custom',
					'style' => ['framed', 'boxed']
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	public function render() {

		$settings  = $this->get_active_settings();

		if ( empty( $settings['share_buttons'] ) ) {
			return;
		}

		$show_text = 'text' === $settings['view'] || 'icon-text' === $settings['view'];
		?>
		<div class="upk-social-share upk-ep-grid upk-social-link">
			<?php
			foreach ( $settings['share_buttons'] as $button ) {
				$social_name = $button['button'];

				$this->add_render_attribute(
					[
						'social-attrs' => [
							'class' => [
								'upk-ss-btn',
								'upk-ss-' . $social_name
							],
							'target' => "_blank",
						]
					], '', '', true
				);

				$this->add_render_attribute('ss-item', 'class', 'upk-social-share-item upk-ep-grid-item elementor-repeater-item-' . esc_attr($button['_id']), true);

				?>
				<div <?php echo($this->get_render_attribute_string('ss-item')); ?>>
					<a href="<?php echo esc_url($button['social_link']); ?>" <?php $this->print_render_attribute_string( 'social-attrs' ); ?>>
						<?php if ( 'icon' === $settings['view'] || 'icon-text' === $settings['view'] ) : ?>
							<span class="upk-ss-icon">
								<?php if ( 'custom' != $button['button'] ) : ?>
									<i class="<?php echo self::get_social_media_class( $social_name ); ?>"></i>
								<?php else: ?>
									<?php Icons_Manager::render_icon($button['social_icon'], ['aria-hidden' => 'true', 'class' => 'fa-fw']); ?>
								<?php endif; ?>
							</span>
						<?php endif; ?>
						<?php if ( $show_text ) : ?>
							<div class="upk-social-share-text upk-inline">
								<?php if ( 'icon-text' === $settings['view'] || 'text' === $settings['view'] ) : ?>
									<span class="upk-social-share-title">
										<?php echo $button['text'] ? esc_html($button['text']) : Module::get_social_media( $social_name )['title']; ?>
									</span>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					</a>
				</div>
				<?php
			}
			?>
		</div>

		
		<?php

		
	}

	
}
