<?php

namespace UltimatePostKitPro\Modules\MulticolorItem;

use Elementor\Controls_Manager;
use UltimatePostKitPro;
use Elementor\Repeater;
use UltimatePostKitPro\Base\Ultimate_Post_Kit_Module_Base;

if (!defined('ABSPATH')) {
    exit;
}

class Module extends Ultimate_Post_Kit_Module_Base {

    public function __construct() {
        parent::__construct();
        $this->add_actions();
    }

    public function get_name() {
        return 'upk-multicolor-item';
    }

    public function register_section($element) {
        $element->start_controls_section(
            'section_upk_mc_item_controls',
            [
                'tab'   => Controls_Manager::TAB_STYLE,
                'label' => BDTUPK_CP . esc_html__('MultiColor Item', 'ultimate-post-kit-pro'),
            ]
        );
        $element->end_controls_section();
    }

    public function register_controls($section, $args) {

        $section->add_control(
            'upk_mc_item_enable',
            [
                'label'              => BDTUPK_CP . esc_html__('Enable', 'ultimate-post-kit-pro'),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => '',
                'return_value'       => 'yes',
                'frontend_available' => true,
            ]
        );

        $section->add_control(
            'upk_mc_item_selector',
            [
                'label'              => esc_html__('Selector', 'ultimate-post-kit-pro'),
                'type'               => Controls_Manager::TEXTAREA,
                'placeholder'        => esc_html__('.test-class', 'ultimate-post-kit-pro'),
                'frontend_available' => true,
                'condition'          => [
                    'upk_mc_item_enable' => 'yes'
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'upk_mc_item_color',
            [
                'label' => esc_html__('Background Color', 'ultimate-post-kit-pro'),
                'type'  => Controls_Manager::COLOR,
            ]
        );

        $repeater->add_control(
            'upk_mc_item_border_color',
            [
                'label' => esc_html__('Border Color', 'ultimate-post-kit-pro'),
                'type'  => Controls_Manager::COLOR,
            ]
        );

        $section->add_control(
            'upk_mc_item_list',
            [
                'label'              => esc_html__('Items Color', 'ultimate-post-kit-pro'),
                'type'               => Controls_Manager::REPEATER,
                'fields'             => $repeater->get_controls(),
                'prevent_empty'      => false,
                'title_field'        => '{{{ upk_mc_item_color }}}',
                'frontend_available' => true,
                'condition'          => [
                    'upk_mc_item_enable' => 'yes',
                ],
                'render_type' => 'template',
            ]
        );
    }

    public function enqueue_scripts() {
        wp_enqueue_script('upk-multicolor-item');
    }
    public function should_script_enqueue($section) {
        if ('yes' === $section->get_settings_for_display('upk_mc_item_enable')) {
            $this->enqueue_scripts();
        }
    }

    protected function add_actions() {
        add_action('elementor/element/container/section_background/after_section_end', [$this, 'register_section']);
        add_action('elementor/element/container/section_upk_mc_item_controls/before_section_end', [$this, 'register_controls'], 10, 2);
        add_action('elementor/frontend/container/after_render', [$this, 'should_script_enqueue']);

        add_action('elementor/element/section/section_background/after_section_end', [$this, 'register_section']);
        add_action('elementor/element/section/section_upk_mc_item_controls/before_section_end', [$this, 'register_controls'], 10, 2);

        //render scripts
        add_action('elementor/frontend/section/after_render', [$this, 'should_script_enqueue']);
        add_action('elementor/preview/enqueue_scripts', [$this, 'enqueue_scripts']);
    }
}
