<?php

namespace UltimatePostKitPro\Modules\KalonGrid;

use UltimatePostKitPro\Base\Ultimate_Post_Kit_Module_Base;
use UltimatePostKit\Traits\Global_Widget_Functions;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) {
	exit;
}
// Exit if accessed directly

class Module extends Ultimate_Post_Kit_Module_Base {

	use Global_Widget_Functions;

	public function __construct() {
		parent::__construct();

		add_action('wp_ajax_nopriv_upk_kalon_grid_loadmore_posts', [$this, 'callback_ajax_loadmore_posts']);
		add_action('wp_ajax_upk_kalon_grid_loadmore_posts', [$this, 'callback_ajax_loadmore_posts']);
	}
	public function get_name() {
		return 'kalon-grid';
	}

	public function get_widgets() {

		$widgets = [
			'Kalon_Grid',
		];
		return $widgets;
	}

	public function callback_ajax_loadmore_posts() {
		$settings = $_POST['settings'];
		$post_type =  isset($settings['post_type']) ? sanitize_text_field($$settings['post_type']) : 'post';
		$ajaxposts = $this->query_args();
		$markup = '';
		if ($ajaxposts->have_posts()) {
			$item_index = 1;
			while ($ajaxposts->have_posts()) :
				$ajaxposts->the_post();
				// $title                 = wp_trim_words(get_the_title(), $title_text_limit, '...');
				$title = get_the_title();
				$post_link = esc_url(get_permalink());
				$image_src = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');
				$category = upk_get_category($post_type);
				$author_url = get_author_posts_url(get_the_author_meta('ID'));
				$author_name = get_the_author();
				$reading_time = ultimate_post_kit_reading_time(get_the_content(), $settings['avg_reading_speed']);

				if ($settings['human_diff_time'] == 'yes') {
					$date =  ultimate_post_kit_post_time_diff(($settings['human_diff_time_short'] == 'yes') ? 'short' : '');
				} else {
					$date =  get_the_date();
				}
				$placeholder_image_src = \Elementor\Utils::get_placeholder_image_src();
				$image_src = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
				if (!$image_src) {
					$image_src = $placeholder_image_src;
				} else {
					$image_src = $image_src[0];
				}

				$markup .= '<div class="upk-item">';
				$markup .= '<div class="upk-item-box">';
				$markup .= '<div class="upk-img-wrap">';
				$markup .= '<img alt=' . $post_link . ' class="upk-img" src="' . esc_url($image_src) . '">';
				$markup .= '</div>';
				// end image wrap
				$markup .= '<div class="upk-content-wrap">';
				$markup .= '<div class="upk-content">';
				if ($settings['show_category'] == 'yes') :
					$markup .= '<div class="upk-category">';
					$markup .= $category;
					$markup .= '</div>';
				endif;
				// end category
				if (isset($_POST['settings']['show_title']) && ('yes' == $_POST['settings']['show_title'])) :
					$markup .= '<h3 class="upk-title-wrap">';
					$markup .= '<a class="upk-title" href="' . $post_link . '" title=' . $title . '>' . $title . '</a>';
					$markup .= '</h3>';
				// end title wrap
				endif;

				$markup .= '<div class="upk-meta">';
				$markup .= '<div class="upk-flex-inline">';
				if (isset($_POST['settings']['show_date']) && ('yes' == $_POST['settings']['show_date'])) :
					$markup .= '<div class="upk-date">';
					$markup .= esc_html($date);
					$markup .= '</div>';
				endif;
				// end date
				$markup .= '<div class="upk-reading-time" data-separator="' . $settings['meta_separator'] . '">' . $reading_time . '</div>';
				$markup .= '</div>';
				// end flex inline
				// author start
				if (isset($settings['show_author']) && ('yes' == $settings['show_author'])) :
					$markup .= '<div class="upk-kalon-author">';
					$markup .= '<span class="upk-author-text">by</span><a class="upk-author-name" href="' . $author_url . '">' . esc_html($author_name) . '</a>';
					$markup .= '</div>';
				endif;
				// end author
				$markup .= '</div>';
				// end meta
				$markup .= '</div>';
				// content end

				if ($settings['show_readmore'] == 'yes') :
					$markup .= '<div class="upk-btn-wrap">';
					$markup .= '<a class="upk-btn" href="' . $post_link . '">';
					$markup .= '<span class="upk-flex upk-flex-middle">' . $settings['readmore_text'] . '<span class="upk-btn-icon upk-flex-align-' . $settings['icon_align'] . '">';
					ob_start();

					Icons_Manager::render_icon($settings['readmore_icon'], ['aria-hidden' => 'true', 'class' => 'fa-fw']);
					$markup .= ob_get_clean();

					$markup .= '</div>';
				endif;
				// end button wrap
				$markup .= '</div>';
				// content wrap end
				$markup .= '</div>';
				$markup .= '</div>';
				$item_index++;
			endwhile;
		}

		wp_reset_postdata();
		$result = [
			'markup' => $markup,
		];
		wp_send_json($result);
		exit;
	}
}
