<?php

namespace UltimatePostKitPro\Modules\InstagramGallery\Widgets;

use Elementor\Modules\DynamicTags\Module as TagsModule;

use UltimatePostKit\Base\Module_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Instagram_Gallery extends Module_Base {

    public function get_name() {
        return 'upk-instagram-gallery';
    }

    public function get_title() {
        return BDTUPK . esc_html__('Instagram Gallery', 'ultimate-post-kit-pro');
    }

    public function get_icon() {
        return 'upk-widget-icon upk-icon-instagram-gallery upk-new';
    }

    public function get_categories() {
        return ['ultimate-post-kit-pro'];
    }

    public function get_keywords() {
        return ['instagram', 'gallery', 'photos', 'images', 'feed', 'social'];
    }

    public function get_style_depends() {
        if ($this->upk_is_edit_mode()) {
            return ['upk-all-styles-pro'];
        } else {
            return ['upk-font', 'upk-instagram-gallery'];
        }
    }

    public function get_script_depends() {
        if ($this->upk_is_edit_mode()) {
            return ['upk-all-scripts-pro'];
        } else {
            return ['upk-instagram-gallery'];
        }
    }

    // public function get_custom_help_url() {
    //     return 'https://youtu.be/uj9WpuFIZb8';
    // }


    public function has_widget_inner_wrapper(): bool {
        return ! \Elementor\Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
    }
	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__('Layout', 'ultimate-post-kit-pro'),
            ]
        );

        $this->add_control(
            'instagram_user_token',
            [
                'label'       => esc_html__('Instagram Token (Optional)', 'ultimate-post-kit-pro'),
                'description' => esc_html__('Enter instagram User Token if you want to show separated user\'s photos', 'ultimate-post-kit-pro'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'layout_style',
            [
                'label'      => __('Layout Style', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::SELECT,
                'options'    => [
                    'style-1' => '1',
                    'style-2' => '2',
                    'style-3' => '3',
                    'style-4' => '4',
                    'style-5' => '5',
                    'style-6' => '6',
                ],
                'default'    => 'style-1',
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'          => esc_html__('Columns', 'ultimate-post-kit-pro'),
                'type'           => Controls_Manager::SELECT,
                'default'        => '4',
                'tablet_default' => '3',
                'mobile_default' => '2',
                'options'        => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery' => 'grid-template-columns: repeat({{VALUE}}, 1fr)',
                ],
                'condition' => [
                    'layout_style' => 'style-1'
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'         => __('Row Gap', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'default'   => [
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'columns_gap',
            [
                'label'         => __('Column Gap', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'default'   => [
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label'     => esc_html__('Item Height', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 250,
                ],
                'range'     => [
                    'px' => [
                        'min'  => 50,
                        'max'  => 500,
                        'step' => 5,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery-thumbnail img, {{WRAPPER}} .upk-instagram-gallery-thumbnail video, {{WRAPPER}} .upk-instagram-gallery-thumbnail .upk-feature-item' => 'height: {{SIZE}}px',
                ],
                'condition' => [
                    'layout_style!' => 'style-1'
                ],
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control(
            'default_item_height',
            [
                'label'     => esc_html__('Item Height', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 250,
                ],
                'range'     => [
                    'px' => [
                        'min'  => 50,
                        'max'  => 500,
                        'step' => 5,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery-item' => 'height: {{SIZE}}px',
                ],
                'condition' => [
                    'layout_style' => 'style-1'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'items',
            [
                'label'   => esc_html__('Item Limit', 'ultimate-post-kit-pro'),
                'type'    => Controls_Manager::SLIDER,
                'range'   => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 12,
                ],
                'condition' => [
                    'layout_style' => 'style-1'
                ]
            ]
        );

        $this->add_control(
            'show_link',
            [
                'label'     => esc_html__('Link Image to Post', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SWITCHER,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'target_blank',
            [
                'label'     => esc_html__('Open in new window', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label'     => __('Alignment', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __('Left', 'ultimate-post-kit-pro'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'ultimate-post-kit-pro'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', 'ultimate-post-kit-pro'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-profile' => 'text-align: {{VALUE}}',
                ],
                'condition' => [
                    'show_profile' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_content_additional',
            [
                'label' => esc_html__('Additional Settings', 'ultimate-post-kit-pro'),
            ]
        );

        $this->add_control(
            'animation_style',
            [
                'label'      => __('Animation Style', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::SELECT,
                'options'    => [
                    'style-1' => '1',
                    'style-2' => '2',
                    'style-3' => '3',
                    'style-4' => '4',
                    'style-5' => '5',
                ],
                'default'    => 'style-1',
            ]
        );

        $this->add_control(
            'show_featured_item',
            [
                'label'     => esc_html__('Profile', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'condition' => [
                    'layout_style' => 'style-1'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'feature_item_position',
            [
                'label'         => __('Active Index', 'ultimatet-store-kit-pro'),
                'type'          => Controls_Manager::SELECT,
                'default'       => 1,
                'options' => [
                    0       => '1',
                    1       => '2',
                    2       => '3',
                    3       => '4',
                    4       => '5',
                    5       => '6',
                    6       => '7',
                    7       => '8',
                    8       => '9',
                    9       => '10',
                    10       => '11',
                    11       => '12',
                    12       => '13',
                    13       => '14',
                    14       => '15',
                    15       => '16',
                    16       => '17',
                    17       => '18',
                    18       => '19',
                    19       => '20',
                ],
                'condition' => [
                    'layout_style' => 'style-1',
                    'show_featured_item' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'cache_gallery',
            [
                'label'   => esc_html__('Cache the Gallery', 'ultimate-post-kit-pro'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'cache_time',
            [
                'label'       => esc_html__('Cache Time', 'ultimate-post-kit-pro'),
                'description' => esc_html__('How much hour(s) you want to cache.', 'ultimate-post-kit-pro'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 12,
                'condition'   => [
                    'cache_gallery' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_item',
            [
                'label' => __('Item', 'ultimate-post-kit-pro'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'overlay_type',
            [
                'label'   => esc_html__('Overlay', 'ultimate-post-kit-pro'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'background',
                'options' => [
                    'none'       => esc_html__('None', 'ultimate-post-kit-pro'),
                    'background' => esc_html__('Background', 'ultimate-post-kit-pro'),
                    'blend'      => esc_html__('Blend', 'ultimate-post-kit-pro'),
                ],
                'condition' => [
                    'animation_style' => ['style-2', 'style-3', 'style-4', 'style-5'],
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'overlay_color',
                'label' => esc_html__('Background', 'ultimate-post-kit-pro'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .upk-instagram-gallery-animation-style-2 .upk-instagram-gallery-thumbnail::before, {{WRAPPER}} .upk-instagram-gallery-animation-style-3 .upk-instagram-gallery-thumbnail::before, {{WRAPPER}} .upk-instagram-gallery-animation-style-4 .upk-instagram-gallery-thumbnail::before, {{WRAPPER}} .upk-instagram-gallery-animation-style-5 .upk-instagram-gallery-thumbnail::before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Overlay Color', 'ultimate-post-kit-pro'),
                        'default' => 'gradient',
                    ],
                    'color' => [
                        'default' => '#11226900',
                    ],
                    'color_b' => [
                        'default' => '#051F8A70',
                    ],
                ],
                'condition' => [
                    'overlay_type' => ['background', 'blend'],
                    'animation_style' => ['style-2', 'style-3', 'style-4', 'style-5'],
                ],
            ]
        );

        $this->add_control(
            'blend_type',
            [
                'label'     => esc_html__('Blend Type', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'multiply',
                'options'   => ultimate_post_kit_blend_options(),
                'condition' => [
                    'overlay_type' => 'blend',
                    'animation_style' => ['style-2', 'style-3', 'style-4', 'style-5'],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery-animation-style-2 .upk-instagram-gallery-thumbnail::before, {{WRAPPER}} . upk-instagram-gallery-animation-style-3 .upk-instagram-gallery-thumbnail::before, {{WRAPPER}} . upk-instagram-gallery-animation-style-4 .upk-instagram-gallery-thumbnail::before, {{WRAPPER}} . upk-instagram-gallery-animation-style-5 .upk-instagram-gallery-thumbnail::before' => 'mix-blend-mode: {{VALUE}};'
                ],
            ]
        );

        $this->start_controls_tabs('tabs_item_style');

        $this->start_controls_tab(
            'tab_item_normal',
            [
                'label' => __('Normal', 'ultimate-post-kit-pro'),
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'item_background',
                'label'     => __('Background', 'ultimate-post-kit-pro'),
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'item_border',
                'label'       => __('Border', 'ultimate-post-kit-pro'),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item',
                'separator'   => 'before',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label'      => __('Border Radius', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label'      => esc_html__('Padding', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name'     => 'css_filters',
                'selector' => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item img, {{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item video',
            ]
        );

        $this->add_control(
            'item_opacity',
            [
                'label'     => __('Opacity (%)', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 1,
                ],
                'range'     => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-instagram-gallery-thumbnail img, {{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item video' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_item_hover',
            [
                'label' => __('Hover', 'ultimate-post-kit-pro'),
            ]
        );

        $this->add_control(
            'item_hover_border_color',
            [
                'label'     => __('Border Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name'     => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item:hover .upk-instagram-gallery-thumbnail img, {{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item:hover video',
            ]
        );

        $this->add_control(
            'item_hover_opacity',
            [
                'label'     => __('Opacity (%)', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 1,
                ],
                'range'     => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item:hover .upk-instagram-gallery-thumbnail img, {{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item:hover video' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_follow_us',
            [
                'label'      => __('Profile', 'ultimate-post-kit-pro'),
                'tab'        => Controls_Manager::TAB_STYLE,
                // 'condition' => [
                //     'show_featured_item' => 'yes'
                // ]
            ]
        );

        $this->start_controls_tabs(
            'tabs_follow_us'
        );
        $this->start_controls_tab(
            'tab_follow_us_label',
            [
                'label' => __('LABEL', 'ultimate-post-kit-pro'),
            ]
        );
        $this->add_control(
            'follow_us_label_color',
            [
                'label'     => __('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-follow-label' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'follow_us_legend_color',
            [
                'label'     => __('Legend Color (optional)', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-follow-label span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'follow_us_legend_spacing',
            [
                'label'         => __('Bottom Spacing', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .upk-follow-label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'follow_us_label_typography',
                'label'    => esc_html__('Typography', 'ultimate-post-kit-pro'),
                'selector' => '{{WRAPPER}} .upk-gallery-content span.upk-follow-label',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_follow_us_title',
            [
                'label' => __('TITLE', 'ultimate-post-kit-pro'),
            ]
        );
        $this->add_control(
            'follow_us_title_color',
            [
                'label'     => __('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-follow-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'follow_us_title_typography',
                'label'    => esc_html__('Typography', 'ultimate-post-kit-pro'),
                'selector' => '{{WRAPPER}} .upk-follow-title',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_profile_icon_size',
            [
                'label' => __('Instagram Icon', 'ultimate-post-kit-pro'),
            ]
        );

        $this->add_responsive_control(
            'featured_item_icon_size',
            [
                'label'     => __('Icon Size', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 60,
                ],
                'range'     => [
                    'px' => [
                        'min'  => 50,
                        'max'  => 500,
                        'step' => 5,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-feature-item img' => 'width: {{SIZE}}px;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_icon',
            [
                'label' => __('Icon', 'ultimate-post-kit-pro'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tabs_icon_style');

        $this->start_controls_tab(
            'tab_icon_normal',
            [
                'label' => esc_html__('Normal', 'ultimate-post-kit-pro'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => __('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'icon_background',
                'label'     => __('Background', 'ultimate-post-kit-pro'),
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'icon_border',
                'label'       => __('Border', 'ultimate-post-kit-pro'),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon',
                'separator'   => 'before',
            ]
        );


        $this->add_responsive_control(
            'icon_border_radius',
            [
                'label'      => __('Border Radius', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label'                 => __('Padding', 'ultimate-post-kit-pro'),
                'type'                  => Controls_Manager::DIMENSIONS,
                'size_units'            => ['px', '%', 'em'],
                'selectors'             => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'icon_box_shadow',
                'selector' => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon',
            ]
        );

        $this->add_responsive_control(
            'font_size',
            [
                'label'         => __('Font Size', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_icon_hover',
            [
                'label' => esc_html__('Hover', 'ultimate-post-kit-pro'),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label'     => __('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'icon_hover_background',
                'selector'  => '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon:hover',
            ]
        );

        $this->add_control(
            'icon_hover_border_color',
            [
                'label'     => esc_html__('Border Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'icon_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-instagram-gallery .upk-instagram-gallery-item .upk-gallery-icon:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function filter_response($response) {
        if (is_wp_error($response)) {
            $response = array(
                'status'  => 422,
                'message' => $response->get_error_message()
            );
        } else {
            $response = array(
                'status'  => wp_remote_retrieve_response_code($response),
                'message' => wp_remote_retrieve_response_message($response),
                'body'    => json_decode(wp_remote_retrieve_body($response)),
            );
        }


        return (object)$response;
    }

    protected function remote_get($url) {
        $response = wp_remote_get(
            $url,
            array(
                'timeout'    => 100,
                'user-agent' => $_SERVER['HTTP_USER_AGENT'],
            )
        );

        return $this->filter_response($response);
    }

    protected $graph_url = 'https://graph.instagram.com';

    protected function get_access_token_transit_key($user_token) {

        $widget_id  = strtolower($this->get_id());
        $user_token = md5($user_token);
        $user_token = strtolower($user_token);
        return 'upk_instagram_long_lived_access_token_' . $widget_id . '_' . $user_token;
    }

    protected function get_instagram_account_transit_key($user_token) {

        $widget_id  = strtolower($this->get_id());
        $user_token = md5($user_token);
        $user_token = strtolower($user_token);
        return 'upk_instagram_account_id_' . $widget_id . '_' . $user_token;
    }

    protected function get_instagram_media_data_transit_key($user_token) {

        $widget_id  = strtolower($this->get_id());
        $user_token = md5($user_token);
        $user_token = strtolower($user_token);
        return 'upk_instagram_media_data_' . $widget_id . '_' . $user_token;
    }

    protected function refresh_token($token, $app_secret) {
        $url    = $this->graph_url . "/refresh_access_token?grant_type=ig_refresh_token&access_token=$token";
        $result = $this->remote_get($url);

        if ($result->status == 200 && isset($result->body->access_token)) {
            return $result->body->access_token;
        }
        return $result;
    }

    protected function get_access_token($user_token, $app_secret) {
        $cache_key       = $this->get_access_token_transit_key($user_token);
        $accessTokenData = get_transient($cache_key);

        if (!$accessTokenData) {
            $url    = $this->graph_url . "/refresh_access_token?grant_type=ig_refresh_token&&access_token=$user_token";
            $result = $this->remote_get($url);

            if ($result->status == 200) {
                $accessTokenData = $result->body->access_token;
                $accessTokenData = $accessTokenData . '_bdthemes_' . time();
                set_transient($cache_key, $accessTokenData);
            } else {
                return $result;
            }
        }


        $accessTokenArr = explode('_bdthemes_', $accessTokenData);
        if (count($accessTokenArr) == 2) {
            $access_token  = $accessTokenArr[0];
            $generatedTime = $accessTokenArr[1];
            $now           = time(); // or your date as well
            $datediff      = $now - $generatedTime;
            $totalDays     = round($datediff / (60 * 60 * 24));

            if ($totalDays > 40) {
                $access_token = $this->refresh_token($access_token, $app_secret);
                if (is_string($access_token)) {
                    $accessTokenData = $access_token . '_bdthemes_' . time();
                    set_transient($cache_key, $accessTokenData);
                }
            }
            return $access_token;
        }
    }

    private function get_instagram_account_id($access_token) {
        $cache_key  = $this->get_instagram_account_transit_key($access_token);
        $account_id = get_transient($cache_key);

        if (!$account_id) {
            $url    = $this->graph_url . "/me?fields=id&access_token=$access_token";
            $result = $this->remote_get($url);
            if ($result->status == 200) {
                $account_id = $result->body->id;
                set_transient($cache_key, $account_id, DAY_IN_SECONDS * 100);
            } else {
                return $result;
            }
        }

        return $account_id;
    }

    public function get_media($access_token, $account_id) {

        $cache_key = $this->get_instagram_media_data_transit_key($access_token);
        $settings   = $this->get_settings_for_display();
        $data       = '';

        $isCacheEnabled = isset($settings['cache_gallery']) && $settings['cache_gallery'] == 'yes';
        if ($isCacheEnabled) {
            $data           = get_transient($cache_key);
        } else {
            delete_transient($cache_key);
        }

        if (!$data) {
            $url    = $this->graph_url . "/$account_id/media?fields=id,media_type,media_url,permalink,username,timestamp&access_token=$access_token&limit=100";
            $result = $this->remote_get($url);
            if ($result->status == 200) {
                $data       = $result->body;

                if ($isCacheEnabled) {
                    $cache_time = isset($settings['cache_time']) ? intval($settings['cache_time']) : 1;
                    if ($cache_time < 1) {
                        $cache_time = 1;
                    }
                    set_transient($cache_key, $data, (HOUR_IN_SECONDS * $cache_time));
                }
            } else {
                return $result;
            }
        }

        return $data;
    }

    public function get_collect_data($app_secret) {
        $settings             = $this->get_settings_for_display();
        $options              = get_option('ultimate_post_kit_api_settings');

        if ($settings['instagram_user_token']) {
            $instagram_user_token = $settings['instagram_user_token'];
        } elseif (!empty($options['instagram_access_token'])) {
            $instagram_user_token = $options['instagram_access_token'];
        } else {
            ultimate_post_kit_alert('Ops! You did not set Instagram User Token!');
            return false;
        }

        //$access_token = $this->get_access_token($instagram_user_token, $app_secret);
        $access_token = $instagram_user_token;
        if (is_string($access_token) && strlen($access_token) > 20) {
            $account_id = $this->get_instagram_account_id($access_token);
            if (is_string($account_id) && strlen($account_id) > 5) {
                return $this->get_media($access_token, $account_id);
            } else {
                return $account_id;
            }
        }

        return $access_token;
    }

    public function get_instagram_data($app_secret) {
        $data = $this->get_collect_data($app_secret);
        if (isset($data->data)) {
            return $data->data;
        } else {
            if (isset($data->status) && $data->status == 422) {
                ultimate_post_kit_alert($data->message);
            }
        }
        return [];
    }


    public function render() {
        $settings = $this->get_settings_for_display();

        $options = get_option('ultimate_post_kit_api_settings');

        $instagram_app_secret = (!empty($options['instagram_app_secret'])) ? $options['instagram_app_secret'] : '';

        if (!$instagram_app_secret) {
            ultimate_post_kit_alert('Ops! You did not set Instagram App Secret in Ultimate Post Kit settings!');

            return;
        }

        /**
         * This is the data
         */
        $data = $this->get_instagram_data($instagram_app_secret);

        $this->add_render_attribute('instagram', 'class', 'upk-instagram-gallery upk-instagram-gallery-gallery-' . $settings['layout_style'] . '');
        $this->add_render_attribute('instagram', 'class', 'upk-instagram-gallery-animation-' . $settings['animation_style'] . '');

?>
        <div <?php echo $this->get_render_attribute_string('instagram'); ?>>



            <?php
            $limit = 1;
            foreach ($data as $key => $item) {
                $target_href = (isset($settings['show_link']) && ($settings['show_link'] == 'yes')) ? $item->permalink : $item->media_url;
                $target_blank = (isset($settings['target_blank']) && ('yes' == $settings['target_blank'])) ? '_blank' : '_self';

                if ($settings['layout_style'] === 'style-1') {
                    $feature_index = $settings['feature_item_position'];
                } elseif ($settings['layout_style'] === 'style-6') {
                    $feature_index = 2;
                } else {
                    $feature_index = 1;
                }


            ?>
                <?php if ($key == $feature_index) { ?>
                    <?php if ($settings['show_featured_item'] !== '') {
                    ?>
                        <div class="upk-instagram-gallery-item upk-feature-item">
                            <a class="upk-gallery-content" target="<?php echo esc_attr($target_blank); ?>" href="<?php echo esc_url('https://instagram.com/' . $item->username); ?>" data-elementor-open-lightbox="yes">
                                <img class="upk-feature-image" src="<?php echo esc_attr(BDTUPK_ASSETS_URL . 'images/instagram.svg') ?>" alt="">
                                <span class="upk-follow-label"><span><?php echo esc_html_x('Follow', 'frontend', 'ultimate-post-kit-pro'); ?></span> <?php echo esc_html_x(' us on', 'frontend', 'ultimate-post-kit-pro'); ?></span>
                                <h2 class="upk-follow-title"><?php echo esc_html_x('Instagram', 'frontend', 'ultimate-post-kit-pro'); ?></h2>
                            </a>
                        </div>
                    <?php }
                    ?>
                <?php } ?>
                <div class="upk-instagram-gallery-item">
                    <?php
                    $embed_url_params = [
                        'autoplay' => 1,
                        'rel' => 0,
                        'controls' => 0,
                    ];

                    $lightbox_options = [
                        'type'         => 'VIDEO' == $item->media_type ? 'video' : 'image',
                        'url'          => $item->media_url,
                        'modalOptions' => [
                            'id' => 'elementor-lightbox-' . $this->get_id(),
                        ],
                    ];

                    $this->add_render_attribute('instagram-video-thumbs', [
                        'class'                        => 'upk-instagram-gallery-thumbnail elementor-clickable',
                        'target'                       => esc_attr($target_blank),
                        'href'                         => esc_url($item->media_url),
                        'data-elementor-open-lightbox' => 'yes',
                        'data-elementor-lightbox'      => wp_json_encode($lightbox_options),
                        'e-action-hash'                => \Elementor\Plugin::instance()->frontend->create_action_hash('lightbox', $lightbox_options),
                    ], null, true);

                    $tag = 'a';

                    if ('VIDEO' == $item->media_type) {
                        $this->add_render_attribute('instagram-video-thumbs', [
                            'href'             => 'javascript:void(0);',
                            'data-href'        => esc_url($item->media_url),
                            'data-lightbox-id' => 'elementor-lightbox-' . $this->get_id(),
                            'class'            => 'upk-instagram-gallery-thumbnail elementor-clickable upk-inst-lightbox',
                            'style'            => 'cursor:pointer;'
                        ], null, true);

                        $tag = 'div';
                    }

                    ?>

                    <<?php echo esc_attr($tag); ?> <?php $this->print_render_attribute_string('instagram-video-thumbs'); ?>>
                        <?php if ('VIDEO' == $item->media_type) : ?>
                            <video src="<?php echo $item->media_url; ?>" title="Image by: <?php echo $item->username; ?>"></video>
                        <?php else : ?>
                            <img src="<?php echo $item->media_url; ?>" alt="Image by: <?php echo $item->username; ?>" loading="lazy">
                        <?php endif; ?>
                        <div class="upk-gallery-icon">
                            <i class="upk-icon-instagram"></i>
                        </div>
                    </<?php echo esc_attr($tag); ?>>
                </div>
            <?php
                switch ($settings['layout_style']) {
                    case 'style-1':
                        $skin_item_limit =  $settings['items']['size'];
                        break;
                    case 'style-2':
                        $skin_item_limit =  4;
                        break;
                    case 'style-3':
                        $skin_item_limit =  4;
                        break;
                    case 'style-4':
                        $skin_item_limit =  5;
                        break;
                    case 'style-5':
                        $skin_item_limit =  2;
                        break;
                    case 'style-6':
                        $skin_item_limit =  8;
                        break;
                    default:
                        $skin_item_limit =  $settings['items']['size'];
                        break;
                }
                if ($limit++ == $skin_item_limit) {
                    break;
                }
                // if ($limit++ == $settings['items']['size']) {
                //     break;
                // }
            }
            ?>
        </div>
<?php
    }
}
