<?php

namespace UltimatePostKitPro\Modules\HoluxTabs;

use Elementor\Utils;
use UltimatePostKitPro\Base\Ultimate_Post_Kit_Module_Base;
use WP_Query;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

class Module extends Ultimate_Post_Kit_Module_Base {

	public function __construct() {
		parent::__construct();
		add_action('wp_ajax_upk_holux_tabs', [$this, 'upk_holux_tabs_callback']);
		add_action('wp_ajax_nopriv_upk_holux_tabs', [$this, 'upk_holux_tabs_callback']);
	}

	public function get_name() {
		return 'holux-tabs';
	}

	public function get_widgets() {
		$widgets = [
			'Holux_Tabs',
		];

		return $widgets;
	}

	public function get_tab_output($output) {
        $tags = [
            'div'  => ['class' => [], 'style' => [], 'data-src' => []],
            'a'    => ['href'  => [], 'target'      => [], 'class' => [], 'data-bdt-tooltip' => [], 'data-fslightbox' => []],
            'span' => ['class' => [], 'style' => []],
            'i'    => ['class' => [], 'aria-hidden' => []],
            'img'  => ['src'   => []],
            'h3'   => [
            	'class' => []
            ],
			'iframe' => [
				'src' => [],
				'allow' => [],
				'class' => [],
				'width' => [],
				'height' => [],
				'style' => [],
				'frameborder' => [],
				'allowfullscreen' => [],
				'id' => []
			]
		];

        if (isset($output)) {
            echo wp_kses($output, $tags);
        }
    }

	function upk_holux_tabs_callback() {

		$show_title          = sanitize_text_field($_POST['show_title']);
		$show_category       = sanitize_text_field($_POST['show_category']);
		$show_meta           = sanitize_text_field($_POST['show_meta']);
		$meta_separator      = sanitize_text_field($_POST['meta_separator']);
		$show_author         = sanitize_text_field($_POST['show_author']);
		$show_date           = sanitize_text_field($_POST['show_date']);
		$show_reading_time   = sanitize_text_field($_POST['show_reading_time']);
		// $avg_reading_speed   = sanitize_text_field($_POST['avg_reading_speed']);
		$posts_per_page      = sanitize_text_field($_POST['posts_per_page']);
		$order 				 = sanitize_text_field($_POST['order']);
		$trending_days 		 = sanitize_text_field($_POST['trending_days_limit']);

		$post_type 			 = sanitize_text_field($_POST['post_type']);
		$post_format         = sanitize_text_field($_POST['post_format']);
		$filter_by 			 = sanitize_text_field($_POST['filter_by']);

		$query_args          = [
			'post_type'      => $post_type,
			'post_status'    => 'publish',
			'posts_per_page' => $posts_per_page,
			'order'          => $order
		];
		if (isset($post_format)) {
			switch ($post_format) {
				case 'standard':
					$query_args['tax_query'] = [
						[
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms'    => [
								'post-format-aside',
								'post-format-audio',
								'post-format-chat',
								'post-format-gallery',
								'post-format-link',
								'post-format-image',
								'post-format-quote',
								'post-format-status',
								'post-format-video',
							],
							'operator' => 'NOT IN'
						]
					];
					break;
				case 'all':
					$query_args['tax_query'] = [];
					break;
				default:
					$query_args['tax_query'] = [
						[
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms'    => ['post-format-' . $post_format . ''],
						]
					];
					break;
			}
		}

		switch ($filter_by) {
			case 'trending':
				$query_args['orderby']    = 'comment_count';
				$query_args['order']      = 'DESC';
				$query_args['date_query'] = [
					'after'     => '' . $trending_days . ' days ago',
					'inclusive' => true,
				];
				break;
			case 'popular':
				$query_args['orderby'] = 'comment_count';
				$query_args['order']   = 'DESC';
				break;
			case 'random':
				$query_args['orderby'] = 'rand';
				$query_args['order']   = 'DESC';
				break;
			case 'modified':
				$query_args['orderby'] = 'modified';
				$query_args['order']   = 'DESC';
				break;
			case 'video':
				$query_args['meta_query'] = [
					[
						'key' => '_upk_video_link_meta_key',
						'compare' => 'EXISTS'
					]
				];
				$query_args['order']   = 'DESC';
				break;
			default:
				$query_args['orderby'] = 'date';
				$query_args['order']   = 'DESC';
				break;
		}


		$ajaxposts = new WP_Query($query_args);
		$response  = '';
		if ($ajaxposts->have_posts()) {
			while ($ajaxposts->have_posts()) : $ajaxposts->the_post();
				$title = get_the_title();
				$post_link             = get_permalink();
				$image_src             = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');
				$category              = upk_get_category($post_type);
				$author_url            = get_author_posts_url(get_the_author_meta('ID'));
				$author_name           = get_the_author();
				$date                  = get_the_date();
				// $avg_reading_speed	   = get_option('avg_reading_speed', 200);
				$reading_time		   = ultimate_post_kit_reading_time(get_the_content(), 200);
				$id					= get_the_ID();
				$placeholder_image_src = Utils::get_placeholder_image_src();
				if (empty($image_src)) {
					$image_src = $placeholder_image_src;
				}

				$video_link = get_post_meta(get_the_ID(), '_upk_video_link_meta_key', true);
				if ($video_link !== false) {
					$youtube_id = (preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $video_link, $match)) ? $match[1] : false;
	
					$vimeo_id = (preg_match('%^https?:\/\/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\d+)\/video\/|video\/|)(\d+)(?:$|\/|\?)(?:[?]?.*)$%im', $video_link, $match)) ? $match[3] : false;
			
					if ($youtube_id) {
						// $video_source    = 'https://www.youtube.com/watch?v=' . $youtube_id;
						$video_source = 'https://www.youtube.com/embed/' . $youtube_id;
					} elseif ($vimeo_id) {
						$video_source = 'https://vimeo.com/' . $vimeo_id;
					} else {
						$video_source = false;
					}
					$video_link = $video_source;
				}

				if (($show_author !== null) && ($show_author === 'yes')) {
					$response_author = '<div class="upk-author"><a href="' . $author_url . '"><i class="upk-icon-user"></i><span class="upk-author-name">' . $author_name . '</span></a></div>';
				}
				if (($show_date !== null) && ($show_date === 'yes')) {
					$response_date = '<div class="upk-date"><i class="upk-icon upk-icon-calendar"></i> <span class="upk-date-text">' . $date . '</span></div>';
				}
				if (($show_reading_time !== null) && ($show_reading_time === 'yes')) {
					$response_reading_time = '<span class="upk-separator">' . $meta_separator . '</span><div class="upk-reading-time">' . $reading_time . '</div>';
				}

				if ($filter_by === 'video' && $video_link !== false) {

					$response .= '<div class="upk-item"><div class="upk-item-box">';
					$response .= '<div class="upk-image"><a href="' . $post_link . '"><img  src="' . $image_src . '"></a>';
					if ($filter_by === 'video' && $video_link !== false) {
						$response .= '<div class="upk-play-btn-wrap"><a data-fslightbox="lightbox" href="#lightbox-'. esc_attr($id) . '" class="upk-play-button" data-class="fslightbox-source">';
						$response .= '<i class="upk-icon-play" aria-hidden="true"></i>';
						$response .= '</a>';
						$response .= '<div class="usk-hidden">';
						$response .= '<iframe src="' . $video_link . '" id="lightbox-'. esc_attr($id) . '" width="1920px" height="1080px" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe>';
						$response .= '</div></div>';
					}
					$response .= '</div>';
					$response .= '<div class="upk-content">';
					if (($show_category !== null) && ($show_category === 'yes')) {
						$response .= '<div class="upk-category">' . $category . '</div>';
					}
					if (($show_title !== null) && ($show_title === 'yes')) {
						$response .= '<h3 class="upk-title"><a href="' . $post_link . '">' . $title . '</a></h3>';
					}
					if (($show_meta !== null) && ($show_meta === 'yes')) {
						$response .= '<div class="upk-meta">' . $response_author . '<span class="upk-separator">' . $meta_separator . '</span>' . $response_date . $response_reading_time . '</div>';
					}
					
					$response .= '</div></div></div>';
				} elseif ($filter_by !== 'video') {
					$response .= '<div class="upk-item"><div class="upk-item-box">';
					$response .= '<div class="upk-image"><a href="' . $post_link . '"><img  src="' . $image_src . '"></a></div>';
					$response .= '<div class="upk-content">';
					if (($show_category !== null) && ($show_category === 'yes')) {
						$response .= '<div class="upk-category">' . $category . '</div>';
					}
					if (($show_title !== null) && ($show_title === 'yes')) {
						$response .= '<h3 class="upk-title"><a href="' . $post_link . '">' . $title . '</a></h3>';
					}
					if (($show_meta !== null) && ($show_meta === 'yes')) {
						$response .= '<div class="upk-meta">' . $response_author . '<span class="upk-separator">' . $meta_separator . '</span>' . $response_date . $response_reading_time . '</div>';
					}
					$response .= '</div></div></div>';
				}

			endwhile;
		} else {
			$response = '<span style="font-size:18px; text-transform:uppercase">'. esc_html__('posts not found', 'ultimate-post-kit-pro') .'</span>';
		}

		$this->get_tab_output($response);

		exit;
	}
}
