<?php

namespace UltimatePostKit\Modules\ArchiveTitle\Widgets;
use UltimatePostKit\Base\Module_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

class Archive_Title extends Module_Base {

	public function get_name() {
		return 'upk-archive-title';
	}

	public function get_title() {
		return BDTUPK . esc_html__('Archive Title', 'ultimate-post-kit-pro');
	}

	public function get_icon() {
		return 'upk-widget-icon upk-icon-post-title';
	}

	public function get_categories() {
		return ['ultimate-post-kit-pro'];
	}

	public function get_keywords() {
		return ['archvie', 'title', 'blog', 'recent', 'news', 'alter'];
	}

	public function has_widget_inner_wrapper(): bool {
        return ! \Elementor\Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
    }
	protected function is_dynamic_content(): bool {
		return true;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__('Layout', 'ultimate-post-kit-pro'),
			]
		);

		// title field
		$this->add_control(
			'upk_archive_title_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'ultimate-post-kit-pro'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'h1' => esc_html__('H1', 'ultimate-post-kit-pro'),
					'h2' => esc_html__('H2', 'ultimate-post-kit-pro'),
					'h3' => esc_html__('H3', 'ultimate-post-kit-pro'),
					'h4' => esc_html__('H4', 'ultimate-post-kit-pro'),
					'h5' => esc_html__('H5', 'ultimate-post-kit-pro'),
					'h6' => esc_html__('H6', 'ultimate-post-kit-pro'),
					'p'  => esc_html__('P', 'ultimate-post-kit-pro'),
					'div'=> esc_html__('DIV', 'ultimate-post-kit-pro'),
				],
				'default' => 'h2',
			]
		);

		// alignment
		$this->add_responsive_control(
			'upk_title_alignment',
			[
				'label'     => __('Alignment', 'ultimate-post-kit-pro'),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => __('Left', 'ultimate-post-kit-pro'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __('Center', 'ultimate-post-kit-pro'),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => __('Right', 'ultimate-post-kit-pro'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .upk-post-archive-title' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'upk_section_style',
			[
				'label' => esc_html__('Title', 'ultimate-post-kit-pro'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		// color
		$this->add_control(
			'upk_title_color',
			[
				'label'     => esc_html__('Color', 'ultimate-post-kit-pro'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .upk-post-archive-title' => 'color: {{VALUE}}',
				],
			]
		);

		// Typography
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'upk_title_typography',
				'label'    => esc_html__('Typography', 'ultimate-post-kit-pro'),
				'selector' => '{{WRAPPER}} .upk-post-archive-title',
			]
		);

		// Text Shadow
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'upk_title_shadow',
				'label'    => __('Text Shadow', 'ultimate-post-kit-pro'),
				'selector' => '{{WRAPPER}} .upk-post-archive-title',
			]
		);

		$this->end_controls_section();
	}

	public function render(){
		$settings = $this->get_settings_for_display();

		$html_tag = $settings['upk_archive_title_tag'];
		$post_archive_title = get_the_archive_title();
		printf( '<%1$s class="upk-post-archive-title">%2$s</%1$s>', esc_attr($html_tag), esc_attr($post_archive_title) );
	}
}
