<?php

namespace UltimatePostKitPro;

use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/**
 * Main class for element pack
 */
class Ultimate_Post_Kit_Pro_Loader {

	/**
	 * @var Ultimate_Post_Kit_Pro_Loader
	 */
	private static $_instance;

	/**
	 * @var Manager
	 */
	private $_modules_manager;

	private $classes_aliases;

	public $elements_data = [ 
		'sections' => [],
		'columns'  => [],
		'widgets'  => [],
	];

	/**
	 * @return string
	 * @deprecated
	 *
	 */
	public function get_version() {
		return BDTUPK_PRO_VER;
	}

	/**
	 * return active theme
	 */
	public function get_theme() {
		return wp_get_theme();
	}

	/**
	 * Throw error on object clone
	 *
	 * The whole idea of the singleton design pattern is that there is a single
	 * object therefore, we don't want the object to be cloned.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function __clone() {
		// Cloning instances of the class is forbidden
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'ultimate-post-kit-pro' ), '1.6.0' );
	}

	/**
	 * Disable unserializing of the class
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function __wakeup() {
		// Unserializing instances of the class is forbidden
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'ultimate-post-kit-pro' ), '1.6.0' );
	}

	/**
	 * @return Plugin
	 */

	public static function elementor() {
		return Plugin::$instance;
	}

	/**
	 * @return Ultimate_Post_Kit_Pro_Loader
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}


	/**
	 * we loaded module manager + admin php from here
	 * @return [type] [description]
	 */
	private function _includes() {

		require_once BDTUPK_PRO_INC_PATH . 'modules-manager.php';

		/**
		 * Load helper functions & template builder
		 */
		require BDTUPK_PRO_PATH . 'base/support/helpers.php';
		require BDTUPK_PRO_INC_PATH . 'builder/loading-builder.php';

		/**
		 * Load shortcode
		 */
		require BDTUPK_PRO_INC_PATH . 'shortcode.php';
	}

	/**
	 * Autoloader function for all classes files
	 *
	 * @param  [type] class [description]
	 *
	 * @return [type]        [description]
	 */
	public function autoload( $class ) {
		if ( 0 !== strpos( $class, __NAMESPACE__ ) ) {
			return;
		}

		$class_to_load = $class;

		// echo '<pre>';

		// echo  $class_to_load;

		// echo '</pre>';

		if ( ! class_exists( $class_to_load ) ) {
			$filename = strtolower(
				preg_replace(
					[ '/^' . __NAMESPACE__ . '\\\/', '/([a-z])([A-Z0-9])/', '/_/', '/\\\/' ],
					[ '', '$1-$2', '-', DIRECTORY_SEPARATOR ],
					$class_to_load
				)
			);

			$filename = BDTUPK_PRO_PATH . $filename . '.php';



			if ( is_readable( $filename ) ) {
				include ( $filename );
			}
		}
	}

	public function register_site_styles() {
		$direction_suffix = is_rtl() ? '.rtl' : '';

		wp_register_style( 'upk-all-styles-pro', BDTUPK_PRO_ASSETS_URL . 'css/upk-all-styles' . $direction_suffix . '.css', [], BDTUPK_PRO_VER );
		wp_register_style( 'upk-font', BDTUPK_PRO_ASSETS_URL . 'css/upk-font' . $direction_suffix . '.css', [], BDTUPK_PRO_VER );
	}

	public function register_site_scripts() {
		wp_register_script( 'upk-all-scripts-pro', BDTUPK_PRO_ASSETS_URL . 'js/upk-all-scripts.min.js', [ 
			'jquery',
			'scrolline'
		], BDTUPK_PRO_VER, true );
	}


	/**
	 * initialize the category
	 * @return [type] [description]
	 */
	public function ultimate_post_kit_init() {
		$this->_modules_manager = new Manager();

		do_action( 'bdthemes_ultimate_post_kit/init' );
	}

	/**
	 * initialize the category
	 * @return [type] [description]
	 */
	public function ultimate_post_kit_category_register() {
		if ( function_exists( 'upk_license_validation' ) && true !== upk_license_validation() ) {
			add_filter( 'elementor/editor/localize_settings', function ($settings) {
				$pro_widget_map       = new \UltimatePostKit\Includes\Pro_Widget_Map();
				$pro_widgets_raw_data = $pro_widget_map->get_pro_widget_map();
				$pro_widgets          = array_column($pro_widgets_raw_data, 'name');
				$pro_widgets = array_map(function ($widget) {
					return 'upk-' . $widget;
				}, $pro_widgets);

				$elementor_widget_blacklist = $pro_widgets;

				foreach ( $elementor_widget_blacklist as $widget_name ) {
					$settings['initial_document']['widgets'][ $widget_name ]['show_in_panel'] = false;
				}

				return $settings;
			}, 999 );

			return;
		}

		$elementor = Plugin::$instance;
		$elementor->elements_manager->add_category(
			'ultimate-post-kit-pro',
			[ 
				'title' => esc_html__( 'Ultimate Post Kit Pro', 'ultimate-post-kit-pro' ),
				'icon'  => 'font'
			]
		);
	}
	public function ultimate_post_kit_single_category_register() {

		$elementor = Plugin::$instance;
		// Add element category in panel
		$elementor->elements_manager->add_category(
			'ultimate-post-kit-template-builder',
			[ 
				'title' => esc_html__( 'Ultimate Post Kit (Single)', 'ultimate-post-kit-pro' ),
				'icon'  => 'font'
			]
		);
	}

	private function setup_hooks() {
		add_action( 'elementor/elements/categories_registered', [ $this, 'ultimate_post_kit_single_category_register' ], 1, 2 );
		add_action( 'elementor/elements/categories_registered', [ $this, 'ultimate_post_kit_category_register' ] );
		add_action( 'elementor/init', [ $this, 'ultimate_post_kit_init' ] );

		add_action( 'wp_enqueue_scripts', [ $this, 'register_site_styles' ], 99999 );
		add_action( 'wp_enqueue_scripts', [ $this, 'register_site_scripts' ], 99999 );
	}

	public function init(){
		if ( ! defined( 'BDTUPK_CH' ) && is_admin() ) {
			require_once BDTUPK_PRO_ADMIN_PATH . 'admin.php';
		}
	}

	/**
	 * Ultimate_Post_Kit_Pro_Loader constructor.
	 */
	private function __construct() {
		// Register class automatically
		spl_autoload_register( [ $this, 'autoload' ] );
		// Include some backend files
		$this->_includes();

		// Finally hooked up all things here
		$this->setup_hooks();

		add_action('init', [ $this, 'init' ]);
	}
}

if ( ! defined( 'BDTUPK_PRO_TESTS' ) ) {
	// In tests we run the instance manually.
	Ultimate_Post_Kit_Pro_Loader::instance();
}

// handy fundtion for push data
function ultimate_post_kit_config() {
	return Ultimate_Post_Kit_Pro_Loader::instance();
}
