<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use UltimatePostKit\Utils;

/**
 * @param \Elementor\Controls_Stack $element    The element stack.
 * @param string                    $section_id Section ID.
 * @param array                     $args       Section arguments.
 */

add_action('elementor/element/upk-skide-slider/section_style_thumbs/after_section_end', function ($element, $section_id) {

    if ('upk-skide-slider' == $element->get_name()) {

        $element->start_controls_section(
            'section_style_top_stories',
            [
                'label'     => esc_html__('Top Stories', 'ultimate-post-kit-pro'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_top_stories' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'glassmorphism_effect',
            [
                'label' => esc_html__('Glassmorphism', 'ultimate-post-kit-pro') . BDTUPK_NC,
                'type'  => Controls_Manager::SWITCHER,
                'description' => sprintf(esc_html__('This feature will not work in the Firefox browser untill you enable browser compatibility so please %1s look here %2s', 'ultimate-post-kit-pro'), '<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/backdrop-filter#Browser_compatibility" target="_blank">', '</a>'),
            ]
        );

        $element->add_control(
            'glassmorphism_blur_level',
            [
                'label'       => esc_html__('Blur Level', 'ultimate-post-kit-pro'),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px' => [
                        'min'  => 0,
                        'step' => 1,
                        'max'  => 50,
                    ]
                ],
                'default'     => [
                    'size' => 5
                ],
                'selectors'   => [
                    '{{WRAPPER}} .upk-skide-top-stories' => 'backdrop-filter: blur({{SIZE}}px); -webkit-backdrop-filter: blur({{SIZE}}px);'
                ],
                'condition' => [
                    'glassmorphism_effect' => 'yes',
                ]
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'stories_background',
                'selector'  => '{{WRAPPER}} .upk-skide-top-stories',
                'separator' => 'before',
            ]
        );

        $element->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'stories_border',
                'selector'    => '{{WRAPPER}} .upk-skide-top-stories',
            ]
        );

        $element->add_responsive_control(
            'stories_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'stories_padding',
            [
                'label'      => __('Padding', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'stories_shadow',
                'selector' => '{{WRAPPER}} .upk-skide-top-stories',
            ]
        );

        $element->add_control(
            'top_stories_header',
            [
                'label'     => esc_html__('HEADER TEXT', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $element->add_control(
            'top_stories_title_color',
            [
                'label'     => esc_html__('Header Text Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-header-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'top_stories_title_spacing',
            [
                'label'      => __('Spacing', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-header-title' => 'margin-bottom: {{SIZE}}{{UNIT};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'top_stories_title_typography',
                'label'     => esc_html__('Typography', 'ultimate-post-kit-pro'),
                'selector'  => '{{WRAPPER}} .upk-skide-top-stories .upk-header-title',
            ]
        );

        $element->add_control(
            'top_stories_divider_color',
            [
                'label'     => esc_html__('Divider Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-stories-item' => 'border-bottom-color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );

        $element->add_control(
            'top_stories_hr',
            [
                'type'      => Controls_Manager::DIVIDER,
            ]
        );

        $element->start_controls_tabs('tabs_top_stories_style');

        $element->start_controls_tab(
            'tab_top_stories_image',
            [
                'label' => esc_html__('Image', 'ultimate-post-kit-pro'),
            ]
        );

        $element->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'top_stories_image_border',
                'selector'    => '{{WRAPPER}} .upk-skide-top-stories .upk-img',
            ]
        );

        $element->add_responsive_control(
            'top_stories_image_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'top_stories_img_margin',
            [
                'label'      => __('Margin', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->end_controls_tab();

        $element->start_controls_tab(
            'tab_top_stories_date',
            [
                'label' => esc_html__('Date', 'ultimate-post-kit-pro'),
            ]
        );

        $element->add_control(
            'stories_date_color',
            [
                'label'     => esc_html__('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'stories_date_margin',
            [
                'label'      => __('Margin', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'stories_date_typography',
                'label'     => esc_html__('Typography', 'ultimate-post-kit-pro'),
                'selector'  => '{{WRAPPER}} .upk-skide-top-stories .upk-date',
            ]
        );

        $element->end_controls_tab();

        $element->start_controls_tab(
            'tab_top_stories_title',
            [
                'label' => esc_html__('Title', 'ultimate-post-kit-pro'),
            ]
        );

        $element->add_control(
            'stories_title_color',
            [
                'label'     => esc_html__('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->add_control(
            'stories_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'stories_title_margin',
            [
                'label'      => __('Margin', 'ultimate-post-kit-pro'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-skide-top-stories .upk-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'stories_title_typography',
                'label'     => esc_html__('Typography', 'ultimate-post-kit-pro'),
                'selector'  => '{{WRAPPER}} .upk-skide-top-stories .upk-title',
            ]
        );

        $element->end_controls_tab();

        $element->end_controls_tabs();

        $element->end_controls_section();
    }
}, 20, 2);


function render_top_stories($object) {

    $settings = $object->get_settings_for_display();

    if (!$object->get_settings('show_top_stories')) {
        return;
    } ?>
    <div class="upk-skide-top-stories">
        <h3 class="upk-header-title"><?php echo esc_html_x('Top Stories', 'Frontend', 'ultimate-post-kit-pro') ?></h3>
        <?php

        $selected_ids      = $object->get_settings_for_display('top_stories_selected_ids');
        $selected_ids      = wp_parse_id_list($selected_ids);
        if (!empty($selected_ids)) {
            $args['post__in'] = $selected_ids;
            $args['orderby'] = 'date';
        } else {
            $args['post_type'] = $object->get_settings('posts_source');
            $args['orderby'] = 'comment_count';
        }
        $defaults = [
            'post_status' => 'publish',
            'posts_per_page'      => 3,
            'order' => 'desc',
            'suppress_filters' => true,
            'ignore_sticky_posts' => true,
        ];
        $query_options = array_merge($args, $defaults);
        $story_posts = new \WP_Query($query_options);

        if (!$story_posts->found_posts) {
            return;
        }

        while ($story_posts->have_posts()) :
            $story_posts->the_post(); ?>
            <div class="upk-stories-item">
                <div class="upk-stories-img">
                    <?php $placeholder_image_src = Utils::get_placeholder_image_src();
                    $image_id = get_post_thumbnail_id(get_the_ID());
                    $image_src = wp_get_attachment_image_src($image_id, 'thumbnail');
                    if (!$image_src) {
                        $image_src = $placeholder_image_src;
                    } else {
                        $image_src = $image_src[0];
                    }
                    ?>
                    <img class="upk-img swiper-lazy" src="<?php echo esc_url($image_src); ?>" alt="<?php echo esc_html(get_the_title()); ?>">
                </div>
                <div class="upk-stories-content">
                    <div class="upk-date upk-flex upk-flex-middle">
                        <div>
                            <?php if ($settings['human_diff_time'] == 'yes') {
                                echo ultimate_post_kit_post_time_diff(($settings['human_diff_time_short'] == 'yes') ? 'short' : '');
                            } else {
                                echo get_the_date();
                            } ?>
                        </div>
                        <?php if ($settings['show_time']) : ?>
                            <div class="upk-post-time">
                                <i class="upk-icon-clock" aria-hidden="true"></i>
                                <?php echo get_the_time(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php printf('<h3 class="upk-title"><a href="%2$s">%1$s</a></h3>', get_the_title(), get_permalink()); ?>
                </div>
            </div>
        <?php
        endwhile;
        // Reset Post Data
        wp_reset_postdata();
        ?>
    </div>

<?php
}

add_filter('show_top_stories',  'render_top_stories', 20, 1);
