<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;

/**
 * @param \Elementor\Controls_Stack $element    The element stack.
 * @param string                    $section_id Section ID.
 * @param array                     $args       Section arguments.
 */
add_action('elementor/element/upk-amox-grid/section_content_layout/before_section_end', function ($element, $args) {
    if ('upk-amox-grid' == $element->get_name()) {
        $element->start_injection([
            'at' => 'after',
            'of' => 'content_alignment',
        ]);

        $element->add_responsive_control(
            'active_content_alignment',
            [
                'label' => __('Active Item Alignment', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'ultimate-post-kit-pro'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'ultimate-post-kit-pro'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'ultimate-post-kit-pro'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-content' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'active_item!' => '',
                ],
            ]
        );

        $element->end_injection();
    }
}, 20, 2);

add_action('elementor/element/upk-amox-grid/upk_section_style/before_section_end', function ($element, $args) {
    if ('upk-amox-grid' == $element->get_name()) {
        $element->start_injection([
            'at' => 'after',
            'of' => 'content_padding',
        ]);

        $element->add_responsive_control(
            'active_content_padding',
            [
                'label' => __('Active Content Padding', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->end_injection();

        $element->start_injection([
            'at' => 'before',
            'of' => 'content_background_background',
        ]);

        $element->add_control(
            'item_overlay_color',
            [
                'label' => esc_html__('Active Overlay Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-img-wrap::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $element->end_injection();

        $element->start_injection([
            'at' => 'before',
            'of' => 'content_hover_background_background',
        ]);

        $element->add_control(
            'item_overlay_hover_color',
            [
                'label' => esc_html__('Active Overlay Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item:hover.active .upk-img-wrap::before' => 'background:  {{VALUE}};',
                ],
            ]
        );

        $element->end_injection();
    }
}, 20, 2);

add_action('elementor/element/upk-amox-grid/section_style_title/before_section_end', function ($element, $args) {
    if ('upk-amox-grid' == $element->get_name()) {
        $element->start_injection([
            'at' => 'after',
            'of' => 'title_color',
        ]);

        $element->add_control(
            'active_title_color',
            [
                'label' => esc_html__('Active Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->end_injection();

        $element->start_injection([
            'at' => 'after',
            'of' => 'title_color_hover',
        ]);

        $element->add_control(
            'active_title_color_hover',
            [
                'label' => esc_html__('Active Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->end_injection();
    }
}, 20, 2);

add_action('elementor/element/upk-amox-grid/section_style_meta/before_section_end', function ($element, $args) {
    if ('upk-amox-grid' == $element->get_name()) {

        $element->start_injection([
            'at' => 'after',
            'of' => 'meta_color',
        ]);

        $element->add_control(
            'meta_active_color',
            [
                'label' => esc_html__('Active Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-meta' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->end_injection();
    }
}, 20, 2);

add_action('elementor/element/upk-amox-grid/section_style_category/before_section_end', function ($element, $args) {
    if ('upk-amox-grid' == $element->get_name()) {

        $element->start_injection([
            'at' => 'after',
            'of' => 'category_active_normal_heading',
        ]);

        $element->add_control(
            'category_active_color',
            [
                'label' => esc_html__('Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-category a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'category_active_background',
                'selector' => '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-category a',
            ]
        );

        $element->add_control(
            'category_active_border_color',
            [
                'label' => esc_html__('Border Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'category_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-category a' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $element->add_control(
            'category_active_hover_heading',
            [
                'label' => esc_html__('HOVER', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'category_active_hover_color',
            [
                'label' => esc_html__('Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-category a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'category_active_hover_background',
                'selector' => '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-category a:hover',
            ]
        );

        $element->add_control(
            'category_active_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'ultimate-post-kit-pro'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'category_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-amox-grid .upk-item.active .upk-category a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $element->end_injection();
    }
}, 20, 2);

function amox_grid_active_item($obj, $i) {
    $settings = $obj->get_settings_for_display();
    $active_item = '';

    if (isset($settings['active_item']) && !empty($settings['active_item'])) {
        $j = (isset($settings['active_item']) && !empty($settings['active_item'])) ? $settings['active_item'] : 2;
        if ($i == $j) {
            $active_item = 'active';
        }
    }

    return $active_item;
}

add_filter('amox_grid_active_item', 'amox_grid_active_item', 20, 2);
