<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;

/**
 * @param \Elementor\Controls_Stack $element    The element stack.
 * @param string                    $section_id Section ID.
 * @param array                     $args       Section arguments.
 */
add_action('elementor/element/upk-alter-carousel/section_style_category/after_section_end', function ($element, $section_id) {
    if ('upk-alter-carousel' == $element->get_name()) {
        $element->start_controls_section(
            'section_style_readmore',
            [
                'label'     => esc_html__('Read More', 'ultimate-post-kit-pro') . BDTUPK_NC,
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'readmore_type' => 'classic',
                ],
            ]
        );

        $element->start_controls_tabs('tabs_readmore_style');

        $element->start_controls_tab(
            'tab_readmore_normal',
            [
                'label' => esc_html__('Normal', 'ultimate-post-kit-pro'),
            ]
        );

        $element->add_control(
            'readmore_color',
            [
                'label'     => esc_html__('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore svg *' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'readmore_background',
                'selector' => '{{WRAPPER}} .upk-alter-carousel .upk-readmore',
            ]
        );

        $element->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'readmore_border',
                'label'       => esc_html__('Border', 'ultimate-post-kit-pro'),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .upk-alter-carousel .upk-readmore',
            ]
        );

        $element->add_responsive_control(
            'readmore_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'readmore_padding',
            [
                'label'      => esc_html__('Padding', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'readmore_margin',
            [
                'label'      => __('Margin', 'ultimate-post-kit-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $element->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'readmore_shadow',
                'selector' => '{{WRAPPER}} .upk-alter-carousel .upk-readmore',
            ]
        );

        $element->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'readmore_typography',
                'label'    => esc_html__('Typography', 'ultimate-post-kit-pro'),
                'selector' => '{{WRAPPER}} .upk-alter-carousel .upk-readmore',
            ]
        );

        $element->end_controls_tab();

        $element->start_controls_tab(
            'tab_readmore_hover',
            [
                'label' => esc_html__('Hover', 'ultimate-post-kit-pro'),
            ]
        );

        $element->add_control(
            'readmore_hover_color',
            [
                'label'     => esc_html__('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore:hover svg *' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'readmore_hover_background',
                'selector' => '{{WRAPPER}} .upk-alter-carousel .upk-readmore:hover',
            ]
        );

        $element->add_control(
            'readmore_hover_border_color',
            [
                'label'     => esc_html__('Border Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'readmore_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $element->add_control(
            'readmore_hover_animation',
            [
                'label' => esc_html__('Animation', 'ultimate-post-kit-pro'),
                'type'  => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $element->end_controls_tab();

        $element->end_controls_tabs();

        $element->end_controls_section();

        $element->start_controls_section(
            'section_style_readmore_on_image',
            [
                'label'     => esc_html__('Read More On Image', 'ultimate-post-kit-pro') . BDTUPK_NC,
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'readmore_type' => 'on_image',
                ],
            ]
        );

        $element->add_control(
            'readmore_on_image_color',
            [
                'label'     => __('Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore-on-image .upk-readmore-icon:before, {{WRAPPER}} .upk-alter-carousel .upk-item:hover .upk-readmore-on-image .upk-readmore-icon span:before, {{WRAPPER}} .upk-alter-carousel .upk-item:hover .upk-readmore-on-image .upk-readmore-icon span:after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $element->add_control(
            'item_image_overlay_color',
            [
                'label'     => esc_html__('Overlay Color', 'ultimate-post-kit-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .upk-alter-carousel .upk-readmore-on-image:before' => 'background: linear-gradient(0deg, {{VALUE}} 0, rgba(141, 153, 174, 0.1) 100%);',
                ],
            ]
        );

        $element->end_controls_section();
    }
}, 20, 2);


function alter_render_readmore($obj)
{
    $settings = $obj->get_settings_for_display();

    $animation = ($obj->get_settings('readmore_hover_animation')) ? ' elementor-animation-' . $obj->get_settings('readmore_hover_animation') : '';

?>

    <a href="<?php echo esc_url(get_permalink()); ?>" class="upk-readmore upk-display-inline-block <?php echo esc_attr($animation); ?>">
        <?php echo esc_html($obj->get_settings('readmore_text')); ?>

        <?php if ($settings['readmore_icon']['value']) : ?>
            <span class="upk-button-icon-align-<?php echo esc_attr($obj->get_settings('readmore_icon_align')); ?>">
                <?php Icons_Manager::render_icon($settings['readmore_icon'], ['aria-hidden' => 'true', 'class' => 'fa-fw']); ?>
            </span>
        <?php endif; ?>
    </a>
<?php
}

add_filter('alter_render_readmore', 'alter_render_readmore', 20, 1);

function alter_render_readmore_on_image()
{

?>
    <a href="<?php echo esc_url(get_permalink()); ?>" class="upk-readmore-on-image">
        <span class="upk-readmore-icon"><span></span></span>
    </a>
<?php
}

add_filter('alter_render_readmore_on_image', 'alter_render_readmore_on_image', 20);
