<?php

namespace UltimatePostKitPro\Includes;

use Elementor\Plugin;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Shortcode {

    public function elementor_shortcode() {
        add_shortcode('upk-template', [$this, 'upk_template_elementor']);
        if (!defined('ELEMENTOR_PRO_VERSION')) {
            add_filter('manage_elementor_library_posts_columns', [$this, 'set_custom_edit_columns']);
            add_action('manage_elementor_library_posts_custom_column', [$this, 'custom_column'], 9, 2);
        }
    }

    public function upk_template_elementor($atts) {
        $atts = shortcode_atts([
            'id' => '',
        ], $atts, 'upk-template');

        $id =  (isset($atts['id']) || !empty($atts['id'])) ? intval($atts['id']) : '';
        return Plugin::instance()->frontend->get_builder_content_for_display($id);
    }

    public function set_custom_edit_columns($columns) {
        $columns['upk-shortcode'] = esc_html__('Shortcode', 'ultimate-post-kit-pro');
        return $columns;
    }

    public function custom_column($column, $post_id) {

        switch ($column) {
            case 'upk-shortcode':
                echo '<input class="elementor-shortcode-input" type="text" width="150" readonly="" onfocus="this.select()" value="[upk-template id=' . '&quot;' . $post_id . '&quot;' . ']">';
                break;
        }
    }
}

if (class_exists('UltimatePostKitPro\Includes\Shortcode')) {
    (new Shortcode())->elementor_shortcode();
}
