<?php

namespace UltimatePostKitPro;

use UltimatePostKit\Admin\ModuleService;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

final class Manager
{

    public function register_module_and_assets()
    {

        ModuleService::get_widget_settings(function ($settings) {
            $core_widgets        = $settings['settings_fields']['ultimate_post_kit_active_modules'];
            $extensions          = $settings['settings_fields']['ultimate_post_kit_elementor_extend'];

            /**
             * Our Widget
             */
            foreach ($core_widgets as $widget) {
                if (ultimate_post_kit_pro_is_widget_enabled($widget['name'])) {
                    $this->load_module_instance($widget);
                }
            }

            /**
             * Extension
             */
            foreach ($extensions as $extension) {
                if (ultimate_post_kit_pro_is_extend_enabled($extension['name'])) {
                    $this->load_module_instance($extension);
                }
            }

            $this->load_module_instance(['name' => 'elementor']);
        });
    }

    public function load_module_instance($module)
    {


        $direction = is_rtl() ? '.rtl' : '';
        $suffix    = '.min';

        $module_id  = $module['name'];
        $class_name = str_replace('-', ' ', $module_id);
        $class_name = str_replace(' ', '', ucwords($class_name));
        $class_name = __NAMESPACE__ . '\\Modules\\' . $class_name . '\\Module';


        if (!ultimate_post_kit_is_preview()) {
            // register widgets css
            if (ModuleService::has_module_style( $module_id, BDTUPK_PRO_MODULES_PATH )) {
                wp_register_style('upk-' . $module_id, BDTUPK_PRO_URL . 'assets/css/upk-' . $module_id . $direction . '.css', [], BDTUPK_PRO_VER);
            }
            // register widget JS
            if (ModuleService::has_module_script( $module_id, BDTUPK_PRO_MODULES_PATH )) {
                wp_register_script('upk-' . $module_id, BDTUPK_PRO_URL . 'assets/js/widgets/upk-' . $module_id . $suffix . '.js', ['jquery'], BDTUPK_VER, true);
            }
        }


        if (class_exists($class_name)) {
            $class_name::instance();
        }
    }

    public function __construct()
    {

        $this->register_module_and_assets();
    }
}
