<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use UltimatePostKit\Utils;

use UltimatePostKit\Admin\ModuleService;

if (!function_exists('ultimate_post_kit_pro_is_widget_enabled')) {
	function ultimate_post_kit_pro_is_widget_enabled($widget_id, $options = []) {

		// print_r($widget_id);

		if (!$options) {
			$options = get_option('ultimate_post_kit_active_modules', []);
		}

		if (ModuleService::is_module_active($widget_id, $options, BDTUPK_PRO_MODULES_PATH)) {
			$widget_id = str_replace('-', '_', $widget_id);
			return apply_filters("ultimatepostkitpro/widget/{$widget_id}", true);
		}
	}
}

if (!function_exists('ultimate_post_kit_pro_is_extend_enabled')) {
	function ultimate_post_kit_pro_is_extend_enabled($widget_id, $options = []) {

		if (!$options) {
			$options = get_option('ultimate_post_kit_elementor_extend', []);
		}

		if (ModuleService::is_module_active($widget_id, $options, BDTUPK_PRO_MODULES_PATH)) {
			$widget_id = str_replace('-', '_', $widget_id);
			return apply_filters("ultimatepostkitpro/extend/{$widget_id}", true);
		}
	}
}

add_filter('upk_column_size', function () {
	return 'grid-template-columns: repeat({{SIZE}}, 1fr);';
}, 20, 1);

add_filter('social_share_prefix_class', function () {
	return 'upk-ss-icon-top--';
}, 20, 1);


