<?php

namespace UltimatePostKitPro;

use UltimatePostKitPro\Base\Ultimate_Post_Kit_Base;
use UltimatePostKit\Notices;


/**
 * License Settings Class
 */
class License_Settings {

	const PAGE_ID = 'ultimate_post_kit_options';

	public  $responseObj;
	public  $licenseMessage;
	public  $showMessage  = false;
	private $is_activated = false;


	function __construct(){
		if (!defined('BDTUPK_HIDE')) {
			add_action('admin_menu', [$this, 'admin_menu'], 201);
			add_action('upk_license_page', [$this, 'license_page'], 99);
		}

		$license_key   = self::get_license_key();
		$license_email = self::get_license_email();


		Ultimate_Post_Kit_Base::addOnDelete(
			function () {
				delete_option('ultimate_post_kit_license_email');
				delete_option('ultimate_post_kit_license_key');
			}
		);

		if (Ultimate_Post_Kit_Base::CheckWPPlugin($license_key, $license_email, $error, $responseObj, BDTUPK_PRO__FILE__)) {

			if (!defined('BDTUPK_LO')) {
				add_action('admin_post_ultimate_post_kit_deactivate_license', [$this, 'action_deactivate_license']);

				$this->is_activated = true;
			}
		} else {

			if (!defined('BDTUPK_LO')) {
				if (!empty($licenseKey) && !empty($this->licenseMessage)) {
					$this->showMessage = true;
				}

				if ($error) {
					$this->licenseMessage = $error;
					$this->license_activate_error_notice();
				}

				$this->license_activate_notice();

				update_option("ultimate_post_kit_license_key", "") || add_option("ultimate_post_kit_license_key", "");
				add_action('admin_post_ultimate_post_kit_activate_license', [$this, 'action_activate_license']);
			}
		}
	}

	public static function get_url(){
		return admin_url('admin.php?page=' . self::PAGE_ID);
	}

	function admin_menu(){

		add_submenu_page(
			'ultimate_post_kit_options',
			BDTUPK_PRO_TITLE,
			esc_html__('License', 'ultimate-post-kit-pro'),
			'manage_options',
			'ultimate_post_kit_options' . '#ultimate_post_kit_license_settings',
			[$this, 'display_page']
		);
	}

	/**
	 * Get all the pages
	 *
	 * @return array page names with key value pairs
	 */
	function get_pages(){
		$pages         = get_pages();
		$pages_options = [];
		if ($pages) {
			foreach ($pages as $page) {
				$pages_options[$page->ID] = $page->post_title;
			}
		}

		return $pages_options;
	}

	/**
	 * Get License Key
	 *
	 * @access public
	 * @return string
	 */

	public static function get_license_key(){
		return trim(get_option('ultimate_post_kit_license_key'));
	}

	/**
	 * Get License Email
	 *
	 * @access public
	 * @return string
	 */

	public static function get_license_email(){
		return trim(get_option('ultimate_post_kit_license_email', get_bloginfo('admin_email')));
	}

	/**
	 * Set License Key
	 *
	 * @access public
	 * @return string
	 */

	public static function set_license_key($license_key){
		return update_option('ultimate_post_kit_license_key', $license_key);
	}

	/**
	 * Set License Email
	 *
	 * @access public
	 * @return string
	 */

	public static function set_license_email($license_email){
		return update_option('ultimate_post_kit_license_email', $license_email);
	}


	/**
	 * Display License Page
	 *
	 * @access public
	 */

	public function license_page(){

		if ($this->is_activated) {

			$this->license_activated();
		} else {
			if (!empty($licenseKey) && !empty($this->licenseMessage)) {
				$this->showMessage = true;
			}

			$this->license_form();
		}
	}

	/**
	 * License Deactivate Action
	 * @access public
	 */

	function action_deactivate_license(){


		check_admin_referer('el-license');
		if (Ultimate_Post_Kit_Base::RemoveLicenseKey(BDTUPK_PRO__FILE__, $message)) {
			update_option("ultimate_post_kit_license_key", "") || add_option("ultimate_post_kit_license_key");
		}
		wp_safe_redirect(admin_url('admin.php?page=' . 'ultimate_post_kit_options#ultimate_post_kit_license_settings'));
	}

	/**
	 * License Active Error
	 *
	 * @access public
	 */

	public function license_activate_error_notice(){
		Notices::add_notice(
			[
				'id'               => 'license-error',
				'type'             => 'error',
				'dismissible'      => true,
				'dismissible-time' => 43200,
				'message'          => $this->licenseMessage,
			]
		);
	}

	/**
	 * License Active Notice
	 *
	 * @access public
	 */

	public function license_activate_notice(){
		Notices::add_notice(
			[
				'id'               => 'license-issue',
				'type'             => 'error',
				'dismissible'      => true,
				'dismissible-time' => HOUR_IN_SECONDS * 72,
				// 'message'          => '<img height="30" src="' . BDTUPK_ASSETS_URL . 'images/logo.svg">' . __('Thank you for purchase Ultimate Post Kit. Please <a href="' . self::get_url() . '#ultimate_post_kit_license_settings">activate your license</a> to get feature updates, premium support. Don\'t have Ultimate Post Kit license? Purchase and download your license copy <a href="https://postkit.pro/" target="_blank">from here</a>.', 'ultimate-post-kit-pro'),
				'html_message'          => $this->license_active_notice_message(),
			]
		);
	}

	public function license_active_notice_message(){
		
		$plugin_icon = BDTUPK_ASSETS_URL . 'images/logo.svg';
		$plugin_title = __('Ultimate Post Kit Pro', 'ultimate-post-kit-pro');
		$plugin_msg = __('Thank you for purchase Ultimate Post Kit. Please activate your license to get feature updates, premium support. Don\'t have Ultimate Post Kit license? Purchase and download your license copy from here.', 'ultimate-post-kit-pro');
		// $admin_url = self::get_url() . '#prime_slider_license_settings';
		ob_start();
		?>
		<div class="bdt-license-notice-global ultimate_post_kit">
					<?php if (!empty($plugin_icon)) : ?>
						<div class="bdt-license-notice-logo">
							<img src="<?php echo esc_url($plugin_icon); ?>" alt="icon">
						</div>
					<?php endif; ?>
					<div class="bdt-license-notice-content">
						<h3>
							<?php printf(wp_kses_post($plugin_title)); ?>
						</h3>
						<p>
							<?php printf(wp_kses_post($plugin_msg)); ?>
						</p>
						<div class="bdt-license-notice-button-wrap">
							<a href="<?php echo esc_url(self::get_url()); ?>#ultimate_post_kit_license_settings" class="bdt-button bdt-button-allow">
							Activate License
							</a>
							<a href="https://postkit.pro/" target="_blank" class="bdt-button bdt-button-skip">
							   Get License
							</a>
						</div>
					</div>
				</div>
		<?php
		return ob_get_clean();
	}

	/**
	 * Display License Activated
	 *
	 * @access public
	 * @return void
	 */

	function license_activated(){
?>
		<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
			<input type="hidden" name="action" value="ultimate_post_kit_deactivate_license" />
			<div class="el-license-container bdt-card bdt-card-body">


				<h3 class="el-license-title"><span class="dashicons dashicons-admin-network"></span> <?php esc_html_e("Ultimate Post Kit License Information", 'ultimate-post-kit-pro'); ?>
				</h3>

				<ul class="ultimate-post-kit-license-info bdt-list bdt-list-divider">
					<li>
						<div>
							<span class="license-info-title"><?php esc_html_e('Status', 'ultimate-post-kit-pro'); ?></span>

							<?php if (Ultimate_Post_Kit_Base::GetRegisterInfo()->is_valid) : ?>
								<span class="license-valid">Valid License</span>
							<?php else : ?>
								<span class="license-valid">Invalid License</span>
							<?php endif; ?>
						</div>
					</li>

					<li>
						<div>
							<span class="license-info-title"><?php esc_html_e('License Type', 'ultimate-post-kit-pro'); ?></span>
							<?php echo Ultimate_Post_Kit_Base::GetRegisterInfo()->license_title; ?>
						</div>
					</li>

					<li>
						<div>
							<span class="license-info-title"><?php esc_html_e('License Expired on', 'ultimate-post-kit-pro'); ?></span>
							<?php echo Ultimate_Post_Kit_Base::GetRegisterInfo()->expire_date; ?>
						</div>
					</li>

					<li>
						<div>
							<span class="license-info-title"><?php esc_html_e('Support Expired on', 'ultimate-post-kit-pro'); ?></span>
							<?php echo Ultimate_Post_Kit_Base::GetRegisterInfo()->support_end; ?>
						</div>
					</li>

					<li>
						<div>
							<span class="license-info-title"><?php esc_html_e('License Email', 'ultimate-post-kit-pro'); ?></span>
							<?php echo self::get_license_email(); ?>
						</div>
					</li>

					<li>
						<div>
							<span class="license-info-title"><?php esc_html_e('Your License Key', 'ultimate-post-kit-pro'); ?></span>
							<span class="license-key"><?php echo esc_attr(substr(Ultimate_Post_Kit_Base::GetRegisterInfo()->license_key, 0, 9) . "XXXXXXXX-XXXXXXXX" . substr(Ultimate_Post_Kit_Base::GetRegisterInfo()->license_key, -9)); ?></span>
						</div>
					</li>
				</ul>

				<div class="el-license-active-btn">
					<?php wp_nonce_field('el-license'); ?>
					<?php submit_button('Deactivate License'); ?>
				</div>
			</div>
		</form>
	<?php
	}



	/**
	 * Display License Form
	 *
	 * @access public
	 * @return void
	 */

	function license_form(){
	?>
		<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
			<input type="hidden" name="action" value="ultimate_post_kit_activate_license" />
			<div class="el-license-container bdt-card bdt-card-body">

				<?php
				if (!empty($this->showMessage) && !empty($this->licenseMessage)) {
				?>
					<div class="notice notice-error is-dismissible">
						<p><?php echo $this->licenseMessage; ?></p>
					</div>
				<?php
				}
				?>

				<h3 class="bdt-text-large">
					<strong><?php esc_html_e('Enter your license key here, to activate Ultimate Post Kit Pro, and get full feature updates and premium support.', 'ultimate-post-kit-pro'); ?></strong>
				</h3>

				<ol class="bdt-text-default">
					<li><?php printf(__('Log in to your <a href="%1s" target="_blank">bdthemes fastspring</a> account to get your license key.', 'ultimate-post-kit-pro'), 'https://bdthemes.onfastspring.com/account'); ?></li>
					<li><?php printf(__('If you don\'t yet have a license key, <a href="%s" target="_blank">get Ultimate Post Kit Pro now</a>.', 'ultimate-post-kit-pro'), 'https://bdthemes.com/ultimate-post-kit/#a851ca7'); ?></li>
					<li><?php esc_html_e('Copy the license key from your account and paste it below for work ultimate post kit properly.', 'ultimate-post-kit-pro'); ?></li>
				</ol>

				<div class="bdt-upk-license-field">
					<label for="ultimate_post_kit_license_email">License Email
						<input type="text" class="regular-text code" name="ultimate_post_kit_license_email" size="50" placeholder="example@email.com" required="required">
					</label>
				</div>

				<div class="bdt-upk-license-field">
					<label for="ultimate_post_kit_license_key">License Code
						<input type="text" class="regular-text code" name="ultimate_post_kit_license_key" size="50" placeholder="xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx" required="required">
					</label>
				</div>


				<div class="el-license-active-btn">
					<?php wp_nonce_field('el-license'); ?>
					<?php submit_button('Activate License'); ?>
				</div>
			</div>
		</form>
<?php
	}

	/**
	 * License Activate Action
	 * @access public
	 */

	function action_activate_license(){
		check_admin_referer('el-license');

		$licenseKey   = !empty($_POST['ultimate_post_kit_license_key']) ? sanitize_text_field($_POST['ultimate_post_kit_license_key']) : "";
		$licenseEmail = !empty($_POST['ultimate_post_kit_license_email']) ? wp_unslash($_POST['ultimate_post_kit_license_email']) : "";

		update_option("ultimate_post_kit_license_key", $licenseKey);
		update_option("ultimate_post_kit_license_email", $licenseEmail);

		wp_safe_redirect(admin_url('admin.php?page=' . 'ultimate_post_kit_options#ultimate_post_kit_license_settings'));
	}
}


new License_Settings();
