<?php

class Eventprime_Zapier_Requests{

    public function all_bookings_data($status)
    {
        $bookings = new EventPrime_Bookings();
        $args = array(
            'numberposts' => -1,
            'post_status' => 'any',
            'post_type'   => 'em_booking',
            'orderby'     => 'date',
            'order'       => 'DESC'
        );

        $all_bookings = get_posts( $args );

        if ( empty( $all_bookings ) ) {
            return array('msg' => esc_html__( 'No bookings found. Please create a demo booking to generate sample data.', 'eventprime-zapier-integration' ));
        }

        foreach ( $all_bookings as $booking_post ) {
            if ( empty( $booking_post->ID ) ) {
                continue;
            }

            $booking_detail = $bookings->load_booking_detail( $booking_post->ID );

            if ( isset( $booking_detail->em_status ) && $booking_detail->em_status === $status ) {
                return $booking_detail; // exit right away
            }
        }

        return array('msg' => sprintf( esc_html__( 'No bookings found with the status "%s". Please create a booking with this status to proceed.', 'eventprime-zapier-integration' ), esc_html( $status ) ));

    }

    public function all_events_data($status)
    {
        $ep_functions = new Eventprime_Basic_Functions;

        $args = array(
            'post_type'      => 'em_event',
            'posts_per_page' => 1,
            'orderby'        => 'date',
            'order'          => 'DESC'
        );

        if ( $status === 'delete_event' ) {
            $args['post_status'] = 'trash';
        }

        $events = get_posts($args);

        if ( empty($events) ) {
            switch ($status) {
                case 'delete_event':
                    return array(
                        'msg' => esc_html__( 'No deleted events found. Please move at least one event to the trash to get sample data.', 'eventprime-zapier-integration' )
                    );
                case 'update_event':
                case 'create_event':
                    return array(
                        'msg' => esc_html__( 'No events found. Please create at least one event to get sample data.', 'eventprime-zapier-integration' )
                    );
                default:
                    return array(
                        'msg' => esc_html__( 'No events found. Please create at least one event to get sample data.', 'eventprime-zapier-integration' )
                    );
            }
        }

        $event_id =  $events[0]->ID;

        $event_data = $ep_functions->get_single_event_detail( $event_id );
        $validated_data = $this->Validate_event_data_fields($event_data);

        return $validated_data;
    }

    public function Validate_event_data_fields($event_data)
    {
        $ep_functions = new Eventprime_Basic_Functions;

        if ( ! empty( $event_data->em_start_date ) ) {
            $event_data->em_start_date = $ep_functions->ep_timestamp_to_date( $event_data->em_start_date );
        }

        if ( ! empty( $event_data->em_end_date ) ) {
            $event_data->em_end_date = $ep_functions->ep_timestamp_to_date( $event_data->em_end_date );
        }

        $event_data->venue_details = (!empty($event_data->em_venue) ) ? $ep_functions->get_single_venue($event_data->em_venue) : array();

        unset( $event_data->fstart_date );
        unset( $event_data->fend_date );

        return $event_data;
    }

    public function all_performers_data($status)
    {
        $ep_functions = new Eventprime_Basic_Functions;

        $args = array(
            'post_type'      => 'em_performer',
            'posts_per_page' => 1,
            'orderby'        => 'date',
            'order'          => 'DESC'
        );

        if ( $status === 'delete_performer' ) {
            $args['post_status'] = 'trash';
        }

        $performers = get_posts($args);

        if ( empty($performers) ) {
            switch ($status) {
                case 'delete_performer':
                    return array(
                        'msg' => esc_html__( 'No deleted performers found. Please move at least one performer to the trash to get sample data.', 'eventprime-zapier-integration' )
                    );
                case 'update_performer':
                case 'create_performer':
                    return array(
                        'msg' => esc_html__( 'No performers found. Please create at least one performer to get sample data.', 'eventprime-zapier-integration' )
                    );
                default:
                    return array(
                        'msg' => esc_html__( 'No performers found. Please create at least one performer to get sample data.', 'eventprime-zapier-integration' )
                    );
            }
        }

        $performer_id =  $performers[0]->ID;

        $performer_data = $ep_functions->get_single_performer( $performer_id );
        if (isset($data->_thumbnail_id)) {
            unset($data->_thumbnail_id);
        }

        return $performer_data;

    }

    public function all_organizers_data()
    {
        $ep_functions = new Eventprime_Basic_Functions;

        $organizers = get_terms( array(
            'taxonomy'   => 'em_event_organizer',
            'hide_empty' => false,
            'orderby'    => 'id',      // order by term_id
            'order'      => 'DESC',    // newest first
            'number'     => 1          // only the most recent
        ));

        if ( is_wp_error( $organizers ) || empty( $organizers ) ) {
            return array(
                'msg' => esc_html__( 'No organizers found. Please create at least one organizer to get sample data.', 'eventprime-zapier-integration' )
            );
        }

        $organizer_id = $organizers[0]->term_id;

        $organizer_data = $ep_functions->get_single_organizer( $organizer_id );

        return $organizer_data;

    }

    public function all_venues_data()
    {
        $ep_functions = new Eventprime_Basic_Functions;

        $venues = get_terms( array(
            'taxonomy'   => 'em_venue',
            'hide_empty' => false,
            'orderby'    => 'id',      // order by term_id
            'order'      => 'DESC',    // newest first
            'number'     => 1          // only the most recent
        ));

        if ( is_wp_error( $venues ) || empty( $venues ) ) {
            return array(
                'msg' => esc_html__( 'No venues found. Please create at least one venue to get sample data.', 'eventprime-zapier-integration' )
            );
        }

        $venue_id = $venues[0]->term_id;

        $venue_data = $ep_functions->ep_get_venue_by_id( $venue_id );

        return $venue_data;

    }

    public function ep_get_tickets_by_event($request)
    {
        $event_id = isset($request['event_id']) ? absint($request['event_id']) : 0;
        $ticket_data = array();

        if (!empty($event_id)) {
            $ep_functions = new Eventprime_Basic_Functions();
            $tickets = $ep_functions->get_single_event_detail( $event_id );
            if (!empty($tickets->all_tickets_data) && is_array($tickets->all_tickets_data)) {
                foreach ($tickets->all_tickets_data as $ticket) {
                    $ticket_data[] = array(
                        'ticket_id'   => $ticket->id,
                        'ticket_name' => $ticket->name,
                    );
                }
            }
        }

        return $ticket_data;
    }
}