<?php

if (!defined( 'ABSPATH')){

    exit;

}

class Eventprime_Zapier_Services {

    public function load_event_data_trigger( $type, $event_id )
    {
        $ep_functions = new Eventprime_Basic_Functions;
        $Zapier_request = new Eventprime_Zapier_Requests;

        $triggers = $this->get_triggers_by_type( $type );
        $response = array();
        if( ! empty( $triggers ) ){
            $data = $ep_functions->get_single_event_detail( $event_id );
            $validated_data = $Zapier_request->Validate_event_data_fields($data);

            foreach ( $triggers as $trigger ) {
                $response[] = $this->init_remote_data( $trigger, $validated_data );
            }
        }

        return $response;
    }

    public function load_performer_data_trigger($type, $performer_id)
    {
        $ep_functions = new Eventprime_Basic_Functions;
        $triggers = $this->get_triggers_by_type( $type );
        $response = array();
        if( ! empty( $triggers ) ){
            $data = $ep_functions->get_single_performer( $performer_id );
            if (isset($data->_thumbnail_id)) {
                unset($data->_thumbnail_id);
            }

            foreach ( $triggers as $trigger ) {
                $response[] = $this->init_remote_data( $trigger, $data );
            }
        }

        return $response;
    }

    public function load_event_booking_data_trigger( $booking_id ){

        $bookings = new EventPrime_Bookings();

        $data = $bookings->load_booking_detail( $booking_id );

        $type = '';
        if ( isset( $data->em_status ) ) {
            switch ( $data->em_status ) {
                case 'completed':
                    $type = 'confirm_booking';
                break;

                case 'pending':
                    $type = 'pending_booking';
                break;

                case 'cancelled':
                    $type = 'cancel_booking';
                break;

                case 'refunded':
                    $type = 'refund_booking';
                break;

                case 'failed':
                    $type = 'failed_booking';
                break;

                default:
                    $type = '';
                break;
            }
        }

        if ( empty( $type ) ) {
            return array(
                'msg' => esc_html__( 'No valid booking status found. Please select a valid booking status to proceed.', 'eventprime-zapier-integration' )
            );
        }

        $triggers = $this->get_triggers_by_type( $type );

        $response = array();
        if( ! empty( $triggers ) ){
            foreach ( $triggers as $trigger ) {
                $response[] = $this->init_remote_data( $trigger, $data );
            }
        }
        return $response;
    }

    public function load_cancel_event_booking_data_trigger($type, $booking_data)
    {
        $triggers = $this->get_triggers_by_type( $type );
        $response = array();
        if( ! empty( $triggers ) ){
            foreach ( $triggers as $trigger ) {
                $response[] = $this->init_remote_data( $trigger, $booking_data );
            }
        }
        return $response;
    }

    public function load_organizer_data_trigger($type, $organizer_id)
    {
        $ep_functions = new Eventprime_Basic_Functions;
        $triggers = $this->get_triggers_by_type( $type );
        $response = array();
        if( ! empty( $triggers ) ){
            $data = $ep_functions->get_single_organizer( $organizer_id );

            foreach ( $triggers as $trigger ) {
                $response[] = $this->init_remote_data( $trigger, $data );
            }
        }
        return $response;

    }

    public function load_venue_data_trigger($type, $venue_id)
    {
        $ep_functions = new Eventprime_Basic_Functions;
        $triggers = $this->get_triggers_by_type( $type );
        $response = array();
        if( ! empty( $triggers ) ){
            $data = $ep_functions->ep_get_venue_by_id( $venue_id );

            foreach ( $triggers as $trigger ) {
                $response[] = $this->init_remote_data( $trigger, $data );
            }
        }
        return $response;

    }

    public function get_triggers_by_type($type){
        $ep_dbhandler = new EP_DBhandler(); 
        $triggers = $ep_dbhandler->get_all_result( 'Zapier_Integration', '*', [ 'type' => $type ] ); 
        return $triggers;  
    }

    public function init_remote_data($trigger, $data){

        $response = wp_remote_post( $trigger->webhook_url, array(

            'headers' => array(
                'Content-Type' => 'application/json',
                'charset' => 'utf-8'
            ),
            'body' => json_encode( $data ),

        ) );

        return $response;
    }

}