<?php
class EP_Helper_Zapier_Integration{

	// Zapier_Integration
	public function get_db_table_name($identifier)
	{
		global $wpdb;
                
		$plugin_prefix = $wpdb->prefix.'eventprime_';
		$table_name= $plugin_prefix.'zapier';
		return $table_name;
	}
	
	public function get_db_table_unique_field_name($identifier)
	{
	   $unique_field_name = 'id';
		return $unique_field_name;
	}	
	
	public function get_db_table_field_type($identifier,$field)
	{
		switch ($field)
		{
			case 'id':
				$format = '%d';
				break;
			case 'name':
			case 'type':
			case 'webhook_url':
			case 'meta':
				$format = '%s';
				break;
			default:
				$format = '%s';
		}
		return $format;
	}
	
	
	public function get_sanitized_fields($identifier,$field,$value)
	{
		switch($field)
		{
			case 'id':
				$sanitized_value = sanitize_text_field($value);
				break;
			case 'name':
				$sanitized_value = sanitize_text_field($value);
				break;
			case 'type':
				$sanitized_value = sanitize_text_field($value);
				break;
            case 'meta':
                $sanitized_value = sanitize_text_field($value); 
                break;
			default:
				$sanitized_value = sanitize_text_field($value);
                break;
		}
		
		return $sanitized_value;
	}
	
}

?>