<?php

/**
 * Fired during plugin activation
 *
 * @link       https://https://theeventprime.com
 * @since      1.0.0
 *
 * @package    Eventprime_Zapier_Integration
 * @subpackage Eventprime_Zapier_Integration/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Eventprime_Zapier_Integration
 * @subpackage Eventprime_Zapier_Integration/includes
 * @author     EventPrime <support@metagauss.com>
 */
class Eventprime_Zapier_Integration_Activator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public function activate()
	{
		global $wpdb;
		if (is_multisite()) {
			// Get all blogs in the network and activate plugin on each one
			$blog_ids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
			foreach ($blog_ids as $blog_id) {
				switch_to_blog($blog_id);
				$this->create_table();
				restore_current_blog();
			}
		} else {
			$this->create_table();
		}
	}
	
	public function create_table()
	{
		global $wpdb;
		require_once (ABSPATH . 'wp-admin/includes/upgrade.php');
		//Ensures proper charset support. Also limits support for WP v3.5+.
		$EP_Helper_Zapier_Integration = new EP_Helper_Zapier_Integration();
		$charset_collate = $wpdb->get_charset_collate();
		$table_name = $EP_Helper_Zapier_Integration->get_db_table_name('ep_zapier');
		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `name` varchar(255) NOT NULL,
            `type` varchar(255) NOT NULL,
            `webhook_url` longtext NOT NULL,
            `meta` longtext DEFAULT NULL,
            PRIMARY KEY (`id`)
                    )$charset_collate;";
		dbDelta($sql);
	}

}
