<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://https://theeventprime.com
 * @since      1.0.0
 *
 * @package    Eventprime_Zapier_Integration
 * @subpackage Eventprime_Zapier_Integration/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Eventprime_Zapier_Integration
 * @subpackage Eventprime_Zapier_Integration/admin
 * @author     EventPrime <support@metagauss.com>
 */
class Eventprime_Zapier_Integration_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Eventprime_Zapier_Integration_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Eventprime_Zapier_Integration_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/eventprime-zapier-integration-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Eventprime_Zapier_Integration_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Eventprime_Zapier_Integration_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/eventprime-zapier-integration-admin.js', array( 'jquery' ), $this->version, false );

	}

	public function ep_plugin_activation_notice_fun() {
        if (!class_exists('Eventprime_Event_Calendar_Management')) {
            $this->EventPrime_installation();
        }
    }

    public function EventPrime_installation() {
        $plugin_slug = 'eventprime-event-calendar-management';
        $installUrl = admin_url('update.php?action=install-plugin&plugin=' . $plugin_slug);
        $installUrl = wp_nonce_url($installUrl, 'install-plugin_' . $plugin_slug);
        ?>
        <div class="notice notice-success is-dismissible">
            <p><?php printf(__("EventPrime Zapier Integration work with Eventprime Plugin. You can install it  from <a href='%s'>Here</a>.","eventprime-zapier-integration"),plugin_basename ( plugin_dir_path( __DIR__ ) ), $installUrl); ?></p>
        </div>
        <?php
        deactivate_plugins( plugin_basename( plugin_dir_path( __DIR__ ) ) . '/eventprime-zapier-integration.php' );
    }

	public function add_pages_setting_meta( $options ){
		$options['zapier_auto']    = 1;
		$options['zapier_api_key'] = strtoupper( substr( str_shuffle( md5( home_url() . time() ) ), 0, 20 ) );
		return $options;
	}

	/**
    * EventPrime zapier settings tabs
    */
    public function add_zapier_settings_tab( $tabs ){
        $tabs['zapier-settings'] = esc_html__( 'Zapier Settings', 'eventprime-zapier-integration' );
        return $tabs; 
    }

	public function ep_extensions_settings($extensions){
		$extensions['zapier-settings'] = array(
			'extension'=>esc_html__('EventPrime Zapier Integration','eventprime-zapier-integration'),
			'description'=> esc_html__('An EventPrime extension allow EventPrime Integration With Zapier Automation.','eventprime-zapier-integration'),
			'url'=> esc_url(add_query_arg(array('tab' => 'zapier-settings')))
		);
		return $extensions;
	}

	public function add_zapier_settings_tab_content( $active_tab ){
		$options = array();
		$settings = new Eventprime_Global_Settings();
		$options['global'] = $settings->ep_get_settings();
		if( $active_tab == 'zapier-settings' ){
			if( $options['global']->zapier_auto == 1 ){
				// generate api key if empty
				if( empty( $options['global']->zapier_api_key) ){
					$options['global']->zapier_api_key = strtoupper( substr( str_shuffle( md5( home_url() . time() ) ), 0, 20 ) );
				}
			}
			$active_tab_arr = explode( '-', $active_tab );
			include __DIR__ .'/partials/settings/views/settings-tab-'.$active_tab_arr[0].'.php'; 
		}
	}

	public function save_zapier_settings(){
		$admin_notices = new EventM_Admin_Notices;
		if( isset( $_POST['em_setting_type'] ) && ! empty( $_POST['em_setting_type'] ) ) {
			$setting_type = sanitize_text_field( $_POST['em_setting_type'] );
			
			/* save zapier settings */
			if( $setting_type == 'zapier_settings' ) {
				$global_settings                             = new Eventprime_Global_Settings();
				$global_settings_data                        = $global_settings->ep_get_settings();
				$global_settings_data->zapier_auto   = isset( $_POST['zapier_auto'] ) ? 1 : 0;
				$global_settings_data->zapier_api_key          = isset( $_POST['zapier_api_key'] ) ? sanitize_text_field( $_POST['zapier_api_key'] ) : '';
			   
				$global_settings->ep_save_settings( $global_settings_data );
				$admin_notices->ep_add_notice( 'success', esc_html__('Setting saved successfully', 'eventprime-zapier-integration' ) );
				$redirect_url = admin_url( "edit.php?post_type=em_event&page=ep-settings&tab=zapier-settings" );
				$nonce = wp_create_nonce('ep_settings_tab');
				$redirect_url = add_query_arg( array('tab_nonce'=>$nonce ),$redirect_url);
				wp_redirect($redirect_url);
				exit();
			}
		}
	}

	/**
        * Add zapier options in global settings object
	*/
	public function ep_add_zapier_global_setting_options( $settings, $options ) {
		if( ! empty( $options ) ) {
			// global settings option for license settings
			$settings->ep_zapier_item_id          = 885;
			$settings->ep_zapier_item_name        = 'Zapier Integration';
			$settings->ep_zapier_license_key      = ( property_exists( $options, 'ep_zapier_license_key' ) ) ? $options->ep_zapier_license_key : '';
			$settings->ep_zapier_license_status   = ( property_exists( $options, 'ep_zapier_license_status' ) ) ? $options->ep_zapier_license_status : '';
			$settings->ep_zapier_license_response = ( property_exists( $options, 'ep_zapier_license_response' ) ) ? $options->ep_zapier_license_response : '';
		}
		return $settings;
	}

	public function ep_add_zapier_license_setting_block( $options ){ 
		?>
			<tr valign="top" class="ep_zapier">
				<td><?php esc_html_e( 'Zapier Integration', 'eventprime-zapier-integration' );?></td>
				<td><input id="ep_zapier_license_key" name="ep_zapier_license_key" type="text" class="regular-text ep-box-wrap ep-license-block" data-prefix="ep_zapier" value="<?php esc_attr_e( ( isset( $options->ep_zapier_license_key ) && ! empty( $options->ep_zapier_license_key ) ) ? $options->ep_zapier_license_key : '' ); ?>" placeholder="<?php esc_html_e( 'Please Enter License Key', 'eventprime-zapier-integration' );?>" /></td>
				<td>         
					<span class="license-expire-date" style="padding-bottom:2rem;" >
						<?php
						if ( isset( $options->ep_zapier_license_response->expires ) && ! empty( $options->ep_zapier_license_response->expires ) ) {
							if( $options->ep_zapier_license_response->expires == 'lifetime' ){
								esc_html_e( 'Your License key is activated for lifetime', 'eventprime-zapier-integration' );
							}else{
								echo sprintf( __('Your License Key expires on %s', 'eventprime-zapier-integration' ), date( 'F d, Y', strtotime( $options->ep_zapier_license_response->expires ) ) );
							}
						} else {
							$expire_date = '';
						}
						?>
					</span>
				</td>
				<td>
					<span class="ep_zapier-license-status-block">
						<?php if ( isset( $options->ep_zapier_license_key ) && ! empty( $options->ep_zapier_license_key )) { ?>
							<?php if ( isset( $options->ep_zapier_license_status ) && $options->ep_zapier_license_status !== false && $options->ep_zapier_license_status == 'valid') { ?>
								<button type="button" class="button action ep-my-2 ep_license_deactivate" name="ep_zapier_license_deactivate" id="ep_zapier_license_deactivate" data-prefix="ep_zapier" value="<?php esc_html_e( 'Deactivate License', 'eventprime-zapier-integration' );?>"><?php esc_html_e( 'Deactivate License', 'eventprime-zapier-integration' );?></button>
							<?php }elseif( ! empty( $options->ep_zapier_license_status ) && $options->ep_zapier_license_status == 'invalid' ){ ?>
								<button type="button" class="button action ep-my-2 ep_license_activate" name="ep_zapier_license_activate" id="ep_zapier_license_activate" data-prefix="ep_zapier" value="<?php esc_html_e( 'Activate License', 'eventprime-zapier-integration' );?>"><?php esc_html_e( 'Activate License', 'eventprime-zapier-integration' );?></button>
							<?php }else{ ?>
								<button type="button" class="button action ep-my-2 ep_license_activate" name="ep_zapier_license_activate" id="ep_zapier_license_activate" data-prefix="ep_zapier" value="<?php esc_html_e( 'Activate License', 'eventprime-zapier-integration' );?>" style="<?php if ( empty( $options->ep_zapier_license_key ) ){ echo 'display:none'; } ?>"><?php esc_html_e( 'Activate License', 'eventprime-zapier-integration' );?></button>
						<?php } }else{ ?>
							<button type="button" class="button action ep-my-2 ep_license_activate" name="ep_zapier_license_activate" id="ep_zapier_license_activate" data-prefix="ep_zapier" value="<?php esc_html_e( 'Activate License', 'eventprime-zapier-integration' );?>" style="display:none;"><?php esc_html_e( 'Activate License', 'eventprime-zapier-integration' );?></button>
						<?php } ?>
					</span>
				</td>
			</tr>
		<?php
	}

	public function ep_pupulate_zapier_license_item_id( $item_id, $form_data ){
		if( isset( $form_data['ep_license_type'] ) && $form_data['ep_license_type'] == 'ep_zapier' ){
			$global_settings = new Eventprime_Global_Settings(); 
			$options = $global_settings->ep_get_settings();
			$item_id  = ( isset(  $options->ep_zapier_item_id ) && ! empty( $options->ep_zapier_item_id ) ) ? $options->ep_zapier_item_id : '';     
		}
		return $item_id; 
	}

	public function ep_pupulate_zapier_license_item_name( $item_name, $form_data ){
		if( isset( $form_data['ep_license_type'] ) && $form_data['ep_license_type'] == 'ep_zapier' ){
			$global_settings = new Eventprime_Global_Settings(); 
			$options = $global_settings->ep_get_settings();
			$item_name  = ( isset( $options->ep_zapier_item_name ) && ! empty( $options->ep_zapier_item_name ) ) ? $options->ep_zapier_item_name : '';    
		}
		return $item_name;
	}

	public function ep_save_zapier_license_setting( $form_data, $license_data ){
		if( isset( $form_data['ep_license_type'] ) && $form_data['ep_license_type'] == 'ep_zapier' && ! empty( $license_data ) ){
			$global_settings = new Eventprime_Global_Settings(); 
			$options = $global_settings->ep_get_settings();
			// $license_data->license will be either "valid" or "invalid"
			$options->ep_zapier_license_key  = ( isset( $form_data['ep_license_key'] ) && ! empty( $form_data['ep_license_key'] )  && ( $license_data->license == 'valid' || $license_data->license = 'deactivated' ) ) ? $form_data['ep_license_key'] : '';
			$options->ep_zapier_license_status  = ( isset( $license_data->license ) && ! empty( $license_data->license ) ) ? $license_data->license : '';
			$options->ep_zapier_license_response  = ( isset( $license_data ) && ! empty( $license_data ) ) ? $license_data : '';
			$global_settings->ep_save_settings( $options );
		
		}
	}

	public function trigger_zapier_event_create_update( $post_id, $post )
	{
		$post_data = get_post( $post_id );
		if ( $post_data->post_date === $post_data->post_modified ) {
			$type = 'create_event';
		} else {
			$type = 'update_event';
		}
		$service = new Eventprime_Zapier_Services();
		$type = 'create_event';
		$template = $service->load_event_data_trigger( $type, $post_id );
		return $template;
	}

	// public function queue_zapier_delete($post_id)
	// {
	// 	$delay = rand( 1, 5 );
	// 	if ( ! wp_next_scheduled( 'eventprime_process_zapier_delete', array( $post_id ) ) ) {
	// 		wp_schedule_single_event( time() + $delay, 'eventprime_process_zapier_delete', array( $post_id ) );
	// 	}
	// }

	public function trigger_zapier_delete($post_id)
	{
		if ( isset($_GET['post']) && is_array($_GET['post']) && count($_GET['post']) > 1 ) {
			return;
		}

		$service  =  new Eventprime_Zapier_Services();
		$post = get_post( $post_id );

		if ( ! $post ) {
			return;
		}

		switch ( $post->post_type ) {
			case 'em_event':
				$type = 'delete_event';
				$template = $service->load_event_data_trigger( $type, $post_id );
				return $template;
				break;

			case 'em_performer':
				$type = 'delete_performer';
				$template = $service->load_performer_data_trigger( $type, $post_id );
				return $template;
			break;
		}

		return false;
	}

	public function trigger_zapier_performer_create_update($post_id, $post)
	{
		if ( $post->post_date === $post->post_modified ) {
			$type = 'create_performer';
		} else {
			$type = 'update_performer';
		}
		$service  = new Eventprime_Zapier_Services();
		$template = $service->load_performer_data_trigger( $type, $post_id );
		return $template;
	}

	public function trigger_zapier_event_booking( $booking_id, $data ){
		$service  = new Eventprime_Zapier_Services();
		$template = $service->load_event_booking_data_trigger( $booking_id );
		return $template;
	}
	
	public function trigger_zapier_cancel_event_booking($booking_data)
	{
		$type = 'cancel_booking';
		$service  = new Eventprime_Zapier_Services();
		$template = $service->load_cancel_event_booking_data_trigger($type, $booking_data );
		return $template;

	}

	public function trigger_zapier_create_new_organizer($term_id, $post)
	{
		$type = 'create_organizer';
		$service  = new Eventprime_Zapier_Services();
		$template = $service->load_organizer_data_trigger($type, $term_id );
		return $template;
	}

	public function trigger_zapier_update_organizer($term_id, $post)
	{
		$type = 'update_organizer';
		$service  = new Eventprime_Zapier_Services();
		$template = $service->load_organizer_data_trigger($type, $term_id );
		return $template;
	}

	public function trigger_zapier_delete_taxonomy( $term_id, $taxonomy ) 
	{
		if ( $taxonomy == 'em_event_organizer' ) {
			$type = 'delete_organizer';
			$service  = new Eventprime_Zapier_Services();
			$template = $service->load_organizer_data_trigger($type, $term_id );
			return $template;
		}

		if ( $taxonomy == 'em_event_venue' ) {
			$type = 'delete_venue';
			$service  = new Eventprime_Zapier_Services();
			$template = $service->load_venue_data_trigger($type, $term_id );
			return $template;
		}

	}

	public function trigger_zapier_venue_create_update($term_id, $post)
	{
		$type = 'create_venue';

		if ( isset( $post['action'] ) ) {
			if ( $post['action'] === 'editedtag' && ! empty( $post['tag_ID'] ) ) {
				$type = 'update_venue';
			} elseif ( $post['action'] === 'add-tag' ) {
				$type = 'create_venue';
			}
		}

		$service  = new Eventprime_Zapier_Services();
		$template = $service->load_venue_data_trigger($type, $term_id );
		return $template;

	}
}
