<?php

class EIX_Import_Service{
    
    public function upload_files(){
        if(isset($_FILES["file"]) && !empty($_FILES["file"])){
            $extension = pathinfo($_FILES["file"]["name"], PATHINFO_EXTENSION);
            $targetId = $_POST['target_id'];
            if($targetId == 'xml-feed' && $extension != 'xml'){
                $returnData['errors'] = __('Only XML files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            if($targetId == 'ics-feed' && $extension != 'ics'){
                $returnData['errors'] = __('Only ICS files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            if($targetId == 'csv-feed' && $extension != 'csv'){
                $returnData['errors'] = __('Only ICS files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            if($targetId == 'json-feed' && $extension != 'json'){
                $returnData['errors'] = __('Only JSON files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            $file = $_FILES['file'];
            $filename = $file['name'];
            $tmp_name = $file['tmp_name'];
            $upload_dir = wp_upload_dir();
            if (move_uploaded_file($file["tmp_name"], $upload_dir['path'] . "/" . $filename)) {
                $uploaded_file['file_name'] = $filename;
                $uploaded_file['upload_url'] = $upload_dir['url'] . "/" . $filename;
                $wp_filetype = wp_check_filetype($filename, null );
                $attachment = array(
                    'guid'           => $uploaded_file['upload_url'],
                    'post_mime_type' => $wp_filetype['type'],
                    'post_title'     => preg_replace( '/\.[^.]+$/', '', $filename ),
                    'post_content'   => '',
                    'post_status'    => 'inherit'
                );
                $attachment_id = wp_insert_attachment( $attachment, $upload_dir['path'] . "/" . $filename );
                if ( ! is_wp_error( $attachment_id ) ) {
                    require_once(ABSPATH . "wp-admin" . '/includes/file.php');
                    $attachment_data = wp_generate_attachment_metadata( $attachment_id, $upload_file['file'] );
                    wp_update_attachment_metadata( $attachment_id,  $attachment_data );
                    $returnData['success'] = array('attachment_id' => $attachment_id);
                }
            }
            else{
                $returnData['errors'] = __($upload_file['error']);
            }
        }
        return $returnData;
    }
    
}

return new EIX_Import_Service();