<?php
use ICal\ICal;
class EIX_Import_Service{
    
    public function upload_files(){
        if(isset($_FILES["file"]) && !empty($_FILES["file"])){
            $extension = pathinfo($_FILES["file"]["name"], PATHINFO_EXTENSION);
            $targetId = isset( $_POST['target_id'] ) ? $_POST['target_id'] : '';
            if($targetId == 'xml-feed' && $extension != 'xml'){
                $returnData['errors'] = __('Only XML files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            if($targetId == 'ics-feed' && $extension != 'ics'){
                $returnData['errors'] = __('Only ICS files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            if($targetId == 'csv-feed' && $extension != 'csv'){
                $returnData['errors'] = __('Only ICS files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            if($targetId == 'json-feed' && $extension != 'json'){
                $returnData['errors'] = __('Only JSON files allowed', 'eventprime-events-import-export');
                return $returnData;
            }
            $file = $_FILES['file'];
            $filename = $file['name'];
            $tmp_name = $file['tmp_name'];
            $upload_dir = wp_upload_dir();
            if (move_uploaded_file($file["tmp_name"], $upload_dir['path'] . "/" . $filename)) {
                $uploaded_file['file_name'] = $filename;
                $uploaded_file['upload_url'] = $upload_dir['url'] . "/" . $filename;
                $wp_filetype = wp_check_filetype($filename, null );
                $attachment = array(
                    'guid'           => $uploaded_file['upload_url'],
                    'post_mime_type' => $wp_filetype['type'],
                    'post_title'     => preg_replace( '/\.[^.]+$/', '', $filename ),
                    'post_content'   => '',
                    'post_status'    => 'inherit'
                );
                $attachment_id = wp_insert_attachment( $attachment, $upload_dir['path'] . "/" . $filename );
                if ( ! is_wp_error( $attachment_id ) ) {
                    require_once(ABSPATH . "wp-admin" . '/includes/file.php');
                    $attachment_data = isset( $upload_file['file'] ) ? wp_generate_attachment_metadata( $attachment_id, $upload_file['file'] ) : '';
                    wp_update_attachment_metadata( $attachment_id,  $attachment_data );
                    $returnData['success'] = array('attachment_id' => $attachment_id);
                }
            }
            else{
                $returnData['errors'] = __($upload_file['error']);
            }
        }
        return $returnData;
    }
    public function em_ix_file_import_csv($attachment_id, $offset = 1){
        $ep_functions = new Eventprime_Basic_Functions(); 
        $dbhandler = new EP_DBhandler;

        // Get Checkout Fields data (id, type, label)
        $dbhandler = new EP_DBhandler();
        $ep_all_checkout_fields_data = $dbhandler->get_all_result('CHECKOUT_FIELDS','id, type, label',1,'results',0, false,'id',true,'','OBJECT_K');

        if($offset == 1){
            $next_row = 5;
        }if($offset == 5) {
            $offset = $offset+1;
            $next_row = $offset + 5;
        }else{
            //$offset = $offset+1;
            $next_row = $offset + 5;
        }
        // error_log('OFFSET '.$offset);
        // error_log('OFFSET '.$offset);
        $total_row = 1;
        $format = $ep_functions->ep_get_datepicker_format();
        $feed_file = get_attached_file($attachment_id);
        $timezone = $ep_functions->ep_get_site_timezone();
        //$rows_string = $this->read_file($feed_file);
        $csv_string = [];
        if (($fp = fopen($feed_file, "r")) !== FALSE) {
            
            while (($row = fgetcsv($fp)) !== false) {
                $csv_string[] = $row;
            }
            fclose($fp);
        }
        $event_ids = array();
        if(!empty($csv_string)){
            // $ep_functions->epd($csv_string);

            // calculate number of tickets from 1st row 
            // $csv_headers = array_slice($csv_string, 0, 1)[0];
            $csv_headers = $csv_string[0];
            // $ep_functions->epd($csv_headers);
            $no_of_cols = 0;
            $max_no_of_tics = 0;
            $i = count($csv_headers); 
            // $ep_functions->epd($csv_headers);
            for ($i; $i >= 0; $i--) {
                if (isset($csv_headers[$i])) {
                    if (preg_match('/Tic_(\d+)_Name/', $csv_headers[$i], $matches)) {
                        $max_no_of_tics = $matches[1];
                        break;
                    }
                }
            }
            // $ep_functions->epd($max_no_of_tics);

            $total_row_all = count($csv_string);
            $total_row = $total_row_all -1;
            if($total_row <= $next_row){
                $next_row = $total_row;
            }

            $csv_string = array_slice($csv_string, $offset, 5);
                        
            $i = $offset + 1;

            $datepicker_format = $ep_functions->ep_get_datepicker_format();

            foreach ($csv_string as $value) {
                $event_venue_id = $event_type_id = '';
                
                $event_feed_id = $value[0];
                $title = $value[1];
                $parent = $value[2];
                if(!empty($parent)){
                    $event_ids[$i] = sprintf(__('Imported %s event successfully with %s parent event. ', 'eventprime-import-export'), $title, $parent);
                    $i++;
                    continue;
                }

                $description = $value[3];
                $csv_start_date = $value[4];
                $csv_hide_start_date = $value[5];
                $csv_start_time = $value[6];
                $csv_hide_start_time = $value[7];
                $csv_end_date = $value[8];
                $csv_hide_end_date = $value[9];
                $csv_end_time = $value[10];
                $csv_hide_end_time = $value[11];
                $event_all_day = $value[12];
                $event_date_placeholder = $value[13];
                $event_date_placeholder_text = $value[14];
                $additional_dates = $value[15];
                $event_image = $value[16];
                $event_type = $value[17];
                $location_name = $value[18];
                $address = $value[19];
                $seating_capacity = $value[20];
                $operator = $value[21];
                $organizer = $value[22];
                $imp_organizer_phones = $value[23];
                $imp_organizer_emails = $value[24];
                $imp_organizer_websites = $value[25];
                $performers = $value[26];
                $event_url = $value[27];
                $booking_status = $value[28];
                $external_booking_link = $value[29];
                $open_link_in_new_browser = $value[30];
                $event_cost = $value[31];
                $hide_booking_status = $value[32];
                $allow_cancellation = $value[33];
                $allow_edit_booking = $value[34];
                $edit_booking_date_data = $value[35];

                $exported_date_format = $value[36];

                $next_indx = 37;
                // create 'em_ticket_category_data' & 'em_ticket_individual_data' arrays 
                $ticket_info['em_ticket_category_data'] = []; 
                $unique_categories = [];
                $ticket_info['em_ticket_individual_data'] = []; 

                // HANDLE Ticket data and indexes 
                if ($max_no_of_tics > 0) {
                    // for each iteration increment $next_indx by num of tic entries(static) 
                    for($tic_counter = 1; $tic_counter <= $max_no_of_tics; $tic_counter++) {
                        if ( isset($value[$next_indx]) && !empty($value[$next_indx]) ) {  // tic_name 
                            $tic_name = $value[$next_indx]; 
                            $tic_price = $value[$next_indx+1]; 
                            $tic_capacity = $value[$next_indx+2]; 
                            $tic_cat_name = $value[$next_indx+3]; 
                            $tic_cat_capacity = $value[$next_indx+4];
                            
                            $tic_min_ticket_no = $value[$next_indx+5];
                            $tic_max_ticket_no = $value[$next_indx+6];
                            $tic_visibility = json_decode($value[$next_indx+7], true);
                            $tic_offers = $value[$next_indx+8];
                            $tic_multiple_offers_option = $value[$next_indx+9];
                            $tic_multiple_offers_max_discount = $value[$next_indx+10];
                            $tic_additional_fees = $value[$next_indx+11];
                            $tic_show_remaining_tickets = $value[$next_indx+12];
                            $tic_show_ticket_booking_dates = $value[$next_indx+13];
                            $tic_booking_starts = json_decode($value[$next_indx+14], true);
                            $tic_booking_ends = json_decode($value[$next_indx+15], true);

                            // $ep_functions->epd($tic_booking_ends);
                            /* 
                            calculate 
                                em_ticket_start_booking_type
                                em_ticket_start_booking_date
                                em_ticket_start_booking_time
                                em_ticket_start_booking_event_option
                                em_ticket_start_booking_days
                                em_ticket_start_booking_days_option
                            from $tic_booking_starts
                            */
                            $em_ticket_start_booking_type = $tic_booking_starts['booking_type'];
                            // $em_ticket_start_booking_date = isset($tic_booking_starts['start_date']) && !empty($tic_booking_starts['start_date']) ? date($datepicker_format, strtotime($tic_booking_starts['start_date'])) : '';
                            $em_ticket_start_booking_date = isset($tic_booking_starts['start_date']) && !empty($tic_booking_starts['start_date']) ? date_create_from_format( $exported_date_format, $tic_booking_starts['start_date'] )->format($datepicker_format) : '';
                            $em_ticket_start_booking_time = isset($tic_booking_starts['start_time']) && !empty($tic_booking_starts['start_time']) ? $tic_booking_starts['start_time'] : '';
                            $em_ticket_start_booking_event_option = isset($tic_booking_starts['event_option']) && !empty($tic_booking_starts['event_option']) ? $tic_booking_starts['event_option'] : '';
                            $em_ticket_start_booking_days = isset($tic_booking_starts['days']) && !empty($tic_booking_starts['days']) ? $tic_booking_starts['days'] : '';
                            $em_ticket_start_booking_days_option = isset($tic_booking_starts['days_option']) && !empty($tic_booking_starts['days_option']) ? $tic_booking_starts['days_option'] : '';

                            /* 
                            calculate 
                                em_ticket_ends_booking_type
                                em_ticket_ends_booking_date
                                em_ticket_ends_booking_time
                                em_ticket_ends_booking_event_option
                                em_ticket_ends_booking_days
                                em_ticket_ends_booking_days_option
                            from $tic_booking_ends
                            */
                            $em_ticket_ends_booking_type = isset($tic_booking_ends['booking_type']) ? $tic_booking_ends['booking_type'] : '';
                            // $em_ticket_ends_booking_date = isset($tic_booking_ends['end_date']) && !empty($tic_booking_ends['end_date']) ? date($datepicker_format, strtotime($tic_booking_ends['end_date'])) : '';
                            $em_ticket_ends_booking_date = isset($tic_booking_ends['end_date']) && !empty($tic_booking_ends['end_date']) ? date_create_from_format( $exported_date_format, $tic_booking_ends['end_date'] )->format($datepicker_format) : '';
                            $em_ticket_ends_booking_time = isset($tic_booking_ends['end_time']) && !empty($tic_booking_ends['end_time']) ? $tic_booking_ends['end_time'] : '';
                            $em_ticket_ends_booking_event_option = isset($tic_booking_ends['event_option']) && !empty($tic_booking_ends['event_option']) ? $tic_booking_ends['event_option'] : '';
                            $em_ticket_ends_booking_days = isset($tic_booking_ends['days']) && !empty($tic_booking_ends['days']) ? $tic_booking_ends['days'] : '';
                            $em_ticket_ends_booking_days_option = isset($tic_booking_ends['days_option']) && !empty($tic_booking_ends['days_option']) ? $tic_booking_ends['days_option'] : '';

                            /*
                            calculate visibility option
                                em_tickets_user_visibility
                                em_ticket_for_invalid_user
                                em_tickets_visibility_time_restrictions
                                em_ticket_visibility_user_roles
                            from $tic_visibility
                            */
                            $em_tickets_user_visibility = isset($tic_visibility['em_tickets_user_visibility']) ? $tic_visibility['em_tickets_user_visibility'] : '';
                            $em_ticket_for_invalid_user = isset($tic_visibility['em_ticket_for_invalid_user']) ? $tic_visibility['em_ticket_for_invalid_user'] : '';
                            $em_tickets_visibility_time_restrictions = isset($tic_visibility['em_tickets_visibility_time_restrictions']) && !empty($tic_visibility['em_tickets_visibility_time_restrictions']) ? $tic_visibility['em_tickets_visibility_time_restrictions'] : '';
                            $em_ticket_visibility_user_roles = isset($tic_visibility['em_ticket_visibility_user_roles']) && !empty($tic_visibility['em_ticket_visibility_user_roles']) ? $tic_visibility['em_ticket_visibility_user_roles'] : '';
                            
                            $next_indx += 16;

                            if (!empty($tic_cat_name)) {    // ticket category exists & current tic belongs to that cat
                                if (!isset($unique_categories[$tic_cat_name])) {
                                    // Initialize unique category
                                    $unique_categories[$tic_cat_name] = [
                                        "name" => $tic_cat_name,
                                        "capacity" => $tic_cat_capacity,
                                        "tickets" => [
                                            [
                                                "name" => $tic_name,
                                                "price" => $tic_price,
                                                "capacity" => $tic_capacity,
                                                "min_ticket_no" => $tic_min_ticket_no,
                                                "max_ticket_no" => $tic_max_ticket_no,
                                                // "visibility" => $tic_visibility,
                                                "offers" => $tic_offers,
                                                "multiple_offers_option" => $tic_multiple_offers_option,
                                                "multiple_offers_max_discount" => $tic_multiple_offers_max_discount,
                                                "ep_additional_ticket_fee_data" => json_decode($tic_additional_fees, true),
                                                "show_remaining_tickets" => $tic_show_remaining_tickets,
                                                "show_ticket_booking_dates" => $tic_show_ticket_booking_dates,
                                                // "tic_booking_starts" => $tic_booking_starts,
                                                // "tic_booking_ends" => $tic_booking_ends,
                                                'em_ticket_start_booking_type' => $em_ticket_start_booking_type,
                                                'em_ticket_start_booking_date' => $em_ticket_start_booking_date,
                                                'em_ticket_start_booking_time' => $em_ticket_start_booking_time,
                                                'em_ticket_start_booking_event_option' => $em_ticket_start_booking_event_option,
                                                'em_ticket_start_booking_days' => $em_ticket_start_booking_days,
                                                'em_ticket_start_booking_days_option' => $em_ticket_start_booking_days_option,
                                                'em_ticket_ends_booking_type' => $em_ticket_ends_booking_type,
                                                'em_ticket_ends_booking_date' => $em_ticket_ends_booking_date,
                                                'em_ticket_ends_booking_time' => $em_ticket_ends_booking_time,
                                                'em_ticket_ends_booking_event_option' => $em_ticket_ends_booking_event_option,
                                                'em_ticket_ends_booking_days' => $em_ticket_ends_booking_days,
                                                'em_ticket_ends_booking_days_option' => $em_ticket_ends_booking_days_option,
                                                'em_tickets_user_visibility' => $em_tickets_user_visibility,
                                                'em_ticket_for_invalid_user' => $em_ticket_for_invalid_user,
                                                'em_tickets_visibility_time_restrictions' => $em_tickets_visibility_time_restrictions,
                                                'em_ticket_visibility_user_roles' => $em_ticket_visibility_user_roles,
                                            ]
                                        ],
                                    ];
                                } else {
                                    // Add new tickets to the existing category
                                    $unique_categories[$tic_cat_name]['tickets'][] = [
                                        "name" => $tic_name,
                                        "price" => $tic_price,
                                        "capacity" => $tic_capacity,
                                        "min_ticket_no" => $tic_min_ticket_no,
                                        "max_ticket_no" => $tic_max_ticket_no,
                                        // "visibility" => $tic_visibility,
                                        "offers" => $tic_offers,
                                        "multiple_offers_option" => $tic_multiple_offers_option,
                                        "multiple_offers_max_discount" => $tic_multiple_offers_max_discount,
                                        "ep_additional_ticket_fee_data" => json_decode($tic_additional_fees, true),
                                        "show_remaining_tickets" => $tic_show_remaining_tickets,
                                        "show_ticket_booking_dates" => $tic_show_ticket_booking_dates,
                                        'em_ticket_start_booking_type' => $em_ticket_start_booking_type,
                                        'em_ticket_start_booking_date' => $em_ticket_start_booking_date,
                                        'em_ticket_start_booking_time' => $em_ticket_start_booking_time,
                                        'em_ticket_start_booking_event_option' => $em_ticket_start_booking_event_option,
                                        'em_ticket_start_booking_days' => $em_ticket_start_booking_days,
                                        'em_ticket_start_booking_days_option' => $em_ticket_start_booking_days_option,
                                        'em_ticket_ends_booking_type' => $em_ticket_ends_booking_type,
                                        'em_ticket_ends_booking_date' => $em_ticket_ends_booking_date,
                                        'em_ticket_ends_booking_time' => $em_ticket_ends_booking_time,
                                        'em_ticket_ends_booking_event_option' => $em_ticket_ends_booking_event_option,
                                        'em_ticket_ends_booking_days' => $em_ticket_ends_booking_days,
                                        'em_ticket_ends_booking_days_option' => $em_ticket_ends_booking_days_option,
                                        'em_tickets_user_visibility' => $em_tickets_user_visibility,
                                        'em_ticket_for_invalid_user' => $em_ticket_for_invalid_user,
                                        'em_tickets_visibility_time_restrictions' => $em_tickets_visibility_time_restrictions,
                                        'em_ticket_visibility_user_roles' => $em_ticket_visibility_user_roles,
                                    ];
                                }
                            } else {    // individual tic
                                $ticket_info['em_ticket_individual_data'][] = [
                                    "name" => $tic_name,
                                    "price" => $tic_price,
                                    "capacity" => $tic_capacity,
                                    "min_ticket_no" => $tic_min_ticket_no,
                                    "max_ticket_no" => $tic_max_ticket_no,
                                    // "visibility" => $tic_visibility,
                                    "offers" => $tic_offers,
                                    "multiple_offers_option" => $tic_multiple_offers_option,
                                    "multiple_offers_max_discount" => $tic_multiple_offers_max_discount,
                                    "ep_additional_ticket_fee_data" => json_decode($tic_additional_fees, true),
                                    "show_remaining_tickets" => $tic_show_remaining_tickets,
                                    "show_ticket_booking_dates" => $tic_show_ticket_booking_dates,
                                    'em_ticket_start_booking_type' => $em_ticket_start_booking_type,
                                    'em_ticket_start_booking_date' => $em_ticket_start_booking_date,
                                    'em_ticket_start_booking_time' => $em_ticket_start_booking_time,
                                    'em_ticket_start_booking_event_option' => $em_ticket_start_booking_event_option,
                                    'em_ticket_start_booking_days' => $em_ticket_start_booking_days,
                                    'em_ticket_start_booking_days_option' => $em_ticket_start_booking_days_option,
                                    'em_ticket_ends_booking_type' => $em_ticket_ends_booking_type,
                                    'em_ticket_ends_booking_date' => $em_ticket_ends_booking_date,
                                    'em_ticket_ends_booking_time' => $em_ticket_ends_booking_time,
                                    'em_ticket_ends_booking_event_option' => $em_ticket_ends_booking_event_option,
                                    'em_ticket_ends_booking_days' => $em_ticket_ends_booking_days,
                                    'em_ticket_ends_booking_days_option' => $em_ticket_ends_booking_days_option,
                                    'em_tickets_user_visibility' => $em_tickets_user_visibility,
                                    'em_ticket_for_invalid_user' => $em_ticket_for_invalid_user,
                                    'em_tickets_visibility_time_restrictions' => $em_tickets_visibility_time_restrictions,
                                    'em_ticket_visibility_user_roles' => $em_ticket_visibility_user_roles,
                                ];
                            }
                        } else {    // if tic_name empty then no tic present 
                            $next_indx += 16;
                            continue; 
                        }
                    }
                    $ticket_info['em_ticket_category_data'] = addslashes(json_encode(array_values($unique_categories)));
                }
                $ticket_info['em_ticket_individual_data'] = addslashes(json_encode($ticket_info['em_ticket_individual_data']));
                
                $event_meta_data = [];  // Event meta data (["meta_key" => meta_value, "meta_key" => meta_value, "meta_key" => meta_value, so on])

                $custom_fields_data = [];  // Event custom fields

                // start the following indexing after evaluating $next_indx 
                $event_text_color = $value[$next_indx];
                $attendee_note = $value[$next_indx+1];
                $max_tic_per_user = $value[$next_indx+2];
                $max_tic_per_booking = $value[$next_indx+3];
                $max_tic_warning_msg = $value[$next_indx+4];
                $event_social_info = $value[$next_indx+5];
                $interval = $value[$next_indx+6];
                $formula = $value[$next_indx+18];
                $attendee_checkout_fields_data = maybe_unserialize($value[$next_indx+19]);
                $fixed_checkout_field_data = maybe_unserialize($value[$next_indx+20]);
                $booking_checkout_fields_data = maybe_unserialize($value[$next_indx+21]);
                $event_type_meta = maybe_unserialize($value[$next_indx+22]);
                $venue_meta = maybe_unserialize($value[$next_indx+23]);
                $organizers_meta = maybe_unserialize($value[$next_indx+24]);
                $performers_meta = maybe_unserialize($value[$next_indx+25]);
                
                // save event
                $event_data = new stdClass();
                $event_data->name = htmlspecialchars_decode(sanitize_text_field(strip_tags($title)));
                $event_data->description = wp_kses_post($description);
                
                // if event name empty then not insert
                if(empty($event_data->name)){
                    $i++;
                    continue;
                }
                if(empty($csv_start_time)){
                    $event_ids[$i] = sprintf(__('Start Date Missing, Title: %s', 'eventprime-import-export'), $event_data->name);
                    $i++;
                    continue;
                }

                
                $start_date = date_create_from_format( $exported_date_format, $csv_start_date )->format($datepicker_format);
                $start_time = '';
                if(!empty($csv_start_time)){
                    $start_time = $csv_start_time;
                }
                
                $end_date = date_create_from_format( $exported_date_format, $csv_end_date )->format($datepicker_format);
                $end_time = '';
                if(!empty($csv_end_time)){
                    $end_time = $csv_end_time;
                }
                $allday = (int) $event_all_day;
                if(!empty($allday) || !trim($start_date) && !trim($end_date)){
                    $allDayDate = $start_date;
                    $event_data->em_all_day = 1;
                    $start_time = "12:00 AM";
                    $end_time = "11:59 PM";
                    $start_date = $allDayDate;
                    //$allEndDate = date($format, strtotime($allDayDate. ' + 1 days'));
                    $end_date = $allDayDate;
                }
                if(!empty($csv_start_date) && empty($csv_end_date)){
                    $allDayDate = $start_date;
                    $event_data->em_all_day = 1;
                    $start_time = !empty($start_time) ? $start_time : "12:00 AM";
                    $end_time = !empty($end_time) ? $end_time : "11:59 PM";
                    $start_date = $allDayDate;
                    $end_date = $allDayDate;
                }
                if(!empty($csv_start_date) && !empty($csv_end_date)){
                    if($start_date > $end_date){
                        $end_date = $start_date;
                    }
                }
                $event_data->em_start_date = !empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date, $datepicker_format,1) : '';
                $event_data->em_end_date = !empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date ,$datepicker_format,1): '';
                $event_data->em_start_time = !empty($start_time) ? $start_time : '12:00 AM';
                $event_data->em_end_time = !empty($end_time) ? $end_time : '11:59 PM';

                // date and time hide settings 
                if (!empty($csv_hide_start_date)) {
                    $event_data->em_hide_event_start_date = 1;
                }
                if (!empty($csv_hide_start_time)) {
                    $event_data->em_hide_event_start_time = 1;
                }
                if (!empty($csv_hide_end_date)) {
                    $event_data->em_hide_end_date = 1;
                }
                if (!empty($csv_hide_end_time)) {
                    $event_data->em_hide_event_end_time = 1;
                }
                
                $event_data->em_enable_booking = $booking_status; 
                if ( $booking_status == "external_bookings" ) {
                    $event_data->em_custom_link = $external_booking_link; 
                    $event_data->em_custom_link_new_browser = $open_link_in_new_browser; 
                }

                // event type
                $type_term = '';
                if(!empty(trim($event_type))){
                    $eventType = $event_type;
                    $type_term = get_term_by('name', $eventType, 'em_event_type');
                }
                if(empty($type_term) && !empty(trim($event_type))){
                    $type_data = new stdClass();
                    $type_data->name = sanitize_text_field($event_type);
                    $type_data = !empty($event_type_meta) ? $event_type_meta : new stdClass();
                    $event_type_id = $ep_functions->create_event_types((array)$type_data);
                    if(!empty($event_type_id)){
                        $event_data->em_event_type = $event_type_id;
                    }
                }
                else{
                    $event_type_id = isset( $type_term->term_id ) ? $type_term->term_id : '';
                    $event_data->em_event_type = $event_type_id;
                }

                // Venue 
                $location_term = new stdClass();
                if(!empty(trim($location_name))){
                    $location_term = get_term_by('name', $location_name, 'em_venue');
                }
                else{
                    if(!empty(trim($address))){
                        $location_exp = explode(",", $address);
                        $location_name = $location_exp[0];
                        $location_term = get_term_by('name', $location_name, 'em_venue');
                    }
                }
                if(empty($location_term) && !empty($location_name)){
                    //$venues_controller
                    $venue_data = new stdClass();
                    $venue_data->name = sanitize_text_field($location_name);
                    $venue_data->em_type = 'standings';
                    $venue_data->em_address = sanitize_text_field($address);
                    if(empty($address)){
                        $venue_data->em_address = sanitize_text_field($location_name);
                    }
                    $venue_data->em_seating_capacity = $seating_capacity;
                    // $venue_data->em_lng = $longitude;
                    // $venue_data->em_lat = $latitude;
                    $venue_data->em_operator = $operator;
                    $venue_data = !empty($venue_meta) ? maybe_unserialize($venue_meta) : $venue_data;
                    $event_venue_id = $ep_functions->create_venue((array)$venue_data);
                    if(!empty($event_venue_id)){
                        $event_data->em_venue = $event_venue_id;
                    }
                }
                else{
                    $event_venue_id = isset( $location_term->term_id ) ? $location_term->term_id : '';
                    $event_data->em_venue = $event_venue_id;
                }

                // Performers 
                if(!empty($performers)){
                    $performers = explode(' | ', $performers);
                    // $all_performers = $dbhandler->get_performer_all_data();
                    $performer_ids = array();
                    $i_perf = 0;
                    foreach ($performers as $imp_per) {
                            $posts = get_posts([
                                'post_type'  => 'em_performer',
                                'title' => $imp_per,
                            ]);
                            
                            if(!empty($posts) && count($posts) > 0){
                                $performer_ids[] = $posts[0]->ID;
                            }else{
                                $performer_data = new stdClass();
                                $performer_data->name = $imp_per;
                                $performer_data->em_type = 'person';
                                $performer_data = !empty($performers_meta) && (isset($performers_meta[$i_perf]) && !empty($performers_meta[$i_perf])) ? $performers_meta[$i_perf] : $performer_data; // ***** meta performer wise, match by name
                                $performer = $ep_functions->insert_performer_post_data((array)$performer_data);
                                $i_perf++;
                                $performer_ids[] = $performer;
                                break;
                            }
                        
                    }
                    $event_data->em_performer = $performer_ids;
                    if(!empty($event_data->em_performer)){
                        $event_data->em_enable_performer = 1;
                    }
                }
                
                // event organizer
                if(!empty($organizer)){
                    $event_organizers = array_filter(explode(" | ", trim($organizer)));
                    if(!empty($imp_organizer_phones)){ 
                        $organizer_phones = explode(" | ", $imp_organizer_phones); 
                        
                    }
                    if(!empty($imp_organizer_emails)){ 
                        $organizer_emails = explode(" | ", $imp_organizer_emails);
                    }
                    if(!empty($imp_organizer_websites)){ 
                        $organizer_websites = explode(" | ", $imp_organizer_websites);
                    }
                    $organizer_ids = array();
                    $i_org = 0;
                    foreach($event_organizers as $key => $organizer_name){
                        $organizer = get_term_by('name',$organizer_name,'em_event_organizer');
                        if(!empty($organizer)){
                            $organizer_ids[] = $organizer->term_id;
                            
                        }else{
                            $org_data = new stdClass();
                            $org_data->name = $organizer_name;
                            if(!empty($organizer_phones) && isset($organizer_phones[$key]) && !empty($organizer_phones[$key])){
                                $org_data->em_organizer_phones = explode(', ', $organizer_phones[$key]);
                            }
                            if(!empty($organizer_emails) && isset($organizer_emails[$key]) && !empty($organizer_emails[$key])){
                                $org_data->em_organizer_emails = explode(', ', $organizer_emails[$key]);
                            }
                            if(!empty($organizer_websites) && isset($organizer_websites[$key]) && !empty($organizer_websites[$key])){
                                $org_data->em_organizer_websites = explode(', ', $organizer_websites[$key]);
                            }
                            $org_data->em_social_links = array(
                                'facebook'=>'',
                                'linkedin'=>'',
                                'instagram'=>'',
                                'twitter'=>''
                            );
                            $org_data = !empty($organizers_meta) && (isset($organizers_meta[$i_org]) && !empty($organizers_meta[$i_org])) ? $organizers_meta[$i_org] : $org_data; // ***** meta organizer wise, match by email
                            $i_org++;
                            $org_id = $ep_functions->create_organizer((array)$org_data);
                        
                            if($org_id){
                                $organizer_ids[] = $org_id;
                            }
                        }
                    }
                    $event_data->em_organizer = $organizer_ids;
                }

                // Recurring Setting
                if(!empty($interval) && !empty($formula)){
                    $event_data->em_enable_recurrence = 1;
                    $conditions = explode(' | ', $formula);
                    $event_data->em_recurrence_interval = isset($conditions[0]) ? $conditions[0] : 'daily';
                    if(trim($event_data->em_recurrence_interval) != 'custom_dates'){
                        $event_data->em_recurrence_step = isset($conditions[1]) ? $conditions[1] : 1;
                    }
                    if(trim($event_data->em_recurrence_interval) == 'daily'){
                        $event_data->em_recurrence_ends = isset($conditions[2]) ? $conditions[2] : '';
                        if($event_data->em_recurrence_ends == 'on'){
                                $em_recurrence_limit = isset($conditions[3]) ? $conditions[3] : '';
                            
                            if(!empty($em_recurrence_limit)){
                                $event_data->em_recurrence_limit = $em_recurrence_limit;
                            }
                        }
                        if($event_data->em_recurrence_ends == 'after'){
                            $event_data->em_recurrence_occurrence_time = isset($conditions[3]) ? $conditions[3] : '';
                        }
                        $title_format = isset($conditions[4]) ? $conditions[4] : 0;
                        if($title_format){
                            $event_data->em_add_slug_in_event_title = 1;
                            $event_data->em_event_slug_type_options = isset($conditions[5]) ? $conditions[5] : 'prefix';
                            $event_data->em_recurring_events_slug_format = isset($conditions[6]) ? $conditions[6] : 'number';
                        }
                        
                    }
                    if(trim($event_data->em_recurrence_interval) == 'weekly'){
                        $event_data->em_recurrence_ends = isset($conditions[2]) ? $conditions[2] : '';
                        if($event_data->em_recurrence_ends == 'on'){
                            $em_recurrence_limit = isset($conditions[3]) ? $conditions[3] : '';
                            if(!empty($em_recurrence_limit)){
                                // $event_data->em_recurrence_limit = date('Y-m-d', strtotime($em_recurrence_limit));
                                $event_data->em_recurrence_limit = date($datepicker_format, strtotime($em_recurrence_limit));
                            }
                        }
                        if($event_data->em_recurrence_ends == 'after'){
                            $event_data->em_recurrence_occurrence_time = isset($conditions[3]) ? $conditions[3] : '';
                        }
                        $week_days  = isset($conditions[4]) && !empty($conditions[4]) ? explode(',',$conditions[4]) : array();
                        $event_data->em_selected_weekly_day = $week_days;
                        $title_format = isset($conditions[5]) ? $conditions[5] : 0;
                        if($title_format){
                            $event_data->em_add_slug_in_event_title = 1;
                            $event_data->em_event_slug_type_options = isset($conditions[6]) ? $conditions[6] : 'prefix';
                            $event_data->em_recurring_events_slug_format = isset($conditions[7]) ? $conditions[7] : 'number';
                        }
                        
                    }
                    if(trim($event_data->em_recurrence_interval) == 'monthly'){
                        $event_data->em_recurrence_ends = isset($conditions[2]) ? $conditions[2] : '';
                        if($event_data->em_recurrence_ends == 'on'){
                            $em_recurrence_limit = isset($conditions[3]) ? $conditions[3] : '';
                            if(!empty($em_recurrence_limit)){
                                // $event_data->em_recurrence_limit = date('Y-m-d', strtotime($em_recurrence_limit));
                                $event_data->em_recurrence_limit = date($datepicker_format, strtotime($em_recurrence_limit));
                            }
                        }
                        if($event_data->em_recurrence_ends == 'after'){
                            $event_data->em_recurrence_occurrence_time = isset($conditions[3]) ? $conditions[3] : '';
                        }
                        $months_days  = isset($conditions[4]) && !empty($conditions[4]) ? $conditions[4] : 'day';
                        $event_data->em_recurrence_monthly_day = $months_days;
                        if($months_days == 'date'){
                            $title_format = isset($conditions[5]) ? $conditions[5] : 0;
                            if($title_format){
                                $event_data->em_add_slug_in_event_title = 1;
                                $event_data->em_event_slug_type_options = isset($conditions[6]) ? $conditions[6] : 'prefix';
                                $event_data->em_recurring_events_slug_format = isset($conditions[7]) ? $conditions[7] : 'number';
                            }
                        }
                        if($months_days =='day'){
                            $months_day_list = isset($conditions[5]) && !empty($conditions[5]) ? explode(',',$conditions[5]) : array();
                            if(!empty($months_day_list)){
                                $event_data->em_recurrence_monthly_weekno = isset($months_day_list[0]) ? $months_day_list[0] : '';
                                $event_data->em_recurrence_monthly_fullweekday = isset($months_day_list[1]) ? $months_day_list[1] : '';
                    
                            }
                            $title_format = isset($conditions[6]) ? $conditions[6] : 0;
                            if($title_format){
                                $event_data->em_add_slug_in_event_title = 1;
                                $event_data->em_event_slug_type_options = isset($conditions[7]) ? $conditions[7] : 'prefix';
                                $event_data->em_recurring_events_slug_format = isset($conditions[8]) ? $conditions[8] : 'number';
                            }
                        }
                        
                    }
                    if(trim($event_data->em_recurrence_interval) == 'yearly'){
                        $event_data->em_recurrence_ends = isset($conditions[2]) ? $conditions[2] : '';
                        if($event_data->em_recurrence_ends == 'on'){
                            $em_recurrence_limit = isset($conditions[3]) ? $conditions[3] : '';
                            if(!empty($em_recurrence_limit)){
                                // $event_data->em_recurrence_limit = date('Y-m-d', strtotime($em_recurrence_limit));
                                $event_data->em_recurrence_limit = date($datepicker_format, strtotime($em_recurrence_limit));
                            }
                        }
                        if($event_data->em_recurrence_ends == 'after'){
                            $event_data->em_recurrence_occurrence_time = isset($conditions[3]) ? $conditions[3] : '';
                        }
                        $year_days  = isset($conditions[4]) && !empty($conditions[4]) ? $conditions[4] : 'day';
                        $event_data->em_recurrence_yearly_day = $year_days;
                        if($year_days == 'date'){
                            $title_format = isset($conditions[5]) ? $conditions[5] : 0;
                            if($title_format){
                                $event_data->em_add_slug_in_event_title = 1;
                                $event_data->em_event_slug_type_options = isset($conditions[6]) ? $conditions[6] : 'prefix';
                                $event_data->em_recurring_events_slug_format = isset($conditions[7]) ? $conditions[7] : 'number';
                            }
                        }
                        if($year_days =='day'){
                            $months_day_list = isset($conditions[5]) && !empty($conditions[5]) ? explode(',',$conditions[5]) : array();
                            if(!empty($months_day_list)){
                                $event_data->em_recurrence_yearly_weekno = isset($months_day_list[0]) ? $months_day_list[0] : '';
                                $event_data->em_recurrence_yearly_fullweekday = isset($months_day_list[1]) ? $months_day_list[1] : '';
                                $event_data->em_recurrence_yearly_monthday = isset($months_day_list[2]) ? $months_day_list[2] : '';
                            }
                            $title_format = isset($conditions[6]) ? $conditions[6] : 0;
                            if($title_format){
                                $event_data->em_add_slug_in_event_title = 1;
                                $event_data->em_event_slug_type_options = isset($conditions[7]) ? $conditions[7] : 'prefix';
                                $event_data->em_recurring_events_slug_format = isset($conditions[8]) ? $conditions[8] : 'number';
                            }
                        }
                        
                    }
                    if(trim($event_data->em_recurrence_interval) == 'advanced'){
                        $event_data->em_recurrence_ends = isset($conditions[2]) ? $conditions[2] : '';
                        if($event_data->em_recurrence_ends == 'on'){
                            $em_recurrence_limit = isset($conditions[3]) ? $conditions[3] : '';
                            if(!empty($em_recurrence_limit)){
                                // $event_data->em_recurrence_limit = date('Y-m-d', strtotime($em_recurrence_limit));
                                $event_data->em_recurrence_limit = date($datepicker_format, strtotime($em_recurrence_limit));
                            }
                        }
                        if($event_data->em_recurrence_ends == 'after'){
                            $event_data->em_recurrence_occurrence_time = isset($conditions[3]) ? $conditions[3] : '';
                        }
                        $adv_options  = isset($conditions[4]) && !empty($conditions[4]) ? explode(',',trim($conditions[4])) : array();
                        $event_data->em_recurrence_advanced_dates = $adv_options;
                        $title_format = isset($conditions[5]) ? $conditions[5] : 0;
                        if($title_format){
                            $event_data->em_add_slug_in_event_title = 1;
                            $event_data->em_event_slug_type_options = isset($conditions[6]) ? $conditions[6] : 'prefix';
                            $event_data->em_recurring_events_slug_format = isset($conditions[7]) ? $conditions[7] : 'number';
                        }
                        
                    }
                    if(trim($event_data->em_recurrence_interval) == 'custom_dates'){
                        $event_data->em_recurrence_selected_custom_dates = isset($conditions[1]) && !empty($conditions[1]) ? explode(',',$conditions[1]) : array();
                        $title_format = isset($conditions[3]) ? $conditions[3] : 0;
                        if($title_format){
                            $event_data->em_add_slug_in_event_title = 1;
                            $event_data->em_event_slug_type_options = isset($conditions[4]) ? $conditions[4] : 'prefix';
                            $event_data->em_recurring_events_slug_format = isset($conditions[5]) ? $conditions[5] : 'number';
                        }
                        
                    }
                    
                }

                $event_meta_data = [];
                $event_meta_data['em_start_date'] = !empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date, $datepicker_format,1) : '';
                $event_meta_data['em_end_date'] = !empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date ,$datepicker_format,1): '';
                $event_meta_data['em_start_time'] = !empty($start_time) ? $start_time : '12:00 AM';
                $event_meta_data['em_end_time'] = !empty($end_time) ? $end_time : '11:59 PM';
                $event_meta_data['em_fixed_event_price'] = $event_cost;
                $event_meta_data['em_event_date_placeholder'] = $event_date_placeholder;
                $event_meta_data['em_event_date_placeholder_custom_note'] = $event_date_placeholder_text;
                // additional_dates 
                if ( !empty($additional_dates) ) {
                    $event_meta_data['em_event_more_dates'] = 1;
                    $add_dates = explode(")  |  (", trim($additional_dates, "() "));

                    // Initialize the output array
                    $result = [];
                    $uid = time();
                    // Process each event string
                    foreach ($add_dates as $add_date) {
                        // Split each event string into components
                        list($date, $time, $label) = explode(" | ", $add_date);

                        // Create an associative array for each event
                        $result[] = [
                            'uid' => $uid, // Generate a unique ID
                            'date' => date_create_from_format( $exported_date_format, trim($date) )->getTimestamp(),
                            'time' => $time,
                            'label' => $label
                        ];
                        $uid++;
                    }
                    $event_meta_data['em_event_add_more_dates'] = $result;
                }

                // Booking section meta 
                $event_meta_data['em_hide_booking_status'] = $hide_booking_status;
                $event_meta_data['em_allow_cancellations'] = $allow_cancellation;
                $event_meta_data['em_allow_edit_booking'] = $allow_edit_booking;

                $event_meta_data['em_edit_booking_date_data'] = [];
                $edit_booking_date_data = json_decode($edit_booking_date_data, true);
                if (!empty($allow_edit_booking) ) {
                    $event_meta_data['em_edit_booking_date_data'] = array(
                        'em_edit_booking_date_type' => sanitize_text_field($edit_booking_date_data['em_edit_booking_date_type']),
                        'em_edit_booking_date_date' => (!empty($edit_booking_date_data['em_edit_booking_date_date']) ? $edit_booking_date_data['em_edit_booking_date_date'] : '' ),
                        'em_edit_booking_date_time' => sanitize_text_field($edit_booking_date_data['em_edit_booking_date_time']),
                        'em_edit_booking_date_days' => sanitize_text_field($edit_booking_date_data['em_edit_booking_date_days']),
                        'em_edit_booking_date_days_option' => sanitize_text_field($edit_booking_date_data['em_edit_booking_date_days_option']),
                        'em_edit_booking_date_event_option' => sanitize_text_field($edit_booking_date_data['em_edit_booking_date_event_option']),
                    );
                }

                // other settings meta 
                $event_meta_data['em_event_text_color'] = $event_text_color;
                $event_meta_data['em_audience_notice'] = $attendee_note;

                // Restriction settings meta 
                $event_meta_data['em_event_max_tickets_per_user'] = $max_tic_per_user;
                $event_meta_data['em_event_max_tickets_per_order'] = $max_tic_per_booking;
                $event_meta_data['em_event_max_tickets_reached_message'] = $max_tic_warning_msg;
                
                // Event socials 
                $em_social_links = array();
                if( !empty($event_social_info) ) {
                    $parts = explode(" | ", $event_social_info);
                    foreach ($parts as $part) {
                        list($platform, $url) = explode(" - ", $part);
                        $key = strtolower($platform);
                        
                        $em_social_links[$key] = $url;
                    }
                }
                $event_meta_data['em_social_links'] = $em_social_links;

                // attendee_checkout_fields_data 
                $custom_fields_data = array();
                if (isset($attendee_checkout_fields_data['em_event_checkout_name']) && !empty($attendee_checkout_fields_data['em_event_checkout_name'])) {
                    $custom_fields_data['em_event_checkout_name'] = absint($attendee_checkout_fields_data['em_event_checkout_name']);
                    if (isset($attendee_checkout_fields_data['em_event_checkout_name_first_name']) && !empty($attendee_checkout_fields_data['em_event_checkout_name_first_name'])) {
                        $custom_fields_data['em_event_checkout_name_first_name'] = absint($attendee_checkout_fields_data['em_event_checkout_name_first_name']);
                    }
                    if (isset($attendee_checkout_fields_data['em_event_checkout_name_first_name_required']) && !empty($attendee_checkout_fields_data['em_event_checkout_name_first_name_required'])) {
                        $custom_fields_data['em_event_checkout_name_first_name_required'] = absint($attendee_checkout_fields_data['em_event_checkout_name_first_name_required']);
                    }
                    if (isset($attendee_checkout_fields_data['em_event_checkout_name_middle_name']) && !empty($attendee_checkout_fields_data['em_event_checkout_name_middle_name'])) {
                        $custom_fields_data['em_event_checkout_name_middle_name'] = absint($attendee_checkout_fields_data['em_event_checkout_name_middle_name']);
                    }
                    if (isset($attendee_checkout_fields_data['em_event_checkout_name_middle_name_required']) && !empty($attendee_checkout_fields_data['em_event_checkout_name_middle_name_required'])) {
                        $custom_fields_data['em_event_checkout_name_middle_name_required'] = absint($attendee_checkout_fields_data['em_event_checkout_name_middle_name_required']);
                    }
                    if (isset($attendee_checkout_fields_data['em_event_checkout_name_last_name']) && !empty($attendee_checkout_fields_data['em_event_checkout_name_last_name'])) {
                        $custom_fields_data['em_event_checkout_name_last_name'] = absint($attendee_checkout_fields_data['em_event_checkout_name_last_name']);
                    }
                    if (isset($attendee_checkout_fields_data['em_event_checkout_name_last_name_required']) && !empty($attendee_checkout_fields_data['em_event_checkout_name_last_name_required'])) {
                        $custom_fields_data['em_event_checkout_name_last_name_required'] = absint($attendee_checkout_fields_data['em_event_checkout_name_last_name_required']);
                    }
                }

                $imp_att_checkout_fields_to_exisiting_map = [];
                $imp_att_checkout_fields_to_new_ids_map = [];
                if (isset($attendee_checkout_fields_data['em_event_checkout_fields_data']) && count($attendee_checkout_fields_data['em_event_checkout_fields_data']) > 0) {
                    $custom_fields_data['em_event_checkout_fields_data'] = array();
                    foreach ($attendee_checkout_fields_data['em_event_checkout_fields_data'] as $imp_cfd) {
                        $imp_cfd = json_decode($imp_cfd);
                        // if ( $imp_cfd->id == "5" ) {
                        //     $ep_functions->epd($imp_cfd);
                        // }

                        $imp_cfd_exists = false;
                        if ( !empty($ep_all_checkout_fields_data) ) {
                            foreach ($ep_all_checkout_fields_data as $checkout_field) {
                                if ( ($imp_cfd->type === $checkout_field->type) && ($imp_cfd->label == $checkout_field->label) ) {
                                    $custom_fields_data['em_event_checkout_fields_data'][] = absint($checkout_field->id);
                                    $imp_att_checkout_fields_to_exisiting_map[$imp_cfd->id] = $checkout_field->id;  // map imported checkout fields ids to exisiting checkout fields ids if condition is true 
                                    $imp_cfd_exists = true;
                                    break;
                                }
                            }
                        }

                        if ( empty($imp_cfd_exists) ) {
                            // $imp_cfd_new_id = $ep_functions->create_checkout_fields($imp_cfd); // class-ep-ajax.php --> save_checkout_field(), add option_data  
                            $dbhandler = new EP_DBhandler;
                            $table_name = 'CHECKOUT_FIELDS';
                            $save_data = array();
                            $save_data['label'] = sanitize_text_field( $imp_cfd->label );
                            $save_data['type'] = sanitize_text_field( $imp_cfd->type );
                            // for option data
                            $save_data['option_data'] = '';
                            $option_data = !empty( $imp_cfd->option_data ) ? (array) $imp_cfd->option_data : '' ;
                            // // set selected value
                            // if( ! empty( $data['ep_checkout_field_option_value_selected'] ) ) {
                            //     $option_index = $data['ep_checkout_field_option_value_selected'];
                            //     $option_data[$option_index]['selected'] = 1;
                            // }
                            if( ! empty( $option_data ) ) {
                                $save_data['option_data'] = maybe_serialize( $option_data );
                            }
                            $save_data['priority'] = 1;
                            $save_data['status'] = 1;
                            $save_data['created_by'] = get_current_user_id();
                            $save_data['created_at'] = date_i18n( "Y-m-d H:i:s", time() );
                            $imp_cfd_new_id = $dbhandler->insert_row($table_name, $save_data);

                            $custom_fields_data['em_event_checkout_fields_data'][] = absint($imp_cfd_new_id);
                            $imp_att_checkout_fields_to_new_ids_map[$imp_cfd->id] = absint($imp_cfd_new_id);
                        }
                    }
                    // get required field data
                    if (isset($attendee_checkout_fields_data['em_event_checkout_fields_data_required']) && count($attendee_checkout_fields_data['em_event_checkout_fields_data_required']) > 0) {
                        $custom_fields_data['em_event_checkout_fields_data_required'] = array();
                        foreach ($attendee_checkout_fields_data['em_event_checkout_fields_data_required'] as $imp_cfdr) {
                            if ( in_array( $imp_cfdr, array_keys($imp_att_checkout_fields_to_exisiting_map) ) ) {
                                $custom_fields_data['em_event_checkout_fields_data_required'][] = absint($imp_att_checkout_fields_to_exisiting_map[$imp_cfdr]);
                                continue;
                            } elseif ( in_array( $imp_cfdr, array_keys($imp_att_checkout_fields_to_new_ids_map) ) ) {
                                // map imported required attendee checkout fields to new created checkout fields IDS 
                                $custom_fields_data['em_event_checkout_fields_data_required'][] = absint($imp_att_checkout_fields_to_new_ids_map[$imp_cfdr]);
                                continue;
                            }
                            // $custom_fields_data['em_event_checkout_fields_data_required'][] = absint($imp_cfdr);
                        }
                    }
                }

                // fixed_checkout_field_data 
                if (isset($fixed_checkout_field_data['em_event_checkout_fixed_terms_enabled']) && absint($fixed_checkout_field_data['em_event_checkout_fixed_terms_enabled']) == 1) {
                    $custom_fields_data['em_event_checkout_fixed_terms_enabled'] = $fixed_checkout_field_data['em_event_checkout_fixed_terms_enabled'];
                    if (isset($fixed_checkout_field_data['em_event_checkout_fixed_terms_label'])) {
                        $custom_fields_data['em_event_checkout_fixed_terms_label'] = sanitize_text_field($fixed_checkout_field_data['em_event_checkout_fixed_terms_label']);
                    }
                    if (isset($fixed_checkout_field_data['em_event_checkout_fixed_terms_option'])) {
                        $custom_fields_data['em_event_checkout_fixed_terms_option'] = sanitize_text_field($fixed_checkout_field_data['em_event_checkout_fixed_terms_option']);
                    }
                    if (isset($fixed_checkout_field_data['em_event_checkout_fixed_terms_content'])) {
                        if ($custom_fields_data['em_event_checkout_fixed_terms_option'] == 'page') {
                            $custom_fields_data['em_event_checkout_fixed_terms_content'] = absint($fixed_checkout_field_data['em_event_checkout_fixed_terms_content']);
                        } else if ($custom_fields_data['em_event_checkout_fixed_terms_option'] == 'content') {
                            $custom_fields_data['em_event_checkout_fixed_terms_content'] = wp_kses_post($fixed_checkout_field_data['em_event_checkout_fixed_terms_content']);
                        } else {
                            $custom_fields_data['em_event_checkout_fixed_terms_content'] = sanitize_text_field($fixed_checkout_field_data['em_event_checkout_fixed_terms_content']);
                        }
                    }
                }

                // booking_checkout_fields_data 
                $imp_booking_checkout_fields_to_exisiting_map = [];
                $imp_booking_checkout_fields_to_new_ids_map = [];
                if (isset($em_event_checkout_booking_fields['em_event_booking_fields_data']) && count($em_event_checkout_booking_fields['em_event_booking_fields_data']) > 0) {
                    $custom_fields_data['em_event_booking_fields_data'] = array();
                    foreach ($em_event_checkout_booking_fields['em_event_booking_fields_data'] as $imp_cfd) {
                        $imp_cfd = json_decode($imp_cfd);
                        
                        $imp_cfd_exists = false;
                        if ( !empty($ep_all_checkout_fields_data) ) {
                            foreach ($ep_all_checkout_fields_data as $checkout_field) {
                                if ( ($imp_cfd->type === $checkout_field->type) && ($imp_cfd->label == $checkout_field->label) ) {
                                    $custom_fields_data['em_event_booking_fields_data'][] = absint($checkout_field->id);
                                    $imp_booking_checkout_fields_to_exisiting_map[$imp_cfd->id] = $checkout_field->id;  // map imported checkout fields ids to exisiting checkout fields ids if condition is true 
                                    $imp_cfd_exists = true;
                                    break;
                                }
                            }
                        }


                        if ( empty($imp_cfd_exists) ) {
                            $dbhandler = new EP_DBhandler;
                            $table_name = 'CHECKOUT_FIELDS';
                            $save_data = array();
                            $save_data['label'] = sanitize_text_field( $imp_cfd->label );
                            $save_data['type'] = sanitize_text_field( $imp_cfd->type );
                            // for option data
                            $save_data['option_data'] = '';
                            $option_data = !empty( $imp_cfd->option_data ) ? (array) $imp_cfd->option_data : '' ;
                            if( ! empty( $option_data ) ) {
                                $save_data['option_data'] = maybe_serialize( $option_data );
                            }
                            $save_data['priority'] = 1;
                            $save_data['status'] = 1;
                            $save_data['created_by'] = get_current_user_id();
                            $save_data['created_at'] = date_i18n( "Y-m-d H:i:s", time() );
                            $imp_cfd_new_id = $dbhandler->insert_row($table_name, $save_data);

                            $custom_fields_data['em_event_booking_fields_data'][] = absint($imp_cfd_new_id);
                            $imp_booking_checkout_fields_to_new_ids_map[$imp_cfd->id] = absint($imp_cfd_new_id);
                        }
                    }
                    // get required field data
                    if (isset($em_event_checkout_booking_fields['em_event_booking_fields_data_required']) && count($em_event_checkout_booking_fields['em_event_booking_fields_data_required']) > 0) {
                        $custom_fields_data['em_event_booking_fields_data_required'] = array();
                        foreach ($em_event_checkout_booking_fields['em_event_booking_fields_data_required'] as $imp_cfdr) {
                            if ( in_array( $imp_cfdr, array_keys($imp_booking_checkout_fields_to_exisiting_map) ) ) {
                                $custom_fields_data['em_event_booking_fields_data_required'][] = absint($imp_booking_checkout_fields_to_exisiting_map[$imp_cfdr]);
                                continue;
                            } elseif ( in_array( $imp_cfdr, array_keys($imp_booking_checkout_fields_to_new_ids_map) ) ) {
                                // map imported required attendee checkout fields to new created checkout fields IDS 
                                $custom_fields_data['em_event_booking_fields_data_required'][] = absint($imp_booking_checkout_fields_to_new_ids_map[$imp_cfdr]);
                                continue;
                            }
                        }
                    }
                }

                // custom meta
                $custom_meta = array(
                    'ix_source' => 'ep-csv-calendar',
                    'ix_feed_id' => $event_feed_id,
                );
                $event_data->em_custom_meta = $custom_meta;

                // save event
                $event_id = $ep_functions->insert_event_post_data((array)$event_data);                
                if($event_id){
                    $dbhandler->eventprime_update_event_post_meta($event_id, (array)$event_data, []);
                    $dbhandler->eventprime_update_event_tickets_and_category($event_id, $ticket_info, []);      // $ticket_info --> $event_data is ARRAY $post
                    $dbhandler->eventprime_save_event_metadata($event_id, $event_meta_data);    // $event_meta_data --> $event_data
                    $dbhandler->eventprime_update_event_custom_fields($event_id, $custom_fields_data, []);  // $custom_fields_data --> $event_data
                    
                    // event_image 
                    if( $event_image ) {
                        $is_thumbnail_imported = $this->ep_ie_add_image_as_thumbnail( $event_id, $event_image );
                    }
                    $event_ids[$i] = sprintf(__('Imported Successfully with event id: %d, Title: %s', 'eventprime-import-export'), $event_id, $event_data->name);
                }else{
                    $event_ids[$i] = sprintf(__('Error id: %d, Title: %s', 'eventprime-import-export'), $i, $event_data->name);
                }
                $i++;
            }
            $eventsCount = count((array)$event_ids);
            if($eventsCount){
                $returnData['success'] = $event_ids;
            }
            else{
                $returnData['errors'] = __('No event imported.','eventprime-events-import-export');
            }
        }
        else{
            $returnData['errors'] = __('No Event found in uploaded file', 'eventprime-events-import-export');
        }
        $response = array(
            'offset'=>$next_row,
            'total_row'=>$total_row,
            'terminate'=> $total_row <= $next_row ? true: false,
            'html'=> $this->import_data_response($returnData),
            // 'csv_string' => $csv_string
        );
        return $response;
    }

    public function ep_ie_add_image_as_thumbnail($post_id, $source_image_url) {
        $upload_dir = wp_upload_dir();

        $parsed_url = parse_url($source_image_url);
        $source_base_url = $parsed_url['scheme'] . '://' . $parsed_url['host'] . dirname($parsed_url['path']);

        $file_name = basename($source_image_url);
        $file_type = wp_check_filetype($source_image_url);

        $new_file_path = $upload_dir['path'] . '/' . $file_name;

        $ch = curl_init($source_image_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
        $image_data = curl_exec($ch);

        if (curl_errno($ch)) {
            error_log('cURL Error: ' . curl_error($ch));
            curl_close($ch);
            return false;
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code === 200 && !empty($image_data)) {
            file_put_contents($new_file_path, $image_data);

            $attachment = array(
                'guid'           => $upload_dir['url'] . '/' . $file_name,
                'post_mime_type' => $file_type['type'],
                'post_title'     => sanitize_file_name($file_name),
                'post_content'   => '',
                'post_status'    => 'inherit',
            );

            $attachment_id = wp_insert_attachment($attachment, $new_file_path, $post_id);

            require_once ABSPATH . 'wp-admin/includes/image.php';
            $attach_data = wp_generate_attachment_metadata($attachment_id, $new_file_path);
            wp_update_attachment_metadata($attachment_id, $attach_data);

            set_post_thumbnail($post_id, $attachment_id);

            return $attachment_id; 
        } else {
            error_log('Failed to fetch image data from: ' . $source_image_url . ' (HTTP Code: ' . $http_code . ')');
            return false;
        }
    }
    
    public function em_ix_file_import_json($attachment_id, $offset =1){
        $ep_functions = new Eventprime_Basic_Functions();
        $next_row = $offset + 5;
        if($offset == 0){
            $next_row = 5;
        
        }
        $total_row = 1;
        $format = $ep_functions->ep_get_datepicker_format();
        $feed_file = get_attached_file($attachment_id);
        $timezone = $ep_functions->ep_get_site_timezone();
        $rows_string = $this->read_file($feed_file);
        $json_array = []; 
        
                if(!empty($rows_string)){
                    $json_string = json_decode($rows_string, true);

                    for ( $counter = 0; $counter < count( $json_string ); $counter++ ) {
                        array_push( $json_array, $json_string[$counter] );

                        if ( isset($json_string[$counter]['child_events']) && !empty($json_string[$counter]['child_events']) ) {
                            foreach ( $json_string[$counter]['child_events'] as $child_event ) {
                                array_push( $json_array, $child_event );
                            }    
                        }
                    }


                    $total_row_all = count($json_array);
                    $total_row = $total_row_all;
                    if($total_row <= $next_row){
                        $next_row = $total_row;
                    }
                    $json_array = array_slice($json_array, $offset, 5);
                    $datepicker_format_arr = $ep_functions->ep_get_global_settings( 'datepicker_format' );
                    if( ! empty( $datepicker_format_arr ) ) {
                        $datepicker_format_arr = explode('&', $datepicker_format_arr);
                        $format = $datepicker_format_arr[1];
                    }
                    $i = $offset+1;
                    foreach ($json_array as $event) {
                        $event_venue_id = $event_type_id = '';
                        /*if($i == 0){
                            $i++;
                            continue;
                        }*/
                        // save event

                        if(!empty($event['parent'])){
                            $event_ids[$i] = sprintf(__('Imported %s event successfully with %s parent event. ', 'eventprime-import-export'), $event['title'], $event['parent']);
                            $i++;
                            continue;
                        }

                        $event_data = new stdClass();
                        $event_data->name = htmlspecialchars_decode(sanitize_text_field(strip_tags($event['title'])));
                        $event_data->description = sanitize_text_field($event['desc']);
                        if(isset($event['start_date']) && !empty($event['start_date'])){
                            $start_date = date($format, strtotime($event['start_date']));
                            
                        }
                        $start_time = '';
                        if(!empty($event['start_time'])){
                            $start_time = $event['start_time'];
                        }
                        if(!empty($event['end_date'])){
                            $end_date = date($format, strtotime($event['end_date']));
                            
                        }
                        $end_time = '';
                        if(!empty($event['end_time'])){
                            $end_time = $event['end_time'];
                        }
                        $allday = isset($event['all_day']) && !empty($event['all_day']) ? 1 : 0;
                        if(!empty($allday) || !trim($start_date) && !trim($end_date)){
                            $allDayDate = $start_date;
                            $allday = 1;
                            $start_time = "12:00 AM";
                            $end_time = "12:00 AM";
                            $start_date = $allDayDate;
                            $allEndDate = date($format, strtotime($allDayDate. ' + 1 days'));
                            $end_date = $allEndDate;
                        }
                        
                        $event_data->em_start_date = !empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date, $format) : '';
                        $event_data->em_end_date = !empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date ,$format): '';
                        $event_data->em_start_time = !empty($start_time) ? $start_time : '';
                        $event_data->em_end_time = !empty($end_time) ? $end_time : '';
                        
                        $event_data->em_ticket_price = isset($event['price']) && !empty($event['price']) ? $event['price']: '';
                        $location_term = new stdClass();
                        if(!empty($event_data->em_ticket_price)){
                            $event_data->em_enable_booking = 'bookings_on';
                        }
                        $location_name = isset($event['venue']) && !empty($event['venue']) ? $event['venue'] : "";
                        $address = isset($event['address']) && !empty($event['address']) ? $event['address'] : "";
                        $venue_object = isset($event['venue_object']) && !empty($event['venue_object']) ? $event['venue_object'] : array();
                        if(!empty(trim($location_name))){
                            $location_term = get_term_by('name', $location_name, 'em_venue');
                        }
                        else{
                            if(!empty(trim($address))){
                                $location_exp = explode(",", $address);
                                $location_name = $location_exp[0];
                                $location_term = get_term_by('name', $location_name, 'em_venue');
                            }
                        }
                        if(empty($location_term) && !empty($location_name)){
                            //$venues_controller
                            $venue_data = new stdClass();
                            if(!empty($venue_object)){
                                $venue_data->name = isset($venue_object['name']) ? $venue_object['name'] : $venue_object['name'];
                                $venue_data->description = isset($venue_object['description']) ? $venue_object['description'] : "";
                                $venue_data->em_address = isset($venue_object['em_address']) ? $venue_object['em_address'] : '';
                                $venue_data->em_lat = isset($venue_object['em_lat']) ? $venue_object['em_lat'] : "";
                                $venue_data->em_lng = isset($venue_object['em_lng']) ? $venue_object['em_lng'] : "";
                                $venue_data->em_state = isset($venue_object['em_state']) ? $venue_object['em_state'] : '';
                                $venue_data->em_country = isset($venue_object['em_country']) ? $venue_object['em_country'] : '';
                                $venue_data->em_postal_code = isset($venue_object['em_postal_code']) ? $venue_object['em_postal_code'] : '';
                                $venue_data->em_zoom_level = isset($venue_object['em_zoom_level']) ? $venue_object['em_zoom_level'] : '';
                                $venue_data->em_established = isset($venue_object['em_established']) ? $venue_object['em_established'] : '';
                                $venue_data->em_seating_organizer = isset($venue_object['em_seating_organizer']) ? $venue_object['em_seating_organizer'] : '';
                                $venue_data->em_is_featured = isset($venue_object['em_is_featured']) ? 1 : 0;
                                $venue_data->em_facebook_page = isset($venue_object['em_facebook_page']) ? $venue_object['em_facebook_page'] : '';
                                $venue_data->em_type = isset($venue_object['em_type']) ? $venue_object['em_type'] : 'standings';

                            }else{
                                $venue_data->name = sanitize_text_field($location_name);
                                $venue_data->em_type = 'standings';
                                
                                $venue_data->em_address = sanitize_text_field($address);
                                if(empty($address)){
                                    $venue_data->em_address = sanitize_text_field($location_name);
                                }
                                $venue_data->em_seating_capacity = isset($event['seating_capacity']) ? $event['seating_capacity'] : "";
                                $venue_data->em_lng = isset($event['lng']) ? $event['lng'] : "";
                                $venue_data->em_lat = isset($event['lat']) ? $event['lat'] : "";
                                $venue_data->em_operator = isset($event['operator']) ? $event['operator'] : "";
                                
                            }
                            $event_venue_id = $ep_functions->create_venue((array)$venue_data);
                            if(!empty($event_venue_id)){
                                $event_data->em_venue = $event_venue_id;
                            }
                        }
                        else{
                            $event_venue_id = isset( $location_term->term_id ) ? $location_term->term_id : '';
                            $event_data->em_venue = $event_venue_id;
                        }
                        $performers = isset($event['performer_object']) ? $event['performer_object'] : array();
                        
                        if(!empty($performers)){
                            $performer_ids = array();
                            foreach ($performers as $performer) {
                                    $posts = get_posts([
                                        'post_type'  => 'em_performer',
                                        'title' => trim($performer['name']),
                                    ]);
                                    if(!empty($posts) && count($posts) > 0){
                                        $performer_ids[] = $posts[0]->ID;
                                    }else{
                                        $performer_data = new stdClass();
                                        
                                        $performer_data->name = isset($performer['name']) ? $performer['name'] : "";
                                        $performer_data->description = isset($performer['description']) ? $performer['description'] : "";
                                        $performer_data->em_type = isset($performer['em_type']) ? $performer['em_type'] : "";
                                        $performer_data->em_role = isset($performer['em_role']) ? $performer['em_role'] : "";
                                        $performer_data->em_display_front = isset($performer['em_display_front']) ? $performer['em_display_front'] : "";
                                        $performer_data->em_is_featured = isset($performer['em_is_featured']) ? $performer['em_is_featured'] : "";
                                        $performer_data->em_social_links = isset($performer['em_social_links']) ? $performer['em_social_links'] : array();
                                        $performer_data->em_performer_phones = isset($performer['em_performer_phones']) ? $performer['em_performer_phones'] : array();
                                        $performer_data->em_performer_emails = isset($performer['em_performer_emails']) ? $performer['em_performer_emails'] : array();
                                        $performer_data->em_performer_websites = isset($performer['em_performer_websites']) ? $performer['em_performer_websites'] : array();
                                        
                                        $performer = $ep_functions->insert_performer_post_data((array)$performer_data);
                                        $performer_ids[] = $performer;
                                        break;
                                    }
                                
                            }
                            $event_data->em_performer = $performer_ids;
                            if(!empty($event_data->em_performer)){
                                $event_data->em_enable_performer = 1;
                            }
                        }
                        
                        /* event organizer */
                        $organizers = isset($event['organizer_object']) && !empty($event['organizer_object']) ? $event['organizer_object'] : array();
                        if(!empty($organizers)){
                            
                            $organizer_ids = array();
                            foreach($organizers as $organizer){
                                $org = get_term_by('name',$organizer['name'],'em_event_organizer');
                                if(!empty($org)){
                                    $organizer_ids[] = $org->term_id;
                                    
                                }else{
                                    $org_data = new stdClass();
                                    $org_data->name = isset($organizer['name']) ? $organizer['name'] : "";
                                    $org_data->name = isset($organizer['name']) ? $organizer['name'] : "";
                                    $org_data->em_organizer_phones = isset($organizer['em_organizer_phones']) ? $organizer['em_organizer_phones'] : array();
                                    $org_data->em_organizer_emails = isset($organizer['em_organizer_emails']) ? $organizer['em_organizer_emails'] : array();
                                    $org_data->em_organizer_websites = isset($organizer['em_organizer_websites']) ? $organizer['em_organizer_websites'] : array();
                                    $org_data->em_is_featured = isset($organizer['em_is_featured']) ? $organizer['em_is_featured'] : 0;
                                    $org_data->em_social_links = isset($organizer['em_social_links']) ? $organizer['em_social_links'] : array('facebook'=>'','linkedin'=>'','instagram'=>'','twitter'=>'');
                                    
                                    $org_id = $ep_functions->create_organizer((array)$org_data);
                                
                                    if($org_id){
                                        $organizer_ids[] = $org_id;
                                    }
                                }
                            }
                            $event_data->em_organizer = $organizer_ids;
                        }
                        // event type
                        $event_type = isset($event['event_type']) && !empty(trim($event['event_type'])) ? sanitize_text_field($event['event_type']) : '';
                        $event_type_obj = isset($event['event_type_object']) && count($event['event_type_object']) ? $event['event_type_object'] : array();
                        
                        if(!empty($event_type)){
                            $type_term = get_term_by('name', $event_type, 'em_event_type');
                        }
                        if(empty($type_term) && !empty($event_type)){
                            $type_data = new stdClass();
                            if(is_array($event_type_obj) && !empty($event_type_obj)){
                               $type_data->name = isset($event_type_obj['name']) ? $event_type_obj['name'] : $event_type;
                               $type_data->description = isset($event_type_obj['description']) ? $event_type_obj['description'] : "";
                               $type_data->em_color = isset($event_type_obj['em_color']) ? $event_type_obj['em_color'] : '';
                               $type_data->em_type_text_color = isset($event_type_obj['em_type_text_color']) ? $event_type_obj['em_type_text_color'] : "";
                               $type_data->em_is_featured = isset($event_type_obj['em_is_featured']) ? $event_type_obj['em_is_featured'] : "";
                               $type_data->age_group = isset($event_type_obj['age_group']) ? $event_type_obj['age_group'] : 'all';
                               
                            }else{
                                $type_data->name = sanitize_text_field($event_type);
                            }
                            
                            $event_type_id = $ep_functions->create_event_types((array)$type_data);
                            if(!empty($event_type_id)){
                                $event_data->em_event_type = $event_type_id;
                            }
                        }
                        else{
                            $event_type_id = isset( $type_term->term_id ) ? $type_term->term_id : ''; 
                            $event_data->em_event_type = $event_type_id;
                        }
                        // custom meta
                        $custom_meta = array(
                            'ix_source' => 'ep-json-files',
                            'ix_feed_id' => isset($event['id']) ? $event['id'] : '',
                        );
                        $event_data->em_custom_meta = $custom_meta;
                        $recurrence = isset($event['recurring_condition']) ? $event['recurring_condition'] : array();
                        if(!empty($recurrence)){
                            $event_data->em_enable_recurrence = 1;
                            $event_data->em_recurrence_step = isset($recurrence['em_recurrence_step']) ? $recurrence['em_recurrence_step'] : 1;
                            $event_data->em_recurrence_interval = isset($recurrence['em_recurrence_interval']) ? $recurrence['em_recurrence_interval'] : '';
                            $event_data->em_recurrence_ends = isset($recurrence['em_recurrence_ends']) ? $recurrence['em_recurrence_ends'] : '';
                            $event_data->em_recurrence_limit = isset($recurrence['em_recurrence_limit']) && !empty($recurrence['em_recurrence_limit']) ? date($format,$recurrence['em_recurrence_limit']) : '';
                            $event_data->em_recurrence_occurrence_time = isset($recurrence['em_recurrence_occurrence_time']) ? $recurrence['em_recurrence_occurrence_time'] : '';
                            $event_data->em_add_slug_in_event_title = isset($recurrence['em_add_slug_in_event_title']) ? $recurrence['em_add_slug_in_event_title'] : '';
                            $event_data->em_event_slug_type_options = isset($recurrence['em_event_slug_type_options']) ? $recurrence['em_event_slug_type_options'] : '';
                            $event_data->em_recurring_events_slug_format = isset($recurrence['em_recurring_events_slug_format']) ? $recurrence['em_recurring_events_slug_format'] : '';
                            $event_data->em_selected_weekly_day = isset($recurrence['em_selected_weekly_day']) ? $recurrence['em_selected_weekly_day'] : '';
                            $event_data->em_recurrence_monthly_weekno = isset($recurrence['em_recurrence_monthly_weekno']) ? $recurrence['em_recurrence_monthly_weekno'] : '';
                            $event_data->em_recurrence_monthly_fullweekday = isset($recurrence['em_recurrence_monthly_fullweekday']) ? $recurrence['em_recurrence_monthly_fullweekday'] : '';
                            $event_data->em_recurrence_monthly_day = isset($recurrence['em_recurrence_monthly_day']) ? $recurrence['em_recurrence_monthly_day'] : '';
                            $event_data->em_recurrence_yearly_weekno = isset($recurrence['em_recurrence_yearly_weekno']) ? $recurrence['em_recurrence_yearly_weekno'] : '';
                            $event_data->em_recurrence_yearly_fullweekday = isset($recurrence['em_recurrence_yearly_fullweekday']) ? $recurrence['em_recurrence_yearly_fullweekday'] : '';
                            $event_data->em_recurrence_yearly_monthday = isset($recurrence['em_recurrence_yearly_monthday']) ? $recurrence['em_recurrence_yearly_monthday'] : '';
                            
                            $event_data->em_recurrence_yearly_day = isset($recurrence['em_recurrence_yearly_day']) ? $recurrence['em_recurrence_yearly_day'] : '';
                            $event_data->em_recurrence_advanced_dates = isset($recurrence['em_recurrence_advanced_dates']) ? $recurrence['em_recurrence_advanced_dates'] : array();
                            $event_data->em_recurrence_selected_custom_dates = isset($recurrence['em_recurrence_selected_custom_dates']) ? $recurrence['em_recurrence_selected_custom_dates'] : '';
                        
                        }
                        // if event name empty then not insert
                        if(empty($event_data->name)){
                            continue;
                        }
                        // save event
                        $event_id = $ep_functions->insert_event_post_data((array)$event_data);
                        if($event_id){
                            $event_ids[$i] = sprintf(__('Imported Successfully with event id: %d', 'eventprime-import-export'), $event_id);
                        }else{
                            $event_ids[$i] = sprintf(__('Error id: %d', 'eventprime-import-export'), $event_id);
                        }
                        
                        $i++;
                    }
                    $eventsCount = count((array)$event_ids);
                    if($eventsCount){
                        $returnData['success'] = $event_ids;
                    }
                    else{
                        $returnData['errors'] = __('No event imported.','eventprime-events-import-export');
                    }
                }
                else{
                    $returnData['errors'] = __('No Event found in uploaded file', 'eventprime-events-import-export');
                }
            $response = array(
                'offset'=>$next_row,
                'total_row'=>$total_row,
                'terminate'=> $total_row <= $next_row ? true: false,
                'html'=> $this->import_data_response($returnData),
            );
            return $response;
    }
    public function em_ix_file_import_xml($attachment_id, $offset =1){
        $ep_functions = new Eventprime_Basic_Functions();

        $datepicker_format = $ep_functions->ep_get_datepicker_format();

        // $next_row = (int)$offset + 5;
        // if($offset == 0){
        //     $next_row = 5;
        
        // }
        if ($offset == 0) {
            $next_row = 4;
        } else{
            $offset = $offset+1;
            $next_row = $offset + 4;
        }
        $total_row = 1;
        $format = $ep_functions->ep_get_datepicker_format();
        $feed_file = get_attached_file($attachment_id);
        $timezone = $ep_functions->ep_get_site_timezone();
        $rows_string = $this->read_file($feed_file);
        $xml_array = [];
                $xml_string = str_replace(':i:', 'iii', $this->read_file($feed_file));
                // load xml and check
                $XML = simplexml_load_string($xml_string);
                if($XML === false){
                    $returnData['errors'] = __('Not a valid XML file');
                    return $returnData;
                }
                if(!empty($XML->children())){
                    // Convert into json
                    $rows_string = json_encode($XML);
                    $xml_string = json_decode($rows_string, true);
                    // return count($xml_string['item']); 
                    // die;
                    
                    if(isset($xml_string['item'][0])){

                        for ( $counter = 0; $counter < count( $xml_string['item'] ); $counter++ ) {
                            array_push( $xml_array, $xml_string['item'][$counter] );

                            if ( isset($xml_string['item'][$counter]['child_events']) && !empty($xml_string['item'][$counter]['child_events']) ) {
                                // return $xml_string['item'][$counter]['child_events']['item']; 
                                // die;
                                foreach ( $xml_string['item'][$counter]['child_events']['item'] as $child_event ) {
                                    // $xml_string = $child_event;
                                    array_push( $xml_array, $child_event );
                                }    
                            }
                        }

                        // if ( isset($xml_string['item']['child_events']) && !empty($xml_string['item']['child_events']) ) {
                        //     foreach ( $xml_string['item']['child_events'] as $child_event ) {
                        //         $xml_string = $child_event;
                        //     }
                        // } else {
                        //     $xml_string = $xml_string['item'];
                        // }

                    }
                    // return $xml_array; 
                    // die;


                    //unset($json_string[0]);

                    // $total_row_all = count($xml_string);
                    // $total_row = $total_row_all;
                    // if($total_row <= $next_row){
                    //     $next_row = $total_row;
                    // }
                    // $xml_string = array_slice($xml_string, $offset, $next_row);
                    
                    $total_row_all = count($xml_array);
                    $total_row = $total_row_all - 1;
                    if($total_row <= $next_row){
                        $next_row = $total_row;
                    }
                    $xml_array = array_slice($xml_array, $offset, 5);

                    // return $xml_array;
                    // die;
                    
                    $i = $offset+1;
                    // foreach($xml_string as $event){
                    foreach($xml_array as $event){

                        // if( isset($event['child_events']) && !empty($event['child_events']) ){
                        //     foreach ( $event['child_events']['item'] as $single_child_event ) {
                        //         $event_ids[$i] = sprintf(__('Imported %s event successfully with %s parent event. ', 'eventprime-import-export'), $single_child_event['title'], $single_child_event['parent']);
                        //         // $total_row++;
                        //         $next_row++;
                        //         $i++; 
                        //     }
                        //     // continue; 
                        // }

                        if( !empty( $event['parent'] ) ){
                            $event_ids[$i] = sprintf(__('Imported %s event successfully with %s parent event. ', 'eventprime-import-export'), $event['title'], $event['parent']);
                            $i++;
                            continue;
                        }

                        $event_venue_id = $event_type_id = '';
                        /*if($i == 0){
                            $i++;
                            continue;
                        }*/
                        $event_data = new stdClass();
                        $event_data->name = htmlspecialchars_decode(sanitize_text_field(strip_tags($event['title'])));
                        $event_data->description = sanitize_text_field($event['desc']);
                        if(isset($event['start_date']) && !empty($event['start_date'])){
                            $start_date = date($format, strtotime($event['start_date']));
                            
                        }
                        $start_time = '';
                        if(!empty($event['start_time'])){
                            $start_time = $event['start_time'];
                        }
                        if(!empty($event['end_date'])){
                            $end_date = date($format, strtotime($event['end_date']));
                            
                        }
                        $end_time = '';
                        if(!empty($event['end_time'])){
                            $end_time = $event['end_time'];
                        }
                        $allday = isset($event['all_day']) && !empty($event['all_day']) ? 1 : 0;
                        if(!empty($allday) || !trim($start_date) && !trim($end_date)){
                            $allDayDate = $start_date;
                            $allday = 1;
                            $start_time = "12:00 AM";
                            $end_time = "12:00 AM";
                            $start_date = $allDayDate;
                            $allEndDate = date($format, strtotime($allDayDate. ' + 1 days'));
                            $end_date = $allEndDate;
                        }
                        $event_data->em_start_date = !empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date, $format) : '';
                        $event_data->em_end_date = !empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date ,$format): '';
                        $event_data->em_start_time = !empty($start_time) ? $start_time : '';
                        $event_data->em_end_time = !empty($end_time) ? $end_time : '';
                        
                        $event_data->em_ticket_price = isset($event['price']) && !empty($event['price']) ? $event['price']: '';
                        $location_term = new stdClass();
                        if(!empty($event_data->em_ticket_price)){
                            $event_data->em_enable_booking = 'bookings_on';
                        }
                        $location_name = isset($event['venue']) && !empty($event['venue']) ? $event['venue'] : "";
                        $address = isset($event['address']) && !empty($event['address']) ? $event['address'] : "";
                        $venue_object = isset($event['venue_object']) && !empty($event['venue_object']) ? $event['venue_object'] : array();
                        
                        if(!empty(trim($location_name))){
                            $location_term = get_term_by('name', $location_name, 'em_venue');
                        }
                        else{
                            if(!empty(trim($address))){
                                $location_exp = explode(",", $address);
                                $location_name = $location_exp[0];
                                $location_term = get_term_by('name', $location_name, 'em_venue');
                            }
                        }
                        if(empty($location_term) && !empty($location_name)){
                            //$venues_controller
                            $venue_data = new stdClass();
                            if(!empty($venue_object)){
                                $venue_data->name = isset($venue_object['name']) ? $venue_object['name'] : $venue_object['name'];
                                $venue_data->description = isset($venue_object['description']) ? $venue_object['description'] : "";
                                $venue_data->em_address = isset($venue_object['em_address']) ? $venue_object['em_address'] : '';
                                $venue_data->em_lat = isset($venue_object['em_lat']) ? $venue_object['em_lat'] : "";
                                $venue_data->em_lng = isset($venue_object['em_lng']) ? $venue_object['em_lng'] : "";
                                $venue_data->em_state = isset($venue_object['em_state']) ? $venue_object['em_state'] : '';
                                $venue_data->em_country = isset($venue_object['em_country']) ? $venue_object['em_country'] : '';
                                $venue_data->em_postal_code = isset($venue_object['em_postal_code']) ? $venue_object['em_postal_code'] : '';
                                $venue_data->em_zoom_level = isset($venue_object['em_zoom_level']) ? $venue_object['em_zoom_level'] : '';
                                $venue_data->em_established = isset($venue_object['em_established']) ? $venue_object['em_established'] : '';
                                $venue_data->em_seating_organizer = isset($venue_object['em_seating_organizer']) ? $venue_object['em_seating_organizer'] : '';
                                $venue_data->em_is_featured = isset($venue_object['em_is_featured']) ? 1 : 0;
                                $venue_data->em_facebook_page = isset($venue_object['em_facebook_page']) ? $venue_object['em_facebook_page'] : '';
                                $venue_data->em_type = isset($venue_object['em_type']) ? $venue_object['em_type'] : 'standings';

                            }else{
                                $venue_data->name = sanitize_text_field($location_name);
                                $venue_data->em_type = 'standings';
                                
                                $venue_data->em_address = sanitize_text_field($address);
                                if(empty($address)){
                                    $venue_data->em_address = sanitize_text_field($location_name);
                                }
                                $venue_data->em_seating_capacity = isset($event['seating_capacity']) ? $event['seating_capacity'] : "";
                                $venue_data->em_lng = isset($event['lng']) ? $event['lng'] : "";
                                $venue_data->em_lat = isset($event['lat']) ? $event['lat'] : "";
                                $venue_data->em_operator = isset($event['operator']) ? $event['operator'] : "";
                                
                            }
                            $event_venue_id = $ep_functions->create_venue((array)$venue_data);
                            if(!empty($event_venue_id)){
                                $event_data->em_venue = $event_venue_id;
                            }
                        }
                        else{
                            $event_venue_id = isset( $location_term->term_id ) ? $location_term->term_id : '';
                            $event_data->em_venue = $event_venue_id;
                        }
                        $performers = isset($event['performer_object']) ? $event['performer_object'] : array();
                        if(isset($performers['item'][0])){
                            $performers = $performers['item'];
                        }

                        if(!empty($performers)){
                            $performer_ids = array();
                            foreach ($performers as $performer) {
                                    $posts = get_posts([
                                        'post_type'  => 'em_performer',
                                        'title' => trim($performer['name']),
                                    ]);
                                    if(!empty($posts) && count($posts) > 0){
                                        $performer_ids[] = $posts[0]->ID;
                                    }else{
                                        $performer_data = new stdClass();
                                        
                                        $performer_data->name = isset($performer['name']) ? htmlspecialchars_decode(sanitize_text_field(strip_tags($performer['name']))) : "";
                                        $performer_data->description = isset($performer['description']) ? sanitize_text_field($performer['description']) : "";
                                        $performer_data->em_type = isset($performer['em_type']) ? $performer['em_type'] : "";
                                        $performer_data->em_role = isset($performer['em_role']) ? sanitize_text_field($performer['em_role']) : "";
                                        $performer_data->em_display_front = isset($performer['em_display_front']) ? $performer['em_display_front'] : "";
                                        $performer_data->em_is_featured = isset($performer['em_is_featured']) ? $performer['em_is_featured'] : "";
                                        $performer_data->em_social_links = isset($performer['em_social_links']) ? $performer['em_social_links'] : array();
                                        $performer_data->em_performer_phones = isset($performer['em_performer_phones']) ? $performer['em_performer_phones'] : array();
                                        $performer_data->em_performer_emails = isset($performer['em_performer_emails']) ? $performer['em_performer_emails'] : array();
                                        $performer_data->em_performer_websites = isset($performer['em_performer_websites']) ? $performer['em_performer_websites'] : array();

                                        $performer = $ep_functions->insert_performer_post_data((array)$performer_data);
                                        $performer_ids[] = $performer;
                                        break;
                                    }
                                
                            }
                            $event_data->em_performer = $performer_ids;
                            if(!empty($event_data->em_performer)){
                                $event_data->em_enable_performer = 1;
                            }
                        }
                        
                        /* event organizer */
                        $organizers = isset($event['organizer_object']) && !empty($event['organizer_object']) ? $event['organizer_object'] : array();
                        if(isset($organizers['item'][0])){
                            $organizers = $organizers['item'];
                        }
                        if(!empty($organizers)){
                            
                            $organizer_ids = array();
                            foreach($organizers as $organizer){
                                $org = get_term_by('name',$organizer['name'],'em_event_organizer');
                                if(!empty($org)){
                                    $organizer_ids[] = $org->term_id;
                                    
                                }else{
                                    $org_data = new stdClass();
                                    $org_data->name = isset($organizer['name']) ? $organizer['name'] : "";
                                    $org_data->name = isset($organizer['name']) ? $organizer['name'] : "";
                                    $org_data->em_organizer_phones = isset($organizer['em_organizer_phones']) ? $organizer['em_organizer_phones'] : array();
                                    $org_data->em_organizer_emails = isset($organizer['em_organizer_emails']) ? $organizer['em_organizer_emails'] : array();
                                    $org_data->em_organizer_websites = isset($organizer['em_organizer_websites']) ? $organizer['em_organizer_websites'] : array();
                                    $org_data->em_is_featured = isset($organizer['em_is_featured']) ? $organizer['em_is_featured'] : 0;
                                    $org_data->em_social_links = isset($organizer['em_social_links']) ? $organizer['em_social_links'] : array('facebook'=>'','linkedin'=>'','instagram'=>'','twitter'=>'');
                                    
                                    $org_id = $ep_functions->create_organizer((array)$org_data);
                                
                                    if($org_id){
                                        $organizer_ids[] = $org_id;
                                    }
                                }
                            }
                            $event_data->em_organizer = $organizer_ids;
                        }
                        // event type
                        $event_type = isset($event['event_type']) && !empty(trim($event['event_type'])) ? sanitize_text_field($event['event_type']) : '';
                        $event_type_obj = isset($event['event_type_object']['item']) && count($event['event_type_object']['item']) ? $event['event_type_object']['item'] : array();
                        
                        if(!empty($event_type)){
                            $type_term = get_term_by('name', $event_type, 'em_event_type');
                        }
                        if(empty($type_term) && !empty($event_type)){
                            $type_data = new stdClass();
                            if(is_array($event_type_obj) && !empty($event_type_obj)){
                               $type_data->name = isset($event_type_obj['name']) ? $event_type_obj['name'] : $event_type;
                               $type_data->description = isset($event_type_obj['description']) ? $event_type_obj['description'] : "";
                               $type_data->em_color = isset($event_type_obj['em_color']) ? $event_type_obj['em_color'] : '';
                               $type_data->em_type_text_color = isset($event_type_obj['em_type_text_color']) ? $event_type_obj['em_type_text_color'] : "";
                               $type_data->em_is_featured = isset($event_type_obj['em_is_featured']) ? $event_type_obj['em_is_featured'] : "";
                               $type_data->age_group = isset($event_type_obj['age_group']) ? $event_type_obj['age_group'] : 'all';
                               
                            }else{
                                $type_data->name = sanitize_text_field($event_type);
                            }
                            
                            $event_type_id = $ep_functions->create_event_types((array)$type_data);
                            if(!empty($event_type_id)){
                                $event_data->em_event_type = $event_type_id;
                            }
                        }
                        else{
                            $event_type_id = $type_term->term_id;
                            $event_data->em_event_type = $event_type_id;
                        }
                        // custom meta
                        $custom_meta = array(
                            'ix_source' => 'ep-json-files',
                            'ix_feed_id' => isset($event['id']) ? $event['id'] : '',
                        );
                        $event_data->em_custom_meta = $custom_meta;
                        
                        $recurrence = isset($event['recurring_condition']) ? $event['recurring_condition'] : array();
                        if(!empty($recurrence)){
                            $event_data->em_enable_recurrence = 1;
                            $event_data->em_recurrence_step = isset($recurrence['em_recurrence_step']) ? $recurrence['em_recurrence_step'] : 1;
                            $event_data->em_recurrence_interval = isset($recurrence['em_recurrence_interval']) ? $recurrence['em_recurrence_interval'] : '';
                            $event_data->em_recurrence_ends = isset($recurrence['em_recurrence_ends']) ? $recurrence['em_recurrence_ends'] : '';
                            $event_data->em_recurrence_limit = isset($recurrence['em_recurrence_limit']) && !empty($recurrence['em_recurrence_limit']) ? date($datepicker_format,$recurrence['em_recurrence_limit']) : '';
                            $event_data->em_recurrence_occurrence_time = isset($recurrence['em_recurrence_occurrence_time']) ? $recurrence['em_recurrence_occurrence_time'] : '';
                            $event_data->em_add_slug_in_event_title = isset($recurrence['em_add_slug_in_event_title']) ? $recurrence['em_add_slug_in_event_title'] : '';
                            $event_data->em_event_slug_type_options = isset($recurrence['em_event_slug_type_options']) ? $recurrence['em_event_slug_type_options'] : '';
                            $event_data->em_recurring_events_slug_format = isset($recurrence['em_recurring_events_slug_format']) ? $recurrence['em_recurring_events_slug_format'] : '';
                            $event_data->em_selected_weekly_day = isset($recurrence['em_selected_weekly_day']['item']) ? explode(',',$recurrence['em_selected_weekly_day']['item']) : array();
                            $event_data->em_recurrence_monthly_weekno = isset($recurrence['em_recurrence_monthly_weekno']) ? $recurrence['em_recurrence_monthly_weekno'] : '';
                            $event_data->em_recurrence_monthly_fullweekday = isset($recurrence['em_recurrence_monthly_fullweekday']) ? $recurrence['em_recurrence_monthly_fullweekday'] : '';
                            $event_data->em_recurrence_monthly_day = isset($recurrence['em_recurrence_monthly_day']) ? $recurrence['em_recurrence_monthly_day'] : '';
                            $event_data->em_recurrence_yearly_weekno = isset($recurrence['em_recurrence_yearly_weekno']) ? $recurrence['em_recurrence_yearly_weekno'] : '';
                            $event_data->em_recurrence_yearly_fullweekday = isset($recurrence['em_recurrence_yearly_fullweekday']) ? $recurrence['em_recurrence_yearly_fullweekday'] : '';
                            $event_data->em_recurrence_yearly_monthday = isset($recurrence['em_recurrence_yearly_monthday']) ? $recurrence['em_recurrence_yearly_monthday'] : '';
                            
                            $event_data->em_recurrence_yearly_day = isset($recurrence['em_recurrence_yearly_day']) ? $recurrence['em_recurrence_yearly_day'] : '';
                            $event_data->em_recurrence_advanced_dates = array();
                            if(isset($recurrence['em_recurrence_advanced_dates']['item'])){
                                $event_data->em_recurrence_advanced_dates = $recurrence['em_recurrence_advanced_dates']['item'];
                            }
                            if(isset($recurrence['em_recurrence_selected_custom_dates']['item'])){
                                $event_data->em_recurrence_selected_custom_dates = $recurrence['em_recurrence_selected_custom_dates']['item'];
                            }
                        
                        }
                        // if event name empty then not insert
                        if(empty($event_data->name)){
                            continue;
                        }
                        // save event
                        $event_id = $ep_functions->insert_event_post_data((array)$event_data);
                        if($event_id){
                            $event_ids[$i] = sprintf(__('Imported %s Successfully with event id: %d', 'eventprime-import-export'), $event['title'], $event_id);
                        }else{
                            $event_ids[$i] = sprintf(__('Error id: %d', 'eventprime-import-export'), $event_id);
                        }
                        
                        $i++;
                    }
                    $eventsCount = count((array)$event_ids);
                    if($eventsCount){
                        $returnData['success'] = $event_ids;
                    }
                    else{
                        $returnData['errors'] = __('No event imported.','eventprime-events-import-export');
                    }
                }
                else{
                    $returnData['errors'] = __('No Event found in uploaded file', 'eventprime-events-import-export');
                }
            $response = array(
                'offset'=>$next_row,
                'total_row'=>$total_row,
                'terminate'=> $total_row <= $next_row ? true: false,
                'html'=> $this->import_data_response($returnData),
                'xml_array'=> $xml_array,
            );
            return $response;
    }
    
    public function em_ix_file_import_ics($attachment_id, $offset=0){
        $ep_functions = new Eventprime_Basic_Functions();
        $next_row = $offset + 5;
        if($offset == 0){
            $next_row = 5;
        
        }
        $total_row = 1;
        $format = $ep_functions->ep_get_datepicker_format();
        $feed_file = get_attached_file($attachment_id);
        $timezone = $ep_functions->ep_get_site_timezone();
        $parsed = $this->parse_ics($feed_file);
        $rows_string = $parsed->events();
        if(!empty($rows_string)){
            $ics_string = $rows_string;
            $total_row_all = count($ics_string);
            
            $total_row = $total_row_all;
            if($total_row <= $next_row){
                $next_row = $total_row;
            }
            
            $ics_string = array_slice($ics_string, $offset, $next_row);
            
            $i = $offset+1;
            foreach ($ics_string as $event_row) {
                $event = (array)$event_row;
                $event_venue_id = $performer = $org_id = $event_type_id = '';

                // return $event_row; die;
                
                // save event
                $event_data = new stdClass();
                $event_data->name = htmlspecialchars_decode(sanitize_text_field(strip_tags($event['summary'])));
                $event_data->description = sanitize_text_field($event['description']);
                $date_start = new DateTime($event['dtstart']);
                $date_start->setTimezone(new DateTimeZone($timezone));
                $start_date = $date_start->format('U');
                $date_end = new DateTime($event['dtend']);
                $date_end->setTimezone(new DateTimeZone($timezone));
                $end_date = $date_end->format('U');
                $allday = isset($event['all_day']) && !empty($event['all_day']) ? (int) $event['all_day'] : 0;
                if(!empty($start_date)){
                    $start_date = date($format, $date_start->format('U'));
                    
                }
                $start_time = '';
                if(!empty($start_date)){
                    $start_time = date("h:i a", $date_start->format('U'));
                }
                
                if(!empty($end_date)){
                    $end_date = date($format, $date_end->format('U'));
                    
                }
                $end_time = '';
                if(!empty($end_date)){
                    $end_time = date('h:i a', $date_end->format('U'));
                }
                
                if(!empty($allday) || !trim($start_date) && !trim($end_date)){
                    $allDayDate = $start_date;
                    $allday = 1;
                    $start_time = "12:00 AM";
                    $end_time = "12:00 AM";
                    $start_date = $allDayDate;
                    $allEndDate = date($format, strtotime($allDayDate. ' + 1 days'));
                    $end_date = $allEndDate;
                }
                $event_data->em_start_date = !empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date, $format) : '';
                $event_data->em_end_date = !empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date ,$format): '';
                $event_data->em_start_time = !empty($start_time) ? $start_time : '';
                $event_data->em_end_time = !empty($end_time) ? $end_time : '';
                
                $location_term='';
                $location_name = isset($event['venue_name']) && !empty($event['venue_name']) ? $event['venue_name'] : "";
                if(!empty(trim($location_name))){
                    $location_nm = explode(',',$location_name);
                    $location_term = get_term_by('name', $location_nm[0], 'em_venue');
                }
                if(empty($location_term) && !empty($location_name)){
                    //$venues_controller
                    $venue_data = new stdClass();
                    $location_nm = explode(',',$location_name);
                    $venue_data->name = sanitize_text_field($location_nm[0]);
                    $location_type = isset($event['venue_type']) && !empty($event['venue_type']) ? $event['venue_type'] : "";
                    if ( $location_type == 'seats' ) {
                        $venue_data->em_type = 'seats';
                    } else {
                        $venue_data->em_type = 'standings';
                    }
                    
                    $venue_data->em_address = isset($event['venue_location']) && !empty($event['venue_location']) ? $event['venue_location'] : "";
                    // if(empty($address)){
                    //     $venue_data->em_address = sanitize_text_field($location_name);
                    // }
                    $venue_data->em_seating_capacity = isset($event['seating_capacity']) ? $event['seating_capacity'] : "";
                    $venue_data->em_lng = isset($event['venue_location_lng']) ? $event['venue_location_lng'] : "";
                    $venue_data->em_lat = isset($event['venue_location_lat']) ? $event['venue_location_lat'] : "";
                    $venue_data->em_operator = isset($event['operator']) ? $event['operator'] : "";
                        
                    $event_venue_id = $ep_functions->create_venue((array)$venue_data);
                    if(!empty($event_venue_id)){
                        $event_data->em_venue = $event_venue_id;
                    }
                }
                else{
                    $event_venue_id = ( isset($location_term->term_id) && !empty($location_term->term_id) ) ? $location_term->term_id : '';
                    $event_data->em_venue = $event_venue_id;
                }
                // Performers 
                $performers = isset($event['performers']) && !empty($event['performers']) ? $event['performers'] : "";
                if(!empty($performers)){
                    $performers = explode(' | ', $performers);
                    $performer_ids = array();
                    foreach ($performers as $imp_per) {
                            $posts = get_posts([
                                'post_type'  => 'em_performer',
                                'title' => $imp_per,
                            ]);
                            
                            if(!empty($posts) && count($posts) > 0){
                                $performer_ids[] = $posts[0]->ID;
                            }else{
                                $performer_data = new stdClass();
                                $performer_data->name = $imp_per;
                                $performer_data->em_type = 'person';
                                $performer = $ep_functions->insert_performer_post_data((array)$performer_data);
                                $performer_ids[] = $performer;
                                break;
                            }
                        
                    }
                    $event_data->em_performer = $performer_ids;
                    if(!empty($event_data->em_performer)){
                        $event_data->em_enable_performer = 1;
                    }
                }
                
                /* event organizer */
                $organizer = isset($event['organizers']) && !empty($event['organizers']) ? $event['organizers'] : "";
                $imp_organizer_phones = isset($event['organizers_phones']) && !empty($event['organizers_phones']) ? $event['organizers_phones'] : "";
                $imp_organizer_emails = isset($event['organizers_emails']) && !empty($event['organizers_emails']) ? $event['organizers_emails'] : "";
                $imp_organizer_websites = isset($event['organizers_websites']) && !empty($event['organizers_websites']) ? $event['organizers_websites'] : "";
                if(!empty($organizer)){
                    $event_organizers = array_filter(explode(" | ", $organizer));
                    if(!empty($imp_organizer_phones)){ 
                        $organizer_phones = explode(" | ", $imp_organizer_phones); 
                        
                    }
                    if(!empty($imp_organizer_emails)){ 
                        $organizer_emails = explode(" | ", $imp_organizer_emails);
                    }
                    if(!empty($imp_organizer_websites)){ 
                        $organizer_websites = explode(" | ", $imp_organizer_websites);
                    }
                    $organizer_ids = array();
                    foreach($event_organizers as $key => $organizer_name){
                        $organizer = get_term_by('name',$organizer_name,'em_event_organizer');
                        if(!empty($organizer)){
                            $organizer_ids[] = $organizer->term_id;
                            
                        }else{
                            $org_data = new stdClass();
                            $org_data->name = $organizer_name;
                            if(!empty($organizer_phones) && isset($organizer_phones[$key]) && !empty($organizer_phones[$key])){
                                $org_data->em_organizer_phones = explode(', ', $organizer_phones[$key]);
                            }
                            if(!empty($organizer_emails) && isset($organizer_emails[$key]) && !empty($organizer_emails[$key])){
                                $org_data->em_organizer_emails = explode(', ', $organizer_emails[$key]);
                            }
                            if(!empty($organizer_websites) && isset($organizer_websites[$key]) && !empty($organizer_websites[$key])){
                                $org_data->em_organizer_websites = explode(', ', $organizer_websites[$key]);
                            }
                            $org_data->em_social_links = array(
                                'facebook'=>'',
                                'linkedin'=>'',
                                'instagram'=>'',
                                'twitter'=>''
                            );
                            $org_id = $ep_functions->create_organizer((array)$org_data);
                        
                            if($org_id){
                                $organizer_ids[] = $org_id;
                            }
                        }
                    }
                    $event_data->em_organizer = $organizer_ids;
                }
                // event type
                $type_term = '';
                $event_type = isset($event['event_type']) && !empty($event['event_type']) ? $event['event_type'] : "";
                if(!empty(trim($event_type))){
                    $eventType = $event_type;
                    $type_term = get_term_by('name', $eventType, 'em_event_type');
                }
                if(empty($type_term) && !empty(trim($event_type))){
                    $type_data = new stdClass();
                    $type_data->name = sanitize_text_field($event_type);
                    $event_type_id = $ep_functions->create_event_types((array)$type_data);
                    if(!empty($event_type_id)){
                        $event_data->em_event_type = $event_type_id;
                    }
                }
                else{
                    $event_type_id = isset( $type_term->term_id ) ? $type_term->term_id : '';
                    $event_data->em_event_type = $event_type_id;
                }
                
                // custom meta
                $custom_meta = array(
                    'ix_source' => 'ep-ics-files',
                    'ix_feed_id' => isset($event['id']) ? $event['id'] : '',
                );
                $event_data->em_custom_meta = $custom_meta;
                $recurrence = isset($event['rrule']) ? $event['rrule'] : array();
                if(!empty($recurrence)){
                    $days = array('SU'=>0,'MO'=>1,'TU'=>2,'WE'=>3,'TH'=>4,'FR'=>5,'SA'=>6);
                    $days_adv = array('SU'=>'sun','MO'=>'mon','TU'=>'tue','WE'=>'wed','TH'=>'thu','FR'=>'fri','SA'=>'sat');
                    $months = array('JAN'=>1, 'FEB'=>2, 'MAR'=>3, 'APR'=>4, 'MAY'=>5, 'JUN'=>6, 'JUL'=>7, 'AUG'=>8, 'SEPT'=>9, 'OCT'=>10, 'NOV'=>11, "DEC"=>12 );
                    $event_data->em_enable_recurrence = 1;
                    $rules = explode(';',$recurrence);
                    $er = array();
                    if(count($rules)){
                        foreach($rules as $rule){
                            $rule = explode('=',$rule); 
                            $er[$rule[0]]= $rule[1];
                        }
                    }
                    if(isset($er['FREQ'])){
                        $event_data->em_recurrence_interval = strtolower($er['FREQ']);
                        $event_data->em_recurrence_step = isset($er['INTERVAL']) ? $er['INTERVAL'] : 1;
                    
                    }
                    if(isset($er['COUNT'])){
                        $event_data->em_recurrence_ends = 'after';
                        $event_data->em_recurrence_occurrence_time = $er['COUNT']; 
                    }
                    if(isset($er['UNTIL'])){
                        $event_data->em_recurrence_ends = 'on';
                        $finish_date = new DateTime($er['UNTIL']);
                        $finish_date->setTimezone(new DateTimeZone($timezone));
                        $event_data->em_recurrence_limit= date($format,$finish_date->format('U'));
                    }
                    
                    if(isset($er['FREQ']) && strtolower($er['FREQ']) =='weekly'){
                        $week_days = array();
                        if(isset($er['BYDAY'])){
                            $byday = explode(',',$er['BYDAY']);
                            if(!empty($byday)){
                                foreach($byday as $day){
                                    if(isset($days[$day])){
                                        $week_days[] = $days[$day]; 
                                    } 
                                }
                            }
                        }
                        $event_data->em_selected_weekly_day = $week_days;
                    }
                    
                    if(isset($er['FREQ']) && strtolower($er['FREQ']) =='monthly' && !isset($er['RFRQ'])){
                        $event_data->em_recurrence_monthly_day = 'date';
                        if(isset($er['BYDAY'])){
                            $byday = preg_split('/(?<=[0-9])(?=[a-z]+)/i',$er['BYDAY']);
                            $event_data->em_recurrence_monthly_weekno = $byday[0];
                            $event_data->em_recurrence_monthly_fullweekday = isset($days[$byday[1]]) && !empty($days[$byday[1]]) ? $days[$byday[1]] : 0;
                            $event_data->em_recurrence_monthly_day = 'day';
                        } 
                    }
                    if(isset($er['FREQ']) && strtolower($er['FREQ']) =='yearly'){
                        $event_data->em_recurrence_yearly_day = 'date';
                        if(isset($er['BYDAY'])){
                            $byday = preg_split('/(?<=[0-9])(?=[a-z]+)/i',$er['BYDAY']);
                            $event_data->em_recurrence_yearly_weekno = $byday[0];
                            $event_data->em_recurrence_yearly_fullweekday = isset($days[$byday[1]]) && !empty($days[$byday[1]]) ? $days[$byday[1]] : 0;
                            $event_data->em_recurrence_yearly_monthday = isset($months[$byday[2]]) && !empty($months[$byday[2]]) ? $months[$byday[2]] : date("m", $date_start->format('U'));
                            $event_data->em_recurrence_yearly_day = 'day';
                        }
                        
                    }
                    if(isset($er['FREQ']) && strtolower($er['FREQ']) =='monthly' && isset($er['RFRQ'])){
                        if(isset($er['BYDAY'])){
                            $event_data->em_recurrence_interval = 'advanced';
                        
                            $bydays = explode(',',$er['BYDAY']);
                            $advday = array();
                            if(!empty($bydays)){
                                foreach($bydays as $byday){
                                    $byday = preg_split('/(?<=[0-9])(?=[a-z]+)/i',$byday);
                                    if($byday[0]==-1){
                                        $byday[0] = 5;
                                    }
                                    $advday[] = $days_adv[$byday[1]].'-'.$byday[0];
                                }
                            }
                            $event_data->em_recurrence_advanced_dates = $advday;
                        }
                        
                    }
                
                }
                // if event name empty then not insert
                if(empty($event_data->name)){
                    continue;
                }
                // save event
                $event_id = $ep_functions->insert_event_post_data((array)$event_data);
                if($event_id){
                    $event_ids[$i] = sprintf(__('Imported Successfully with event id: %d', 'eventprime-import-export'), $event_id);
                }else{
                    $event_ids[$i] = sprintf(__('Error id: %d', 'eventprime-import-export'), $event_id);
                }
                
                $i++;
            }
            $eventsCount = count((array)$event_ids);
            if($eventsCount){
                $returnData['success'] = $event_ids;
            }
            else{
                $returnData['errors'] = __('No event imported.','eventprime-events-import-export');
            }
        }
        else{
            $returnData['errors'] = __('No Event found in uploaded file', 'eventprime-events-import-export');
        }
        $response = array(
            'offset'=>$next_row,
            'total_row'=>$total_row,
            'terminate'=> $total_row <= $next_row ? true: false,
            'html'=> $this->import_data_response($returnData),
        );
        return $response;
    }
    public function import_data_response($response){
        $html = '';
        if(isset($response['success']) && !empty($response['success'])){
            foreach($response['success'] as $row_id => $msg){
                $html .= "<li>".__('Row:-', 'eventprime-events-import-export')." " .$row_id." " .$msg."</li>";
            }
        }elseif($response['errors']){
            $html .= "<li>".$response['errors']."</li>";
        }
        
        return $html;
    }
    public function em_ix_file_import() {
        $ep_functions = new Eventprime_Basic_Functions(); 
        $attachment_id = sanitize_text_field($_POST['attachment_id']);
        $event_target = sanitize_text_field($_POST['event_target']);
        
        $feed_file = get_attached_file($attachment_id);
        $timezone = $ep_functions->ep_get_site_timezone();
        //$event_service = EventM_Factory_Service::get_service('EventM_Service');
        if(!empty($feed_file)){
            $exp = explode('.', $feed_file);
            $extension = end($exp);
            if(strtolower($extension) == 'csv'){
                $offset = isset($_POST['offset']) && $_POST['offset'] != 0 ? sanitize_text_field($_POST['offset']) : 1;
                return $this->em_ix_file_import_csv($attachment_id, $offset);
                            
            }
            if(strtolower($extension) == 'json'){
                $offset = isset($_POST['offset']) ? sanitize_text_field($_POST['offset']) : 0;
                return $this->em_ix_file_import_json($attachment_id, $offset);
                            
            }
            if(strtolower($extension) == 'xml'){
                $offset = isset($_POST['offset']) ? sanitize_text_field($_POST['offset']) : 0;
                return $this->em_ix_file_import_xml($attachment_id, $offset);
                            
            }
            if(strtolower($extension) == 'ics'){
                $offset = isset($_POST['offset']) ? sanitize_text_field($_POST['offset']) : 0;
                return $this->em_ix_file_import_ics($attachment_id, $offset);
                            
            }
        }
    }

    private function read_file($filename){
        $fh = fopen($filename, 'rb');
        if(false === $fh) return false;
        clearstatcache();
        if($fsize = @filesize($filename)){
            $data = fread($fh, $fsize);
            fclose($fh);
            return $data;
        }
        else{
            fclose($fh);
            return false;
        }
    }

    private function parse_ics($feed){
        try {
            return new ICal($feed, array(
                'defaultSpan'                 => 2,     // Default value
                'defaultTimeZone'             => 'UTC',
                'defaultWeekStart'            => 'MO',  // Default value
                'disableCharacterReplacement' => false, // Default value
                'skipRecurrence'              => true, // Default value
                //'useTimeZoneWithRRules'       => false, // Default value
            ));
        }
        catch(\Exception $e)
        {
            return false;
        }
    }
    
    
}

//return new EIX_Import_Service();