<?php

class EIX_Google_Import_Service{
    public function check_google_import_apis(){
        $ep_functions = new Eventprime_Basic_Functions(); 

        $returnData = array();
        $format = $ep_functions->ep_get_datepicker_format();
        $ix_gcal_import_api_key = $_POST['ix_gcal_import_api_key'];
        $ix_gcal_import_cal_id = $_POST['ix_gcal_import_cal_id'];
        $ix_gcal_import_start_date = $_POST['ix_gcal_import_start_date'];
        $ix_gcal_import_end_date  = $_POST['ix_gcal_import_end_date'];
        if(empty($ix_gcal_import_start_date)){
            $ix_gcal_import_start_date = 'Today';
        }
        if(empty($ix_gcal_import_end_date)){
            $ix_gcal_import_end_date = 'Tomorrow';
        }
        if(!empty($ix_gcal_import_api_key) && !empty($ix_gcal_import_cal_id)){
            // first save in global options
            $options = get_option('em_global_settings');

            $api_key = $options->ix_gcal_import_api_key;
            $cal_id = $options->ix_gcal_import_cal_id;
            // api call
            $gcal_client = new Google\Client();
            $gcal_client->setApplicationName('EventPrime Events Calendar');
            $gcal_client->setAccessType('online');
            $gcal_client->setScopes(array('https://www.googleapis.com/auth/calendar.readonly'));
            $gcal_client->setDeveloperKey($api_key);
            $service = new Google\Service\Calendar($gcal_client);
            $events_data = array();
            try
            {
                $data = array();
                $site_timezone = $ep_functions->ep_get_site_timezone();
                $gtm_offset = $ep_functions->get_gmt_offset($site_timezone);
                $data['timeMin'] = date('Y-m-d\TH:i:s', strtotime($ix_gcal_import_start_date)).$gtm_offset;
                $data['timeMax'] = date('Y-m-d\T23:59:59', strtotime($ix_gcal_import_end_date)).$gtm_offset;
                $data['maxResults'] = 50000;
                $response = $service->events->listEvents($cal_id, $data);

                $events_data['id'] = $cal_id;
                $events_data['title'] = $response->getSummary();
                $events_data['timezone'] = $response->getTimeZone();
                $events_data['events'] = array();
                foreach($response->getItems() as $event){
                    
                    $title = $event->getSummary();
                    if(trim($title) == '') continue;

                    // Import Only Main Events
                    if($event->getRecurringEventId()) continue;

                    // start date and end date setu according to timezone
                    $event_start_date = $event->getStart();
                    $date_start = new DateTime($event_start_date->date ? trim($event_start_date->date) : $event_start_date->dateTime);
                    if($site_timezone != $events_data['timezone']){
                        $date_start->setTimezone(new DateTimeZone($site_timezone));
                    }
                    $event_end_date = $event->getEnd();
                    $date_end = new DateTime($event_end_date->date ? trim($event_end_date->date) : $event_end_date->dateTime);
                    if($site_timezone != $events_data['timezone']){
                        $date_end->setTimezone(new DateTimeZone($site_timezone));
                    }
                    
                    $events_data['events'][] = array('id' => $event->id, 'title' => $title, 'start' => $date_start->format($format.' H:i:s'), 'end' => $date_end->format($format.' H:i:s'));
                }
                $events_data['count'] = count($events_data['events']);
            }
            catch(Exception $e)
            {
                $returnData['errors'] = $e->getMessage();
            }
            
            $returnData['success'] = $events_data;
        }
        else{
            $returnData['errors'] = __('All of Google API Key and Calendar ID are required!','eventprime-events-import-export');
        }
        return $this->formate_html_response($returnData);
    }
    
    public function formate_html_response($response){
        if(isset($response['success']) && count($response['success']) > 0){
            if(isset($response['success']['count']) && $response['success']['count']){
                ?>
                <div class="ep-import-list-events-container">
                    <div class="ep-event-list-success ep-eix-success epnotice">
                        <?php echo sprintf(__('Total %s Events  Found. Please select your desired event(s) to import.','eventprime-events-import-export'), $response['success']['count']);?>
                    </div>
                    <?php /*?>
                    <div class="emrow ep-subhead-wrap">
                        <div class="ep-subhead-title"><?php echo esc_html__('Event List', 'eventprime-events-import-export');?></div>
                        <div class="ep-import-select-deselect">
                            <button type="button" id="ep-google-ie-select-all" class="btn btn-primary" onClick="import_event_list_action('select-all')"><?php echo esc_html__('Select All', 'eventprime-events-import-export');?></button>
                            <button type="button" id="ep-google-ie-deselect-all" class="btn btn-primary" onClick="import_event_list_action('deselect-all')" disabled><?php echo esc_html__('Deselect All', 'eventprime-events-import-export');?></button>
                        </div>
                    </div>
                    <?php */?>

                    <table class="wp-list-table widefat fixed striped table-view-excerpt posts ep-my-3">
                        <thead>
                            <tr>
                                <td id="cb" class="manage-column column-cb check-column">
                                    <input type="checkbox" id="ep-select-all-events">
                                    <label for="ep-select-all-events"><span class="screen-reader-text">Select All</span></label>
                                </td>
                                <th><?php esc_html_e('Event Name', 'eventprime-import-export'); ?></th>
                                <th><?php esc_html_e('Start Date', 'eventprime-import-export'); ?></th>
                                <th><?php esc_html_e('End Date', 'eventprime-import-export'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="ep-google-ie-list-events">
                            <?php /* ?>
                            <ul class="ep-import-list-events">
                                <?php foreach($response['success']['events'] as $event):?>
                                <li class="em_import_event_listing">
                                    <input type="checkbox" name="gcal_import_list[]" value="<?php echo esc_attr($event['id']);?>">
                                    <span>
                                        <?php echo _e('Event Title: ', 'eventprime-events-import-export').'&nbsp &nbsp'.$event['title'];?> <?php echo _e(' Event Date: ', 'eventprime-events-import-export').' '.$event['start']. ' - '.$event['end'];?>
                                    </span>
                                </li>
                                <?php endforeach;?>
                            </ul>
                            <?php */ ?>
                            <?php foreach($response['success']['events'] as $event): ?>
                                <tr>
                                    <td><input class="ep-google-event-checkbox" type="checkbox" name="gcal_import_list[]" value="<?php echo esc_attr($event['id']);?>"></td>
                                    <td><?php echo esc_html($event['title']); ?></td>
                                    <td><?php echo esc_html($event['start']); ?></td>
                                    <td><?php echo esc_html($event['end']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    
                    <div class="eprow"> 
                        <button type="button" class="btn btn-primary ep-import-google-events-button ep-import-btn ep-cursor" onClick="import_gcal_events()"><?php echo _e('Import','eventprime-events-import-export'); ?></button>
                    </div>
                    <div class="eprow ep-eix-btn-response">
                        
                    </div>
                </div>
                <?php
            }
        }
        else{
            ?>
            <div class="ep-import-error">
                <?php if(isset($response['errors'])):
                    echo esc_html($response['errors']);
                endif;
                ?>
            </div>
            <?php
        }
    }
    
    public function import_google_selected_events_apis(){
        $global_settings = new Eventprime_Global_Settings();
        $global_options = $global_settings->ep_get_settings();

        $ep_functions = new Eventprime_Basic_Functions();

        $form_data = $_POST;
        $returnData = array();
        $format = $ep_functions->ep_get_datepicker_format();
        $selected_event_idx = isset($form_data['gcal_import_list']) && !empty($form_data['gcal_import_list']) ? $form_data['gcal_import_list'] : '';
        $api_key = $global_options->ix_gcal_import_api_key;
        $cal_id = $global_options->ix_gcal_import_cal_id;
        if(empty($api_key) || empty($cal_id)){
            $returnData['errors'] = __('API key and Calendar ID are required!','eventprime-events-import-export');
            return $this->imported_msg($returnData);
        }
        if(empty($selected_event_idx)){
            $returnData['errors'] = __('No Event Selected.','import-export');
            return $this->imported_msg($returnData);
        }
        // Timezone
        $site_timezone = $ep_functions->ep_get_site_timezone();
        // Google Client
        $gcal_client = new Google\Client();
        $gcal_client->setApplicationName('EventPrime Events Calendar');
        $gcal_client->setAccessType('online');
        $gcal_client->setScopes(array('https://www.googleapis.com/auth/calendar.readonly'));
        $gcal_client->setDeveloperKey($api_key);
        $service = new Google\Service\Calendar($gcal_client);
        $event_ids = array();
        // import starts

        $ep_functions = new Eventprime_Basic_Functions(); 
        
        foreach ($selected_event_idx as $event_id) {
            
            try{
                $event = $service->events->get($cal_id, $event_id, array('timeZone' => $site_timezone));
            }
            catch(Exception $e){
                continue;
            }
            // event data
            $title = $event->getSummary();
            $description = $event->getDescription();
            $gcal_ical_uid = $event->getICalUID();
            $gcal_id = $event->getId();
            $location = !empty($event->getLocation()) ? trim($event->getLocation()) : '';
            // Event Start Date and Time            
            $start = $event->getStart();
            $start_date = $start->getDate();
            $start_datetime = !empty($start->getDateTime()) ? trim($start->getDateTime()) : '';
            $date_start = new DateTime($start_datetime ? $start_datetime : $start_date);
            $start_date = $date_start->format($format);
            $start_hour = 6;
            $start_minutes = '00';
            $start_ampm = 'AM';
            if($start_datetime){
                $start_hour = $date_start->format('g');
                $start_minutes = $date_start->format('i');
                $start_ampm = $date_start->format('a');
            }

            $end = $event->getEnd();
            $end_date = $end->getDate();
            $end_datetime = !empty($end->getDateTime()) ? trim($end->getDateTime()) : '';
            $date_end = new DateTime($end_datetime ? $end_datetime : $end_date);
            $end_date = $date_end->format($format);
            $end_hour = 11;
            $end_minutes = '59';
            $end_ampm = 'PM';
            if($end_datetime){
                $end_hour = $date_end->format('g');
                $end_minutes = $date_end->format('i');
                $end_ampm = $date_end->format('A');
            }
            $allday = 0;
            // if start and end time empty then it will be all day
            if( !$start_datetime && !$end_datetime ){
                $allday = 1;
                $start_hour = '12';
                $start_minutes = '00';
                $end_hour = 11;
                $end_minutes = 59;
            }
            // save event
            //$event_data = $event_service->load_model_from_db(0);
            $event_data = new stdClass();
            $event_data->em_name = $event_data->name = htmlspecialchars_decode(sanitize_text_field(strip_tags($title)));
            $event_data->description = sanitize_text_field($description);
            $event_start_time = $start_hour.':'.$start_minutes.' '.$start_ampm;
            $event_end_time = $end_hour.':'.$end_minutes.' '.$end_ampm;
            
            $event_data->em_start_date = !empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date) : '';
            $event_data->em_end_date = !empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date) : '';
            $event_data->em_start_time = $event_start_time;
            $event_data->em_end_time = $event_end_time;
            $event_data->em_all_day = $allday;
            // location
            if(!empty($location)){
                $location_exp = explode(",", $location);
                $location_name = $location_exp[0];
                $location_term = get_term_by('name', $location_name, 'em_venue');
                if(is_object($location_term) and isset($location_term->term_id)) {
                    $event_venue_id = $location_term->term_id;
                }
                else{
                    $venue_args = array(
                        'name'=>$location_name,
                        'em_address'=>$location,
                        'em_type'=>'standings',
                        'em_seating_capacity'=>0,
                    );
                    $event_venue_id = $ep_functions->create_venue($venue_args);
                    
                }
                if(!empty($event_venue_id)){
                    $event_data->em_venue = $event_venue_id;
                }
            }
            $recurrence = $event->getRecurrence();
            if(!empty($recurrence)){
                $days = array('SU'=>0,'MO'=>1,'TU'=>2,'WE'=>3,'TH'=>4,'FR'=>5,'SA'=>6);
                $days_adv = array('SU'=>'sun','MO'=>'mon','TU'=>'tue','WE'=>'wed','TH'=>'thu','FR'=>'fri','SA'=>'sat');
                $months = array('JAN'=>1, 'FEB'=>2, 'MAR'=>3, 'APR'=>4, 'MAY'=>5, 'JUN'=>6, 'JUL'=>7, 'AUG'=>8, 'SEPT'=>9, 'OCT'=>10, 'NOV'=>11, "DEC"=>12 );
                            
                $er= array();
                $rules = array();
                $rule = explode(':',$recurrence[0]);
                
                if(isset($rule[1])){
                    $rules = explode(';',$rule[1]);
                    if(!empty($rules)){
                        foreach($rules as $rule){
                            $split_rul = explode('=',$rule);
                            $er[$split_rul[0]] = $split_rul[1];
                        }
                    }
                }
                $event_data->em_enable_recurrence = 1;
                            
                if(isset($er['FREQ'])){
                                $event_data->em_recurrence_interval = strtolower($er['FREQ']);
                                $event_data->em_recurrence_step = isset($er['INTERVAL']) ? $er['INTERVAL'] : 1;
                            
                            }
                            if(isset($er['COUNT'])){
                                $event_data->em_recurrence_ends = 'after';
                                $event_data->em_recurrence_occurrence_time = $er['COUNT']; 
                            }
                            if(isset($er['UNTIL'])){
                                $event_data->em_recurrence_ends = 'on';
                                $finish_date = new DateTime($er['UNTIL']);
                                $finish_date->setTimezone(new DateTimeZone($site_timezone));
                                $event_data->em_recurrence_limit= date($format,$finish_date->format('U'));
                            }
                            
                            if(isset($er['FREQ']) && strtolower($er['FREQ']) =='weekly'){
                                $week_days = array();
                                if(isset($er['BYDAY'])){
                                    $byday = explode(',',$er['BYDAY']);
                                    if(!empty($byday)){
                                        foreach($byday as $day){
                                           if(isset($days[$day])){
                                               $week_days[] = $days[$day]; 
                                           } 
                                        }
                                    }
                                }
                                $event_data->em_selected_weekly_day = $week_days;
                            }
                            
                            if(isset($er['FREQ']) && strtolower($er['FREQ']) =='monthly' && !isset($er['RFRQ'])){
                                $event_data->em_recurrence_monthly_day = 'date';
                                if(isset($er['BYDAY'])){
                                    $byday = preg_split('/(?<=[0-9])(?=[a-z]+)/i',$er['BYDAY']);
                                    $event_data->em_recurrence_monthly_weekno = $byday[0] == -1 ? 5 : $byday[0];
                                    $event_data->em_recurrence_monthly_fullweekday = isset($days[$byday[1]]) && !empty($days[$byday[1]]) ? $days[$byday[1]] : 0;
                                    $event_data->em_recurrence_monthly_day = 'day';
                                } 
                            }
                            if(isset($er['FREQ']) && strtolower($er['FREQ']) =='yearly'){
                                $event_data->em_recurrence_yearly_day = 'date';
                                if(isset($er['BYDAY'])){
                                    $byday = preg_split('/(?<=[0-9])(?=[a-z]+)/i',$er['BYDAY']);
                                    $event_data->em_recurrence_yearly_weekno = $byday[0];
                                    $event_data->em_recurrence_yearly_fullweekday = isset($days[$byday[1]]) && !empty($days[$byday[1]]) ? $days[$byday[1]] : 0;
                                    $event_data->em_recurrence_yearly_monthday = isset($months[$byday[2]]) && !empty($months[$byday[2]]) ? $months[$byday[2]] : date("m", $date_start->format('U'));
                                    $event_data->em_recurrence_yearly_day = 'day';
                                }
                               
                            }
                            
            }
            $custom_meta = array(
                'ix_source' => 'google-calendar',
                'ix_gcal_ical_uid' => $gcal_ical_uid,
                'ix_gcal_id' => $gcal_id,
                'ix_gcal_calendar_id' => $cal_id,
            );

            $event_data->em_custom_meta = $custom_meta;

            // first check
            $defaults = array(
                'post_status' => 'any',
                'post_type' => 'em_event',
                'numberposts' => -1,
                'meta_query' => array(
                    array(
                        'key'     => 'em_custom_meta',
                        'value'   => serialize($custom_meta),
                        'compare' => 'LIKE'
                    )
                )
            );
            $posts = get_posts($defaults);            
            if(!empty($posts) && count($posts) > 0){
                // $idx++;
                continue;
            }
            $events_id = $ep_functions->insert_event_post_data((array)$event_data);
            
            $event_ids[] = $events_id;
            // $idx++;
        }
        $eventsCount = count($event_ids);
        if($eventsCount == 0){
            $returnData['errors'] = __('No Event Imported. All Events Already Exist!','eventprime-events-import-export');
        }
        else{
            $returnData['success'] = count($event_ids).__(' Event(s) Imported Successfully!','eventprime-events-import-export');
        }
        return $this->imported_msg($returnData);
    }
    
    public function imported_msg($response){
        if(isset($response['success'])){
            ?>
            <div class="ep-eix-success">
                <?php echo $response['success'];?>
            </div>
            <?php 
        }else{?>
            <div class="ep-eix-error">
                <?php echo $response['errors'];?>
            </div>
        <?php }
    }
}