<?php

class EIX_Google_Export_Service{
    public $global_options = '';
    
    public function __construct() {
        $this->set_global_options();
        
    }
    
    public function set_global_options(){
        $global_settings = new Eventprime_Global_Settings();
        $this->global_options = $global_settings->ep_get_settings();
    }
    public function save_global_options($global_settings_data){
        $global_settings = new Eventprime_Global_Settings();
        
        $global_settings->ep_save_settings( $global_settings_data );
    }
    public function check_gcal_export_auth() {
        $returnData = array();
        $ix_gcal_export_client_id = $this->global_options->ix_gcal_export_client_id;
        $ix_gcal_export_client_secret = $this->global_options->ix_gcal_export_client_secret;
        $ix_gcal_export_calendar_id = $this->global_options->ix_gcal_export_calendar_id;
        
        if(!empty($ix_gcal_export_client_id) && !empty($ix_gcal_export_client_secret) && !empty($ix_gcal_export_calendar_id)){
            // first save in global options
            
            $redirect = admin_url().'edit.php?post_type=em_event&page=ep-export-setting&exporter=google&ep-ix-action=gcal-get-token';
            //$redirect = esc_url(add_query_arg(array('page'=>'ep-export-setting','exporter'=>'google','ep-ix-action' => 'gcal-get-token'), $url));
            
            try{
                
                $client = new Google\Client();
                $client->setApplicationName(get_bloginfo('name'));
                $client->setAccessType('offline');
                $client->setApprovalPrompt('force');
                $client->setScopes(array('https://www.googleapis.com/auth/calendar'));
                $client->setClientId($ix_gcal_export_client_id);
                $client->setClientSecret($ix_gcal_export_client_secret);
                $client->setRedirectUri($redirect);
                $auth_url = filter_var(filter_var($client->createAuthUrl(), FILTER_SANITIZE_URL));
            }
            catch(Exception $e){
                $returnData = array('success'=>0,'msg'=>$e->getMessage());
            }
            
            $returnData = array('success'=>1, 'msg'=> sprintf(__('All set! Please click %s to authenticate your app.', 'eventprime-import-export'), '<a href="'.$auth_url.'">'.__('here', 'eventprime-event-google-import-export').'</a>'));
        }
        else{
            $returnData = array('success'=>1,'msg'=>__('All of Client ID, Client Secret, and Calendar ID are required!','eventprime-import-export'));
        }
        return $this->gcal_auth_response($returnData);
        
    }
    
    public function gcal_auth_response($response){
        if(isset($response['success']) && !empty($response['success'])){
            ?>
            <div class="ep-eix-success">
                <?php echo $response['msg'];?>
            </div>
            <?php
        }
        else{
            ?>
            <div class="ep-eix-error">
                <?php if(isset($response['msg'])):
                    echo esc_html($response['msg']);
                endif;
                ?>
            </div>
            <?php
        }
    }
    public function gcal_export_get_token() {
        $ep_functions = new Eventprime_Basic_Functions();
        $ep_eix_cntrl = new EventM_EIX_Controller_Settings();
        $format = $ep_functions->ep_get_datepicker_format();
        $returnData = array();
        $client_id = $this->global_options->ix_gcal_export_client_id;
        $client_secret = $this->global_options->ix_gcal_export_client_secret;
        $code = sanitize_text_field($_POST['ix_auth_code']);
        try
        {
            $redirect = admin_url().'edit.php?post_type=em_event&page=ep-export-setting&exporter=google&ep-ix-action=gcal-get-token';
            $client = new Google\Client();
            $client->setApplicationName(get_bloginfo('name'));
            $client->setAccessType('offline');
            $client->setApprovalPrompt('force');
            $client->setScopes(array('https://www.googleapis.com/auth/calendar'));
            $client->setClientId($client_id);
            $client->setClientSecret($client_secret);
            $client->setRedirectUri($redirect);

            $authentication = $client->fetchAccessTokenWithAuthCode($code);
            $token = $client->getAccessToken();
            
            // $auth = json_decode($authentication, true);
            $refresh_token = $authentication['refresh_token'] ?? '';

            // save token in global options
            $this->global_options->ix_gcal_export_token = $token;
            $this->global_options->ix_gcal_export_refresh_token = $refresh_token;
            $this->save_global_options($this->global_options);
            $args = array(
                'orderby'=>'date',
                'order'=>'ASC',
                'post_parent'=>0,
            );
            $events = $ep_eix_cntrl->ep_get_published_events_data($args);
            
        }
        catch(Exception $ex)
        {
            $returnData['errors'] = $ex->getMessage();
        }
        if(!empty($events->posts) && count($events->posts) > 0){
            foreach ($events->posts as $event) {
                $start_date = $ep_functions->ep_datetime_to_timestamp(date($format,$event->em_start_date).' '.$event->em_start_time,$format.' h:i a');
                $end_date = $ep_functions->ep_datetime_to_timestamp(date($format,$event->em_end_date).' '.$event->em_end_time,$format.' h:i a');
            
                $events_data[] = array('id' => $event->id, 'title' => $event->name, 'start' => $start_date, 'end' => $end_date);
                $returnData = array("success" => 1, "events" => $events_data);
            }
        } else {
            $returnData['errors'] = __('No events found! (Please ensure published events exist)', 'eventprime-import-export');
        }
        return $this->formate_events_list($returnData);
        
    }
    
    public function formate_events_list($response){
        $ep_functions = new Eventprime_Basic_Functions();

        $format = $ep_functions->ep_get_datepicker_format();
        if(isset($response['success'])){
            if(isset($response['events']) && count($response['events'])> 0){
                ?>
                <div class="ep-export-list-events-container">
                    <div class="ep-event-list-success ep-eix-success epnotice">
                        <?php echo sprintf(esc_html__('Total %s Events  Found. Please select your desired event(s) to export.','eventprime-import-export'), count($response['events']));?>
                    </div>
                    <?php /*?>
                    <div class="emrow ep-subhead-wrap">
                        <div class="ep-subhead-title"><?php echo esc_html__('Event List', 'eventprime-import-export');?></div>
                        <div class="ep-import-select-deselect">
                            <button type="button" class="btn btn-primary" onClick="import_event_list_action('select-all')"><?php echo esc_html__('Select All', 'eventprime-import-export');?></button>
                            <button type="button" class="btn btn-primary" onClick="import_event_list_action('deselect-all')"><?php echo esc_html__('Deselect All', 'eventprime-import-export');?></button>
                        </div>
                    </div>
                    <?php */?>

                    <table class="wp-list-table widefat fixed striped table-view-excerpt posts ep-my-3">
                        <thead>
                            <tr>
                                <td id="cb" class="manage-column column-cb check-column">
                                    <input type="checkbox" id="ep-select-all-events">
                                    <label for="ep-select-all-events"><span class="screen-reader-text">Select All</span></label>
                                </td>
                                <th><?php esc_html_e('Event Name', 'eventprime-import-export'); ?></th>
                                <th><?php esc_html_e('Start Date', 'eventprime-import-export'); ?></th>
                                <th><?php esc_html_e('End Date', 'eventprime-import-export'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="ep-google-ie-list-events">
                            <?php /* ?>
                            <ul class="ep-import-list-events">
                                <?php foreach($response['events'] as $event):?>
                                <li class="em_import_event_listing">
                                    <input type="checkbox" name="gcal_export_list[]" value="<?php echo esc_attr($event['id']);?>">
                                    <span>
                                        <?php echo _e('Event Title: ', 'eventprime-import-export').'&nbsp &nbsp'.$event['title'];?> <?php echo _e(' Event Date: ', 'eventprime-import-export').' '.date($format.' h:i a',$event['start']). ' - '.date($format.' h:i a',$event['end']);?>
                                    </span>
                                </li>
                                <?php endforeach;?>
                            </ul>
                            <?php */ ?>

                            <?php foreach($response['events'] as $event): ?>
                                <tr>
                                    <td><input class="ep-google-event-checkbox" type="checkbox" name="gcal_export_list[]" value="<?php echo esc_attr($event['id']);?>"></td>
                                    <td><?php echo esc_html($event['title']); ?></td>
                                    <td><?php echo esc_html( date($format.' h:i a',$event['start']) ); ?></td>
                                    <td><?php echo esc_html( date($format.' h:i a',$event['end']) ); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    
                    <div class="eprow"> 
                        <button type="button" class="btn btn-primary ep-export-google-events-button ep-export-btn ep-cursor" onClick="export_gcal_events()"><?php echo _e('Export','eventprime-import-export'); ?></button>
                        <span class="spinner"></span>
                    </div>
                    <div class="eprow ep-eix-btn-response">
                        
                    </div>
                </div>
                <?php
            } else {
                ?>
                <div class="ep-eix-error">
                    <?php if(isset($response['errors'])):
                        echo esc_html($response['errors']);
                    endif;
                    ?>
                </div>
                <?php
            }
        }
        else{
            ?>
            <div class="ep-eix-error">
                <?php if(isset($response['errors'])):
                    echo esc_html($response['errors']);
                endif;
                ?>
            </div>
            <?php
        }
    }
    public function export_google_events(){
        $ep_functions = new Eventprime_Basic_Functions();

        $returnData = array();
        $format = $ep_functions->ep_get_datepicker_format();
        $client_id = $this->global_options->ix_gcal_export_client_id;
        $client_secret = $this->global_options->ix_gcal_export_client_secret;
        $calendar_id = $this->global_options->ix_gcal_export_calendar_id;
        if(empty($client_id) || empty($client_secret) || empty($calendar_id)){
            $returnData['errors'] = __('Client Id, Client Secret, and Calendar ID are all required!', 'eventprime-event-google-import-export');
            return $this->gcal_exports_response($returnData);
        }
        $selected_event_ids = isset($_POST['gcal_export_list']) && !empty($_POST['gcal_export_list']) ? $_POST['gcal_export_list'] : '';
        if(empty($selected_event_ids)){
            $returnData['errors'] = __('Please select event(s) to export!','eventprime-event-google-import-export');
            return $this->gcal_exports_response($returnData);
        }
        
        $token = $this->global_options->ix_gcal_export_token;
        $refresh_token = $this->global_options->ix_gcal_export_refresh_token;
        if (!isset($token['refresh_token']) && $refresh_token) {
            $token['refresh_token'] = $refresh_token;
        }
        
        $redirect = admin_url().'edit.php?post_type=em_event&page=ep-export-setting&exporter=google&ep-ix-action=gcal-get-token';
            
        $client = new Google\Client();
        $client->setApplicationName(get_bloginfo('name'));
        $client->setAccessType('offline');
        $client->setScopes(array('https://www.googleapis.com/auth/calendar'));
        $client->setClientId($client_id);
        $client->setClientSecret($client_secret);
        $client->setRedirectUri($redirect);
        $client->setAccessToken($token);
        if ($client->isAccessTokenExpired()) {
	    $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
	}       
        $service = new Google\Service\Calendar($client);
        $g_events_not_inserted = $g_events_inserted = $g_events_updated = array();
        
        // Timezone
        $site_timezone = $ep_functions->ep_get_site_timezone();
        $gmt_offset = $ep_functions->get_gmt_offset($site_timezone);
        foreach ($selected_event_ids as $ev_id) {
            $event = $ep_functions->get_single_event($ev_id);
            $start_date_time = $ep_functions->ep_datetime_to_timestamp(date($format,$event->em_start_date).' '.$event->em_start_time);
            $end_date_time = $ep_functions->ep_datetime_to_timestamp(date($format,$event->em_end_date).' '.$event->em_end_time);
            
            $start = array(
                'dateTime' => gmdate('Y-m-d\TH:i:s', $start_date_time),
                'timeZone' => $site_timezone,
            );
            $end = array(
                'dateTime' => gmdate('Y-m-d\TH:i:s', $end_date_time),
                'timeZone' => $site_timezone,
            );
            $allday = isset($event->em_all_day) ? $event->em_all_day : 0;
            if($allday)
            {
                $start['dateTime'] = date('Y-m-d\T00:00:00', $event->em_start_date).$gmt_offset;
                $end['dateTime'] = date('Y-m-d\T00:00:00', strtotime('+1 Day', $event->em_start_date)).$gmt_offset;
            }
            $location = '';
            if(!empty($event->em_venue)){
                $location = $ep_functions->get_single_venue($event->em_venue);
            }
            // Event Data
            $event_data = array(
                'summary' => $event->name,
                'location' => (isset($location->em_address) ? $location->em_address : (isset($location->name) ? $location->name : '')),
                'description' => strip_tags($event->description),
                'start' => $start,
                'end' => $end
            );
            if(isset($event->em_enable_recurrence) && !empty($event->em_enable_recurrence)){
                $event_data['recurrence'] = $this->check_recurrence_events($event);
                //$event_data['recurrence'] = array("RRULE:FREQ=WEEKLY;WKST=SU;COUNT=3;BYDAY=MO");
            }
            //print_r($event_data);
            //die;
            $cal_event = new Google\Service\Calendar\Event($event_data);
            $iCalUID = 'ep-ical-'.$event->id;
            
            if(isset($event->em_custom_meta) && !empty($event->em_custom_meta) && is_serialized($event->em_custom_meta)){
                $ev_custom_meta = unserialize($event->em_custom_meta);
                $ep_iCalUID = $ev_custom_meta['ix_gcal_ical_uid'];
                $ep_calendar_id = $ev_custom_meta['ix_gcal_calendar_id'];
                if($ep_calendar_id == $calendar_id and trim($ep_iCalUID)){
                    $iCalUID = $ep_iCalUID;
                }
            }
            $cal_event->setICalUID($iCalUID);
            try
            {
                $g_event = $service->events->insert($calendar_id, $cal_event);
                // Set Google Calendar ID to EP databse for updating it in the future instead of adding it twice
                $custom_meta = array(
                    'ix_gcal_ical_uid' => $g_event->getICalUID(),
                    'ix_gcal_id' => $g_event->getId(),
                    'ix_gcal_calendar_id' => $calendar_id,
                );
                update_post_meta($event->id, 'em_custom_meta', serialize($custom_meta));
                $g_events_inserted[] = array('title' => $event->name, 'message' => $g_event->htmlLink);
            }
            catch(Exception $ex)
            {
                // Event already existed
                if($ex->getCode() == 409)
                {
                    try
                    {
                        $custom_meta = unserialize(get_post_meta($event->id, 'em_custom_meta', true));
                        $g_event_id = $custom_meta['ix_gcal_id'];
                        $g_event = $service->events->get($calendar_id, $g_event_id);
                        // Update Event Data
                        $g_event->setSummary($event_data['summary']);
                        $g_event->setLocation($event_data['location']);
                        $g_event->setDescription($event_data['description']);

                        $start = new Google\Service\Calendar\EventDateTime();
                        $start->setDateTime($event_data['start']['dateTime']);
                        $start->setTimeZone($event_data['start']['timeZone']);
                        $g_event->setStart($start);

                        $end = new Google\Service\Calendar\EventDateTime();
                        $end->setDateTime($event_data['end']['dateTime']);
                        $end->setTimeZone($event_data['end']['timeZone']);
                        $g_event->setEnd($end);

                        $g_updated_event = $service->events->update($calendar_id, $g_event_id, $g_event);
                        $g_events_updated[] = array('title' => $event->name, 'message' => $g_updated_event->htmlLink);
                    }
                    catch(Exception $ex)
                    {
                        $g_events_not_inserted[] = array('title' => $event->name, 'message' => $ex->getMessage());
                    }
                }
                else $g_events_not_inserted[] = array('title' => $event->name, 'message' => $ex->getMessage());
            }
        }

        $results = '<ul>';
            foreach($g_events_not_inserted as $g_event_not_inserted) $results .= '<li><strong>'.$g_event_not_inserted['title'].'</strong>: '.$g_event_not_inserted['message'].'</li>';
        $results .= '<ul>';
        $message = (count($g_events_inserted) ? sprintf(__('%s Event(s) added to Google Calendar with success.', 'eventprime-event-google-import-export'), '<strong>'.count($g_events_inserted).'</strong>') : '');
        $message .= (count($g_events_updated) ? ' '.sprintf(__('%s Updated previously added Event(s).', 'eventprime-event-google-import-export'), '<strong>'.count($g_events_updated).'</strong>') : '');
        $message .= (count($g_events_not_inserted) ? ' '.sprintf(__('%s Event(s) failed to add for following reasons: %s', 'eventprime-event-google-import-export'), '<strong>'.count($g_events_not_inserted).'</strong>', $results) : '');
        $success = ((count($g_events_inserted) or count($g_events_updated)) ? 1 : 0);
        if(empty($success)){
            $returnData['errors'] = trim($message);
        }
        else{
            $returnData['success'] = trim($message);
        }
        return $this->gcal_exports_response($returnData);
    }
    
    public function gcal_exports_response($response){
        if(isset($response['success'])){
            ?>
            <div class="ep-eix-success">
                <?php echo $response['success'];?>
            </div>
            <?php 
        }else{?>
            <div class="ep-eix-error">
                <?php echo $response['errors'];?>
            </div>
        <?php }
    }
    
    public function check_recurrence_events($event){
        $ical = array();
        if(isset($event->em_enable_recurrence) && !empty($event->em_enable_recurrence)){
            $days = array('SU','MO','TU','WE','TH','FR','SA');
            $days_adv = array('sun'=>'SU','mon'=>'MO','tue'=>'TU','wed'=>'WE','thu'=>'TH','fri'=>'FR','sat'=>'SA');
            $em_recurrence_step = $event->em_recurrence_step;
            $em_recurrence_interval = $event->em_recurrence_interval;
            $em_recurrence_ends = $event->em_recurrence_ends;
            $em_recurrence_limit = isset($event->em_recurrence_limit) ? $event->em_recurrence_limit : '';
            $em_recurrence_occurrence_time = isset($event->em_recurrence_occurrence_time) ? $event->em_recurrence_occurrence_time : '';
            $end_date_time = $event->em_end_date_time;
            if($em_recurrence_interval =='daily' && $em_recurrence_ends=='after'){
                $ical[] = "RRULE:FREQ=DAILY;COUNT=".$em_recurrence_occurrence_time.";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='daily' && $em_recurrence_ends=='on'){
                $ical[]  ="RRULE:FREQ=DAILY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='weekly' && $em_recurrence_ends=='after'){
                $day = isset($event->em_selected_weekly_day) ? $event->em_selected_weekly_day : array(); 
                $day_list = array();
                if(!empty($day)){
                    foreach($day as $day){
                        $day_list[] = $days[$day];
                    }
                }
                $days_re = implode(',',$day_list);
                $ical[] = "RRULE:FREQ=WEEKLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".$days_re.";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='weekly' && $em_recurrence_ends=='on'){
                $day = isset($event->em_selected_weekly_day) ? $event->em_selected_weekly_day : array(); 
                $day_list = array();
                if(!empty($day)){
                    foreach($day as $day){
                        $day_list[] = $days[$day];
                    }
                }
                $days_re = implode(',',$day_list);
                $ical[] ="RRULE:FREQ=WEEKLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;BYDAY=".$days_re.";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='monthly' && $em_recurrence_ends=='after'){
                $em_recurrence_monthly_day = isset($event->em_recurrence_monthly_day) ? $event->em_recurrence_monthly_day : 1; 
                if($em_recurrence_monthly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical[] = "RRULE:FREQ=MONTHLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_monthly_weekno) ? $event->em_recurrence_monthly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_monthly_fullweekday) ? $event->em_recurrence_monthly_fullweekday : 1;
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical[] = "RRULE:FREQ=MONTHLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='monthly' && $em_recurrence_ends=='on'){
                $em_recurrence_monthly_day = isset($event->em_recurrence_monthly_day) ? $event->em_recurrence_monthly_day : 1; 
                if($em_recurrence_monthly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical[] = "RRULE:FREQ=MONTHLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_monthly_weekno) ? $event->em_recurrence_monthly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_monthly_fullweekday) ? $event->em_recurrence_monthly_fullweekday : 1;
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical[] ="RRULE:FREQ=MONTHLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='yearly' && $em_recurrence_ends=='after'){
                $em_recurrence_yearly_day = isset($event->em_recurrence_yearly_day) ? $event->em_recurrence_yearly_day : 1; 
                if($em_recurrence_yearly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $icalp[] = "RRULE:FREQ=YEARLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_yearly_weekno) ? $event->em_recurrence_yearly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_yearly_weekname) ? $event->em_recurrence_yearly_weekname : 1;
                    $monthCount = isset($event->em_recurrence_yearly_monthday) ? $event->em_recurrence_yearly_monthday : 1;
                    
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical[] = "RRULE:FREQ=YEARLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='yearly' && $em_recurrence_ends=='on'){
                $em_recurrence_yearly_day = isset($event->em_recurrence_yearly_day) ? $event->em_recurrence_yearly_day : 1; 
                if($em_recurrence_yearly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical[] = "RRULE:FREQ=YEARLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_yearly_weekno) ? $event->em_recurrence_yearly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_yearly_weekname) ? $event->em_recurrence_yearly_weekname : 1;
                    $monthCount = isset($event->em_recurrence_yearly_monthday) ? $event->em_recurrence_yearly_monthday : 1;
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical[] ="RRULE:FREQ=YEARLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='advanced' && $em_recurrence_ends=='after'){
                $em_recurrence_advanced_dates = isset($event->em_recurrence_advanced_dates) ? $event->em_recurrence_advanced_dates : array(); 
                if(!empty($em_recurrence_advanced_dates)){
                    $select_weeks = array();
                    foreach($em_recurrence_advanced_dates as $dates){
                        if(!empty($dates)){
                            $date_sle = explode('-',$dates);
                            if($date_sle[1]==5) $date_sle[1] = '-1';
                            $select_weeks[] = $date_sle[1].''.$days_adv[$date_sle[0]];
                        }
                    }
                    $ical[] = "RRULE:FREQ=MONTHLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".implode(',',$select_weeks).";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='advanced' && $em_recurrence_ends=='on'){
                $em_recurrence_advanced_dates = isset($event->em_recurrence_advanced_dates) ? $event->em_recurrence_advanced_dates : array(); 
                if(!empty($em_recurrence_advanced_dates)){
                    $select_weeks = array();
                    foreach($em_recurrence_advanced_dates as $dates){
                        if(!empty($dates)){
                            $date_sle = explode('-',$dates);
                            if($date_sle[1]==5) $date_sle[1] = '-1';
                            $select_weeks[] = $date_sle[1].''.$days_adv[$date_sle[0]];
                        }
                    }
                    $ical[] ="RRULE:FREQ=MONTHLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit)."Z;BYDAY=".implode(',',$select_weeks).";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            } 
        }
        return $ical;
    }
}