<?php


class EIX_Facebook_Import_Service{
    public $global_options = '';
    public $fb_access_token ='';
    public function __construct() {
        $this->set_global_options();
        
    }
    
    public function set_global_options(){
        $global_settings = new Eventprime_Global_Settings();        
        $this->global_options = $global_settings->ep_get_settings();
    }
    public function save_global_options($global_settings_data){
        $global_settings = new Eventprime_Global_Settings();
        
        $global_settings->ep_save_settings( $global_settings_data );
    }
    
    
    public function f_calendar_import_start()
    {
        $form_data = $_POST;
        $fb_page_link = isset($form_data['ix_facebook_import_page_link']) ? $form_data['ix_facebook_import_page_link'] : NULL;
        $this->fb_access_token = isset($form_data['ix_facebook_app_token']) ? $form_data['ix_facebook_app_token'] : NULL;

        if(!trim($fb_page_link)){
            return $this->formate_facebook_import_response(array('success'=>0, 'message'=>__("Please insert your Facebook page's link.", 'eventprime-events-import-export')));
        }
        
        // Save options
        // save token in global options
        $this->global_options->ix_facebook_import_page_link = $fb_page_link;
        $this->global_options->ix_facebook_app_token = $this->fb_access_token;
        $this->save_global_options($this->global_options);
            
        $fb_page = $this->f_calendar_import_get_page($fb_page_link);

        $fb_page_id = isset($fb_page['id']) ? $fb_page['id'] : 0;
        if(!$fb_page_id)
        {
            $message = esc_html__("We were not able to recognize your Facebook page. Please check again and provide a valid link.", 'eventprime-events-import-export');
            if(isset($fb_page['error']) and isset($fb_page['error']['message'])) $message = $fb_page['error']['message'];

            return $this->formate_facebook_import_response(array('success'=>0, 'message'=>$message));
        }

        $events = array();
        $next_page = 'https://graph.facebook.com/v12.0/'.$fb_page_id.'/events/?access_token='.$this->fb_access_token;

        do
        {
            $events_result = $this->get_web_page($next_page);
            $fb_events = json_decode($events_result, true);

            // Exit the loop if no event found
            if(!isset($fb_events['data'])) break;

            foreach($fb_events['data'] as $fb_event)
            {
                $events[] = array('id'=>$fb_event['id'], 'name'=>$fb_event['name']);
            }

            $next_page = isset($fb_events['paging']['next']) ? $fb_events['paging']['next'] : NULL;
        }
        while($next_page);
        if(!count($events)) {
            $response = array('success'=>0, 'message'=>__("No events found!", 'eventprime-events-import-export'));
        }
        else {
            $response = array('success'=>1, 'message'=>'', 'data'=>array('events'=>$events, 'count'=>count($events), 'name'=>$fb_page['name']));
        }
        return $this->formate_facebook_import_response($response);
    }
    
    public function formate_facebook_import_response($response){
        
        if(isset($response['success']) && $response['success'] == 1){
            if(isset($response['data'])){
                $data = $response['data'];
                if(isset($data['count']) && $data['count']){
                    ?>
                <div class="ep-import-list-events-container">
                    <div class="ep-event-list-success epnotice ep-eix-success">
                        <?php echo sprintf(__('Total %s Events  Found. Please select your desired event(s) to import.','eventprime-events-import-export'), $response['data']['count']);?>
                    </div>
                    <div class="emrow ep-subhead-wrap">
                        <div class="ep-subhead-title"><?php echo esc_html__('Event List', 'eventprime-events-import-export');?></div>
                        <div class="ep-import-select-deselect">
                            <button type="button" class="btn btn-primary" onClick="import_fb_event_list_action('select-all')"><?php echo esc_html__('Select All', 'eventprime-events-import-export');?></button>
                            <button type="button" class="btn btn-primary" onClick="import_fb_event_list_action('deselect-all')"><?php echo esc_html__('Deselect All', 'eventprime-events-import-export');?></button>
                        </div>
                    </div>
                    <ul id='ep_import_f_calendar_events'>
                    <?php
                    foreach($data['events'] as $event){
                       
                       ?>
                        <li>
                            <label>
                                <input type="checkbox" name="f-import-events[]" value="<?php echo $event['id'];?>">
                                <span><?php _e('Event Title: ','eventprime-events-import-export');?> <strong><?php echo $event['name'];?></strong></span>
                            </label>
                        </li>
                       <?php
                    }
                    ?>
                    </ul>
                    <div class="ep-eix-facebook-options">
                        <div class="ep-facebook-options-title">
                            <?php echo esc_html__('Import Options', 'eventprime-events-import-export');?>
                        </div>
                        <div class="ep-row">
                            <label>
                                <input type="checkbox" name="import_locations" />
                                <?php echo esc_html__('Import Locations', 'eventprime-events-import-export');?>
                            </label>
                        </div>
                        <div class="ep-row">
                            <label>
                                <input type="checkbox" name="import_link_event" />
                                <?php echo esc_html__('Import Facebook Link as Event Link', 'eventprime-events-import-export');?>
                            </label>
                        </div>
                    </div>
                    <div class="eprow"> 
                        <button type="button" class="btn btn-primary ep-import-facebook-events-button ep-import-btn" onClick="import_facebbok_events()"><?php echo _e('Import','eventprime-events-import-export'); ?></button>
                        <span class="spinner"></span>
                    </div>
                    
                    <div class="eprow ep-eix-btn-response">
                        
                    </div>
                </div>
                    <?php
                }
            }
        }else{
            ?>
            <div class="ep-eix-error">
                    <?php echo $response['message'];?>
            </div>
            <?php 
        }
    }
    public function f_calendar_import_do()
    {
        $f_events = ((isset($_POST['f-import-events']) and is_array($_POST['f-import-events'])) ? array_map('sanitize_text_field', $_POST['f-import-events']) : array());
        if(!count($f_events)) return $this->formate_facebook_import(array('success'=>0, 'message'=>__('Please select events to import!', 'eventprime-events-import-export')));

        $fb_page_link = $this->global_options->ix_facebook_import_page_link;
        $this->fb_access_token = $this->global_options->ix_facebook_app_token;
        if(!trim($fb_page_link)) return $this->formate_facebook_import(array('success'=>0, 'message'=>__("Please insert your facebook page's link.", 'eventprime-events-import-export')));

        $fb_page = $this->f_calendar_import_get_page($fb_page_link);

        $fb_page_id = isset($fb_page['id']) ? $fb_page['id'] : 0;
        if(!$fb_page_id) return $this->formate_facebook_import(array('success'=>0, 'message'=>__("We were not able to recognize your Facebook page. Please check again and provide a valid link.", 'eventprime-events-import-export')));

        // Timezone
        $timezone = ep_get_site_timezone();

        // MEC File
        //$file = $this->getFile();
        $wp_upload_dir = wp_upload_dir();

        $ep_functions = new Eventprime_Basic_Functions(); 

        $post_ids = array();
        foreach($f_events as $f_event_id)
        {
            $events_result = $this->get_web_page('https://graph.facebook.com/v12.0/'.$f_event_id.'?fields=name,place,description,start_time,end_time,cover,event_times&access_token='.$this->fb_access_token);
            $event = json_decode($events_result, true);

            // An error Occurred
            if(isset($event['error']) and is_array($event['error']) and count($event['error'])) continue;

            // Event organizer
            $organizer_id = 1;

            // Event location
            $location = isset($event['place']) ? $event['place'] : array();
            $location_id = 1;
            // Import Event Locations into MEC locations
            $event_venue_id = '';
            if(isset($_POST['import_locations']) and $_POST['import_locations'] and count($location))
            {
                $location_name = $location['name'];
                $location_term = get_term_by('name', $location_name, 'em_venue');
                if(is_object($location_term) and isset($location_term->term_id)) {
                    $event_venue_id = $location_term->term_id;
                }else{
                    $location_address = trim($location_name.' '.(isset($location['location']['city']) ? $location['location']['city'] : '').' '.(isset($location['location']['state']) ? $location['location']['state'] : '').' '.(isset($location['location']['country']) ? $location['location']['country'] : '').' '.(isset($location['location']['zip']) ? $location['location']['zip'] : ''), '');
                    $venue_args = array(
                        'name'=>trim($location_name),
                        'em_address'=>$location_address,
                        'em_lat'=>!empty($location['location']['latitude']) ? $location['location']['latitude'] : '',
                        'em_lng'=>!empty($location['location']['longitude']) ? $location['location']['longitude'] : '',
                        'em_city'=>!empty($location['location']['city']) ? $location['location']['city'] : '',
                        'em_country'=>!empty($location['location']['country']) ? $location['location']['country'] : '',
                        'em_state'=>!empty($location['location']['state']) ? $location['location']['state'] : '',
                        'em_postal_code'=>!empty($location['location']['zip']) ? $location['location']['zip'] : '',
                        'em_type'=>'standings',
                        'em_seating_capacity'=>0,
                    );
                    $event_venue_id = $ep_functions->create_venue($venue_args);
                }
            }
            // Event Title and Content
            $title = $event['name'];
            $description = isset($event['description']) ? $event['description'] : '';

            // Event Times (Custom Events)
            $event_times = ((isset($event['event_times']) and is_array($event['event_times'])) ? $event['event_times'] : array());

            if(count($event_times))
            {
                $days = '';
                $main_datetime = array();

                $i = 1;
                foreach($event_times as $event_time)
                {
                    if($i == count($event_times)) $main_datetime = $event_time;
                    else
                    {
                        $ds = new DateTime($event_time['start_time']);
                        $ds->setTimezone(new DateTimeZone($timezone));

                        $de = new DateTime($event_time['end_time']);
                        $de->setTimezone(new DateTimeZone($timezone));

                        $days .= $ds->format('m/d/Y').':'.$de->format('m/d/Y').':'.$ds->format('h-i-A').':'.$de->format('h-i-A').',';
                    }

                    $i++;
                }

                $date_start = new DateTime($main_datetime['start_time']);
                $date_start->setTimezone(new DateTimeZone($timezone));

                $start_date = $date_start->format('m/d/Y');
                $start_hour = $date_start->format('h');
                $start_minutes = $date_start->format('i');
                $start_ampm = $date_start->format('A');
                
                $date_end = new DateTime($main_datetime['end_time']);
                $date_end->setTimezone(new DateTimeZone($timezone));

                $end_date = $date_end->format('m/d/Y');
                $end_hour = $date_end->format('h');
                $end_minutes = $date_end->format('i');
                $end_ampm = $date_end->format('A');
                
                $repeat_status = 1;
                $repeat_type = 'custom_days';
                $days = trim($days, ', ');
            }
            else
            {
                $date_start = new DateTime($event['start_time']);
                $date_start->setTimezone(new DateTimeZone($timezone));

                $start_date = $date_start->format('m/d/Y');
                $start_hour = $date_start->format('h');
                $start_minutes = $date_start->format('i');
                $start_ampm = $date_start->format('A');
                
                $end_timestamp = isset($event['end_time']) ? strtotime($event['end_time']) : 0;
                if($end_timestamp)
                {
                    $date_end = new DateTime($event['end_time']);
                    $date_end->setTimezone(new DateTimeZone($timezone));
                }

                $end_date = $end_timestamp ? $date_end->format('m/d/Y') : $start_date;
                $end_hour = $end_timestamp ? $date_end->format('h') : 23;
                $end_minutes = $end_timestamp ? $date_end->format('i') : '59';
                $end_ampm = $end_timestamp ? $date_end->format('A') : 'PM';
                
                $repeat_status = 0;
                $repeat_type = '';
                $days = NULL;
            }

            // Event Time Options
            $allday = 0;

            // Import Facebook Link as Event Link
            $read_more = '';
            $em_enable_booking = '';
            if(isset($_POST['import_link_event']) and $_POST['import_link_event']) {
                $read_more = 'https://www.facebook.com/events/'.$f_event_id.'/';
                $em_enable_booking = 'external_bookings';
            }
            
            $event_start_time = $start_hour.':'.$start_minutes.' '.$end_ampm;
            $event_end_time = $end_hour.':'.$end_minutes.' '.$end_ampm;
            $custom_meta = array(
                    'ix_source' => 'facebbok-calendar',
                    'ix_facebook_page_id' => $fb_page_id,
                    'ix_facebook_event_id' => $f_event_id,
                    'ix_allday'=>$allday,
                    'ix_read_more'=>$read_more,
                    'ix_in_days'=>$days,
                );
            $event_data = array(
                'name'=>$title,
                'description'=>$description,
                'em_start_date'=>!empty($start_date) ? $ep_functions->ep_date_to_timestamp($start_date, 'm/d/Y') : '',
                'em_end_date'=>!empty($end_date) ? $ep_functions->ep_date_to_timestamp($end_date, 'm/d/Y') : '',
                'em_start_time'=>$event_start_time,
                'em_end_time'=>$event_end_time,
                'em_venue'=>$event_venue_id,
                'em_all_day'=>$allday,
                'em_enable_booking'=>$em_enable_booking,
                'em_custom_link'=>$read_more,
                'em_custom_meta'=>$custom_meta,
            );
            // first check
            $defaults = array(
                'post_status' => 'any',
                'post_type' => 'em_event',
                'numberposts' => -1,
                'meta_query' => array(
                    array(
                        'key'     => 'em_custom_meta',
                        'value'   => serialize($custom_meta),
                        'compare' => 'LIKE'
                    )
                )
            );
            $posts = get_posts($defaults);            
            if(!empty($posts) && count($posts) > 0){
                $idx++;
                continue;
            }
           
            $post_id = $ep_functions->insert_event_post_data($event_data);
            $post_ids[] = $post_id;

            if(!has_post_thumbnail($post_id) and isset($event['cover']) and is_array($event['cover']) and count($event['cover']))
            {
            }
        }
        
        $response = array('success'=>1, 'data'=>$post_ids);
        return $this->formate_facebook_import($response);
    }

    public function formate_facebook_import($response){
        if(isset($response['success']) && $response['success']){
            if(count($response['data'])){
            ?>
                <div class='ep-eix-success'>
                    <?php echo sprintf(__('Total %s events imported','eventprime-events-import-export'), count($response['data']));?>
                </div>
            <?php
            }
            else{
                ?>
                <div class="ep-eix-error">
                    <?php _e('No Event Imported. All Events Already Exist!','eventprime-events-import-export');?>
                </div>
                <?php
            }
        }else{
            ?>
            <div class='ep-eix-error'>
                <?php echo $response['message'];?>
            </div>
            <?php
        }
    }
    
    public function f_calendar_import_get_page($link)
    {
        $fb_page_result = $this->get_web_page('https://graph.facebook.com/v12.0/?access_token='.$this->fb_access_token.'&id='.$link);

        return json_decode($fb_page_result, true);
    }
    public function get_web_page($url, $timeout = 20){
	$result = false;
        if(function_exists('wp_remote_get')){
            $result = wp_remote_retrieve_body(wp_remote_get($url, array(
                'body' => null,
                'timeout' => $timeout,
                'redirection' => 5,
            )));
        }

        if($result === false){
            $http = array();
            $result = @file_get_contents($url, false, stream_context_create(array('http'=>$http)));
	}

        return $result;
    }

}