<?php

class EIX_Export_Service{
    public function ep_export_events_csv($start_date, $end_date){      
        $ep_functions = new Eventprime_Basic_Functions(); 
        $events_data = array();

        $args['orderby']='date';
        $args['order']='ASC';
        //$args['post_parent'] = 0;
        $args['meta_query'] = array(	
                'relation'     => 'AND',
                array(
                    'key'      => 'em_start_date',
                    'value'    => $start_date,
                    'compare'  => '>='
                ),
                array(
                    'key'      => 'em_end_date',
                    'value'    => $end_date,
                    'compare'  => '<='
                )
        );
        $events = $ep_functions->get_events_post_data($args);
        $datepicker_format = $ep_functions->ep_get_datepicker_format();

        $max_num_of_tics_in_events = 0;
        $row = 1;
        if(!empty($events)){
            usort($events->posts, function($a, $b) {
                // Compare based on the count of all_tickets_data
                return count($b->all_tickets_data) <=> count($a->all_tickets_data);
            });

            if ( !empty($events->posts) ) {
                $max_num_of_tics_in_events = count($events->posts[0]->all_tickets_data);
                $events_data[0] = $this->ep_create_csv_column_headers($events->posts[0]);
            }
            
            foreach ($events->posts as $event){
                $row_data = $this->ep_format_csv_rows($event, $max_num_of_tics_in_events, $datepicker_format);
                $events_data[$row] = $row_data;
                $row++;
                /*
                $child_events = $ep_functions->ep_get_child_events($event->em_id);
                if(!empty($child_events) && count($child_events)){
                    foreach($child_events as $event){
                        $event = $ep_functions->get_single_event($event->ID);
                        $row_data = $this->ep_format_csv_rows($event, $max_num_of_tics_in_events, $datepicker_format);
                        $events_data[$row] = $row_data;
                        $row++;
                    }
                }
                */
            }
        }

        // $ep_functions->epd($events_data);

        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="ep-events-'.md5(time().mt_rand(100, 999)).'.csv"');
        $f = fopen('php://output', 'w');
        foreach ($events_data as $line) {
            fputcsv($f, $line);
        }
        exit;
    }

    public function ep_create_csv_column_headers($event) {
        $ep_functions = new Eventprime_Basic_Functions();
        
        // Event fields 
        $response['id'] = __('ID', 'eventprime-events-import-export');
        $response['title'] = __('Title', 'eventprime-events-import-export');
        $response['parent'] = __('Parent Event', 'eventprime-events-import-export');
        $response['desc'] = __('Description', 'eventprime-events-import-export');
        $response['start_date'] = __('Start Date', 'eventprime-events-import-export');
        $response['hide_start_date'] = __('Hide Start Date', 'eventprime-events-import-export');
        $response['start_time'] = __('Start Time', 'eventprime-events-import-export');
        $response['hide_start_time'] = __('Hide Start Time', 'eventprime-events-import-export');
        $response['end_date'] =     __('End Date', 'eventprime-events-import-export');
        $response['hide_end_date'] =     __('Hide End Date', 'eventprime-events-import-export');
        $response['end_time'] =     __('End Time', 'eventprime-events-import-export');
        $response['hide_end_time'] =     __('Hide End Time', 'eventprime-events-import-export');
        $response['all_day'] =     __('All Day', 'eventprime-events-import-export');

        $response['em_event_date_placeholder'] =     __('Event Date Placeholder', 'eventprime-events-import-export');
        $response['em_event_date_placeholder_custom_note'] =     __('Date Placeholder Text', 'eventprime-events-import-export');
        $response['em_event_add_more_dates'] =     __('Additional Dates', 'eventprime-events-import-export');
        
        $response['image_url'] =     __('Event Image', 'eventprime-events-import-export');
        
        // event-type fields
        $response['event_type'] =     __('Event Type', 'eventprime-events-import-export');

        // Venue fields
        $response['location'] =     __('Location', 'eventprime-events-import-export');
        $response['address'] =     __('Address', 'eventprime-events-import-export'); 
        // $response['latitude'] =     __('Latitude', 'eventprime-events-import-export'); 
        // $response['longitude'] =     __('Longitude', 'eventprime-events-import-export'); 
        $response['seat_capicity'] =     __('Seating Capacity', 'eventprime-events-import-export');
        $response['operator'] =     __('Operator', 'eventprime-events-import-export');

        // organizers 
        $response['organizer'] =     __('Organizer Name', 'eventprime-events-import-export');
        $response['org_phone'] =     __('Organizer Phone', 'eventprime-events-import-export');
        $response['org_email'] =     __('Organizer Email', 'eventprime-events-import-export');
        $response['org_website'] =     __('Organizer Website', 'eventprime-events-import-export');

        // performers 
        $response['performers'] =     __('Performers', 'eventprime-events-import-export');
        
        $response['link'] =     __('Link', 'eventprime-events-import-export');

        $response['booking_status'] =     __('Booking Status', 'eventprime-events-import-export');
        $response['em_custom_link'] =     __('External Booking Link', 'eventprime-events-import-export');
        $response['em_custom_link_new_browser'] =     __('Open link in new browser', 'eventprime-events-import-export');
        $response['price'] =     __('Event Price', 'eventprime-events-import-export');
        $response['hide_booking_status'] = __('Hide Booking Status', 'eventprime-events-import-export');
        $response['allow_cancellations'] = __('Allow Cancellations', 'eventprime-events-import-export');
        $response['allow_edit_booking'] = __('Allow Booking Modifications', 'eventprime-events-import-export');
        $response['edit_booking_date_data'] = __('Booking Modifications Settings', 'eventprime-events-import-export');

        $response['date_format'] = __('Date Format', 'eventprime-events-import-export');

        $tic_no = 1;
        // category tic data 
        if ( isset($event->ticket_categories) && !empty($event->ticket_categories) ) {
            $cat_no = 1;
            foreach( $event->ticket_categories as $cat ) {
                foreach( $cat->tickets as $cat_tic ) {
                    // Import tic Offers ***** 
                    $response["tic_{$tic_no}_name"] = "Tic_{$tic_no}_Name";
                    $response["tic_{$tic_no}_price"] = "Tic_{$tic_no}_Price";
                    $response["tic_{$tic_no}_capacity"] = "Tic_{$tic_no}_Capacity";
                    $response["tic_{$tic_no}_cat_name"] = "Tic_{$tic_no}_Category_Name";
                    $response["tic_{$tic_no}_cat_capacity"] = "Tic_{$tic_no}_Category_Capacity";

                    $response["tic_{$tic_no}_min_ticket_no"] = "Tic_{$tic_no}_Min_Ticket_No";
                    $response["tic_{$tic_no}_max_ticket_no"] = "Tic_{$tic_no}_Max_Ticket_No";
                    $response["tic_{$tic_no}_visibility"] = "Tic_{$tic_no}_Visibility";
                    $response["tic_{$tic_no}_offers"] = "Tic_{$tic_no}_Offers";
                    $response["tic_{$tic_no}_multiple_offers_option"] = "Tic_{$tic_no}_Multiple_Offers_Option";
                    $response["tic_{$tic_no}_multiple_offers_max_discount"] = "Tic_{$tic_no}_Multiple_Offers_Max_Discount";
                    $response["tic_{$tic_no}_additional_fees"] = "Tic_{$tic_no}_Additional_Fees";
                    $response["tic_{$tic_no}_show_remaining_tickets"] = "Tic_{$tic_no}_Show_Remaining_Tickets";
                    $response["tic_{$tic_no}_show_ticket_booking_dates"] = "Tic_{$tic_no}_Show_Ticket_Booking_Dates";
                    $response["tic_{$tic_no}_booking_starts"] = "Tic_{$tic_no}_Booking_Starts";
                    $response["tic_{$tic_no}_booking_ends"] = "Tic_{$tic_no}_Booking_Ends";
                    
                    $tic_no++;
                }
                $cat_no++;
            }
        }
        
        // individual ticket data 
        if ( isset($event->solo_tickets) && !empty($event->solo_tickets) ) {
            foreach( $event->solo_tickets as $tic ) {
                // Import tic Offers ***** 
                $response["tic_{$tic_no}_name"] = "Tic_{$tic_no}_Name";
                $response["tic_{$tic_no}_price"] = "Tic_{$tic_no}_Price";
                $response["tic_{$tic_no}_capacity"] = "Tic_{$tic_no}_Capacity";
                $response["tic_{$tic_no}_cat_name"] = "Tic_{$tic_no}_Category_Name";
                $response["tic_{$tic_no}_cat_capacity"] = "Tic_{$tic_no}_Category_Capacity";

                $response["tic_{$tic_no}_min_ticket_no"] = "Tic_{$tic_no}_Min_Ticket_No";
                $response["tic_{$tic_no}_max_ticket_no"] = "Tic_{$tic_no}_Max_Ticket_No";
                $response["tic_{$tic_no}_visibility"] = "Tic_{$tic_no}_Visibility";
                $response["tic_{$tic_no}_offers"] = "Tic_{$tic_no}_Offers";
                $response["tic_{$tic_no}_multiple_offers_option"] = "Tic_{$tic_no}_Multiple_Offers_Option";
                $response["tic_{$tic_no}_multiple_offers_max_discount"] = "Tic_{$tic_no}_Multiple_Offers_Max_Discount";
                $response["tic_{$tic_no}_additional_fees"] = "Tic_{$tic_no}_Additional_Fees";
                $response["tic_{$tic_no}_show_remaining_tickets"] = "Tic_{$tic_no}_Show_Remaining_Tickets";
                $response["tic_{$tic_no}_show_ticket_booking_dates"] = "Tic_{$tic_no}_Show_Ticket_Booking_Dates";
                $response["tic_{$tic_no}_booking_starts"] = "Tic_{$tic_no}_Booking_Starts";
                $response["tic_{$tic_no}_booking_ends"] = "Tic_{$tic_no}_Booking_Ends";
                
                $tic_no++;
            }
        }
        // ***** 
        // $response['currency_symbol'] = __('Currency Symbol', 'eventprime-events-import-export');
        // $response['currency_position'] = __('Currency Position', 'eventprime-events-import-export');
        
        // Event other settings 
        $response['em_event_text_color'] = __('Event Text Color', 'eventprime-events-import-export');
        $response['em_audience_notice'] = __('Attendee Note', 'eventprime-events-import-export');
        
        // Event restriction settings
        $response['em_event_max_tickets_per_user'] = __('Maximum Tickets Per User', 'eventprime-events-import-export');
        $response['em_event_max_tickets_per_order'] = __('Maximum Tickets Per Order Across All Tickets', 'eventprime-events-import-export');
        $response['em_event_max_tickets_reached_message'] = __('Message for Maximum Tickets Reached', 'eventprime-events-import-export');
        
        // Event socials 
        $response['em_social_links'] = __('Social Information', 'eventprime-events-import-export');

        // recuring settings
        $response['rec_interval'] =     __('Recurring Interval', 'eventprime-events-import-export');
        $response['rec_step'] =     __('Recurring After (days/weeks)etc.', 'eventprime-events-import-export');
        $response['rec_ends_date'] =     __('Ends on Date', 'eventprime-events-import-export');
        $response['rec_ends_count'] =     __('Occurrences Count', 'eventprime-events-import-export');
        $response['rec_title_format'] =     __('Title Formate', 'eventprime-events-import-export');
        $response['rec_week_days'] =     __('Week Days', 'eventprime-events-import-export');
        $response['rec_month_type'] =     __('Month Type(date/day)', 'eventprime-events-import-export');
        $response['rec_month_days'] =     __('Month Days', 'eventprime-events-import-export');
        $response['rec_year_type'] =     __('Year Type(date/day)', 'eventprime-events-import-export');
        $response['rec_year_days'] =     __('Year Days', 'eventprime-events-import-export');
        $response['rec_adv_days'] =     __('Advanced Days', 'eventprime-events-import-export');
        $response['rec_cust_date'] =     __('Custom Dates', 'eventprime-events-import-export');
        $response['formula'] =     __('Recurring Formula', 'eventprime-events-import-export');

        $response['em_event_checkout_attendee_fields'] = __('Attendee Checkout Fields', 'eventprime-events-import-export');   // ***** 
        $response['em_event_checkout_fixed_fields'] = __('Terms and Conditions Fields', 'eventprime-events-import-export');   // ***** 
        $response['em_event_checkout_booking_fields'] = __('Booking Checkout Fields', 'eventprime-events-import-export');   // ***** 

        // Meta Fields
        $response['event_type_meta'] =     __('Event-Type Meta', 'eventprime-events-import-export');
        $response['venue_meta'] =     __('Venue Meta', 'eventprime-events-import-export');
        $response['organizers_meta'] =     __('Organizers Meta', 'eventprime-events-import-export');
        $response['performers_meta'] =     __('Performers Meta', 'eventprime-events-import-export');



        return $response;
    }
    
    public function ep_format_csv_rows($event, $max_num_of_tics_in_events, $datepicker_format){
        $ep_dbhandler = new EP_DBhandler(); 
        $ep_functions = new Eventprime_Basic_Functions(); 

        $checkout_fields_type_with_option_data = ["radio", "checkbox", "dropdown"];
        
        $ticket_categories = $event->ticket_categories;
        $solo_tickets = $event->solo_tickets;
        
        $events_data = array();
        $events_data['id']= $event->em_id;
        $events_data['title'] = $event->em_name;
        $events_data['parent'] = '';
        
        if(wp_get_post_parent_id($event->em_id)){
            $events_data['parent'] = get_the_title(wp_get_post_parent_id($event->em_id));
        }
        $events_data['desc'] = $event->description;
        $events_data['start_date'] = isset($event->em_start_date) ? $ep_functions->ep_timestamp_to_date($event->em_start_date): '';
        $events_data['hide_start_date'] = isset($event->em_hide_event_start_date) ? $event->em_hide_event_start_date: 0;
        $events_data['start_time'] = isset($event->em_start_time) ? $event->em_start_time: '';
        $events_data['hide_start_time'] = isset($event->em_hide_event_start_time) ? $event->em_hide_event_start_time: 0;
        $events_data['end_date'] = isset($event->em_end_date) ? $ep_functions->ep_timestamp_to_date($event->em_end_date): '';
        $events_data['hide_end_date'] = isset($event->em_hide_end_date) ? $event->em_hide_end_date: 0;
        $events_data['end_time'] = isset($event->em_end_time) ? $event->em_end_time: '';
        $events_data['hide_end_time'] = isset($event->em_hide_event_end_time) ? $event->em_hide_event_end_time: 0;
        $events_data['all_day'] = isset($event->em_all_day) ? $event->em_all_day : 0;

        $events_data['em_event_date_placeholder'] = isset($event->em_event_date_placeholder) && !empty($event->em_event_date_placeholder) ? $event->em_event_date_placeholder : '';
        $events_data['em_event_date_placeholder_custom_note'] = isset($event->em_event_date_placeholder_custom_note) && !empty($event->em_event_date_placeholder_custom_note) ? $event->em_event_date_placeholder_custom_note : '';
        $events_data['em_event_add_more_dates'] = [];
        $events_data['em_event_add_more_dates'] = [];
        if ( isset($event->em_event_more_dates) && !empty($event->em_event_more_dates) ) {
            if ( !empty($event->em_event_add_more_dates) ) {
                foreach ($event->em_event_add_more_dates as $additional_date) {
                    $events_data['em_event_add_more_dates'][] = " ( " . implode(' | ', array(
                        $ep_functions->ep_timestamp_to_date($additional_date['date']),
                        $additional_date['time'],
                        $additional_date['label'],
                    )) . " ) ";
                }
            }
        }
        $events_data['em_event_add_more_dates'] = implode(' | ', $events_data['em_event_add_more_dates']);

        // featured image 
        $events_data['image_url'] = isset($event->image_url) && !empty($event->image_url) ? $event->image_url : '';

        // Event-type 
        $events_data['event_type'] = '';
        if ( isset($event->event_type_details) && !empty($event->event_type_details) ) {
            $events_data['event_type'] = $event->event_type_details->name;
        }

        // Venue details 
        $events_data['location'] = '';
        $events_data['address'] = ''; 
        // $events_data['latitude'] = ''; 
        // $events_data['longitude'] = ''; 
        $events_data['seat_capicity'] = '';
        $events_data['operator'] ='';
        if(isset($event->venue_details) && !empty($event->venue_details)){
            $venue = $event->venue_details; 
            if(!empty($venue)){
                $events_data['location'] = $venue->name;
                $events_data['address'] = isset($venue->em_address) ? $venue->em_address : '';
                // $events_data['latitude'] = isset($venue->em_lat) ? $venue->em_lat : ''; 
                // $events_data['longitude'] = isset($venue->em_lng) ? $venue->em_lng : '';
                if(isset($venue->em_type) && $venue->em_type =='seats'){
                    $events_data['seat_capicity'] = isset($venue->seating_capacity) ? $venue->seating_capacity : '';
                }
                if(isset($venue->em_seating_organizer)){
                    $events_data['operator'] = $venue->em_seating_organizer;
                }
            }
        }

        // Organizer details
        $events_data['organizer'] = ''; 
        $events_data['org_phone'] = ''; 
        $events_data['org_email'] = '';
        $events_data['org_website'] = '';
        if(isset($event->organizer_details) && !empty($event->organizer_details)){
            $organizers = array();
            $org_phones = array();
            $org_email = array();
            $org_web = array();
            foreach($event->organizer_details as $organizer){
                if(!empty($organizer)){
                    $organizers[] = $organizer->name;
                }
                if(isset($organizer->em_organizer_phones) && !empty($organizer->em_organizer_phones) && !empty($organizer->em_organizer_phones[0])){
                    $org_phones[] = implode(', ',$organizer->em_organizer_phones);
                    
                }
                if(isset($organizer->em_organizer_emails) && !empty($organizer->em_organizer_emails) && !empty($organizer->em_organizer_emails[0])){
                    $org_email[] = implode(', ',$organizer->em_organizer_emails);
                }
                if(isset($organizer->em_organizer_websites) && !empty($organizer->em_organizer_websites) && !empty($organizer->em_organizer_websites[0])){
                    $org_web[] = implode(', ',$organizer->em_organizer_websites);
                }
            }
            if(!empty($organizers)){
                $events_data['organizer'] = implode(' | ', $organizers);
                
            }
            if(!empty($org_phones)){
                $events_data['org_phone'] = implode(' | ',$org_phones); 
            }
            if(!empty($org_email)){
                $events_data['org_email'] = implode(' | ',$org_email); 
            }
            if(!empty($org_web)){
                $events_data['org_website'] = implode(' | ',$org_web); 
            }                    
        }

        // Performers details 
        $events_data['performers'] = ''; 
        if(isset($event->performer_details) && !empty($event->performer_details)){
            $performers = array();
            foreach($event->performer_details as $performer){
                if(!empty($performer)){
                    $performers[] = $performer->name;
                }
            }
            if(!empty($performers)){
                $events_data['performers'] = implode(' | ', $performers);
            }
        }

        $events_data['link'] = get_permalink($event->em_id);

        $events_data['booking_status'] = $event->em_enable_booking;

        $events_data['em_custom_link'] = 0;
        $events_data['em_custom_link_new_browser'] = 0;
        if($event->em_enable_booking =='external_bookings'){
            $events_data['em_custom_link'] = isset($event->em_custom_link) ? $event->em_custom_link : '';
            $events_data['em_custom_link_new_browser'] = isset($event->em_custom_link_new_browser) ? $event->em_custom_link_new_browser : '';
        }
        
        $events_data['price'] ='';
        $events_data['hide_booking_status'] = '';
        $events_data['allow_cancellations'] = '';
        $events_data['allow_edit_booking'] = '';
        $events_data['edit_booking_date_data'] = '';
        
        // $events_data['ticket_price_range'] = '';    // can include this too ***** check for free events 

        // if( $event->em_enable_booking == 'bookings_on' || $event->em_enable_booking == "bookings_off") {
            $events_data['price'] = isset($event->em_fixed_event_price) ? $event->em_fixed_event_price : '';
            $events_data['hide_booking_status'] = $event->em_hide_booking_status;
            $events_data['allow_cancellations'] = $event->em_allow_cancellations;
            $events_data['allow_edit_booking'] = $event->em_allow_edit_booking;
            $events_data['edit_booking_date_data'] = (isset($event->em_edit_booking_date_data) && !empty($event->em_edit_booking_date_data)) ? json_encode($event->em_edit_booking_date_data) : "";

            // $events_data['ticket_price_range'] = '';    // ***** 

            $events_data['date_format'] = $datepicker_format;

            $tic_no = 1;
            // category tic data 
            if ($ticket_categories) {
                $cat_no = 1;
                foreach ($ticket_categories as $cat) {
                    // $ep_functions->epd($cat->tickets);
                    foreach( $cat->tickets as $cat_tic ) {
                        // Import tic Offers ***** 
                        $events_data["tic_{$tic_no}_name"] = $cat_tic->name;
                        $events_data["tic_{$tic_no}_price"] = $cat_tic->price;
                        $events_data["tic_{$tic_no}_capacity"] = $cat_tic->capacity;
                        $events_data["tic_{$tic_no}_cat_name"] = $cat->name;
                        $events_data["tic_{$tic_no}_cat_capacity"] = $cat->capacity;
                        $events_data["tic_{$tic_no}_min_ticket_no"] = $cat_tic->min_ticket_no;
                        $events_data["tic_{$tic_no}_max_ticket_no"] = $cat_tic->max_ticket_no;
                        $events_data["tic_{$tic_no}_visibility"] = $cat_tic->visibility;
                        $events_data["tic_{$tic_no}_offers"] = $cat_tic->offers;
                        $events_data["tic_{$tic_no}_multiple_offers_option"] = $cat_tic->multiple_offers_option;
                        $events_data["tic_{$tic_no}_multiple_offers_max_discount"] = $cat_tic->multiple_offers_max_discount;
                        $events_data["tic_{$tic_no}_additional_fees"] = $cat_tic->additional_fees;
                        $events_data["tic_{$tic_no}_show_remaining_tickets"] = $cat_tic->show_remaining_tickets;
                        $events_data["tic_{$tic_no}_show_ticket_booking_dates"] = $cat_tic->show_ticket_booking_dates;
                        $events_data["tic_{$tic_no}_booking_starts"] = $cat_tic->booking_starts;
                        $events_data["tic_{$tic_no}_booking_ends"] = $cat_tic->booking_ends;
                        $tic_no++;
                    }
                    $cat_no++;  
                }
            }
            // solo tickets 
            if($solo_tickets) {
                foreach ($solo_tickets as $tic) {
                    // Import tic Offers ***** 
                    $events_data["tic_{$tic_no}_name"] = $tic->name;
                    $events_data["tic_{$tic_no}_price"] = $tic->price;
                    $events_data["tic_{$tic_no}_capacity"] = $tic->capacity;
                    $events_data["tic_{$tic_no}_cat_name"] = '';
                    $events_data["tic_{$tic_no}_cat_capacity"] = '';
                    $events_data["tic_{$tic_no}_min_ticket_no"] = $tic->min_ticket_no;
                    $events_data["tic_{$tic_no}_max_ticket_no"] = $tic->max_ticket_no;
                    $events_data["tic_{$tic_no}_visibility"] = $tic->visibility;
                    $events_data["tic_{$tic_no}_offers"] = $tic->offers;
                    $events_data["tic_{$tic_no}_multiple_offers_option"] = $tic->multiple_offers_option;
                    $events_data["tic_{$tic_no}_multiple_offers_max_discount"] = $tic->multiple_offers_max_discount;
                    $events_data["tic_{$tic_no}_additional_fees"] = $tic->additional_fees;
                    $events_data["tic_{$tic_no}_show_remaining_tickets"] = $tic->show_remaining_tickets;
                    $events_data["tic_{$tic_no}_show_ticket_booking_dates"] = $tic->show_ticket_booking_dates;
                    $events_data["tic_{$tic_no}_booking_starts"] = $tic->booking_starts;
                    $events_data["tic_{$tic_no}_booking_ends"] = $tic->booking_ends;
                    $tic_no++;
                }
            }

            while($tic_no <= $max_num_of_tics_in_events) {
                $events_data["tic_{$tic_no}_name"] = "";
                $events_data["tic_{$tic_no}_price"] = "";
                $events_data["tic_{$tic_no}_capacity"] = "";
                $events_data["tic_{$tic_no}_cat_name"] = "";
                $events_data["tic_{$tic_no}_cat_capacity"] = "";
                $events_data["tic_{$tic_no}_min_ticket_no"] = "";
                $events_data["tic_{$tic_no}_max_ticket_no"] = "";
                $events_data["tic_{$tic_no}_visibility"] = "";
                $events_data["tic_{$tic_no}_offers"] = "";
                $events_data["tic_{$tic_no}_multiple_offers_option"] = "";
                $events_data["tic_{$tic_no}_multiple_offers_max_discount"] = "";
                $events_data["tic_{$tic_no}_additional_fees"] = "";
                $events_data["tic_{$tic_no}_show_remaining_tickets"] = "";
                $events_data["tic_{$tic_no}_show_ticket_booking_dates"] = "";
                $events_data["tic_{$tic_no}_booking_starts"] = "";
                $events_data["tic_{$tic_no}_booking_ends"] = "";
                $tic_no++;
            }

        // }

        // add other settings meta box
        $events_data['em_event_text_color'] = isset($event->em_event_text_color) ? $event->em_event_text_color : '';
        $events_data['em_audience_notice'] = isset($event->em_audience_notice) ? $event->em_audience_notice : '';
        
        // add restrictions settings meta box
        $events_data['em_event_max_tickets_per_user'] = isset($event->em_event_max_tickets_per_user) ? $event->em_event_max_tickets_per_user : '';
        $events_data['em_event_max_tickets_per_order'] = isset($event->em_event_max_tickets_per_order) ? $event->em_event_max_tickets_per_order : '';
        $events_data['em_event_max_tickets_reached_message'] = isset($event->em_event_max_tickets_reached_message) ? $event->em_event_max_tickets_reached_message : '';

        // save social info
        $em_social_links = array();
        if (isset($event->em_social_links) && !empty($event->em_social_links)) {
            foreach ($event->em_social_links as $social_key => $social_links) {
                if (!empty($social_links)) {
                    $em_social_links[] = strtoupper($social_key) . " - " . $social_links;
                }
            }
        }
        $events_data['em_social_links'] = implode( " | ", $em_social_links);


        // Recurring details 
        $em_recurrence_interval = get_post_meta( $event->em_id, 'em_recurrence_interval', true );
        if( ! empty( $em_recurrence_interval ) && strpos( $em_recurrence_interval, '_' ) === true ) {
            $em_recurrence_interval = implode(' ', explode('_', $em_recurrence_interval) );
        }

        // $events_data['formula'] = $events_data['rec_interval'] = $events_data['rec_step'] = $events_data['rec_ends_date'] = $events_data['rec_ends_count'] = $events_data['rec_title_format'] = $events_data['rec_week_days'] = $events_data['rec_month_type'] = $events_data['rec_month_days'] = $events_data['rec_year_type'] = $events_data['rec_year_days'] = $events_data['rec_adv_days'] = $events_data['rec_cust_date'] = '';
        $events_data['formula'] = $events_data['rec_cust_date'] = $events_data['rec_adv_days'] = $events_data['rec_year_days'] = $events_data['rec_year_type'] = $events_data['rec_month_days'] = $events_data['rec_month_type'] = $events_data['rec_week_days'] = $events_data['rec_title_format'] = $events_data['rec_ends_count'] = $events_data['rec_ends_date'] = $events_data['rec_step'] = $events_data['rec_interval'] = '';
        if(!wp_get_post_parent_id($event->em_id)&& !empty($event->em_enable_recurrence)){
            $rec_condition = $this->format_recurring_data($event);
            // $events_data['booking_status'] = $event->em_enable_booking;
            $events_data['rec_interval'] = $rec_condition->em_recurrence_interval;
            $events_data['rec_step'] = $rec_condition->em_recurrence_step;
            // $events_data['rec_ends_date'] = isset($rec_condition->em_recurrence_limit) && !empty($rec_condition->em_recurrence_limit) ? date($ep_functions->ep_get_datepicker_format(),$rec_condition->em_recurrence_limit) : '';
            $events_data['rec_ends_date'] = isset($rec_condition->em_recurrence_limit) && !empty($rec_condition->em_recurrence_limit) ? date($datepicker_format,$rec_condition->em_recurrence_limit) : '';
            $events_data['rec_ends_count'] = $rec_condition->em_recurrence_occurrence_time;
            $events_data['rec_title_format'] = isset($rec_condition->em_add_slug_in_event_title) ? $rec_condition->em_event_slug_type_options.'|'.$rec_condition->em_recurring_events_slug_format :'';
            $events_data['rec_week_days'] = isset($rec_condition->em_selected_weekly_day) && !empty($rec_condition->em_selected_weekly_day) ? implode(' | ',$rec_condition->em_selected_weekly_day) : '';
            $events_data['rec_month_type'] = isset($rec_condition->em_recurrence_monthly_day) ? $rec_condition->em_recurrence_monthly_day : '';
            $events_data['rec_month_days'] = isset($rec_condition->em_recurrence_monthly_weekno) ? $rec_condition->em_recurrence_monthly_weekno.'|'.$rec_condition->em_recurrence_monthly_fullweekday : '';
            
            $events_data['rec_year_type'] = isset($rec_condition->em_recurrence_yearly_day) ? $rec_condition->em_recurrence_yearly_day : '';
            $events_data['rec_year_days'] = isset($rec_condition->em_recurrence_yearly_weekno) ? $rec_condition->em_recurrence_yearly_weekno.'|'.$rec_condition->em_recurrence_yearly_monthday.'|'.$rec_condition->em_recurrence_yearly_fullweekday : '';

            $events_data['rec_adv_days'] = isset($rec_condition->em_recurrence_advanced_dates) && !empty($rec_condition->em_recurrence_advanced_dates) ? implode('|',$rec_condition->em_recurrence_advanced_dates) : '';
            $events_data['rec_cust_date'] = isset($rec_condition->em_recurrence_selected_custom_dates) && !empty($rec_condition->em_recurrence_selected_custom_dates) ? implode('|',$rec_condition->em_recurrence_selected_custom_dates) : '';
            
            
            if($rec_condition->em_recurrence_ends == 'on'){
                    // $stop = date($ep_functions->ep_get_datepicker_format(),$rec_condition->em_recurrence_limit);
                    $stop = date($datepicker_format,$rec_condition->em_recurrence_limit);
            }else{
                    $stop = $rec_condition->em_recurrence_occurrence_time;
            }
            $title_format_on = 0;
            $title_format = '';
            $title_opt='';
            if(isset($rec_condition->em_add_slug_in_event_title)){
                $title_format_on = 1;
                $title_opt = $rec_condition->em_event_slug_type_options;
                $title_format = $rec_condition->em_recurring_events_slug_format;
            }
            if($events_data['rec_interval'] == 'daily'){
                $formula = array(
                    'daily',
                    $events_data['rec_step'],
                    $rec_condition->em_recurrence_ends,
                    $stop,
                    $title_format_on,
                    $title_opt,
                    $title_format
                );
                $events_data['formula'] = implode( ' | ', $formula);
            }
            if($events_data['rec_interval'] == 'weekly'){
                $day_format = isset($rec_condition->em_selected_weekly_day) && !empty($rec_condition->em_selected_weekly_day) ? implode(',',$rec_condition->em_selected_weekly_day) : '';
                
                $formula = array(
                    'weekly',
                    $events_data['rec_step'],
                    $rec_condition->em_recurrence_ends,
                    $stop,
                    $day_format,
                    $title_format_on,
                    $title_opt,
                    $title_format
                );
                $events_data['formula'] = implode( ' | ', $formula);
            }
            if($events_data['rec_interval'] == 'monthly'){
                $date_type = isset($rec_condition->em_recurrence_monthly_day) ? $rec_condition->em_recurrence_monthly_day : 'daily';
                if($date_type=='day'){
                    $rec_month_days = isset($rec_condition->em_recurrence_monthly_weekno) ? $rec_condition->em_recurrence_monthly_weekno.','.$rec_condition->em_recurrence_monthly_fullweekday : '1,1';
                    $formula = array(
                        'monthly',
                        $events_data['rec_step'],
                        $rec_condition->em_recurrence_ends,
                        $stop,
                        $date_type,
                        $rec_month_days,
                        $title_format_on,
                        $title_opt,
                        $title_format
                    );
                }else{
                    $formula = array(
                        'monthly',
                        $events_data['rec_step'],
                        $rec_condition->em_recurrence_ends,
                        $stop,
                        $date_type,
                        $title_format_on,
                        $title_opt,
                        $title_format
                    );
                }
                
                $events_data['formula'] = implode( ' | ', $formula);
            }
            if($events_data['rec_interval'] == 'yearly'){
                $date_type = isset($rec_condition->em_recurrence_yearly_day) ? $rec_condition->em_recurrence_yearly_day : 'daily';
                if($date_type=='day'){
                    $rec_year_days = isset($rec_condition->em_recurrence_yearly_weekno) ? $rec_condition->em_recurrence_yearly_weekno.','.$rec_condition->em_recurrence_yearly_monthday.','.$rec_condition->em_recurrence_yearly_fullweekday : '';
                    $formula = array(
                        'yearly',
                        $events_data['rec_step'],
                        $rec_condition->em_recurrence_ends,
                        $stop,
                        $date_type,
                        $rec_year_days,
                        $title_format_on,
                        $title_opt,
                        $title_format
                    );
                }else{
                    $formula = array(
                        'yearly',
                        $events_data['rec_step'],
                        $rec_condition->em_recurrence_ends,
                        $stop,
                        $date_type,
                        $title_format_on,
                        $title_opt,
                        $title_format
                    );
                }
                
                $events_data['formula'] = implode( ' | ', $formula);
            }
            if($events_data['rec_interval'] == 'advanced'){
                $rec_adv_days = isset($rec_condition->em_recurrence_advanced_dates) && !empty($rec_condition->em_recurrence_advanced_dates) ? implode(',',$rec_condition->em_recurrence_advanced_dates) : '';
            
                $formula = array(
                    'advanced',
                    $events_data['rec_step'],
                    $rec_condition->em_recurrence_ends,
                    $stop,
                    $rec_adv_days,
                    $title_format_on,
                    $title_opt,
                    $title_format
                );
                $events_data['formula'] = implode( ' | ', $formula);
            }
            if($events_data['rec_interval'] == 'custom_dates'){
                $rec_cust_date = isset($rec_condition->em_recurrence_selected_custom_dates) && !empty($rec_condition->em_recurrence_selected_custom_dates) ? implode(',',$rec_condition->em_recurrence_selected_custom_dates) : '';
            
                $formula = array(
                    'custom_dates',
                    $rec_cust_date,
                    $title_format_on,
                    $title_opt,
                    $title_format
                );
                $events_data['formula'] = implode( ' | ', $formula);
            }
        }

        // Attendee checkout fields 
        $events_data['em_event_checkout_attendee_fields'] = [];
        if ( isset($event->em_event_checkout_attendee_fields) && !empty($event->em_event_checkout_attendee_fields) ) {
            // check for name field
            if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name'])) {
                $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name']);
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name_first_name']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name_first_name'])) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name_first_name'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name_first_name']);
                }
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name_first_name_required']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name_first_name_required'])) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name_first_name_required'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name_first_name_required']);
                }
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name_middle_name']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name_middle_name'])) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name_middle_name'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name_middle_name']);
                }
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name_middle_name_required']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name_middle_name_required'])) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name_middle_name_required'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name_middle_name_required']);
                }
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name_last_name']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name_last_name'])) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name_last_name'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name_last_name']);
                }
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_name_last_name_required']) && !empty($event->em_event_checkout_attendee_fields['em_event_checkout_name_last_name_required'])) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_name_last_name_required'] = absint($event->em_event_checkout_attendee_fields['em_event_checkout_name_last_name_required']);
                }
            }
            // check for checkout fields
            if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_fields_data']) && count($event->em_event_checkout_attendee_fields['em_event_checkout_fields_data']) > 0) {
                $events_data['em_event_checkout_attendee_fields']['em_event_checkout_fields_data'] = array();
                foreach ($event->em_event_checkout_attendee_fields['em_event_checkout_fields_data'] as $cfd) {
                    $cfd->option_data = "";
                    if ( in_array( $cfd->type, $checkout_fields_type_with_option_data ) ) {
                        $field_data = $ep_functions->get_checkout_field_by_id($cfd->id);
                        $cfd->option_data = maybe_unserialize($field_data->option_data);
                    }
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_fields_data'][] = json_encode($cfd);
                }
                // get required field data
                if (isset($event->em_event_checkout_attendee_fields['em_event_checkout_fields_data_required']) && count($event->em_event_checkout_attendee_fields['em_event_checkout_fields_data_required']) > 0) {
                    $events_data['em_event_checkout_attendee_fields']['em_event_checkout_fields_data_required'] = array();
                    foreach ($event->em_event_checkout_attendee_fields['em_event_checkout_fields_data_required'] as $cfdr) {
                        $events_data['em_event_checkout_attendee_fields']['em_event_checkout_fields_data_required'][] = absint($cfdr);
                    }
                }
            }
        }
        $events_data['em_event_checkout_attendee_fields'] = !empty($events_data['em_event_checkout_attendee_fields']) ? maybe_serialize($events_data['em_event_checkout_attendee_fields']) : '';

        // T & C field  
        $events_data['em_event_checkout_fixed_fields'] = [];
        if (isset($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_enabled']) && absint($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_enabled']) == 1) {
            $events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_enabled'] = $event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_enabled'];
            if (isset($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_label'])) {
                $events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_label'] = sanitize_text_field($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_label']);
            }
            if (isset($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_option'])) {
                $events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_option'] = sanitize_text_field($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_option']);
            }
            if (isset($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_content'])) {
                if ($events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_option'] == 'page') {
                    $events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_content'] = absint($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_content']);
                } else if ($events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_option'] == 'content') {
                    $events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_content'] = wp_kses_post($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_content']);
                } else {
                    $events_data['em_event_checkout_fixed_fields']['em_event_checkout_fixed_terms_content'] = sanitize_text_field($event->em_event_checkout_fixed_fields['em_event_checkout_fixed_terms_content']);
                }
            }
        }
        $events_data['em_event_checkout_fixed_fields'] = !empty($events_data['em_event_checkout_fixed_fields']) ? maybe_serialize($events_data['em_event_checkout_fixed_fields']) : '';

        // Booking checkout fields 
        $events_data['em_event_checkout_booking_fields'] = [];
        if (isset($event->em_event_checkout_booking_fields['em_event_booking_fields_data']) && count($event->em_event_checkout_booking_fields['em_event_booking_fields_data']) > 0) {
            $events_data['em_event_checkout_booking_fields']['em_event_booking_fields_data'] = array();
            foreach ($event->em_event_checkout_booking_fields['em_event_booking_fields_data'] as $cfd) {
                $cfd->option_data = "";
                if ( in_array( $cfd->type, $checkout_fields_type_with_option_data ) ) {
                    $field_data = $ep_functions->get_checkout_field_by_id($cfd->id);
                    $cfd->option_data = maybe_unserialize($field_data->option_data);
                }
                $events_data['em_event_checkout_booking_fields']['em_event_booking_fields_data'][] = json_encode($cfd);
            }
            // get required field data
            if (isset($event->em_event_checkout_booking_fields['em_event_booking_fields_data_required']) && count($event->em_event_checkout_booking_fields['em_event_booking_fields_data_required']) > 0) {
                $events_data['em_event_checkout_booking_fields']['em_event_booking_fields_data_required'] = array();
                foreach ($event->em_event_checkout_booking_fields['em_event_booking_fields_data_required'] as $cfdr) {
                    $events_data['em_event_checkout_booking_fields']['em_event_booking_fields_data_required'][] = absint($cfdr);
                }
            }
        }
        $events_data['em_event_checkout_booking_fields'] = !empty($events_data['em_event_checkout_booking_fields']) ? maybe_serialize($events_data['em_event_checkout_booking_fields']) : '';

        // Event-type meta (Single)
        $events_data['event_type_meta'] = '';
        if ( isset($event->event_type_details) && !empty($event->event_type_details) ) {
            $events_data['event_type_meta'] = maybe_serialize($event->event_type_details);
        }

        // Venue meta (Single)
        $events_data['venue_meta'] = '';
        if ( isset($event->venue_details) && !empty($event->venue_details) ) {
            $events_data['venue_meta'] = maybe_serialize($event->venue_details);
        }

        // Organizer meta (Multiple | Array)
        $events_data['organizers_meta'] = '';
        if ( isset($event->organizer_details) && !empty($event->organizer_details) ) {
            $events_data['organizers_meta'] = maybe_serialize($event->organizer_details);
        }

        // Performer meta (Multiple | Array)
        $events_data['performers_meta'] = '';
        if ( isset($event->performer_details) && !empty($event->performer_details) ) {
            $events_data['performers_meta'] = maybe_serialize($event->performer_details);
        }

        return $events_data;
                
    }
    
    public function ep_export_events_xml($start_date, $end_date){
        $remove_keys = array("seats", "enable_recurrence", "recurrence_interval", "recurrence_step", "recurrence_limit", "selected_weekly_day", "monthly_weekno", "monthly_fullweekday", "monthly_month", "yearly_weekno", "yearly_fullweekday", "yearly_monthday", "is_daily_event", "is_weekly_recurrence", "is_monthly_recurrence", "is_advanced_recurrence", "advanced_month", "advanced_recurr", "is_yearly_recurrence", "is_custom_dates_recurrence", "recurrence_custom_dates", "enable_recurrence_automatic_booking", "child_exists", "organizer_name","_edit_lock","_edit_last");
        
        $ep_dbhandler = new EP_DBhandler(); 
        $ep_functions = new Eventprime_Basic_Functions();
        // global $wpdb;
        // $table_name = $wpdb->prefix . 'eventprime_ticket_categories'; 

        // $query = "SELECT * FROM $table_name";
        // $results = $wpdb->get_results($query);
        $results = $ep_dbhandler->get_all_result( 'TICKET_CATEGORIES', '*' ); 

        // $price_table = $wpdb->prefix. 'em_price_options';
        // $ticket_prices = $wpdb->get_results("SELECT * FROM $price_table");
        $ticket_prices = $ep_dbhandler->get_all_result( 'TICKET', '*' ); 

        $args['orderby']='date';
        $args['order']='ASC';
        $args['post_parent'] = 0;
        $args['meta_query'] = array(	
                'relation'     => 'AND',
                array(
                    'key'      => 'em_start_date',
                    'value'    => $start_date,
                    'compare'  => '>='
                ),
                array(
                    'key'      => 'em_end_date',
                    'value'    => $end_date,
                    'compare'  => '<='
                ),
            );
        $events = $ep_functions->get_events_post_data($args);
        $output = array();
        foreach($events->posts as $event) {
            $single_event = array();
            $single_event['id']= $event->em_id;
            $single_event['title'] = $event->em_name;
            $single_event['parent'] = '';
            if(wp_get_post_parent_id($event->em_id)){
                $single_event['parent'] = get_the_title(wp_get_post_parent_id($event->em_id));
            }
            $single_event['desc'] = $event->description;
            $single_event['start_date'] = isset($event->em_start_date) ? $ep_functions->ep_timestamp_to_date($event->em_start_date): '';
            $single_event['end_date'] = isset($event->em_end_date) ? $ep_functions->ep_timestamp_to_date($event->em_end_date): '';
            $single_event['start_time'] = isset($event->em_start_time) ? $event->em_start_time: '';
            $single_event['end_time'] = isset($event->em_end_time) ? $event->em_end_time: '';
            $single_event['all_day'] = isset($event->em_all_day) ? $event->em_all_day : 0;
            if($event->em_enable_booking =='external_bookings'){
                $single_event['link'] = isset($event->em_custom_link) ? $event->em_custom_link : '';
            }else{
            $single_event['link'] = get_permalink($event->em_id);

            }
            if(isset($event->em_event_type) && !empty($event->em_event_type)){
                $event_type = $ep_functions->get_single_event_type($event->em_event_type);
                if(!empty($event_type)){
                    $single_event['event_type_object'] = $event_type;
                    $single_event['event_type'] = $event_type->name;
                }
            }

            $single_event['price'] ='';
            $single_event['hide_booking_status'] = '';
            $single_event['allow_cancellations'] = '';
            $single_event['ticket_category_name'] = '';
            $single_event['ticket_category_capacity'] = '';
            $single_event['ticket_type_name'] = '';
            $single_event['ticket_type_price'] = '';
            $single_event['ticket_type_capacity'] = '';
            if($event->em_enable_booking =='bookings_on'){
            $single_event['price'] = isset($event->em_fixed_event_price) ? $event->em_fixed_event_price : '';
            $single_event['hide_booking_status'] = $event->em_hide_booking_status;
            $single_event['allow_cancellations'] = $event->em_allow_cancellations;
            if ($results) {
                foreach ($results as $row) {
                    if ($row->event_id == $event->em_id) {
                    $name = $row->name;
                    $capacity = $row->capacity;
                    $single_event['ticket_category_name'] .= ($single_event['ticket_category_name'] !== '') ? ', ' . $name : $name; 
                    $single_event['ticket_category_capacity'] .= ($single_event['ticket_category_capacity'] !== '') ? ', ' . $capacity : $capacity; 
                    }                    
                }
            }
            if($ticket_prices)
            {
                foreach ($ticket_prices as $row) {
                    if ($row->event_id == $event->em_id) {
                    $name = $row->name;
                    $price = $row->price;
                    $capacity = $row->capacity;
                    $single_event['ticket_type_name'] .= ($single_event['ticket_type_name'] !== '') ? ', ' . $name : $name; 
                    $single_event['ticket_type_price'] .= ($single_event['ticket_type_price'] !== '') ? ', ' . $price : $price; 
                    $single_event['ticket_type_capacity'] .= ($single_event['ticket_type_capacity'] !== '') ? ', ' . $capacity : $capacity;
                    }
                }
            }
            }
            

            
            if(isset($event->em_venue) && !empty($event->em_venue)){
                $venue = $ep_functions->get_single_venue($event->em_venue[0]);
                if(!empty($venue)){
                    $single_event['venue_object'] = $venue;
                    $single_event['venue'] = $venue->name;
                    $single_event['address'] = $venue->em_address;
                    $single_event['lat'] = $venue->em_lat;
                    $single_event['lng'] = $venue->em_lng;
                    if(isset($venue->em_type) && $venue->em_type =='seats'){
                        $single_event['seat_capicity'] = isset($venue->seating_capacity) ? $venue->seating_capacity : '';
                    }
                    if($venue->em_seating_organizer){
                        $single_event['operator'] = $venue->em_seating_organizer;
                    }
                }
            }
            $event_performer_name_onject = array();
            $event_performer_name = array();
            if(isset($event->em_performer) && !empty($event->em_performer)){
                foreach ($event->em_performer as $performer) {
                    $event_performer = $ep_functions->get_single_performer($performer); 
                    if(!empty($event_performer)){
                        $event_performer_name_onject[] = $event_performer;
                        $event_performer_name[] = $event_performer->name;
                    }
                }
                $single_event['performer'] = $event_performer_name;
                $single_event['performer_object'] = $event_performer_name_onject;
            }
            
            $event_organizer_object = array();
            $event_organizer_name = array();
            $event_organizer_phones = array();
            $event_organizer_emails = array();
            $event_organizer_websites = array();
            if(isset($event->em_organizer) && !empty($event->em_organizer)){
                if(is_serialized($event->em_organizer)):
                    $event->em_organizer = unserialize($event->em_organizer); 
                endif;
                foreach ($event->em_organizer as $organizer) {
                    $event_organizer = $ep_functions->get_single_organizer($organizer);
                    if(!empty($event_organizer)){
                        $event_organizer_object[] = $event_organizer;
                        $event_organizer_name[] = $event_organizer->name;
                        if(isset($event_organizer->em_organizer_phones) && !empty($event_organizer->em_organizer_phones)){
                            $event_organizer_phones[] = implode(", ", $event_organizer->em_organizer_phones);
                        }
                        if(isset($event_organizer->em_organizer_emails) && !empty($event_organizer->em_organizer_emails)){
                            $event_organizer_emails[] = implode(", ", $event_organizer->em_organizer_emails);  
                        }
                        if(isset($event_organizer->em_organizer_websites) && !empty($event_organizer->em_organizer_websites)){
                            $event_organizer_websites[] = implode(", ", $event_organizer->em_organizer_websites);
                        }
                    }
                }
                $single_event['organizer_object'] = $event_organizer_object;
                $single_event['organizer'] = implode(" | ", array_filter($event_organizer_name));
                $single_event['organizer_phones'] = implode(" | ", array_filter($event_organizer_phones));
                $single_event['organizer_emails'] = implode(" | ", array_filter($event_organizer_emails));
                $single_event['organizer_websites'] = implode(" | ", array_filter($event_organizer_websites));
            }
            $em_recurrence_interval = get_post_meta( $event->em_id, 'em_recurrence_interval', true );
            if( ! empty( $em_recurrence_interval ) && strpos( $em_recurrence_interval, '_' ) === true ) {
                $em_recurrence_interval = implode(' ', explode('_', $em_recurrence_interval) );
            }
            $single_event['recurring'] = ( ! empty( $em_recurrence_interval ) ? ucwords( $em_recurrence_interval ) : '' );
            $single_event['recurring_condition'] = $this->format_recurring_data($event);
            $events_recurring = array();
            $child_events = $ep_functions->ep_get_child_events($event->em_id);
            if(!empty($child_events) && count($child_events)){
                foreach($child_events as $event){
                    $row_data = $this->ep_format_json_xml_rows($event);
                    $events_recurring[] = $row_data;
                    
                }
            }
            if(count($events_recurring)){
                $single_event['child_events'] = (object)$events_recurring;   
            }
            $eventData = (object) $single_event;
            $output[] = $eventData;
        }
        $xml_feed = $this->convert_to_xml(array('events' => $output));
        header('Content-type: application/force-download; charset=utf-8'); 
        header('Content-Disposition: attachment; filename="ep-events-'.date('YmdTHi').'.xml"');
        echo $xml_feed;
        exit;
    }
    public function ep_export_events_json($start_date, $end_date){
        $remove_keys = array("seats", "enable_recurrence", "recurrence_interval", "recurrence_step", "recurrence_limit", "selected_weekly_day", "monthly_weekno", "monthly_fullweekday", "monthly_month", "yearly_weekno", "yearly_fullweekday", "yearly_monthday", "is_daily_event", "is_weekly_recurrence", "is_monthly_recurrence", "is_advanced_recurrence", "advanced_month", "advanced_recurr", "is_yearly_recurrence", "is_custom_dates_recurrence", "recurrence_custom_dates", "enable_recurrence_automatic_booking", "child_exists", "organizer_name","_edit_lock","_edit_last");
        
        $ep_dbhandler = new EP_DBhandler(); 
        $ep_functions = new Eventprime_Basic_Functions(); 
        // global $wpdb;
        // $table_name = $wpdb->prefix . 'eventprime_ticket_categories'; 

        // $query = "SELECT * FROM $table_name";
        // $results = $wpdb->get_results($query);
        $results = $ep_dbhandler->get_all_result( 'TICKET_CATEGORIES', '*' ); 

        // $price_table = $wpdb->prefix. 'em_price_options';
        // $ticket_prices = $wpdb->get_results("SELECT * FROM $price_table");
        $ticket_prices = $ep_dbhandler->get_all_result( 'TICKET', '*' ); 

        $args['orderby']='date';
        $args['order']='ASC';
        $args['post_parent'] = 0;
        $args['meta_query'] = array(	
            'relation'     => 'AND',
            array(
                'key'      => 'em_start_date',
                'value'    => $start_date,
                'compare'  => '>='
            ),
            array(
                'key'      => 'em_end_date',
                'value'    => $end_date,
                'compare'  => '<='
            ),
        );
        $events = $ep_functions->get_events_post_data($args);
        $output = array();
        foreach($events->posts as $event) {
            //$eventData = $event;
            //$single_event = (array) $eventData;
            $single_event = array();
            $single_event['id']= $event->em_id;
            $single_event['title'] = $event->em_name;
            $single_event['parent'] = '';
            if(wp_get_post_parent_id($event->em_id)){
                $single_event['parent'] = get_the_title(wp_get_post_parent_id($event->em_id));
            }
            $single_event['desc'] = $event->description;
            $single_event['start_date'] = isset($event->em_start_date) ? $ep_functions->ep_timestamp_to_date($event->em_start_date): '';
            $single_event['end_date'] = isset($event->em_end_date) ? $ep_functions->ep_timestamp_to_date($event->em_end_date): '';
            $single_event['start_time'] = isset($event->em_start_time) ? $event->em_start_time: '';
            $single_event['end_time'] = isset($event->em_end_time) ? $event->em_end_time: '';
            $single_event['all_day'] = isset($event->em_all_day) ? $event->em_all_day : 0;
            if($event->em_enable_booking =='external_bookings'){
                $single_event['link'] = isset($event->em_custom_link) ? $event->em_custom_link : '';
            }else{
            $single_event['link'] = get_permalink($event->em_id);

            }
            if(isset($event->em_event_type) && !empty($event->em_event_type)){
                $event_type = $ep_functions->get_single_event_type($event->em_event_type);
                if(!empty($event_type)){
                    $single_event['event_type_object'] = $event_type;
                    $single_event['event_type'] = $event_type->name;
                }
            }

            $single_event['price'] ='';
            $single_event['hide_booking_status'] = '';
            $single_event['allow_cancellations'] = '';
            $single_event['ticket_category_name'] = '';
            $single_event['ticket_category_capacity'] = '';
            $single_event['ticket_type_name'] = '';
            $single_event['ticket_type_price'] = '';
            $single_event['ticket_type_capacity'] = '';
            if($event->em_enable_booking =='bookings_on'){
                $single_event['price'] = isset($event->em_fixed_event_price) ? $event->em_fixed_event_price : '';
                $single_event['hide_booking_status'] = $event->em_hide_booking_status;
                $single_event['allow_cancellations'] = $event->em_allow_cancellations;
                if ($results) {
                    foreach ($results as $row) {
                        if ($row->event_id == $event->em_id) {
                            $name = $row->name;
                            $capacity = $row->capacity;
                            $single_event['ticket_category_name'] .= ($single_event['ticket_category_name'] !== '') ? ', ' . $name : $name; 
                            $single_event['ticket_category_capacity'] .= ($single_event['ticket_category_capacity'] !== '') ? ', ' . $capacity : $capacity; 
                        }                    
                    }
                }
                if($ticket_prices){
                    foreach ($ticket_prices as $row) {
                        if ($row->event_id == $event->em_id) {
                            $name = $row->name;
                            $price = $row->price;
                            $capacity = $row->capacity;
                            $single_event['ticket_type_name'] .= ($single_event['ticket_type_name'] !== '') ? ', ' . $name : $name; 
                            $single_event['ticket_type_price'] .= ($single_event['ticket_type_price'] !== '') ? ', ' . $price : $price; 
                            $single_event['ticket_type_capacity'] .= ($single_event['ticket_type_capacity'] !== '') ? ', ' . $capacity : $capacity;
                        }
                    }
                }
            }

            if(isset($event->em_venue) && !empty($event->em_venue)){
                $venue = $ep_functions->get_single_venue($event->em_venue[0]);
                if(!empty($venue)){
                    $single_event['venue_object'] = $venue;
                    $single_event['venue'] = $venue->name;
                    $single_event['address'] = isset( $venue->em_address ) ? $venue->em_address : '';
                    $single_event['lat'] = isset( $venue->em_lat ) ? $venue->em_lat : '';
                    $single_event['lng'] = isset( $venue->em_lng ) ? $venue->em_lng : '';
                    if(isset($venue->em_type) && $venue->em_type =='seats'){
                        $single_event['seat_capicity'] = isset($venue->seating_capacity) ? $venue->seating_capacity : '';
                    }
                    // if($venue->em_seating_organizer){
                        $single_event['operator'] = isset( $venue->em_seating_organizer ) ? $venue->em_seating_organizer : '';
                    // }
                }
            }
            $event_performer_name_onject = array();
            $event_performer_name = array();
            if(isset($event->em_performer) && !empty($event->em_performer)){
                foreach ($event->em_performer as $performer) {
                    $event_performer = $ep_functions->get_single_performer($performer);
                    if(!empty($event_performer)){
                        $event_performer_name_onject[] = $event_performer;
                        $event_performer_name[] = $event_performer->name;
                    }
                }
                $single_event['performer'] = $event_performer_name;
                $single_event['performer_object'] = $event_performer_name_onject;
            }
            
            $event_organizer_object = array();
            $event_organizer_name = array();
            $event_organizer_phones = array();
            $event_organizer_emails = array();
            $event_organizer_websites = array();
            if(isset($event->em_organizer) && !empty($event->em_organizer)){
                if(is_serialized($event->em_organizer)):
                    $event->em_organizer = unserialize($event->em_organizer); 
                endif;
                foreach ($event->em_organizer as $organizer) {
                    $event_organizer = $ep_functions->get_single_organizer($organizer);
                    if(!empty($event_organizer)){
                        $event_organizer_object[] = $event_organizer;
                        $event_organizer_name[] = $event_organizer->name;
                        if(isset($event_organizer->em_organizer_phones) && !empty($event_organizer->em_organizer_phones)){
                            $event_organizer_phones[] = implode(", ", $event_organizer->em_organizer_phones);
                        }
                        if(isset($event_organizer->em_organizer_emails) && !empty($event_organizer->em_organizer_emails)){
                            $event_organizer_emails[] = implode(", ", $event_organizer->em_organizer_emails);  
                        }
                        if(isset($event_organizer->em_organizer_websites) && !empty($event_organizer->em_organizer_websites)){
                            $event_organizer_websites[] = implode(", ", $event_organizer->em_organizer_websites);
                        }
                    }
                }
                $single_event['organizer_object'] = $event_organizer_object;
                $single_event['organizer'] = implode(" | ", array_filter($event_organizer_name));
                $single_event['organizer_phones'] = implode(" | ", array_filter($event_organizer_phones));
                $single_event['organizer_emails'] = implode(" | ", array_filter($event_organizer_emails));
                $single_event['organizer_websites'] = implode(" | ", array_filter($event_organizer_websites));
            }
            $em_recurrence_interval = get_post_meta( $event->em_id, 'em_recurrence_interval', true );
            if( ! empty( $em_recurrence_interval ) && strpos( $em_recurrence_interval, '_' ) === true ) {
                $em_recurrence_interval = implode(' ', explode('_', $em_recurrence_interval) );
            }
            $single_event['recurring'] = ( ! empty( $em_recurrence_interval ) ? ucwords( $em_recurrence_interval ) : '' );
            $single_event['recurring_condition'] = $this->format_recurring_data($event);
            
            $events_recurring = array();
            $child_events = $ep_functions->ep_get_child_events($event->em_id);
            if(!empty($child_events) && count($child_events)){
                foreach($child_events as $event){
                    $row_data = $this->ep_format_json_xml_rows($event);
                    $events_recurring[] = $row_data;
                    
                }
            }
            if(count($events_recurring)){
                $single_event['child_events'] = (object)$events_recurring;   
            }
            $eventData = (object) $single_event;
            $output[] = $eventData;
        }
        header('Content-type: application/force-download; charset=utf-8'); 
        header('Content-Disposition: attachment; filename="ep-events-'.date('YmdTHi').'.json"');
        echo json_encode($output);
    }

    public function ep_format_json_xml_rows($event){
        $ep_functions = new Eventprime_Basic_Functions(); 
        
        $single_event = array();
        $single_event['id']= $event->em_id;
        $single_event['title'] = $event->em_name;
        $single_event['parent'] = '';
        if(wp_get_post_parent_id($event->em_id)){
            $single_event['parent'] = get_the_title(wp_get_post_parent_id($event->em_id));
        }
        $single_event['desc'] = $event->description;
        $single_event['start_date'] = isset($event->em_start_date) ? $ep_functions->ep_timestamp_to_date($event->em_start_date): '';
        $single_event['end_date'] = isset($event->em_end_date) ? $ep_functions->ep_timestamp_to_date($event->em_end_date): '';
        $single_event['start_time'] = isset($event->em_start_time) ? $event->em_start_time: '';
        $single_event['end_time'] = isset($event->em_end_time) ? $event->em_end_time: '';
        $single_event['all_day'] = isset($event->em_all_day) ? $event->em_all_day : 0;
        if($event->em_enable_booking =='external_bookings'){
            $single_event['link'] = isset($event->em_custom_link) ? $event->em_custom_link : '';
        }else{
        $single_event['link'] = get_permalink($event->em_id);

        }
        
        if(isset($event->em_event_type) && !empty($event->em_event_type)){
            $event_type = $ep_functions->get_single_event_type($event->em_event_type);
            if(!empty($event_type)){
                $single_event['event_type_object'] = $event_type;
                $single_event['event_type'] = $event_type->name;
            }
        }
        $single_event['price'] ='';
        if($event->em_enable_booking =='bookings_on'){
            $single_event['price'] = isset($event->em_fixed_event_price) ? $event->em_fixed_event_price : '';
        }
        if(isset($event->em_venue) && !empty($event->em_venue)){
            $venue = $ep_functions->get_single_venue($event->em_venue[0]);
            if(!empty($venue)){
                $single_event['venue_object'] = $venue;
                $single_event['venue'] = $venue->name;
                $single_event['address'] = $venue->em_address;
                $single_event['lat'] = $venue->em_lat;
                $single_event['lng'] = $venue->em_lng;
                if(isset($venue->em_type) && $venue->em_type =='seats'){
                    $single_event['seat_capicity'] = isset($venue->seating_capacity) ? $venue->seating_capacity : '';
                }
                if($venue->em_seating_organizer){
                    $single_event['operator'] = $venue->em_seating_organizer;
                }
            }
        }
        $event_performer_name_onject = array();
        $event_performer_name = array();
        if(isset($event->em_performer) && !empty($event->em_performer)){
            foreach ($event->em_performer as $performer) {
                $event_performer = $ep_functions->get_single_performer($performer);
                if(!empty($event_performer)){
                    $event_performer_name_onject[] = $event_performer;
                    $event_performer_name[] = $event_performer->name;
                }
            }
            $single_event['performer'] = $event_performer_name;
            $single_event['performer_object'] = $event_performer_name_onject;
        }
        
        $event_organizer_object = array();
        $event_organizer_name = array();
        $event_organizer_phones = array();
        $event_organizer_emails = array();
        $event_organizer_websites = array();
        if(isset($event->em_organizer) && !empty($event->em_organizer)){
            if(is_serialized($event->em_organizer)):
                $event->em_organizer = unserialize($event->em_organizer); 
            endif;
            foreach ($event->em_organizer as $organizer) {
                $event_organizer = $ep_functions->get_single_organizer($organizer);
                if(!empty($event_organizer)){
                    $event_organizer_object[] = $event_organizer;
                    $event_organizer_name[] = $event_organizer->name;
                    if(isset($event_organizer->em_organizer_phones) && !empty($event_organizer->em_organizer_phones)){
                        $event_organizer_phones[] = implode(", ", $event_organizer->em_organizer_phones);
                    }
                    if(isset($event_organizer->em_organizer_emails) && !empty($event_organizer->em_organizer_emails)){
                        $event_organizer_emails[] = implode(", ", $event_organizer->em_organizer_emails);  
                    }
                    if(isset($event_organizer->em_organizer_websites) && !empty($event_organizer->em_organizer_websites)){
                        $event_organizer_websites[] = implode(", ", $event_organizer->em_organizer_websites);
                    }
                }
            }
            $single_event['organizer_object'] = $event_organizer_object;
            $single_event['organizer'] = implode(" | ", array_filter($event_organizer_name));
            $single_event['organizer_phones'] = implode(" | ", array_filter($event_organizer_phones));
            $single_event['organizer_emails'] = implode(" | ", array_filter($event_organizer_emails));
            $single_event['organizer_websites'] = implode(" | ", array_filter($event_organizer_websites));
        }
        $em_recurrence_interval = get_post_meta( $event->em_id, 'em_recurrence_interval', true );
        if( ! empty( $em_recurrence_interval ) && strpos( $em_recurrence_interval, '_' ) === true ) {
            $em_recurrence_interval = implode(' ', explode('_', $em_recurrence_interval) );
        }
        $single_event['recurring'] = ( ! empty( $em_recurrence_interval ) ? ucwords( $em_recurrence_interval ) : '' );
        return (object)$single_event;
    }

    public function ep_export_events_ical($start_date, $end_date){
        $remove_keys = array("seats", "enable_recurrence", "recurrence_interval", "recurrence_step", "recurrence_limit", "selected_weekly_day", "monthly_weekno", "monthly_fullweekday", "monthly_month", "yearly_weekno", "yearly_fullweekday", "yearly_monthday", "is_daily_event", "is_weekly_recurrence", "is_monthly_recurrence", "is_advanced_recurrence", "advanced_month", "advanced_recurr", "is_yearly_recurrence", "is_custom_dates_recurrence", "recurrence_custom_dates", "enable_recurrence_automatic_booking", "child_exists", "organizer_name","_edit_lock","_edit_last");
        
        $ep_functions = new Eventprime_Basic_Functions();
        $args['orderby']='date';
        $args['order']='ASC';
        $args['post_parent'] = 0;
        $args['meta_query'] = array(	
                'relation'     => 'AND',
                array(
                    'key'      => 'em_start_date',
                    'value'    => $start_date,
                    'compare'  => '>='
                ),
                array(
                    'key'      => 'em_end_date',
                    'value'    => $end_date,
                    'compare'  => '<='
                ),
            );
	    $events = $ep_functions->get_events_post_data($args);
        $output = '';
        foreach($events->posts as $event){
            $output .= $this->ix_get_single_ical($event);                
        }
        $ical_calendar = $this->ix_ical_calendar($output);
        header('Content-type: application/force-download; charset=utf-8'); 
        header('Content-Disposition: attachment; filename="ep-events-'.date('YmdTHi').'.ics"');
        echo $ical_calendar;
        exit;
    }
    public function em_ix_file_export() {
        $ep_functions = new Eventprime_Basic_Functions(); 
        $file_format =sanitize_text_field($_POST['ep_export_file_format']);
        $start_date = sanitize_text_field($_POST['ep-ex-file-start-date']);
        $end_date = sanitize_text_field($_POST['ep-ex-file-end-date']);
        $format = $ep_functions->ep_get_datepicker_format();
        if(!empty($start_date)){
            $start_date = $ep_functions->ep_date_to_timestamp($start_date,$format);
        }else{
            $start_date = $ep_functions->ep_date_to_timestamp(date($format, strtotime("-1 Days")),$format);
        }
        if(!empty($end_date)){
            $end_date = $ep_functions->ep_date_to_timestamp($end_date,$format);
        }else{
            $end_date = $ep_functions->ep_date_to_timestamp(date($format, strtotime("+15 Days")),$format);
        }
        // echo $ep_functions->ep_timestamp_to_date($start_date); 
        // die; 
        if(!empty($file_format)){
            switch($file_format){
                case 'csv':
                    return $this->ep_export_events_csv($start_date, $end_date);
                    break;
                case 'xml':
                    return $this->ep_export_events_xml($start_date, $end_date); 
                    break;
                case 'json':
                    return $this->ep_export_events_json($start_date, $end_date);
                    break;
                case 'ical':
                    return $this->ep_export_events_ical($start_date, $end_date);
                    break;
                default:
                    return $this->ep_export_events_csv($start_date, $end_date);
            }
        }
        
    }
    
    public function ix_get_single_ical($event) {
        
        $ep_functions = new Eventprime_Basic_Functions(); 
        
        $event_url = $ep_functions->ep_get_custom_page_url( 'events_page', $event->id, 'event' );
        $format = $ep_functions->ep_get_datepicker_format();
        $ical = "BEGIN:VEVENT"."\r\n";
        $ical .= "UID:EP-".md5(strval($event->id))."@".$ep_functions->ep_get_site_domain()."\r\n";
        $start_time = isset($event->em_start_time) ? $event->em_start_time: '';
        $end_time = isset($event->em_end_time) ? $event->em_end_time: '';
        $start_date_time = $ep_functions->ep_datetime_to_timestamp(date($format, $event->em_start_date).' '.$start_time, $format.' h:i a'); 
        $end_date_time = $ep_functions->ep_datetime_to_timestamp(date($format, $event->em_end_date).' '.$end_time,$format.' h:i a'); 
        $ical .= "DTSTART:".gmdate('Ymd\\THi00', $start_date_time)."\r\n";
        $ical .= "DTEND:".gmdate('Ymd\\THi00', $end_date_time)."\r\n";
        if(isset($event->em_enable_recurrence) && !empty($event->em_enable_recurrence)){
            $days = array('SU','MO','TU','WE','TH','FR','SA');
            $days_adv = array('sun'=>'SU','mon'=>'MO','tue'=>'TU','wed'=>'WE','thu'=>'TH','fri'=>'FR','sat'=>'SA');
            $em_recurrence_step = $event->em_recurrence_step;
            $em_recurrence_interval = $event->em_recurrence_interval;
            $em_recurrence_ends = $event->em_recurrence_ends;
            $em_recurrence_limit = isset($event->em_recurrence_limit) ? $event->em_recurrence_limit : '';
            $em_recurrence_occurrence_time = isset($event->em_recurrence_occurrence_time) ? $event->em_recurrence_occurrence_time : '';
            if($em_recurrence_interval =='daily' && $em_recurrence_ends=='after'){
                $ical .= "RRULE:FREQ=DAILY;COUNT=".$em_recurrence_occurrence_time.";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='daily' && $em_recurrence_ends=='on'){
                $ical .="RRULE:FREQ=DAILY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='weekly' && $em_recurrence_ends=='after'){
                $day = isset($event->em_selected_weekly_day) ? $event->em_selected_weekly_day : array(); 
                $day_list = array();
                if(!empty($day)){
                    foreach($day as $day){
                        $day_list[] = $days[$day];
                    }
                }
                $days_re = implode(',',$day_list);
                $ical .= "RRULE:FREQ=WEEKLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".$days_re.";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='weekly' && $em_recurrence_ends=='on'){
                $day = isset($event->em_selected_weekly_day) ? $event->em_selected_weekly_day : array(); 
                $day_list = array();
                if(!empty($day)){
                    foreach($day as $day){
                        $day_list[] = $days[$day];
                    }
                }
                $days_re = implode(',',$day_list);
                $ical .="RRULE:FREQ=WEEKLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";BYDAY=".$days_re.";INTERVAL=".$em_recurrence_step."\r\n";
            }elseif($em_recurrence_interval =='monthly' && $em_recurrence_ends=='after'){
                $em_recurrence_monthly_day = isset($event->em_recurrence_monthly_day) ? $event->em_recurrence_monthly_day : 1; 
                if($em_recurrence_monthly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical .= "RRULE:FREQ=MONTHLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_monthly_weekno) ? $event->em_recurrence_monthly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_monthly_fullweekday) ? $event->em_recurrence_monthly_fullweekday : 1;
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical .= "RRULE:FREQ=MONTHLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='monthly' && $em_recurrence_ends=='on'){
                $em_recurrence_monthly_day = isset($event->em_recurrence_monthly_day) ? $event->em_recurrence_monthly_day : 1; 
                if($em_recurrence_monthly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical .= "RRULE:FREQ=MONTHLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_monthly_weekno) ? $event->em_recurrence_monthly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_monthly_fullweekday) ? $event->em_recurrence_monthly_fullweekday : 1;
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical .="RRULE:FREQ=MONTHLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='yearly' && $em_recurrence_ends=='after'){
                $em_recurrence_yearly_day = isset($event->em_recurrence_yearly_day) ? $event->em_recurrence_yearly_day : 1; 
                if($em_recurrence_yearly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical .= "RRULE:FREQ=YEARLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_yearly_weekno) ? $event->em_recurrence_yearly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_yearly_fullweekday) ? $event->em_recurrence_yearly_fullweekday : 1;
                    $monthCount = isset($event->em_recurrence_yearly_monthday) ? $event->em_recurrence_yearly_monthday : 1;
                    
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical .= "RRULE:FREQ=YEARLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='yearly' && $em_recurrence_ends=='on'){
                $em_recurrence_yearly_day = isset($event->em_recurrence_yearly_day) ? $event->em_recurrence_yearly_day : 1; 
                if($em_recurrence_yearly_day == 'date'){
                    $date = date('d',$end_date_time);
                    $ical .= "RRULE:FREQ=YEARLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";BYMONTHDAY=".$date.";INTERVAL=".$em_recurrence_step."\r\n";
                }else{
                    $weekCount = isset($event->em_recurrence_yearly_weekno) ? $event->em_recurrence_yearly_weekno : 1;
                    $dayCount = isset($event->em_recurrence_yearly_fullweekday) ? $event->em_recurrence_yearly_fullweekday : 1;
                    $monthCount = isset($event->em_recurrence_yearly_monthday) ? $event->em_recurrence_yearly_monthday : 1;
                    $week_days = $weekCount.''.$days[$dayCount];
                    $ical .="RRULE:FREQ=YEARLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";BYDAY=".$week_days.";INTERVAL=".$em_recurrence_step."\r\n";
                }
                
            }elseif($em_recurrence_interval =='advanced' && $em_recurrence_ends=='after'){
                $em_recurrence_advanced_dates = isset($event->em_recurrence_advanced_dates) ? $event->em_recurrence_advanced_dates : array(); 
                if(!empty($em_recurrence_advanced_dates)){
                    $select_weeks = array();
                    foreach($em_recurrence_advanced_dates as $dates){
                        if(!empty($dates)){
                            $date_sle = explode('-',$dates);
                            if($date_sle[1]==5) $date_sle[1] = '-1';
                            $select_weeks[] = $date_sle[1].''.$days_adv[$date_sle[0]];
                        }
                    }
                    $ical .= "RRULE:FREQ=MONTHLY;WKST=SU;COUNT=".$em_recurrence_occurrence_time.";BYDAY=".implode(',',$select_weeks).";INTERVAL=".$em_recurrence_step.";RFRQ=ADVANCED\r\n";
                    
                }
                
            }elseif($em_recurrence_interval =='advanced' && $em_recurrence_ends=='on'){
                $em_recurrence_advanced_dates = isset($event->em_recurrence_advanced_dates) ? $event->em_recurrence_advanced_dates : array(); 
                if(!empty($em_recurrence_advanced_dates)){
                    $select_weeks = array();
                    foreach($em_recurrence_advanced_dates as $dates){
                        if(!empty($dates)){
                            $date_sle = explode('-',$dates);
                            if($date_sle[1]==5) $date_sle[1] = '-1';
                            $select_weeks[] = $date_sle[1].''.$days_adv[$date_sle[0]];
                        }
                    }
                    $ical .="RRULE:FREQ=MONTHLY;WKST=SU;UNTIL=".gmdate('Ymd\\THi00', $em_recurrence_limit).";BYDAY=".implode(',',$select_weeks).";INTERVAL=".$em_recurrence_step.";RFRQ=ADVANCED\r\n";
                    
                }
                
            }
            
            
            
        }
        
        $ical .= "DTSTAMP:".gmdate('Ymd\\THi00')."\r\n";
        $ical .= "CREATED:".get_the_date('Ymd', $event->id)."\r\n";
        $ical .= "DESCRIPTION:".html_entity_decode(trim(strip_tags($event->description)), ENT_NOQUOTES, 'UTF-8')."\r\n";
        $ical .= "LAST-MODIFIED:".get_the_modified_date('Ymd', $event->id)."\r\n";
        // event location
        if (!empty($event->em_venue)) {
            $venue = $ep_functions->get_single_venue($event->em_venue[0]);
            
            if(!empty($venue) && isset($venue->em_address)){                
                $ical .= "LOCATION:".trim(strip_tags($venue->em_address))."\r\n";
            }
        }
        // event type 
        if(isset($event->em_event_type) && !empty($event->em_event_type)){
            $event_type = $ep_functions->get_single_event_type($event->em_event_type);
            if(!empty($event_type)){
                $ical .= "EVENT-TYPE:".trim(strip_tags($event_type->name))."\r\n";
            }
        }
        // event organizer 
        $event_organizer_object = array();
        $event_organizer_name = array();
        $event_organizer_phones = array();
        $event_organizer_emails = array();
        $event_organizer_websites = array();
        if(isset($event->em_organizer) && !empty($event->em_organizer)){
            if(is_serialized($event->em_organizer)):
                $event->em_organizer = unserialize($event->em_organizer); 
            endif;
            foreach ($event->em_organizer as $organizer) {
                $event_organizer = $ep_functions->get_single_organizer($organizer);
                if(!empty($event_organizer)){
                    $event_organizer_object[] = $event_organizer;
                    $event_organizer_name[] = $event_organizer->name;
                    if(isset($event_organizer->em_organizer_phones) && !empty($event_organizer->em_organizer_phones)){
                        $event_organizer_phones[] = implode(", ", $event_organizer->em_organizer_phones);
                    }
                    if(isset($event_organizer->em_organizer_emails) && !empty($event_organizer->em_organizer_emails)){
                        $event_organizer_emails[] = implode(", ", $event_organizer->em_organizer_emails);  
                    }
                    if(isset($event_organizer->em_organizer_websites) && !empty($event_organizer->em_organizer_websites)){
                        $event_organizer_websites[] = implode(", ", $event_organizer->em_organizer_websites);
                    }
                }
            }
            $ical .= "ORGANIZERS:".implode(" | ", array_filter($event_organizer_name))."\r\n";
            $ical .= "ORGANIZERS-PHONES:".implode(" | ", array_filter($event_organizer_phones))."\r\n";
            $ical .= "ORGANIZERS-EMAILS:".implode(" | ", array_filter($event_organizer_emails))."\r\n";
            $ical .= "ORGANIZERS-WEBSITES:".implode(" | ", array_filter($event_organizer_websites))."\r\n";
        }
        // event performer 
        if(isset($event->em_performer) && !empty($event->em_performer)){
            foreach ($event->em_performer as $performer) {
                $event_performer = $ep_functions->get_single_performer($performer);
                if(!empty($event_performer)){
                    $event_performer_name_onject[] = $event_performer;
                    $event_performer_name[] = $event_performer->name;
                }
            }
            $ical .= "PERFORMERS:".implode( ',', $event_performer_name )."\r\n";
        }
        $ical .= "SUMMARY:".html_entity_decode($event->name, ENT_NOQUOTES, 'UTF-8')."\r\n";
        // event attachment
        $cover_image_id = get_post_thumbnail_id($event->id);
        if (!empty($cover_image_id) && $cover_image_id > 0) {
            $cover_image_url = get_the_post_thumbnail_url($event->id, 'full');
            $ical .= "ATTACH;FMTTYPE=".get_post_mime_type($cover_image_id).":".$cover_image_url."\r\n";
        }
        
        
        $ical .= "END:VEVENT"."\r\n";
        
        return $ical;
    }
    
    public function ix_ical_calendar($events_ical) {
        $ical  = "BEGIN:VCALENDAR"."\r\n";
        $ical .= "VERSION:2.0"."\r\n";
        $ical .= "METHOD:PUBLISH"."\r\n";
        $ical .= "CALSCALE:GREGORIAN"."\r\n";
        $ical .= "PRODID:-//WordPress - EPv".EVENTPRIME_VERSION."//EN"."\r\n";
        $ical .= "X-ORIGINAL-URL:".home_url().'/'."\r\n";
        $ical .= $events_ical;
        $ical .= "END:VCALENDAR";
        
        return $ical;
    }

    public function convert_to_xml($data){
        $main_node = array_keys($data);        
        // Creating SimpleXMLElement object
        $xml = new SimpleXMLElement('<?xml version="1.0"?><'.$main_node[0].'></'.$main_node[0].'>');
        // Convert array to xml
        $this->array_to_xml($data[$main_node[0]], $xml);
        // Return XML String
        return $xml->asXML();
    }

    public function array_to_xml($data, &$xml){
        foreach($data as $key => $value){
            if(is_numeric($key)) $key = 'item';

            if(is_array($value)){
                $subnode = $xml->addChild($key);
                $this->array_to_xml($value, $subnode);
            }
            elseif(is_object($value)){
                $subnode = $xml->addChild($key);
                $this->array_to_xml($value, $subnode);
            }
            else{
                $xml->addChild($key, htmlspecialchars($value));
            }
        }
    }
    
    public function format_recurring_data($event){
        $recurring_data = new stdClass();
        if(isset($event->em_enable_recurrence) && !empty($event->em_enable_recurrence)){
            $em_recurrence_step = $event->em_recurrence_step;
            $em_recurrence_interval = $event->em_recurrence_interval;
            $em_recurrence_ends = $event->em_recurrence_ends;
            $em_recurrence_limit = isset($event->em_recurrence_limit) && $em_recurrence_ends=='on' ? $event->em_recurrence_limit : '';
            $em_recurrence_occurrence_time = isset($event->em_recurrence_occurrence_time) && $em_recurrence_ends=='after' ? $event->em_recurrence_occurrence_time : '';
            $recurring_data->em_recurrence_step = $em_recurrence_step;
            $recurring_data->em_recurrence_interval = $em_recurrence_interval;
            $recurring_data->em_recurrence_ends = $em_recurrence_ends;
            $recurring_data->em_recurrence_limit = $em_recurrence_limit; 
            $recurring_data->em_recurrence_occurrence_time = $em_recurrence_occurrence_time;
            
            if(isset($event->em_add_slug_in_event_title) && !empty($event->em_add_slug_in_event_title)){
                $recurring_data->em_add_slug_in_event_title = 1;
                $recurring_data->em_event_slug_type_options = isset($event->em_event_slug_type_options) ? $event->em_event_slug_type_options : 'prefix';
                $recurring_data->em_recurring_events_slug_format = isset($event->em_recurring_events_slug_format) ? $event->em_recurring_events_slug_format : 'number';
                
            }
            if($em_recurrence_interval =='weekly'){
                $em_selected_weekly_day = isset($event->em_selected_weekly_day) ? $event->em_selected_weekly_day : array(); 
                $recurring_data->em_selected_weekly_day = $em_selected_weekly_day;
                
            }elseif($em_recurrence_interval =='monthly'){
                $em_recurrence_monthly_day = isset($event->em_recurrence_monthly_day) ? $event->em_recurrence_monthly_day : 'date'; 
                $weekCount = isset($event->em_recurrence_monthly_weekno) ? $event->em_recurrence_monthly_weekno : 1;
                $dayCount = isset($event->em_recurrence_monthly_fullweekday) ? $event->em_recurrence_monthly_fullweekday : 1;
                if($em_recurrence_monthly_day =='day'){
                    $recurring_data->em_recurrence_monthly_weekno =$weekCount;
                    $recurring_data->em_recurrence_monthly_fullweekday =$dayCount;
                }
                $recurring_data->em_recurrence_monthly_day =$em_recurrence_monthly_day;
                
            }elseif($em_recurrence_interval =='yearly'){
                $em_recurrence_yearly_day = isset($event->em_recurrence_yearly_day) ? $event->em_recurrence_yearly_day : 'date'; 
                $weekCount = isset($event->em_recurrence_yearly_weekno) ? $event->em_recurrence_yearly_weekno : 1;
                $dayCount = isset($event->em_recurrence_yearly_fullweekday) ? $event->em_recurrence_yearly_fullweekday : 1;
                $monthCount = isset($event->em_recurrence_yearly_monthday) ? $event->em_recurrence_yearly_monthday : 1;
                if($em_recurrence_yearly_day =='day'){
                    $recurring_data->em_recurrence_yearly_weekno =$weekCount;
                    $recurring_data->em_recurrence_yearly_fullweekday =$dayCount;
                    $recurring_data->em_recurrence_yearly_monthday =$monthCount;
                }
                $recurring_data->em_recurrence_yearly_day =$em_recurrence_yearly_day;
                
                
            }elseif($em_recurrence_interval =='advanced'){
                $em_recurrence_advanced_dates = isset($event->em_recurrence_advanced_dates) ? $event->em_recurrence_advanced_dates : array(); 
                $recurring_data->em_recurrence_advanced_dates =$em_recurrence_advanced_dates;
            }elseif($em_recurrence_interval =='custom_dates'){
                $em_recurrence_selected_custom_dates = isset($event->em_recurrence_selected_custom_dates) ? $event->em_recurrence_selected_custom_dates : array(); 
                $recurring_data->em_recurrence_selected_custom_dates =$em_recurrence_selected_custom_dates;
            }
            
            
            
        }
        return $recurring_data;
    }
}