<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://https://theeventprime.com
 * @since      1.0.0
 *
 * @package    Eventprime_Event_Import_Export
 * @subpackage Eventprime_Event_Import_Export/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Eventprime_Event_Import_Export
 * @subpackage Eventprime_Event_Import_Export/includes
 * @author     EventPrime <support@metagauss.com>
 */
class Eventprime_Event_Import_Export {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Eventprime_Event_Import_Export_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'EVENTPRIME_EVENT_IMPORT_EXPORT_VERSION' ) ) {
			$this->version = EVENTPRIME_EVENT_IMPORT_EXPORT_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'eventprime-event-import-export';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Eventprime_Event_Import_Export_Loader. Orchestrates the hooks of the plugin.
	 * - Eventprime_Event_Import_Export_i18n. Defines internationalization functionality.
	 * - Eventprime_Event_Import_Export_Admin. Defines all hooks for the admin area.
	 * - Eventprime_Event_Import_Export_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {
            
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-eventprime-event-import-export-activator.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-eventprime-event-import-export-deactivator.php';
	
		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-eventprime-event-import-export-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-eventprime-event-import-export-i18n.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-eventprime-event-import-export-dbhandler.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/controllers/class-eix-controller.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/class-eix-import.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/class-eix-export.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/class-eix-google-import.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/class-eix-google-export.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/class-eix-facebook-import.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/ICal.php';   
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/Event.php';   
        
        if( !class_exists( '\Google\Client' ) ) {   
            require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/services/Google/autoload.php';   
        }
	require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-eventprime-event-import-export-admin.php';

	$this->loader = new Eventprime_Event_Import_Export_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Eventprime_Event_Import_Export_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

        $plugin_i18n = new Eventprime_Event_Import_Export_i18n();

        $this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Eventprime_Event_Import_Export_Admin( $this->get_plugin_name(), $this->get_version() );
        
        $this->loader->add_action( 'admin_menu',$plugin_admin, 'eix_sub_menu',20);
        $this->loader->add_action( 'admin_enqueue_scripts',$plugin_admin, 'enqueue_styles');
        $this->loader->add_action( 'admin_enqueue_scripts',$plugin_admin, 'enqueue_scripts');

		$this->loader->add_action('admin_notices', $plugin_admin, 'ep_plugin_activation_notice_fun');
		$this->loader->add_action('network_admin_notices', $plugin_admin, 'ep_plugin_activation_notice_fun');

        $this->loader->add_action( 'wp_ajax_ep_admin_import_file_upload',$plugin_admin, 'admin_import_file_upload');
        $this->loader->add_action( 'wp_ajax_ep_admin_import_file',$plugin_admin, 'admin_import_file');
        $this->loader->add_action( 'wp_ajax_ep_export_files_events',$plugin_admin, 'export_files_events');
        $this->loader->add_filter('ep_add_general_options', $plugin_admin, 'save_eix_meta_options');
        $this->loader->add_action( 'admin_post_ep_eix_form',$plugin_admin, 'save_import_export_data');
        $this->loader->add_action( 'wp_ajax_ep_admin_save_google_importer',$plugin_admin, 'save_google_importer');
        $this->loader->add_action( 'wp_ajax_ep_admin_import_google_events',$plugin_admin, 'import_selected_google_events');
        $this->loader->add_action( 'wp_ajax_ep_admin_google_gcal_token',$plugin_admin, 'varify_google_gcal_token');
        $this->loader->add_action( 'wp_ajax_ep_admin_save_google_exporter',$plugin_admin, 'save_google_exporter');
        $this->loader->add_action( 'wp_ajax_ep_admin_export_google_events',$plugin_admin, 'export_google_events');

        // $this->loader->add_action( 'wp_ajax_ep_admin_save_facebook_importer',$plugin_admin, 'save_facebook_importer');
        // $this->loader->add_action( 'wp_ajax_ep_admin_import_facebook_events',$plugin_admin, 'import_selected_facebook_events');
        // $this->loader->add_action( 'ep_import_lists',$plugin_admin, 'ep_import_lists');
        // $this->loader->add_action( 'ep_import_lists_settings',$plugin_admin, 'ep_import_lists_settings');

        $this->loader->add_action( 'admin_post_ep_export_files_form',$plugin_admin, 'ep_export_files_form');

        // add global settings options
        $this->loader->add_filter('ep_add_global_setting_options', $plugin_admin, 'ep_add_eix_global_setting_options', 10, 2);

        // ep license module addon
        $this->loader->add_action( 'ep_add_license_setting_blocks',$plugin_admin, 'ep_add_eix_license_setting_block');
        $this->loader->add_filter( 'ep_pupulate_license_item_id',$plugin_admin, 'ep_pupulate_eix_license_item_id', 10, 2); // populate license item id.
        $this->loader->add_filter( 'ep_pupulate_license_item_name',$plugin_admin, 'ep_pupulate_eix_license_item_name', 10, 2); // populate license item name.
        $this->loader->add_action( 'ep_save_license_settings',$plugin_admin, 'ep_save_eix_license_setting', 10, 2);
        
        // third party plugin data import
        $this->loader->add_action( 'wp_ajax_ep_third_party_import_start',$plugin_admin, 'ep_third_party_import_start'); 
		
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		
                
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Eventprime_Event_Import_Export_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
