<?php

/**
 * @link              https://theeventprime.com
 * @since             1.0.0
 * @package           Eventprime_Event_Import_Export
 *
 * @wordpress-plugin
 * Plugin Name:       EventPrime Events Import Export
 * Plugin URI:        https://theeventprime.com
 * Description:       An EventPrime extension that allows to import and export events in popular file formats like CSV, ICS, XML and JSON.
 * Version:           4.2
 * Author:            EventPrime
 * Author URI:        https://theeventprime.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       eventprime-events-import-export
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EVENTPRIME_EVENT_IMPORT_EXPORT_VERSION', '4.2' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-eventprime-event-import-export-activator.php
 */
function activate_eventprime_event_import_export() {
    $ep_import_export_activator = new Eventprime_Event_Import_Export_Activator();
	$ep_import_export_activator->activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-eventprime-event-import-export-deactivator.php
 */
function deactivate_eventprime_event_import_export() {
    $ep_import_export_deactivator = new Eventprime_Event_Import_Export_Deactivator();
    $ep_import_export_deactivator->deactivate();
}

register_activation_hook( __FILE__, 'activate_eventprime_event_import_export' );
register_deactivation_hook( __FILE__, 'deactivate_eventprime_event_import_export' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-eventprime-event-import-export.php';

/* plugin updater start */
if(!class_exists('EventPrime_Plugin_Updater'))
{
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-eventprime-plugin-updater.php';
}

$key = 'Eventprime_Event_Import_Export';

$license_status = get_option($key.'_license_status','');
if( ! empty( $license_status ) && $license_status == 'valid' ){
    add_action( 'init','Eventprime_Event_Import_Export_plugin_updater' );
}

function Eventprime_Event_Import_Export_plugin_updater()
{
    $key = 'Eventprime_Event_Import_Export';
    $doing_cron = defined( 'DOING_CRON' ) && DOING_CRON;
    if ( ! current_user_can( 'manage_options' ) && ! $doing_cron ) {
        return;
    }

    // retrieve our license key from the global settings
    $license_key = get_option($key.'_license_key');
    $item_id = get_option($key.'_item_id');
    $site_url = 'https://theeventprime.com/';
    // setup the updater
    $eventprime_updater = new Eventprime_Plugin_Updater(
        $site_url,
        __FILE__,
        array(
            'version' => EVENTPRIME_EVENT_IMPORT_EXPORT_VERSION,  // current version number
            'license' => $license_key,  // license key
            'item_id' => $item_id,       // ID of the product
            'author'  => 'EventPrime', // author of this plugin
            'beta'    => false,
        ),
        $key
    );
}
/* plugin updater end. */

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_eventprime_event_import_export() {

	$plugin = new Eventprime_Event_Import_Export();
	$plugin->run();

}
run_eventprime_event_import_export();
