<div class="ep-importer-tab-content">
    <h2><?php esc_html_e( 'Google Calendar Importer', 'eventprime-events-import-export' );?></h2>
    <input type="hidden" name="em_setting_type" value="importer_setting">
</div>

<h3 class="ep-mt-3"><?php echo esc_html('This will help you import events from your Google Calendar to EventPrime.','eventprime-events-import-export');?></h3>
<table class="form-table">
    <tbody>
 
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_import_api_key">
                        <?php esc_html_e( 'Google API Key', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_import_api_key" class="regular-text" id="ix_gcal_import_api_key" type="text" value="<?php echo isset($global_options->ix_gcal_import_api_key) ? $global_options->ix_gcal_import_api_key : '';?>" >    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php _e( sprintf('Enter your Google API Key. <a href="%s" target="__">Learn more about Google Calendar API keys</a>','https://developers.google.com/calendar/api/quickstart/js'), 'eventprime-events-import-export' );?></div>
                </td>
        </tr>
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_import_cal_id">
                        <?php esc_html_e( 'Calendar ID', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_import_cal_id" class="regular-text" id="ix_gcal_import_cal_id" type="text" value="<?php echo isset($global_options->ix_gcal_import_cal_id) ? $global_options->ix_gcal_import_cal_id : '';?>" >    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php _e( sprintf('Enter your Google Calendar ID. <a href="%s" target="__">Learn more about Google Calendar ID.</a>','https://developers.google.com/calendar/api/quickstart/js'), 'eventprime-events-import-export' );?></div>
                </td>
        </tr>
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_import_start_date">
                        <?php esc_html_e( 'Start Date', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_import_start_date" class="regular-text" id="ix_gcal_import_start_date" type="text" class="ep-datepicker" value="<?php echo date($ep_functions->ep_get_datepicker_format(), strtotime("-1 Months"));?>" autocomplete="off">    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php esc_html_e( 'Only events after this date will be imported.', 'eventprime-event-calendar-management' );?></div>
                </td>
        </tr>
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_import_end_date">
                        <?php esc_html_e( 'End Date', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_import_end_date"  class="regular-text" id="ix_gcal_import_end_date" type="text" class="ep-datepicker" value="<?php echo date($ep_functions->ep_get_datepicker_format(), strtotime("+3 Months"));?>"  autocomplete="off">    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php esc_html_e( 'Only events before this date will be imported.', 'eventprime-event-calendar-management' );?></div>
                </td>
        </tr>
    <tbody>
</table>
<p class="submit">
    <input type="hidden" name="action" value="ep_eix_form">
    <?php wp_nonce_field('ep_import_export_nonce'); ?>
    <button name="save" class="button-primary ep-save-button" type="button" onClick="check_google_events();"><?php echo esc_html('Check','eventprime-events-import-export');?></button>
    <span class="spinner"></span>
</p>

<div class="ep-google-response">
    
</div>
