<?php
$ix_action = isset($_GET['ep-ix-action']) ? sanitize_text_field($_GET['ep-ix-action']) : '';

?>
<div class="ep-importer-tab-content">
    <h2><?php esc_html_e( 'Google Calendar Exporter', 'eventprime-events-import-export' );?></h2>
    <input type="hidden" name="em_setting_type" value="exporter_setting">
</div>
<div class="ep-google-exporter-note">
    <?php echo esc_html('This will help you import events from your Google Calendar to EventPrime.','eventprime-events-import-export');?>
</div>
<div class="ep-subhead-info epnotice">
    <?php 
        $redirect = admin_url().'edit.php?post_type=em_event&page=ep-export-setting&exporter=google&ep-ix-action=gcal-get-token';
        _e("To display your desired events in your Google Calendar,", 'eventprime-events-import-export'); ?> <?php echo sprintf(__('you must set %s as redirect page in your Google App Console.', 'eventprime-event-google-import-export'), '<code>'.$redirect.'</code>'); ?>
</div>
<table class="form-table">
    <tbody>
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_export_client_id">
                        <?php esc_html_e( 'App Client ID', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_export_client_id" class="regular-text" id="ix_gcal_export_client_id" type="text" value="<?php echo isset($global_options->ix_gcal_export_client_id) ? $global_options->ix_gcal_export_client_id : '';?>" >    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php _e( sprintf('Enter your App Client ID from your Google App Console. <a href="%s" target="__">Learn more about Google App Client ID.</a>','https://developers.google.com/identity/oauth2/web/guides/get-google-api-clientid'), 'eventprime-events-import-export' );?></div>
                </td>
        </tr>
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_export_client_secret">
                        <?php esc_html_e( 'App Client Secret', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_export_client_secret" class="regular-text" id="ix_gcal_export_client_secret" type="text" value="<?php echo isset($global_options->ix_gcal_export_client_secret) ? $global_options->ix_gcal_export_client_secret : '';?>" >    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php _e( sprintf('Enter your App Client Secret from your Google App Console. <a href="%s" target="__">Learn more about Google App Client ID.</a>','https://analytify.io/get-google-client-id-and-client-secret/'), 'eventprime-events-import-export' );?></div>
                </td>
        </tr>
        <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="ix_gcal_export_calendar_id">
                        <?php esc_html_e( 'Calendar ID', 'eventprime-events-import-export' );?>
                    </label>
                </th>
                <td class="forminp forminp-text">
                    <input name="ix_gcal_export_calendar_id" class="regular-text" id="ix_gcal_export_calendar_id" type="text" value="<?php echo isset($global_options->ix_gcal_export_calendar_id) ? $global_options->ix_gcal_export_calendar_id : '';?>" >    
                    <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php esc_html_e( 'Your Google Calendar ID.', 'eventprime-event-calendar-management' );?></div>
                </td>
        </tr>
        <input type="hidden" name="ix_auth_code" value="<?php echo isset($_GET['code']) ? sanitize_text_field($_GET['code']) : '';?>">
    <tbody>
</table>
<p class="submit">
    <input type="hidden" name="action" value="ep_eix_form">
    <?php wp_nonce_field('ep_import_export_nonce'); ?>
    <button name="save" class="button-primary ep-save-button" type="button" onclick="authorize_google_access();"><?php echo esc_html('Authenticate','eventprime-import-export');?></button>
    
</p>
<div class="ep-goggle-export-response-area">
    
</div>

<?php if(!empty($ix_action)){
?>
<script>
ep_check_authorization();
</script>
<?php
}?>