<?php
$ep_functions = new Eventprime_Basic_Functions();
$format = $ep_functions->ep_get_datepicker_format();
?>
<div class="ep-importer-tab-content">
    <h2><?php esc_html_e( 'File Exporter', 'eventprime-events-import-export' );?></h2>
    <input type="hidden" name="em_setting_type" value="exporter_setting">
</div>
<?php do_action( 'ep_add_loader_section' );?>
<table class="form-table ep-importable-table">
    <tbody>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="ep_export_file_format">
                    <?php esc_html_e( 'Select File Format', 'eventprime-events-import-export' );?>
                </label>
            </th>
            <td class="forminp forminp-text">
                <select id="ep_export_file_format" name="ep_export_file_format" class="ep-form-control">
                    <option value="csv"><?php esc_html_e( 'CSV', 'eventprime-events-import-export' );?></option>
                    <option value="xml"><?php esc_html_e( 'XML', 'eventprime-events-import-export' );?></option>
                    <option value="json"><?php esc_html_e( 'JSON', 'eventprime-events-import-export' );?></option>
                    <option value="ical"><?php esc_html_e( 'Ical', 'eventprime-events-import-export' );?></option>
                </select>
                <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php esc_html_e( 'Select File format that you want to exports.', 'eventprime-event-calendar-management' );?></div>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="ep-ex-file-start-date">
                    <?php esc_html_e( 'Select Start Date', 'eventprime-events-import-export' );?>
                </label>
            </th>
            <td class="forminp forminpload-text">
                <input type="text" name="ep-ex-file-start-date" class="regular-text" id="ep-ex-file-start-date" value="<?php echo date($format, strtotime("-1 Days"));?>" autocomplete="off"/>
                <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php esc_html_e( 'Select Start Date of Events.', 'eventprime-event-calendar-management' );?></div>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="ep-ex-file-end-date">
                    <?php esc_html_e( 'Select End Date', 'eventprime-events-import-export' );?>
                </label>
            </th>
            <td class="forminp forminp-text">
                <input type="text" name="ep-ex-file-end-date" class="regular-text" id="ep-ex-file-end-date" value="<?php echo date($format, strtotime("+15 Days"));?>" autocomplete="off"/>
                <div class="ep-help-tip-info ep-my-2 ep-text-muted"><?php esc_html_e( 'Select End Date of Events.', 'eventprime-event-calendar-management' );?></div>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row" class="titledesc">
               <?php wp_nonce_field( 'ep_import_export_nonce' ); ?>
                <input type="hidden" name="action" value="ep_export_files_form">
                <button type="button" name="ep-export-file" id="ep-export-file" class="btn button-primary" onclick="export_files_events();"><?php esc_html_e( 'Export', 'eventprime-events-import-export' );?></button>  
            </th>
            <td class="forminp forminp-text">

                
            </td>
        </tr>
    </tbody>
</table>
<div class="ep-eix-btn-response"></div>
