<?php 
$ep_functions = new Eventprime_Basic_Functions();
$third_party_plugins = $data->third_party_plugins;
?>
<h3><?php echo esc_html_e( 'Third Party Plugins', 'eventprime-events-import-export' ); ?></h3>
<?php 
$text = esc_html__('Migrate Events from The Events Calendar','eventprime-event-calendar-management');
$link = 'https://theeventprime.com/learn-how-to-migrate-events-from-the-event-calendar-to-eventprime/';
?>
<div class="ep-box-col-12 ep-mb-3">
    <?php $ep_functions->ep_documentation_link_notice_html($text,$link);?>
</div>
<table class="widefat importers striped">
   <tbody>
        <tr>
          <select name="ep_third_party_plugin" id="ep_third_party_plugin">
            <option value="" hidden><?php echo esc_html_e( 'Select Plugin', 'eventprime-events-import-export' ); ?></option>
            <?php foreach( $third_party_plugins as $key => $value ){ ?>
              <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_attr( $value ); ?></option>
            <?php } ?>
          </select>
        </tr>
        <tr>
          <input type="hidden" name="ep-ix-action" value="third-party-plugin-import">
          <input type="button" class="button ep-third-party-import-button" name="ep-third-party-import-button" id="ep-third-party-import-button" value="<?php echo esc_html_e( 'Import', 'eventprime-events-import-export' ); ?>">
        </tr>
        <tr>
          <span class="spinner ep-third-party-plugin-spinner"></span>
        </tr>
        
   </tbody>
</table>
<div id="imported_events">
</div>
<div id="ep_custom_msg"></div>