jQuery( function( $ ) {
    var date_format = 'yy-mm-dd';
    if( eventprime.global_settings.datepicker_format ) {
        settings_date_format = eventprime.global_settings.datepicker_format;
        if( settings_date_format ) {
            settings_date_format = settings_date_format.split( '&' )[0];
            if( settings_date_format ) {
                date_format = settings_date_format;
            }
        }
    }
    
    jQuery(document).ready(function(e){
        var d = new Date();
        d.setMonth(d.getMonth() - 2);
        jQuery( ".ep-datepicker" ).datepicker({
            dateFormat: date_format,
            setDate : d,
            beforeShow: function () {
                $('#ui-datepicker-div').addClass( 'ep-ui-show-on-top' );
            }
        }); 

    });
    jQuery(document).ready(function(e){
        jQuery( "#ep-ex-file-start-date,#ep-ex-file-end-date" ).datepicker({
            dateFormat  : date_format,
            beforeShow: function () {
                $('#ui-datepicker-div').addClass( 'ep-ui-show-on-top' );
            }
        }); 

        $(document).on('change', '#ep-select-all-events', function () {
            $('.ep-google-event-checkbox').prop('checked', this.checked);
        });

        // Datepicker for Google Calendar Import dates 
        jQuery( "#ix_gcal_import_start_date" ).datepicker({
            dateFormat  : date_format,
            beforeShow: function () {
                $('#ui-datepicker-div').addClass( 'ep-ui-show-on-top' );
            }
        }); 
        jQuery( "#ix_gcal_import_end_date" ).datepicker({
            dateFormat  : date_format,
            beforeShow: function () {
                $('#ui-datepicker-div').addClass( 'ep-ui-show-on-top' );
            }
        }); 


    });
});

function check_google_events(){
       var form = document.getElementById('ep-import');
        var fd = new FormData(form);
        fd.append('action', 'ep_admin_save_google_importer');  
        jQuery('.spinner').addClass('is-active');
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: fd,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.spinner').removeClass('is-active');
                jQuery('.ep-google-response').html(response);
            }
        });
}
function import_fb_event_list_action(action){
    if(action == 'select-all'){
        jQuery('#ep_import_f_calendar_events input').prop('checked', true);
    }else{
        jQuery('#ep_import_f_calendar_events input').prop('checked', false);
    }
}
function import_event_list_action(action){
    if(action == 'select-all'){
        jQuery('.ep-import-list-events input').prop('checked', true);
        jQuery('#ep-google-ie-deselect-all').prop('disabled',false);
    }else{
        jQuery('.ep-import-list-events input').prop('checked', false);
        jQuery('#ep-google-ie-deselect-all').prop('disabled',true);
    }
}

function import_gcal_events(){
    var form = document.getElementById('ep-import');
    var data = new FormData(form);
    data.append('action','ep_admin_import_google_events');
    jQuery('.spinner').addClass('is-active');
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: data,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.spinner').removeClass('is-active');
                jQuery('.ep-eix-btn-response').html(response);
            }
        });
}


function ep_check_authorization(){
        jQuery('.spinner').addClass('is-active');
        var form = document.getElementById('ep-export');
        var fd = new FormData(form);
        fd.append('action', 'ep_admin_google_gcal_token');  

        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: fd,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.ep-goggle-export-response-area').html(response);
                jQuery('.spinner').removeClass('is-active');
            }
        });
}
function authorize_google_access(){
       jQuery('.spinner').addClass('is-active');
       var form = document.getElementById('ep-export');
        var fd = new FormData(form);
        fd.append('action', 'ep_admin_save_google_exporter');
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: fd,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.ep-goggle-export-response-area').html(response);
                jQuery('.spinner').removeClass('is-active');
            }
        });
}
function export_gcal_events(){
        jQuery('.spinner').addClass('is-active');
        var form = document.getElementById('ep-export');
        var fd = new FormData(form);
        fd.append('action', 'ep_admin_export_google_events');
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: fd,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.ep-eix-btn-response').html(response);
                jQuery('.spinner').removeClass('is-active');
            }
        });
}

//Facebook Import
function check_facebook_events(){
       var form = document.getElementById('ep-import');
        var fd = new FormData(form);
        fd.append('action', 'ep_admin_save_facebook_importer');  
        jQuery('.spinner').addClass('is-active');
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: fd,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.spinner').removeClass('is-active');
                jQuery('.ep-google-response').html(response);
            }
        });
}
function import_facebbok_events(){
    var form = document.getElementById('ep-import');
    var data = new FormData(form);
    data.append('action','ep_admin_import_facebook_events');
    jQuery('.spinner').addClass('is-active');
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: data,
            contentType: false,
            processData: false,
            success: function(response){
                jQuery('.spinner').removeClass('is-active');
                jQuery('.ep-eix-btn-response').html(response);
            }
        });
}

/*function export_files_events(){
    var form = document.getElementById('ep-export');
        var fd = new FormData(form);
        fd.append('action', 'ep_export_files_events');  
        jQuery.ajax({
            type: 'POST',
            url: eventprime.ajaxurl,
            data: fd,
            contentType: false,
            processData: false,
            success: function(res){
                var downloadLink = document.createElement("a");
                var fileData = ['\ufeff'+res];
                var blobObject = new Blob(fileData,{
                   type: "text/csv;charset=utf-8;"
                 });
                var url = URL.createObjectURL(blobObject);
                downloadLink.href = url;
                downloadLink.download = "events.csv";

                document.body.appendChild(downloadLink);
                downloadLink.click();
                document.body.removeChild(downloadLink);
            }
        });
}*/

function export_files_events(){
    jQuery('.spinner').addClass('is-active');
    var type = jQuery('#ep_export_file_format').val();
    var startDate = jQuery('#ep-ex-file-start-date').val();
    var endDate = jQuery('#ep-ex-file-end-date').val();
    
    var form = document.getElementById('ep-export');
    form.submit();
    jQuery('.spinner').removeClass('is-active');
}

/*
 * Import Start
 */

jQuery(document).on('change','.ep-import-file', function(e){
    var accepted_format = jQuery(this).data("type");
    var filename = jQuery(this).val();
        var extension = filename.replace(/^.*\./, '');
        if (extension == filename) {
            extension = '';
        } else {
            extension = extension.toLowerCase();
        }
    if(extension != accepted_format){
        jQuery(this).closest('tr').find('.ep-import-button').attr('disabled',true);
        alert('Please select '+ accepted_format + ' file only.');
        jQuery(this).val('');
        return;
    }else{
        jQuery(this).closest('tr').find('.ep-import-button').removeAttr('disabled');
    }
   
});
jQuery(document).on('click','.ep-import-button', function(e){
    var accepted_format = jQuery(this).data("type");
    jQuery('.ep-import-file-table:not(.ep-import-table-'+accepted_format+')').hide();
    jQuery('.spinner').addClass('is-active');
    var fd = new FormData();
    var file = jQuery(document).find('#import-file-'+accepted_format);
    var individual_file = file[0].files[0];
    fd.append("file", individual_file);
    fd.append('action', 'ep_admin_import_file_upload');  

    jQuery.ajax({
        type: 'POST',
        url: eventprime.ajaxurl,
        data: fd,
        contentType: false,
        processData: false,
        success: function(response){
            if(response.data.attachment_id){
                event_target = accepted_format+'-feed';
                import_files_loop(response.data.attachment_id, event_target, 0);
            }
        }
    });
});
/*
function upload_file_import(element){
    jQuery('.ep-event-loader').show();
    var accepted_formate = jQuery(element).data("type");
    var filename = jQuery(element).val();
        var extension = filename.replace(/^.*\./, '');
        if (extension == filename) {
            extension = '';
        } else {
            extension = extension.toLowerCase();
        }
    if(extension != accepted_formate){
        alert('Please select '+ accepted_formate + ' file only.');
        jQuery(element).val('');
        jQuery('.ep-event-loader').hide();
        return;
    }
    var fd = new FormData();
    var file = jQuery(document).find('#'+element.id);
    var individual_file = file[0].files[0];
    fd.append("file", individual_file);
    fd.append('action', 'ep_admin_import_file_upload');  

    jQuery.ajax({
        type: 'POST',
        url: eventprime.ajaxurl,
        data: fd,
        contentType: false,
        processData: false,
        success: function(response){
            jQuery(element).parent().find('.ep-hidden-attachment').val(response.data.attachment_id);
            jQuery('.ep-event-loader').hide();
        }
    });
}

function ep_event_import(element, target, msg){
    //e.preventDefault();
    var attachment_id = jQuery(element).closest('table').find('.ep-hidden-attachment').val();
    if(!attachment_id){
        alert('Please select file.');
        return;
    }
    var event_target = target+'-feed';
    var offset =1;
    var formData = new FormData();
    formData.append('attachment_id', attachment_id);
    formData.append('event_target', event_target);
    formData.append('action','ep_admin_import_file');
    jQuery('.ep-import-overlay').show();
    jQuery.ajax({
        type: 'POST',
        url: eventprime.ajaxurl,
        data: formData,
        contentType: false,
        processData: false,
        success: function(response){
            if(response.data.terminate == true){
                jQuery('.ep-import-done').show();
            }else{
                var totalRow = response.data.total_row;
                var offset = response.data.offset;
                import_files_loop(attachment_id, event_target, offset);
            }
            jQuery('.ep-import-files-response').html(response.data.html);
        }
    });
    
}*/
let progress = 0;
function import_files_loop(attachment_id, event_target, offset){
    jQuery('.prgress-bar-wrap.' + event_target).fadeIn(500); 
    var formData = new FormData();
    formData.append('attachment_id', attachment_id);
    formData.append('event_target', event_target);
    formData.append('offset', offset);
    jQuery('.ep-eix-import-overlay').show();
    formData.append('action','ep_admin_import_file');
    
    // console.log(jQuery('.prgress-bar-wrap.' + event_target))
    // console.log(event_target)
    // return
    jQuery.ajax({
        type: 'POST',
        url: eventprime.ajaxurl,
        data: formData,
        contentType: false,
        processData: false,
        success: function(response){
            // jQuery('.completion-percentage').text( ( parseInt(response.data.offset) / parseInt(response.data.total_row) ) * 100 )   // ***** Progress bar! 

            // console.log(response); return; 
            let increaseRateInPercent = ( parseInt(response.data.offset) / parseInt(response.data.total_row) ) * 100; 
            // console.log(progress)
            increaseProgress(increaseRateInPercent); 
            if(response.data.terminate == true){
                jQuery('.ep-import-done').show();
                jQuery('.spinner').removeClass('is-active');
            }else{
                var totalRow = response.data.total_row;
                var offset = response.data.offset;
                // console.log( totalRow / offset )
                import_files_loop(attachment_id, event_target, offset);
            }
            jQuery('.ep-import-files-response').append(response.data.html);
        }
    });
}

function updateProgress() {
    // document.getElementById('myProgressBar').style.width = progress + '%';
    // jQuery('#myProgressBar').width(progress + '%');
    jQuery('.progress-bar.' + event_target).width(progress + '%');
    // document.getElementById('progressText').innerHTML = progress + '%';
    // jQuery('#progressText').html(progress + '%');
    jQuery('.progress-text.' + event_target).html(progress + '%');
}
function increaseProgress(increaseRateInPercent) {
    if (progress < 100) {
        progress = increaseRateInPercent; 
        updateProgress();
    }
}

jQuery(document).on('click','.ep-third-party-import-button', function(e){
    var import_button = jQuery(this).val();
    var ep_third_party_plugin = jQuery('#ep_third_party_plugin').val();
    jQuery('.spinner').addClass('is-active');
    jQuery('.ep-third-party-import-button').addClass('disabled');
    var fd = new FormData();
    fd.append('action', 'ep_third_party_import_start');
    fd.append('ep_third_party_plugin', ep_third_party_plugin );
    fd.append('ep-third-party-import-button', import_button );  

    jQuery.ajax({
        type: 'POST',
        url: eventprime.ajaxurl,
        data: fd,
        contentType: false,
        processData: false,
        success: function(response){
            if(response){
                jQuery('.spinner').removeClass('is-active');
                jQuery('.ep-third-party-import-button').removeClass('disabled');
                if( response.data.events_imported > 0 ){
                    if( response.data.events_imported == 1 ){
                        jQuery('#ep_custom_msg').html( response.data.events_imported + ' Event Imported Successfully' );
                        jQuery('#imported_events').html(response.data.imported_events_details);
                    }else{
                        jQuery('#ep_custom_msg').html( response.data.events_imported + ' Events Imported Successfully' );
                        jQuery('#imported_events').html(response.data.imported_events_details);
                    }
                }else{
                    jQuery('#ep_custom_msg').html( 'No Event Imported' ); 
                }
            }
        }
    });
});