<?php

defined( 'ABSPATH' ) || exit;
class EventM_EIX_Controller_Settings {

    public function save_settings() {
        if( isset( $_POST['em_setting_type'] ) && ! empty( $_POST['em_setting_type'] ) ) {
            if($_POST['em_setting_type'] == 'google_importer_setting'){
                $this->save_google_import_form();
            }
            do_action('ep_save_eix_form_data', $_POST);
        }
    }
    
    public function save_google_import_form(){
        echo 'DONE';
    }
    
    public function save_google_import_data(){
        $global_settings = new Eventprime_Global_Settings();
        $global_settings_data = $global_settings->ep_get_settings(); 
        $form_data = $_POST;
        $global_settings_data->ix_gcal_import_api_key = sanitize_text_field($form_data['ix_gcal_import_api_key']);
        $global_settings_data->ix_gcal_import_cal_id = sanitize_text_field($form_data['ix_gcal_import_cal_id']);
        
        $global_settings->ep_save_settings( $global_settings_data );
        $service = new EIX_Google_Import_Service();
        return $service->check_google_import_apis();
        //return true;
        
    }
    
    public function import_google_events(){
        $service = new EIX_Google_Import_Service();
        return $service->import_google_selected_events_apis();
    }
    
    public function save_google_export_data(){
        $global_settings = new Eventprime_Global_Settings();
        $global_settings_data = $global_settings->ep_get_settings(); 
        $form_data = $_POST;
        $global_settings_data->ix_gcal_export_client_id = sanitize_text_field($form_data['ix_gcal_export_client_id']);
        $global_settings_data->ix_gcal_export_client_secret = sanitize_text_field($form_data['ix_gcal_export_client_secret']);
        $global_settings_data->ix_gcal_export_calendar_id = sanitize_text_field($form_data['ix_gcal_export_calendar_id']);
        
        $global_settings->ep_save_settings( $global_settings_data );
        $service = new EIX_Google_Export_Service();
        return $service->check_gcal_export_auth();
    }
    
    public function export_google_events(){
        $service = new EIX_Google_Export_Service();
        return $service->export_google_events();
    }
    
    public function save_facebook_import_data(){
        $service = new EIX_Facebook_Import_Service();
        return $service->f_calendar_import_start();
    }
    public function import_facebook_events(){
        $service = new EIX_Facebook_Import_Service();
        return $service->f_calendar_import_do();
    }

    public function ep_get_published_events_data($args = [], $fetch_single_event_details = true) {
        $ep_functions = new Eventprime_Basic_Functions();

        $default = array(
            'post_status' => 'publish',
            'order'       => 'ASC',
            'post_type'   => 'em_event',
            'numberposts' => -1,
            'offset'      => 0,
        );
        $args = wp_parse_args( $args, $default );
        $posts = get_posts( $args );
        if( empty( $posts ) )
            return array();
        
        $events = array();
        foreach( $posts as $post ) {
            if( empty( $post ) || empty( $post->ID ) ) continue;
            
            if($fetch_single_event_details)
            {
                $event = $ep_functions->get_single_event( $post->ID, $post );
            }
            else
            {
                $event = $post;
            }
            
            if( ! empty( $event ) ) {
                $events[] = $event;
            }
        }
        $wp_query = new WP_Query( $args );
        $wp_query->posts = $events;
        return $wp_query;
    }
}