<?php 

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Eventprime_Event_Import_Export
 * @subpackage Eventprime_Event_Import_Export/admin
 * @author     EventPrime <support@metagauss.com>
 */
class Eventprime_Event_Import_Export_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
        /**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Eventprime_Event_Import_Export_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Eventprime_Event_Import_Export_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

        $page_url = $_GET;
        if(isset($page_url['page']) && in_array($page_url['page'], array('ep-import-export','ep-export-setting','ep-import-setting'))){
            wp_enqueue_style( 'em-meta-box-admin-jquery-ui', plugin_dir_url(EP_PLUGIN_FILE) . '/admin/css/jquery-ui.min.css', false, EVENTPRIME_VERSION );
            wp_enqueue_style( 'em-meta-box-admin-jquery-timepicker', plugin_dir_url(EP_PLUGIN_FILE) . '/admin/css/jquery-ui.min.css', false, EVENTPRIME_VERSION );
            wp_enqueue_style( 'ep-eix-styles', plugin_dir_url( __FILE__ ) . 'css/ep-eix-styles.css', array(), $this->version, 'all' );
        }

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
        /**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Eventprime_Event_Import_Export_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Eventprime_Event_Import_Export_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

        $page_url = $_GET;
        if(isset($page_url['page']) && in_array($page_url['page'], array('ep-import-export','ep-export-setting','ep-import-setting'))){
            $ep_functions = new Eventprime_Basic_Functions();
            $global_settings = $ep_functions->ep_get_global_settings();

            // wp_enqueue_script('ep-common-script', plugin_dir_url(EP_PLUGIN_FILE) . 'admin/js/ep-common-script.js', array('jquery'), $this->version);
            wp_enqueue_script( 'jquery-ui-datepicker' );
            wp_enqueue_script( 'ep-eix-scripts', plugin_dir_url( __FILE__ ) . 'js/ep-eix-scripts.js', array( 'jquery' ), $this->version, false );
            wp_localize_script(
                'ep-eix-scripts',
                'eventprime',
                array(
                    'global_settings' => $global_settings,
                    'ajaxurl' => admin_url('admin-ajax.php')
                )
            );
        }

	}

    public function ep_plugin_activation_notice_fun() {
        if (!class_exists('Eventprime_Event_Calendar_Management')) {
            $this->EventPrime_installation();
        }
    }

    public function EventPrime_installation() {
        $plugin_slug = 'eventprime-event-calendar-management';
        $installUrl = admin_url('update.php?action=install-plugin&plugin=' . $plugin_slug);
        $installUrl = wp_nonce_url($installUrl, 'install-plugin_' . $plugin_slug);
        ?>
        <div class="notice notice-success is-dismissible">
            <p><?php printf(__("EventPrime Events Import Export work with Eventprime Plugin. You can install it  from <a href='%s'>Here</a>.","eventprime-event-tickets"),plugin_basename ( plugin_dir_path( __DIR__ ) ), $installUrl); ?></p>
        </div>
        <?php
        deactivate_plugins( plugin_basename( plugin_dir_path( __DIR__ ) ) . '/eventprime-event-import-export.php' );
    }
	
    public function eix_sub_menu(){
        $menu_order = 11;
        $add_order = 0;
        if(class_exists( 'EM_Sponsor' )){     
            $add_order = $add_order +1;
        }
        if(class_exists( 'EP_Coupons' )){   
            $add_order = $add_order +1;
        }
        if(class_exists( 'EM_Event_Tickets' )){  
            $ep_functions = new Eventprime_Basic_Functions(); 
            $allow_event_tickets = $ep_functions->ep_get_global_settings('allow_event_tickets'); 

            if(!empty($allow_event_tickets)){
                $add_order = $add_order +1;
            }
        }
        $menu_order = $menu_order + $add_order;
        
        add_submenu_page( 'edit.php?post_type=em_event', esc_html__( 'Import Export', 'eventprime-events-import-export' ), esc_html__( 'Import Export', 'eventprime-events-import-export' ), 'edit_posts', 'ep-import-export', array( $this, 'eix_pages' ), $menu_order );
        
        add_submenu_page( "ep_hidden_menu", esc_html__( 'Import setting', 'eventprime-events-import-export' ), esc_html__( 'Import Setting', 'eventprime-events-import-export' ), 'edit_posts', 'ep-import-setting', array( $this, 'eix_import_settings' ) );
        
        add_submenu_page( "", esc_html__( 'Export setting', 'eventprime-events-import-export' ), esc_html__( 'Export Setting', 'eventprime-events-import-export' ), 'edit_posts', 'ep-export-setting', array( $this, 'eix_export_settings' ) );
    }
    
    /*
     * Event Import Export Settings
     */
    public function eix_pages(){
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        $data = new stdClass();
        $default_tab = null;
        $tab = isset($_GET['tab']) ? $_GET['tab'] : $default_tab;
        $data->import_lists = $this->ep_import_lists();
        $data->import_settings = $this->ep_import_lists_settings();
        $data->export_lists = $this->ep_export_lists();
        $data->export_settings = $this->ep_export_lists_settings();
        $data->third_party_plugins = $this->ep_get_third_party_plugins_for_import();
        ?>
        <div class="wrap">
            <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
            <nav class="nav-tab-wrapper">
                <a href="<?php echo esc_url( admin_url( 'edit.php?post_type=em_event&page=ep-import-export' ) );?>" class="nav-tab <?php if( $tab === null ):?>nav-tab-active<?php endif; ?>">
                    <?php echo esc_html__( 'Import', 'eventprime-events-import-export' );?>
                </a>
                <a href="<?php echo esc_url( admin_url( 'edit.php?post_type=em_event&page=ep-import-export&tab=export' ) );?>" class="nav-tab <?php if( $tab === 'export' ):?>nav-tab-active<?php endif; ?>">
                    <?php echo esc_html__( 'Export', 'eventprime-events-import-export' );?>
                </a>
                <a href="<?php echo esc_url( admin_url( 'edit.php?post_type=em_event&page=ep-import-export&tab=third-party' ) );?>" class="nav-tab <?php if( $tab === 'third-party' ):?>nav-tab-active<?php endif; ?>">
                    <?php echo esc_html__( 'Third Party Plugin', 'eventprime-events-import-export' );?>
                </a>
            </nav>
            <div class="tab-content wrap"><?php 
                switch( $tab    ) :
                    case 'export':
                        include_once __DIR__ . '/partials/ep-export-tabs.php';
                    break;
                    case 'third-party':
                        include_once __DIR__ . '/partials/ep-third-party-tabs.php';
                    break;
                    default:
                        include_once __DIR__ . '/partials/ep-import-tabs.php';
                    break;
                endswitch; ?>
            </div>
        </div><?php
    }
    
    /*
     * Import Settings Form
     */
    public function eix_import_settings(){
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        $data = new stdClass();
        $import_settings = $this->ep_import_lists_settings();
        $default_importer = 'files';
        $importer = isset($_GET['importer']) ? sanitize_text_field( $_GET['importer'] ) : $default_importer;
        if( ! isset( $import_settings[$importer] ) ) {
            $importer = 'files';
        }?>
        <div class="wrap">
            <form name="ep-import" id="ep-import" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data">
                <?php echo $import_settings[$importer];?>
            </form>
        </div><?php
    }
    
    /*
     * Export Form 
     */
    public function eix_export_settings(){
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        $data = new stdClass();
        $export_settings = $this->ep_export_lists_settings();
        $default_exporter = 'files';
        $exporter = isset($_GET['exporter']) ? $_GET['exporter'] : $default_exporter;
        if(!isset($export_settings[$exporter])){
            $exporter = 'files';
        }
        ?>
        <div class="wrap">
            <form name='ep-export' id='ep-export' action='<?php echo admin_url( 'admin-post.php' ); ?>' method='post' enctype='multipart/form-data'>
                <?php echo $export_settings[$exporter];?>
            </form>
        </div>
        <?php
    }
    
    /*
     * Import list options
     */
    public function ep_import_lists(){
        $import_lists = array();
        
        $import_lists['google'] = array(
            'id'=>'google',
            'title'=>esc_html__( 'Google Calendar', 'eventprime-events-import-export' ),
            'description'=>esc_html__( 'Import Events from google calendar', 'eventprime-events-import-export' )
        );
        $import_lists['files'] = array(
            'id'=>'files',
            'title'=>esc_html__( 'Import using files', 'eventprime-events-import-export' ),
            'description'=>esc_html__( 'Import Event from .CSV, .XML, .JSON etc.', 'eventprime-events-import-export' )
        );
        
        /*$import_lists['facebook'] = array(
            'id'=>'facebook',
            'title'=>esc_html__( 'Facebook Events', 'eventprime-events-import-export' ),
            'description'=>esc_html__( 'Import events from facebook events lists via apis.', 'eventprime-events-import-export' )
        );*/
        
        return apply_filters( 'ep_import_lists', $import_lists );
    }
    
    /*
     * Import Details Settings HTML
     */
    public function ep_import_lists_settings(){
        $settings = new Eventprime_Global_Settings();
        $global_options = $settings->ep_get_settings(); 

        $ep_functions = new Eventprime_Basic_Functions();
        
        //print_r($global_options);
        $importer_settings = array();
        ob_start();
        /*     include __DIR__ .'/partials/importer/ep-facebook-importer.php';
        $facebook_importer = ob_get_clean();
        $importer_settings['facebook'] = $facebook_importer;
        */
        ob_start();
        include __DIR__ .'/partials/importer/ep-google-importer.php';
        $google_importer = ob_get_clean();
        $importer_settings['google'] = $google_importer;
        
        ob_start();
        include __DIR__ .'/partials/importer/ep-meetup-importer.php';
        $meetup_importer = ob_get_clean();
        $importer_settings['meetup'] = $meetup_importer;
        
        ob_start();
        include __DIR__ .'/partials/importer/ep-files-importer.php';
        $files_importer = ob_get_clean();
        $importer_settings['files'] = $files_importer;
        
        return apply_filters('ep_import_lists_settings', $importer_settings);
    }
    
    /*
     * Availabe Export Options
     */
    public function ep_export_lists(){
        $export_lists = array();
        
        $export_lists['google'] = array(
            'id'=>'google',
            'title'=>esc_html__( 'Google Calendar', 'eventprime-events-import-export' ),
            'description'=>esc_html__( 'Export Events to google calendar', 'eventprime-events-import-export' )
        );
        $export_lists['files'] = array(
            'id'=>'files',
            'title'=>esc_html__( 'Export using files', 'eventprime-events-import-export' ),
            'description'=>esc_html__( 'Export Event to .CSV, .XML, .JSON etc.', 'eventprime-events-import-export' )
        );
        
        return apply_filters( 'ep_export_lists', $export_lists );
    }
    
    /*
     * Export Event Setting Page HTML
     */
    public function ep_export_lists_settings(){
        $global_options = (object) get_option( 'em_global_settings' );
        $exporter_settings = array();
        
        ob_start();
            include __DIR__ .'/partials/exporter/ep-google-exporter.php';
        $google_exporter = ob_get_clean();
        $exporter_settings['google'] = $google_exporter;
        
        ob_start();
            include __DIR__ .'/partials/exporter/ep-files-exporter.php';
        $files_exporter = ob_get_clean();
        $exporter_settings['files'] = $files_exporter;
        
        return apply_filters('ep_export_lists_settings', $exporter_settings);
    }
    
    /*
     * Update File on Change event
     */
    public function admin_import_file_upload(){
        $service = new EIX_Import_Service();
        $postdata = $service->upload_files();
        if(isset($postdata['errors'])){
            wp_send_json_error(array('errors' => $postdata['errors']));
        }
        if(isset($postdata['success'])){
            wp_send_json_success($postdata['success']);
        }
        die;
    }
    
    /*
     * Import Events From Files
     */
    public function admin_import_file(){
        $service = new EIX_Import_Service();
        
        $postdata = $service->em_ix_file_import();
            
        wp_send_json_success($postdata);
            
        die;
    }
    
    /*
     * Ajax Files Export options
     */
    public function ep_export_files_form(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
            $admin_notices = new EventM_Admin_Notices(); 
            $admin_notices->ep_add_notice( 'error', esc_html__( 'Nonce Not matched...', 'eventprime-event-calendar-management' ) );
        
            $redirect_url = admin_url( "edit.php?post_type=em_event&page=ep-export-setting&exporter=files" );
            wp_redirect( $redirect_url );
            exit();
            //return;
	    }
        $service = new EIX_Export_Service();
        $response = $service->em_ix_file_export();
        
    }
    
    /*
     * Save Google Form Data using Ajax
     */
    public function save_google_importer(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        
        $settings = new EventM_EIX_Controller_Settings();
        echo $response  = $settings->save_google_import_data();
        
        die;
    }
    
    /*
     * Import google Events
     */
    public function import_selected_google_events(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        $settings = new EventM_EIX_Controller_Settings();
        echo $response  = $settings->import_google_events();
        die;
    }
    /*
     * Save Google Export Data
     */
    
    public function save_google_exporter(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        $settings = new EventM_EIX_Controller_Settings();
        echo $settings->save_google_export_data();
        
        die;
    }
    
    public function export_google_events(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        $settings = new EventM_EIX_Controller_Settings();
        echo $settings->export_google_events();
        die;
    }
    /*
     * Verify Google Auth token
     */
    
    public function varify_google_gcal_token(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        $service = new EIX_Google_Export_Service();
        echo $service->gcal_export_get_token();
        
        die;
    }
    
    
    /*
     * Validate Facebook credential
     */
    
    public function save_facebook_importer(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        
        $settings = new EventM_EIX_Controller_Settings();
        echo $response  = $settings->save_facebook_import_data();
        
        die;
    }
    public function import_selected_facebook_events(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        
        $settings = new EventM_EIX_Controller_Settings();
        echo $response  = $settings->import_facebook_events();
        
        die;
    }
    /*
     * Adding options in global options
     */
    
    public function save_eix_meta_options($options){
        $options['ix_gcal_import_api_key'] = '';
        $options['ix_gcal_import_cal_id'] = '';
        $options['ix_gcal_import_start_date'] = date("d-m-Y", strtotime("-1 Months"));
        $options['ix_gcal_import_end_date'] = date("d-m-Y", strtotime("+3 Months"));
        $options['ix_gcal_export_client_id'] = '';
        $options['ix_gcal_export_client_secret'] = '';
        $options['ix_gcal_export_calendar_id'] = '';
        $options['ix_gcal_export_token'] = '';
        $options['ix_gcal_export_refresh_token'] = '';
        $options['ix_facebook_app_token'] = '';
        $options['ix_facebook_import_page_link'] = '';
        return $options;
    }
    
    /*
     * Save Form data using normal action
     */
    public function save_import_export_data(){
        if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['_wpnonce'] ), 'ep_import_export_nonce' ) ) {
		return;
	}
        $settings = new EventM_EIX_Controller_Settings();
        $settings->save_settings();
    }

    /**
    * Add mailpoet options in global settings object
    */
    public function ep_add_eix_global_setting_options( $settings, $options ) {
        if( ! empty( $options ) ) {
            // global settings option for license settings
            $settings->ep_eix_item_id          = 849;
            $settings->ep_eix_item_name        = 'Events Import Export';
            $settings->ep_eix_license_key      = ( property_exists( $options, 'ep_eix_license_key' ) ) ? $options->ep_eix_license_key : '';
            $settings->ep_eix_license_status   = ( property_exists( $options, 'ep_eix_license_status' ) ) ? $options->ep_eix_license_status : '';
            $settings->ep_eix_license_response = ( property_exists( $options, 'ep_eix_license_response' ) ) ? $options->ep_eix_license_response : '';
        }
        return $settings;
    }

    public function ep_add_eix_license_setting_block( $options ){ ?>
        <tr valign="top" class="ep_eix">
            <td><?php esc_html_e( 'Events Import Export', 'eventprime-events-import-export' );?></td>
            <td><input id="ep_eix_license_key" name="ep_eix_license_key" type="text" class="regular-text ep-box-wrap ep-license-block" data-prefix="ep_eix" value="<?php esc_attr_e( ( isset( $options->ep_eix_license_key ) && ! empty( $options->ep_eix_license_key ) ) ? $options->ep_eix_license_key : '' ); ?>" placeholder="<?php esc_html_e( 'Please Enter License Key', 'eventprime-events-import-export' );?>" /></td>
            <td>         
                <span class="license-expire-date" style="padding-bottom:2rem;" >
                    <?php
                    if ( isset( $options->ep_eix_license_response->expires ) && ! empty( $options->ep_eix_license_response->expires ) ) {
                        if( $options->ep_eix_license_response->expires == 'lifetime' ){
                            esc_html_e( 'Your License key is activated for lifetime', 'eventprime-events-import-export' );
                        }else{
                            echo sprintf( __('Your License Key expires on %s', 'eventprime-events-import-export' ), date( 'F d, Y', strtotime( $options->ep_eix_license_response->expires ) ) );
                        }
                    } else {
                        $expire_date = '';
                    }
                    ?>
                </span>
            </td>
            <td>
                <span class="ep_eix-license-status-block">
                    <?php if ( isset( $options->ep_eix_license_key ) && ! empty( $options->ep_eix_license_key )) { ?>
                        <?php if ( isset( $options->ep_eix_license_status ) && $options->ep_eix_license_status !== false && $options->ep_eix_license_status == 'valid') { ?>
                            <button type="button" class="button action ep-my-2 ep_license_deactivate" name="ep_eix_license_deactivate" id="ep_eix_license_deactivate" data-prefix="ep_eix" value="<?php esc_html_e( 'Deactivate License', 'eventprime-events-import-export' );?>"><?php esc_html_e( 'Deactivate License', 'eventprime-events-import-export' );?></button>
                        <?php }elseif( ! empty( $options->ep_eix_license_status ) && $options->ep_eix_license_status == 'invalid' ){ ?>
                            <button type="button" class="button action ep-my-2 ep_license_activate" name="ep_eix_license_activate" id="ep_eix_license_activate" data-prefix="ep_eix" value="<?php esc_html_e( 'Activate License', 'eventprime-events-import-export' );?>"><?php esc_html_e( 'Activate License', 'eventprime-events-import-export' );?></button>
                        <?php }else{ ?>
                            <button type="button" class="button action ep-my-2 ep_license_activate" name="ep_eix_license_activate" id="ep_eix_license_activate" data-prefix="ep_eix" value="<?php esc_html_e( 'Activate License', 'eventprime-events-import-export' );?>" style="<?php if ( empty( $options->ep_eix_license_key ) ){ echo 'display:none'; } ?>"><?php esc_html_e( 'Activate License', 'eventprime-events-import-export' );?></button>
                    <?php } }else{ ?>
                        <button type="button" class="button action ep-my-2 ep_license_activate" name="ep_eix_license_activate" id="ep_eix_license_activate" data-prefix="ep_eix" value="<?php esc_html_e( 'Activate License', 'eventprime-events-import-export' );?>" style="display:none;"><?php esc_html_e( 'Activate License', 'eventprime-events-import-export' );?></button>
                    <?php } ?>
                </span>
            </td>
        </tr><?php
    }

    public function ep_pupulate_eix_license_item_id( $item_id, $form_data ){
        if( isset( $form_data['ep_license_type'] ) && $form_data['ep_license_type'] == 'ep_eix' ){
            $global_settings = new Eventprime_Global_Settings();
            $options = $global_settings->ep_get_settings(); 
            $item_id  = ( isset(  $options->ep_eix_item_id ) && ! empty( $options->ep_eix_item_id ) ) ? $options->ep_eix_item_id : '';     
        }
        return $item_id; 
    }

    public function ep_pupulate_eix_license_item_name( $item_name, $form_data ){
        if( isset( $form_data['ep_license_type'] ) && $form_data['ep_license_type'] == 'ep_eix' ){
            $global_settings = new Eventprime_Global_Settings();
            $options = $global_settings->ep_get_settings();
            $item_name  = ( isset( $options->ep_eix_item_name ) && ! empty( $options->ep_eix_item_name ) ) ? $options->ep_eix_item_name : '';    
        }
        return $item_name;
    }

    public function ep_save_eix_license_setting( $form_data, $license_data ){
        if( isset( $form_data['ep_license_type'] ) && $form_data['ep_license_type'] == 'ep_eix' && ! empty( $license_data ) ){
            $global_settings = new Eventprime_Global_Settings();
            $options = $global_settings->ep_get_settings();
            // $license_data->license will be either "valid" or "invalid"
            $options->ep_eix_license_key  = ( isset( $form_data['ep_license_key'] ) && ! empty( $form_data['ep_license_key'] )  && ( $license_data->license == 'valid' || $license_data->license = 'deactivated' ) ) ? $form_data['ep_license_key'] : '';
            $options->ep_eix_license_status  = ( isset( $license_data->license ) && ! empty( $license_data->license ) ) ? $license_data->license : '';
            $options->ep_eix_license_response  = ( isset( $license_data ) && ! empty( $license_data ) ) ? $license_data : '';
            $global_settings->ep_save_settings( $options );
        
        }
    }
    /*
     * Get Third Party Plugins for Import
     */
    public function ep_get_third_party_plugins_for_import(){
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        $third_parties = array();
        
        $third_parties['the-events-calendar'] = esc_html__( 'The Events Calendar', 'eventprime-events-import-export' );
        
        return $third_parties;
    }

    public function ep_third_party_import_start(){
        if( isset( $_POST['ep-third-party-import-button'] ) && ! empty( $_POST['ep-third-party-import-button'] ) ){
            // global $wpdb;
            $ep_dbhandler = new EP_DBhandler(); 
            $imported_events_details = '';
            $ep_functions = new Eventprime_Basic_Functions();
            $format = $ep_functions->ep_get_datepicker_format();

            $third_party_plugin = $_POST['ep_third_party_plugin'];
            if( $third_party_plugin == 'the-events-calendar' && class_exists('Tribe__Events__Main') && function_exists( 'tribe_get_events' ) ){
                $events_list = tribe_get_events( array(
                    'posts_per_page' => -1,
                    'post_type' => 'tribe_events', 
                ));
                
                if( ! empty( $events_list ) ){
                    $i = 0;
                    foreach( $events_list as $event ){
                        $event_data = new stdClass();
                        $event_meta = get_post_meta( $event->ID );
                        
                        $event_data->name = htmlspecialchars_decode(sanitize_text_field(strip_tags($event->post_title)));
                        $event_data->description = sanitize_text_field($event->post_content);
                        if( empty( $event_meta['_EventStartDate'][0] ) ){
                            
                        }
                        if( ! empty( $event_meta['_EventStartDate'][0] ) ){
                            $start_date = date( $format, strtotime( $event_meta['_EventStartDate'][0] ) );
                            
                        }
                        $start_time = '';
                        if( ! empty( $event_meta['_EventStartDate'][0] ) ){
                            $start_time = date( 'h:i A', strtotime( $event_meta['_EventStartDate'][0] ) );
                        }
                        if( ! empty( $event_meta['_EventEndDate'][0] ) ){
                            $end_date = date( $format, strtotime( $event_meta['_EventEndDate'][0] ) );
                            
                        }
                        $end_time = '';
                        if( ! empty( $event_meta['_EventEndDate'][0] ) ){
                            $end_time =  date( 'h:i A', strtotime( $event_meta['_EventEndDate'][0] ) );
                        }
                        $allday = ( isset( $event_meta['_EventAllDay'][0] ) && trim( $event_meta['_EventAllDay'][0] ) == 'yes' ) ? 1 : 0;
                        if( ! empty( $allday ) || ! trim( $start_date ) && ! trim( $end_date ) ){
                            $allDayDate = $start_date;
                            $event_data->em_all_day = 1;
                            $start_time = "12:00 AM";
                            $end_time = "11:59 PM";
                            $start_date = $allDayDate;
                            $end_date = $allDayDate;
                        }
                        if( ! empty( $start_date ) && empty( $end_date ) ){
                            $allDayDate = $start_date;
                            $event_data->em_all_day = 1;
                            $start_time = ! empty( $start_time ) ? $start_time : "12:00 AM";
                            $end_time = ! empty( $end_time ) ? $end_time : "11:59 PM";
                            $start_date = $allDayDate;
                            $end_date = $allDayDate;
                        }
                        if( ! empty( $start_date ) && ! empty( $end_date ) ){
                            if( $start_date > $end_date ){
                                $end_date = $start_date;
                            }
                        }
                        $event_data->em_start_date = ! empty( $start_date ) ? $ep_functions->ep_date_to_timestamp( $start_date, $format ) : '';
                        $event_data->em_end_date = ! empty( $end_date ) ? $ep_functions->ep_date_to_timestamp( $end_date ,$format ): '';
                        $event_data->em_start_time = ! empty( $start_time ) ? $start_time : '12:00 AM';
                        $event_data->em_end_time = ! empty( $end_time ) ? $end_time : '11:59 PM';
                        
                        $event_data->em_ticket_price = isset( $event_meta['_EventCost'] ) ? $event_meta['_EventCost'] : 0;
                        if( ! empty( $event_data->em_ticket_price ) ){
                            $event_data->em_enable_booking = 'bookings_on';
                        }
                        
                        // event venue
                        $location_term = new stdClass();
                        $location = get_post( $event_meta['_EventVenueID'][0] );
                        $event_venue_id = 1;
                        $location_name = $location->post_title; // location name
                        $location_meta = get_post_meta( $location->ID );
                        $address       = $location_meta['_VenueAddress']; // get location address
                        if( ! empty( trim( $location_name ) ) ){
                            $location_term = get_term_by( 'name', $location_name, 'em_venue' );
                        }
                        else{
                            if( ! empty( trim( $address ) ) ){
                                $location_exp = explode( ",", $address );
                                $location_name = $location_exp[0];
                                $location_term = get_term_by( 'name', $location_name, 'em_venue' );
                            }
                        }
                        if( empty( $location_term ) && ! empty( $location_name ) ){
                            $venue_data = new stdClass();
                            $venue_data->name = sanitize_text_field( $location_name );
                            $venue_data->em_type = 'standings';
                            $venue_data->em_address = sanitize_text_field( $address );
                            if( empty( $address ) ){
                                $venue_data->em_address = sanitize_text_field( $location_name );
                            }
                            $venue_data->em_seating_capacity = isset( $event_meta['_tribe_ticket_capacity'] ) ? $event_meta['_tribe_ticket_capacity'] : 0;
                            $venue_data->em_lng = '';
                            $venue_data->em_lat = '';
                            $venue_data->em_operator = '';
                            $event_venue_id = $ep_functions->create_venue((array)$venue_data);
                            if(!empty($event_venue_id)){
                                $event_data->em_venue = $event_venue_id;
                            }
                        }
                        else{
                            $event_venue_id = $location_term->term_id;
                            $event_data->em_venue = $event_venue_id;
                        }
                        
                        // event organizer
                        $organizer_ids = array();
                        $organizers_ids = isset( $event_meta['_EventOrganizerID'] ) ? $event_meta['_EventOrganizerID'] : '';
                        if( ! empty( $organizers_ids ) ){
                            foreach( $organizers_ids as $key => $organizer_id ){
                                if( ! empty( $organizer_id ) ){
                                    $organizer = get_post( $organizer_id );
                                    $organizer_id = 1;
                                    if( ! empty( $organizer ) ){
                                        $organizer_meta = get_post_meta( $organizer->ID );
                                        $organizer_phones = isset( $organizer_meta['_OrganizerPhone'] ) ? $organizer_meta['_OrganizerPhone'] : '';
                                        $organizer_emails = isset( $organizer_meta['_OrganizerEmail'] ) ? $organizer_meta['_OrganizerEmail'] : '';
                                        $organizer_websites = isset( $organizer_meta['_OrganizerWebsite'] ) ? $organizer_meta['_OrganizerWebsite'] : '';
                                    
                                        $organizer_name = $organizer->post_title;
                                        $organizer = get_term_by( 'name', $organizer_name, 'em_event_organizer' );

                                        if( ! empty( $organizer ) ){
                                            $organizer_ids[] = $organizer->term_id;
                                            
                                        }else{
                                            $org_data = new stdClass();
                                            $org_data->name = $organizer_name;
                                            if( isset( $organizer_phones ) && ! empty( $organizer_phones ) ){
                                                $org_data->em_organizer_phones = $organizer_phones;
                                            }
                                            if( isset($organizer_emails) && ! empty( $organizer_emails ) ){
                                                $org_data->em_organizer_emails = $organizer_emails;
                                            }
                                            if( isset( $organizer_websites ) && ! empty( $organizer_websites ) ){
                                                $org_data->em_organizer_websites = $organizer_websites;
                                            }
                                            $org_data->em_social_links = array(
                                                'facebook'=>'',
                                                'linkedin'=>'',
                                                'instagram'=>'',
                                                'twitter'=>''
                                            );
                                            $org_id = $ep_functions->create_organizer( (array)$org_data );
                                        
                                            if( $org_id ){
                                                $organizer_ids[] = $org_id;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        $event_data->em_organizer = $organizer_ids;

                        // event type
                        $categories = wp_get_post_terms( $event->ID, 'tribe_events_cat' );
                        if( ! empty( $categories ) ){

                            foreach( $categories as $category ){
                                if( ! empty( $category ) ){
                                    $eventType = $category->name;
                                    $type_term = get_term_by( 'name',$eventType, 'em_event_type' );
                                }
                                if( empty( $type_term ) && ! empty( $category ) ){
                                    $type_data = new stdClass();
                                    $type_data->name = sanitize_text_field( $category->name );
                                    $event_type_id = $ep_functions->create_event_types((array)$type_data);
                                    if( ! empty( $event_type_id ) ){
                                        $event_data->em_event_type = $event_type_id;
                                    }
                                }
                                else{
                                    $event_type_id = $type_term->term_id;
                                    $event_data->em_event_type = $event_type_id;
                                }    
                            }
                        }

                        // save event
                        $event_id = $ep_functions->insert_event_post_data((array)$event_data);

                        // save ticket
                        // $price_options_table = $wpdb->prefix.'em_price_options';
                        // get tec tickets id
                        $ticket_ids = $this->ep_get_tec_ticket_ids_by_meta_key_and_value( '_tec_tickets_commerce_event', $event->ID );
                        // get ticket data
                        if( ! empty( $ticket_ids ) ){
                            foreach( $ticket_ids as $ticket_id ){
                               if( ! empty( $ticket_id ) ){
                                    $ticket = get_post( $ticket_id );
                                    $ticket_meta = get_post_meta( $ticket->ID );
                                    if( isset( $ticket ) && ! empty( $ticket ) ) {
                                        $ticket_data 				   = array();
                                        $ticket_data['category_id']    = 0;
                                        $ticket_data['event_id'] 	   = $event_id;
                                        $ticket_data['name'] 		   = addslashes( $ticket->post_title );
                                        $ticket_data['description']    = isset( $ticket->post_excerpt ) ? addslashes( $ticket->post_excerpt ) : '';
                                        $ticket_data['price'] 		   = isset( $ticket_meta['_price'][0] ) ? $ticket_meta['_price'][0] : 0;
                                        $ticket_data['special_price']  = '';
                                        $ticket_data['capacity'] 	   = isset( $ticket_meta['_tribe_ticket_capacity'][0] ) ? absint( $ticket_meta['_tribe_ticket_capacity'][0] ) : 0;
                                        $ticket_data['is_default']     = 1;
                                        $ticket_data['is_event_price'] = 0;
                                        $ticket_data['icon'] 		   = '';
                                        $ticket_data['priority'] 	   = 1;
                                        $ticket_data['status'] 		   = 1;
                                        $ticket_data['created_at'] 	   = date_i18n("Y-m-d H:i:s", time());

                                        // date
                                        $start_date = [];
                                        if( ! empty( $ticket ) && ! empty( $ticket_meta ) ) {
                                            $start_date['booking_type'] = 'custom_date';
                                            if( isset( $ticket_meta['_ticket_start_date'][0] ) && ! empty( $ticket_meta['_ticket_start_date'][0] ) ) {
                                                $start_date['start_date'] = $ticket_meta['_ticket_start_date'][0];
                                            }
                                            if( isset( $ticket_meta['_ticket_start_time'][0] ) && ! empty( $ticket_meta['_ticket_start_time'][0] ) ) {
                                                $start_date['start_time'] = $ticket_meta['_ticket_start_time'][0];
                                            }
                                        }
                                        $ticket_data['booking_starts'] = json_encode( $start_date );
                                        // end date
                                        $end_date = [];
                                        if( ! empty( $ticket ) && ! empty( $ticket_meta ) ) {
                                            $end_date['booking_type'] = 'custom_date';
                                            if( isset( $ticket_meta['_ticket_end_date'][0] ) && ! empty( $ticket_meta['_ticket_end_date'][0] ) ) {
                                                $end_date['end_date'] = $ticket_meta['_ticket_end_date'][0];
                                            }
                                            if( isset( $ticket_meta['_ticket_end_time'][0] ) && ! empty( $ticket_meta['_ticket_end_time'][0] ) ) {
                                                $end_date['end_time'] = $ticket_meta['_ticket_end_time'][0];
                                            }
                                        }
                                        $ticket_data['booking_ends'] = json_encode( $end_date );
                                        $event_data->em_enable_booking = 'bookings_on';
                                        // $result = $wpdb->insert( $price_options_table, $ticket_data );
                                        $result = $ep_dbhandler->insert_row( 'TICKET', $ticket_data ); 
                                    }
                               }
                            }
                        }

                        // custom link
                        $em_custom_link = isset( $event_meta['_EventURL'] ) ? $event_meta['_EventURL'] : '';
                        update_post_meta( $event_id, 'em_custom_link', $em_custom_link );
                        // update post meta
                        $thumbnail_id = isset( $event_meta['_thumbnail_id'][0] ) ? $event_meta['_thumbnail_id'][0] : 0;
                        set_post_thumbnail( $event_id, $thumbnail_id );
                        // set post terms
                        wp_set_post_terms( $event_id, $event_venue_id , 'em_venue', false );
                        wp_set_post_terms( $event_id, $event_type_id , 'em_event_type', false );
                        // set post terms for organizers
                        if( ! empty( $event_data->em_organizer ) ){
                            foreach( $event_data->em_organizer as $organizer ){
                                if( ! empty( $organizer ) ){
                                    wp_set_post_terms( $event_id,$organizer , 'em_event_organizer', false );
                                }
                            }
                        }
                        $imported_events_details .= '<div>'.$event_data->name. ' Imported successully </div>';
                        $i++;
                    }
                    $response = array( 'success' => true, 'events_imported' => $i, 'imported_events_details' => $imported_events_details );
                    wp_send_json_success( $response );
                }
            }
        }
    }

    public function ep_get_tec_ticket_ids_by_meta_key_and_value($key, $value) {
		global $wpdb;
		$metas = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->postmeta." WHERE meta_key=%s AND meta_value=%s", $key, $value ) );
        $ticket_ids = array();
        if( ! empty( $metas ) ){
            foreach( $metas as $meta ){
                if ( is_array( $meta ) && ! empty( $meta ) && isset( $meta[0] ) ) {
                    $ticket_ids[] = $meta[0];
                }		
                if ( is_object( $meta ) ) {
                    $ticket_ids[] = $meta->post_id;
                }
                else {
                    return false;
                }
            }
        }
        return $ticket_ids;
	}

}
