<?php
/**
 * View: Week View - Grid Body
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events-pro/v2/week/grid-body.php
 *
 * See more documentation about our views templating system.
 *
 * @link https://evnt.is/1aiy
 *
 * @since 5.0.0 Initial template.
 * @since 7.7.8 Removed invalid role attributes from structure.
 *
 * @version 7.7.8
 *
 * @var array $multiday_events     An array of each day multi-day events and more event count, if any, in the shape
 *                                 `[ <Y-m-d> => [ 'events' => [ ...$multiday_events], 'more_events' => <int> ] ]`.
 * @var bool  $has_multiday_events Boolean whether the week has multiday events or not.
 * @var array $events              An array of each day non multi-day events, if any, in the shape `[ <Y-m-d> => [ ...$events ] ]`.
 * @var array $days                An array of days with additional data.
 */

?>
<div class="tribe-events-pro-week-grid__body">

	<?php if ( count( $multiday_events ) && $has_multiday_events ) : ?>

		<div class="tribe-events-pro-week-grid__multiday-events-row-outer-wrapper">
			<div class="tribe-events-pro-week-grid__multiday-events-row-wrapper">
				<div
					class="tribe-events-pro-week-grid__multiday-events-row"
					data-js="tribe-events-pro-week-multiday-events-row"
				>

					<?php $this->template( 'week/grid-body/multiday-events-row-header' ); ?>

					<?php foreach ( $multiday_events as $day => list( $day_multiday_events, $more_events ) ) : ?>
						<?php
						$this->template(
							'week/grid-body/multiday-events-day',
							[
								'day'    => $day,
								'events' => $day_multiday_events,
							]
						);
						?>
					<?php endforeach; ?>

				</div>
			</div>
		</div>

	<?php endif; ?>

	<div class="tribe-events-pro-week-grid__events-scroll-wrapper">
		<div class="tribe-events-pro-week-grid__events-row-outer-wrapper" data-js="tribe-events-pro-week-grid-events-row-outer-wrapper">
			<div class="tribe-events-pro-week-grid__events-row-wrapper" data-js="tribe-events-pro-week-grid-events-row-wrapper">
				<div class="tribe-events-pro-week-grid__events-row">

					<?php $this->template( 'week/grid-body/events-row-header' ); ?>

					<?php foreach ( $events as $day => $day_events ) : ?>
						<?php
						$this->template(
							'week/grid-body/events-day',
							[
								'events'      => $day_events,
								'more_events' => ! empty( $days[ $day ]['more_events'] ) ? $days[ $day ]['more_events'] : false,
								'more_url'    => ! empty( $days[ $day ]['day_url'] ) ? $days[ $day ]['day_url'] : false,
							]
						);
						?>
					<?php endforeach; ?>

				</div>
			</div>
		</div>
	</div>
</div>
