<?php

function ect_pro_gutenberg_scripts() {
	$blockPath = '/dist/block.js';
	$stylePath = '/dist/block.css';

	// Enqueue the bundled block JS file
	wp_enqueue_script(
		'ect-block-js',
		plugins_url( $blockPath, __FILE__ ),
		array( 'wp-i18n', 'wp-blocks', 'wp-edit-post', 'wp-element', 'wp-editor', 'wp-components', 'wp-data', 'wp-plugins', 'wp-edit-post', 'wp-api' ),
		filemtime( plugin_dir_path( __FILE__ ) . $blockPath )
	);
	wp_localize_script( 'ect-block-js', 'ectUrl', array( ECT_PRO_PLUGIN_URL ) );

	// Enqueue frontend and editor block styles
	wp_enqueue_style(
		'ect-block-css',
		plugins_url( $stylePath, __FILE__ ),
		'',
		filemtime( plugin_dir_path( __FILE__ ) . $stylePath )
	);

}

// Hook scripts function into block editor hook
add_action( 'enqueue_block_editor_assets', 'ect_pro_gutenberg_scripts' );

/**
 * Block Initializer.
 */
add_action(
	'plugins_loaded',
	function () {
		if ( function_exists( 'register_block_type' ) ) {
			// Hook server side rendering into render callback

			register_block_type(
				'ect/shortcode',
				array(
					'render_callback' => 'ect_pro_block_callback',
					'attributes'      => array(
						'category'         => array(
							'type'    => 'string',
							'default' => 'all',
						),
						'template'         => array(
							'type'    => 'string',
							'default' => 'default',
						),
						'style'            => array(
							'type'    => 'string',
							'default' => 'style-1',
						),
						'order'            => array(
							'type'    => 'string',
							'default' => 'ASC',
						),
						'time'             => array(
							'type'    => 'string',
							'default' => 'future',
						),
						'dateFilter'       => array(
							'type'    => 'string',
							'default' => 'all_default',
						),
						'dateformat'       => array(
							'type'    => 'string',
							'default' => 'default',
						),
						'limit'            => array(
							'type'    => 'string',
							'default' => '10',
						),
						'startDate'        => array(
							'type'    => 'string',
							'default' => '',
						),
						'endDate'          => array(
							'type'    => 'string',
							'default' => '',
						),
						'featuredonly'     => array(
							'type'    => 'string',
							'default' => 'false',
						),
						'showdescription'  => array(
							'type'    => 'string',
							'default' => 'yes',
						),
						'columns'          => array(
							'type'    => 'string',
							'default' => 2,
						),
						'autoplay'         => array(
							'type'    => 'string',
							'default' => 'true',
						),
						'hideVenue'        => array(
							'type'    => 'string',
							'default' => 'no',
						),
						'tags'             => array(
							'type'    => 'string',
							'default' => '',
						),
						'venues'           => array(
							'type'    => 'string',
							'default' => '',
						),
						'organizers'       => array(
							'type'    => 'string',
							'default' => '',
						),
						'socialshare'      => array(
							'type'    => 'string',
							'default' => 'no',
						),
						'datetxt'          => array(
							'type'    => 'string',
							'default' => 'Date',
						),
						'timetxt'          => array(
							'type'    => 'string',
							'default' => 'Duration',
						),
						'desctxt'          => array(
							'type'    => 'string',
							'default' => 'Description',
						),
						'evttitle'         => array(
							'type'    => 'string',
							'default' => 'Event Name',
						),
						'eventVenueTittle' => array(
							'type'    => 'string',
							'default' => 'Location',
						),
						'viewMoreTittle'   => array(
							'type'    => 'string',
							'default' => 'View More',
						),
						'cateTitle'        => array(
							'type'    => 'string',
							'default' => 'Category',
						),
						'filterbar'        => array(
							'type'    => 'string',
							'default' => 'no',
						),
						'filterbarstyle'        => array(
							'type'    => 'string',
							'default' => 'both',
						),
						'selectfilter'     => array(
							'type'    => 'string',
							'default' => 'category,tags,venue,organizer',
						)
					),
				)
			);
		}
	}
);

/**
 * Block Output.
 */
function ect_pro_block_callback( $attr ) {
	$category    = isset( $attr['category'] )    ? sanitize_text_field( $attr['category'] )    : 'all';
    $template    = isset( $attr['template'] )    ? sanitize_text_field( $attr['template'] )    : 'default';
    $style       = isset( $attr['style'] )       ? sanitize_text_field( $attr['style'] )       : 'style-1';
    $dateformat  = isset( $attr['dateformat'] )  ? sanitize_text_field( $attr['dateformat'] )  : 'default';
    $limit       = isset( $attr['limit'] )       ? intval( $attr['limit'] )                    : 10;
    $order       = isset( $attr['order'] )       ? sanitize_text_field( $attr['order'] )       : 'ASC';
    $hideVenue   = isset( $attr['hideVenue'] )   ? sanitize_text_field( $attr['hideVenue'] )   : 'no';
    $time        = isset( $attr['time'] )        ? sanitize_text_field( $attr['time'] )        : 'future';
    $startDate   = isset( $attr['startDate'] )   ? sanitize_text_field( $attr['startDate'] )   : '';
    $endDate     = isset( $attr['endDate'] )     ? sanitize_text_field( $attr['endDate'] )     : '';
    $socialshare = isset( $attr['socialshare'] ) ? sanitize_text_field( $attr['socialshare'] ) : 'no';
    $dateFilter  = isset( $attr['dateFilter'] )  ? sanitize_text_field( $attr['dateFilter'] )  : 'all_default';
    $columns     = isset( $attr['columns'] )     ? intval( $attr['columns'] )                  : 2;
    $autoplay    = isset( $attr['autoplay'] )    ? sanitize_text_field( $attr['autoplay'] )    : 'true';
    $featuredonly = isset( $attr['featuredonly'] ) ? sanitize_text_field( $attr['featuredonly'] ) : 'false';
    $showdescription = isset( $attr['showdescription'] ) ? sanitize_text_field( $attr['showdescription'] ) : 'yes';
    $tags        = isset( $attr['tags'] )        ? sanitize_text_field( $attr['tags'] )        : '';
    $venues      = isset( $attr['venues'] )      ? sanitize_text_field( $attr['venues'] )      : '';
    $organizers  = isset( $attr['organizers'] )  ? sanitize_text_field( $attr['organizers'] )  : '';
    $datetxt     = isset( $attr['datetxt'] )     ? sanitize_text_field( $attr['datetxt'] )     : 'Date';
    $timetxt     = isset( $attr['timetxt'] )     ? sanitize_text_field( $attr['timetxt'] )     : 'Duration';
    $evttitle    = isset( $attr['evttitle'] )    ? sanitize_text_field( $attr['evttitle'] )    : 'Event Name';
    $desctxt     = isset( $attr['desctxt'] )     ? sanitize_text_field( $attr['desctxt'] )     : 'Description';
    $cateTitle   = isset( $attr['cateTitle'] )   ? sanitize_text_field( $attr['cateTitle'] )   : 'Category';
    $eventVenueTittle = isset( $attr['eventVenueTittle'] ) ? sanitize_text_field( $attr['eventVenueTittle'] ) : 'Location';
    $viewMoreTittle = isset( $attr['viewMoreTittle'] ) ? sanitize_text_field( $attr['viewMoreTittle'] ) : 'View More';
    $filterbar   = isset( $attr['filterbar'] )   ? sanitize_text_field( $attr['filterbar'] )   : 'no';
    $filterbarstyle = isset( $attr['filterbarstyle'] ) ? sanitize_text_field( $attr['filterbarstyle'] ) : 'both';
    $selectfilter = isset( $attr['selectfilter'] ) ? sanitize_text_field( $attr['selectfilter'] ) : 'category,tags,venue,organizer';
	if ( isset( $template ) ) {
		$shortcode_string = '[events-calendar-templates template="%s" 
		style="%s" category="%s" date_format="%s"
		start_date="%s" end_date="%s" limit="%s"
		order="%s" hide-venue="%s"
		time="%s" date-filter="%s" columns="%s" 
		autoplay="%s" featured-only="%s"
		show-description="%s"
		 tags="%s" venues="%s" organizers="%s" socialshare="%s" date-lbl="%s" time-lbl="%s" event-lbl="%s" desc-lbl="%s" category-lbl="%s" location-lbl="%s" vm-lbl="%s" filterbar="%s" filterbarstyle="%s" selectfilter="%s"]';
		$shortcode        = sprintf(
			$shortcode_string,
			esc_attr($template),
			esc_attr($style),
			esc_attr($category),
			esc_attr($dateformat),
			esc_attr($startDate),
			esc_attr($endDate),
			esc_attr($limit),
			esc_attr($order),
			esc_attr($hideVenue),
			esc_attr($time),
			esc_attr($dateFilter),
			esc_attr($columns),
			esc_attr($autoplay),
			esc_attr($featuredonly),
			esc_attr($showdescription),
			esc_attr($tags),
			esc_attr($venues),
			esc_attr($organizers),
			esc_attr($socialshare),
			esc_attr($datetxt),
			esc_attr($timetxt),
			esc_attr($evttitle),
			esc_attr($desctxt),
			esc_attr($cateTitle),
			esc_attr($eventVenueTittle),
			esc_attr($viewMoreTittle),
			esc_attr($filterbar),
			esc_attr($filterbarstyle),
			esc_attr($selectfilter)
		);
		return $shortcode;
	}
}
