<?php
if (!defined('ABSPATH')) {
    exit();
}

if (!class_exists('ECT_pro_cronjob')) {
    class ECT_pro_cronjob
    {

        public function __construct() {
           
       
          // Register cron jobs
            add_filter('cron_schedules', array($this, 'ect_pro_cron_schedules'));
            add_action('ect_pro_extra_data_update', array($this, 'ect_pro_cron_extra_data_autoupdater'));
        }
        
        static public function cpfm_get_user_info() {
            global $wpdb;
        
            // Server and WP environment details
            $server_info = [
                'server_software'        => isset($_SERVER['SERVER_SOFTWARE']) ? sanitize_text_field($_SERVER['SERVER_SOFTWARE']) : 'N/A',
                'mysql_version'          => $wpdb ? sanitize_text_field($wpdb->get_var("SELECT VERSION()")) : 'N/A',
                'php_version'            => sanitize_text_field(phpversion() ?: 'N/A'),
                'wp_version'             => sanitize_text_field(get_bloginfo('version') ?: 'N/A'),
                'wp_debug'               => (defined('WP_DEBUG') && WP_DEBUG) ? 'Enabled' : 'Disabled',
                'wp_memory_limit'        => sanitize_text_field(ini_get('memory_limit') ?: 'N/A'),
                'wp_max_upload_size'     => sanitize_text_field(ini_get('upload_max_filesize') ?: 'N/A'),
                'wp_permalink_structure' => sanitize_text_field(get_option('permalink_structure') ?: 'Default'),
                'wp_multisite'           => is_multisite() ? 'Enabled' : 'Disabled',
                'wp_language'            => sanitize_text_field(get_option('WPLANG') ?: get_locale()),
                'wp_prefix'              => isset($wpdb->prefix) ? sanitize_key($wpdb->prefix) : 'N/A',
                'plugin_initial'         => get_option('ect-pro-initial-save-version') ?: 'N/A',
            ];
        
            // Theme details
            $theme = wp_get_theme();
            $theme_data = [
                'name'      => sanitize_text_field($theme->get('Name')),
                'version'   => sanitize_text_field($theme->get('Version')),
                'theme_uri' => esc_url($theme->get('ThemeURI')),
            ];
            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }
            if (!function_exists('get_plugin_data')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }  
            $plugin_data = [];
            $active_plugins = get_option('active_plugins', []);
        
            foreach ( $active_plugins as $plugin_path ) {
    
                $plugin_info = get_plugin_data(WP_PLUGIN_DIR . '/' . sanitize_text_field($plugin_path));
    
                $author_url = ( isset( $plugin_info['AuthorURI'] ) && !empty( $plugin_info['AuthorURI'] ) ) ? esc_url( $plugin_info['AuthorURI'] ) : 'N/A';
                $plugin_url = ( isset( $plugin_info['PluginURI'] ) && !empty( $plugin_info['PluginURI'] ) ) ? esc_url( $plugin_info['PluginURI'] ) : 'N/A';
                
                $plugin_data[] = [
                    'name'       => sanitize_text_field($plugin_info['Name']),
                    'version'    => sanitize_text_field($plugin_info['Version']),
                    'plugin_uri' => !empty($plugin_url) ? $plugin_url : $author_url,
                ];
            }
        
            return [
                'server_info'   => $server_info,
                'extra_details' => [
                    'wp_theme'       => $theme_data,
                    'active_plugins' => $plugin_data,
                ],
            ];
        }

        function ect_pro_cron_extra_data_autoupdater() {
                if (class_exists('ECT_pro_cronjob')) {
                    self::ect_pro_send_data();
                }
            
        }

                /**
         * Cron status schedule(s).
         */
        public function ect_pro_cron_schedules($schedules)
        {
            // 30days schedule for update information

            if (!isset($schedules['every_30_days'])) {

                $schedules['every_30_days'] = array(
                    'interval' => 30 * 24 * 60 * 60, // 2,592,000 seconds
                    'display'  => __('Once every 30 days'),
                );
            }

            return $schedules;
        }

           
       static public function ect_pro_send_data() {
                   
            $feedback_url = ECT_PRO_FEEDBACK_URL.'wp-json/coolplugins-feedback/v1/site';
            $extra_data_details = self::cpfm_get_user_info();
            $server_info    = $extra_data_details['server_info'];
            $extra_details  = $extra_data_details['extra_details'];
            $site_url       = esc_url(get_site_url());
            $install_date   = get_option('ect-pro-install-date');
            $uni_id         = '21';
            $site_id        = $site_url . '-' . $install_date . '-' . $uni_id;
            $initial_version = get_option('ect-pro-initial-save-version');
            $initial_version = is_string($initial_version) ? sanitize_text_field($initial_version) : 'N/A';
            $plugin_version = defined('ECT_PRO_VERSION') ? ECT_PRO_VERSION : 'N/A';
            $admin_email    = sanitize_email(get_option('admin_email') ?: 'N/A');
            
            $post_data = array(

                'site_id'           => md5($site_id),
                'plugin_version'    => $plugin_version,
                'plugin_name'       => 'Events Shortcodes Pro',
                'plugin_initial'    => $initial_version,
                'email'             => $admin_email,
                'site_url'          => esc_url_raw($site_url),
                'server_info'       => $server_info,
                'extra_details'     => $extra_details,
            );
            
            $response = wp_remote_post($feedback_url, array(

                'method'    => 'POST',
                'timeout'   => 30,
                'headers'   => array(
                    'Content-Type' => 'application/json',
                ),
                'body'      => wp_json_encode($post_data),
            ));

            if (is_wp_error($response) ) {
                return;
            }
            
            $response_body  = wp_remote_retrieve_body($response);
            $decoded        = json_decode($response_body, true);

            if (!wp_next_scheduled('ect_pro_extra_data_update')) {
                
                wp_schedule_event(time(), 'every_30_days', 'ect_pro_extra_data_update');
                
              
            }
        }
          



    }

    $cron_init = new ECT_pro_cronjob();
}